/* Copyright 1993 - Matti Aarnio, Turku University, Turku, Finland
   This will be free software, but only when it is finished.

   The way the Zmailer uses DBM entries is by using strings with
   their terminating NULL as keys, and as data..  Thus the length
   is strlen(string)+1, not strlen(string) !
*/

#include "hostenv.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <fcntl.h>
#ifdef HAVE_NDBM_H
#define datum Ndatum
#include <ndbm.h>
#undef datum
#endif
#ifdef HAVE_GDBM_H
#define datum Gdatum
#include <gdbm.h>
#undef datum
#endif
#ifdef HAVE_DB_H
#include <db.h>
#endif

#define PROG "makendbm"

#include <errno.h>
extern int errno;	/* Not all systems declare it in <errno.h> ... */

extern char *strchr();

extern void create_dbase __((FILE *, void *, int));

void
usage(prog,err,errno)
char *prog, *err;
int errno;
{
  fprintf(stderr,"Usage: %s dbtype database.name [infilename|-]\n",prog);
  fprintf(stderr,"  where supported dbtypes are:");
#ifdef HAVE_NDBM_H
  fprintf(stderr," ndbm");
#endif
#ifdef HAVE_GDBM_H
  fprintf(stderr," gdbm");
#endif
#ifdef HAVE_DB_H
  fprintf(stderr," btree");
#endif
  fprintf(stderr,"\n");
  fprintf(stderr,"  If no infilename is defined, database.name is assumed.\n");
#ifdef HAVE_NDBM_H
  fprintf(stderr,"  (NDBM appends  .pag, and .dir  into actual db file names..)\n");
#endif
#ifdef HAVE_GDBM_H
  fprintf(stderr,"  (GDBM appends .pag, to the actual db file name..)\n");
#endif
#ifdef HAVE_DB_H
  fprintf(stderr,"  (BTREE appends .db, to the actual db file name..)\n");
#endif
  fprintf(stderr," Error now: %s",err);
  fprintf(stderr,", errno=%d (%s)",errno,strerror(errno));
  fprintf(stderr,"\n");
  exit (1);
}


void
create_dbase(infile,dbf,typ)
     FILE *infile;
     void *dbf;
     int typ;
{
	char linebuf[2048];
	char *s, *t;
#ifdef HAVE_NDBM_H
	DBM *ndbmfile = dbf;
#endif
#ifdef HAVE_GDBM_H
	GDBM_FILE gdbmfile = dbf;
#endif
#ifdef HAVE_DB_H
	DB *dbfile = dbf;
#endif
	int rc;


	while (!feof(infile) && !ferror(infile)) {
	  *linebuf = 0;
	  fgets(linebuf,sizeof(linebuf)-1,infile);
	  if (*linebuf == 0) break; /* Last! */
	  s = (char *)strchr(linebuf,'\n');
	  if (s) *s = 0; /* Zap \n from the end -- if it exists.. */
	  if (*linebuf == '#') continue; /* Comment! */

	  /* Scan first white-space separated token, point its start with t! */
	  t = linebuf;
	  while (*t == '\t' || *t == ' ') ++t;

	  if (*t == 0) continue; /* Blank line! */

	  s = t;
	  while (*s && *s != '\t' && *s != ' ') ++s;
	  if (*s) {
	    *s = 0; /* Found end of input token, put 0 there, and look if
		       there is some data on this line! */
	    ++s;
	    while (*s && (*s == '\t' || *s == ' ')) ++s;
	    /* Point to begin of data after separating white space! */
	  }

	  rc = -2;
#ifdef HAVE_NDBM_H
	  if (typ == 1) {
	    Ndatum Ndat, Nkey;
	    Nkey.dptr  = t;
	    Nkey.dsize = strlen(t)+1;
	    Ndat.dptr  = s;
	    Ndat.dsize = strlen(s)+1;
	    rc = dbm_store(ndbmfile, Nkey, Ndat, DBM_INSERT);
	  }
#endif
#ifdef HAVE_GDBM_H
	  if (typ == 2) {
	    Gdatum Gdat, Gkey;
	    Gkey.dptr  = t;
	    Gkey.dsize = strlen(t)+1;
	    Gdat.dptr  = s;
	    Gdat.dsize = strlen(s)+1;
	    rc = gdbm_store(gdbmfile, Gkey, Gdat, GDBM_INSERT);
	  }
#endif
#ifdef HAVE_DB_H
	  if (typ == 3) {
	    DBT Bkey, Bdat;
	    Bkey.data = t;
	    Bkey.size = strlen(t)+1;
	    Bdat.data = s;
	    Bdat.size = strlen(s)+1;
	    rc = (dbfile->put)(dbfile,&Bkey,&Bdat,R_NOOVERWRITE);
	  }
#endif
	  if (rc > 0) {
	    fprintf(stderr,"Key: `%s' is duplicate!\n",t);
	  } else if (rc < 0) {
	    break; /* Some error -- any, just quit */
	  }
	}
}


int
main(argc,argv)
int argc;
char *argv[];
{
	char *dbasename = NULL;
	FILE *infile = NULL;
	int typ = 0;
#ifdef HAVE_NDBM_H
	DBM *ndbmfile;
#endif
#ifdef HAVE_GDBM_H
	GDBM_FILE gdbmfile;
#endif
#ifdef HAVE_DB_H
	DB *dbfile;
#endif
	char *dbtype;
	void *dbf;

	/* Usage: */
	/*  makendbm dbtype database.name [infilename|-] */
	/* argv[] 0    1          2           3		 */

	if (argc < 3) usage(argv[0],"too few arguments",0);
	if (argc > 4) usage(argv[0],"too many arguments",0);
	dbasename = argv[2];

	if (argc == 4) {
	  if (strcmp(argv[3],"-")==0)
	    infile = stdin;
	  else
	    infile = (FILE*)fopen(argv[3],"r");
	} else
	  infile = (FILE*)fopen(argv[2],"r");
	dbtype = argv[1];

	if (infile == NULL) usage(argv[0],"bad infile",errno);

	typ = 0;
#ifdef HAVE_NDBM_H
	if (strcasecmp(dbtype,"ndbm")==0)
	  typ = 1;
	else
#endif
#ifdef HAVE_GDBM_H
	  if (strcasecmp(dbtype,"gdbm")==0)
	    typ = 2;
	  else
#endif
#ifdef HAVE_DB_H
	    if (strcasecmp(dbtype,"btree")==0)
	      typ = 3;
#endif
	if (typ == 0)
	  usage(argv[0],"unknown dbtype",0);

#ifdef HAVE_NDBM_H
	if (typ == 1) {
	  ndbmfile = dbm_open(dbasename, O_RDWR|O_CREAT|O_TRUNC, 0644);
	  dbf = ndbmfile;
	}
#endif
#ifdef HAVE_GDBM_H
	if (typ == 2) {
	  /* Play loose .. don't do syncs while writing */
	  dbasename = strcpy(malloc(strlen(dbasename)+8),dbasename);
	  strcat(dbasename,".pag"); /* ALWAYS append this */
	  gdbmfile = gdbm_open(dbasename, 0, GDBM_NEWDB|GDBM_FAST, 0644, NULL);
	  dbf = gdbmfile;
	}
#endif
#ifdef HAVE_DB_H
	if (typ == 3) {
	  dbasename = strcpy(malloc(strlen(dbasename)+8),dbasename);
	  strcat(dbasename,".db"); /* ALWAYS append this */
	  dbfile = dbopen(dbasename, O_RDWR|O_CREAT|O_TRUNC, 0644,
			  DB_BTREE, NULL);
	  dbf = dbfile;
	}
#endif
	if (dbf == NULL)
	  usage(argv[0],"Can't open dbase file",errno);

	create_dbase(infile,dbf,typ);

#ifdef HAVE_NDBM_H
	if (typ == 1)
	  dbm_close(ndbmfile);	
#endif
#ifdef HAVE_GDBM_H
	if (typ == 2)
	  gdbm_close(gdbmfile);
#endif
#ifdef HAVE_DB_H
	if (typ == 3) {
	  (dbfile->sync)(dbfile,0);
	  (dbfile->close)(dbfile);
	}
#endif

	return 0;
}
