/*
 * XX: Build unique boundary for MIME applications needing such
 */

#include <stdio.h>

extern char *getzenv();
extern char *strdup();

char *
mydomain()
{
	static char *mydomainname = NULL;

	if (!mydomainname)
	  mydomainname = getzenv("ORGDOMAIN");
	if (!mydomainname) {
	  char buf[200];
	  *buf = 0; buf[sizeof(buf)-1] = 0;
	  getmyhostname(buf,sizeof(buf)-1);
	  if (*buf == 0)
	    return NULL;
	  mydomainname = strdup(buf);
	}
	return mydomainname;
}

char *
buildboundary()
{
	static char buf[400];
	static int  boundaryserial = 0;
	char *dom = mydomain();

	if (dom == NULL) dom = "unknown.domain";

	if (boundaryserial == 0)
	  boundaryserial = rand();

	sprintf(buf,"A%X.%d=_/%s",boundaryserial++,time(NULL),dom);
	return buf;
}
