/*
 * tablems.h - -ms macros table and other explicit troff command strings
 *		Release 1.0a	August 1988
 *		Release 2.0	January 1990
 *
 * Copyright 1988, 1989, 1990  Beverly A.Erlebacher
 * erlebach@cs.toronto.edu    ...uunet!utai!erlebach
 *
 */

/*
 * miscellaneous commands, described in texi2roff.h
 */
struct misccmds mscmds = { ".nr _- 0\n.ND",
			"\n.PP\n", "\n.IP\n", "\n.RS\n", "\n.RE\n"};

struct tablerecd mstable[] = {
    "@*",		"",	"\n.br\n",	"",	"",	ESCAPED,
    "@.",		"",	"\\&.",		"",	"",	ESCAPED,
    "@:",		"",	"",		"",	"",	ESCAPED,
    "@@",		"",	"@",		"",	"",	ESCAPED,
    "@Arrow",		"\n",	"\\(rh",	"\n",	"",	CHAR,
    "@TeX{",		"}",	"TeX",		"",	"",	INPARA,
    "@appendix",	"\n",  
	"\n.if !\\n(_- \\{\\\n.nr _- 1\n.nr H1 0 1\n.af H1 A\\}\n.bp\n.ds __ ",
	"\n.NH 1\n\\*(__ \n.XS \n\\n(H1	\\*(__ \n.XE\n","\\fB",	HEADING,
    "@appendixsec",     "\n",   "\n.ds __ ",
	"\n.NH 2\n\\*(__ \n.XS \n\\n(H1.\\n(H2      \\*(__ \n.XE\n",
							"\\fB",	HEADING,
    "@appendixsection", "\n",   "\n.ds __ ",
	"\n.NH 2\n\\*(__ \n.XS \n\\n(H1.\\n(H2      \\*(__ \n.XE\n",
							"\\fB",	HEADING,
    "@appendixsubsec",  "\n",   "\n.ds __ ",
	"\n.NH 3\n\\*(__ \n.XS \n\\n(H1.\\n(H2.\\n(H3    \\*(__ \n.XE\n",
							"\\fB",	HEADING,
    "@appendixsubsubsec","\n",  "\n.ds __ ",
	"\n.NH 4\n\\*(__ \n.XS \n\\n(H1.\\n(H2.\\n(H3.\\n(H4  \\*(__ \n.XE\n",
							"\\fB",	HEADING,
    "@arrow",		"\n",	"\\(->",	"\n",	"",	CHAR,
    "@asis",		"\n",	"",		"\n",	"",	PARAGRAPH,
    "@asis{",		"}",	"",		"",	"",	INPARA,
    "@author",		"\n",	"\n.ce\n",	"\n",	"",	HEADING,
    "@br",		"\n",	"\n.br\n.sp\n", "",	"",	PARAGRAPH,
    "@bullet{",		"}",	"\\(bu",	"",	"",	CHAR,
    "@bye",		"\n",	"",		"\n",	"",	DISCARD,
    "@b{",		"}",	"\\fB",		"",	"\\fB",	INPARA,
    "@c",		"\n",	"",		"\n",	"",	DISCARD,
    "@center",		"\n",	"\n.ce\n",	"\n",	"",	HEADING,
    "@center{",		"}",	"\n.ce\n",	"",	"",	HEADING,
    "@chapter",	 "\n",   "\n.bp\n.ds __ ",
	"\n.NH 1\n\\*(__ \n.XS \n\\n(H1	\\*(__ \n.XE\n","\\fB",	HEADING,
    "@cindex",		"\n",	"\n.iX \"c ",	"\"\n",	"",	INDEX,
    "@cite{",		"}",	"\\fI",		"",	"\\fI",	INPARA,
    "@code{",		"}",	"\\fR\\&\\f(CW","","\\fR\\&\\f(CW",INPARA,
    "@comment",		"\n",	"",		"\n",	"",	DISCARD,
    "@contents",	"\n",	"\n.nr % 0\n.af % i\n.bp\n.PX\n",
						"",	"",	INPARA,
    "@copyright{",	"}",	"\\(co",	"",	"",	CHAR,
    "@ctrl{",		"}",	"\\fR\\&\\f(CW^","","\\fR\\&\\f(CW",INPARA,
    "@dag",		"}{",	"\\(dg",	"",	"",	CHAR,
    "@dag{",		"}",	"\\(dg",	"",	"",	CHAR,
    "@ddag",		"}{",	"\\(dd",	"",	"",	CHAR,
    "@ddag{",		"}",	"\\(dd",	"",	"",	CHAR,
    "@defcmd",		"@end", "\n.LP\n*\\ Command: ","","",	HEADING,
    "@defcmdx",		"\n", 	"\n.LP\n*\\ Command: ","\n.br\n","",HEADING,
    "@defconst",	"@end", "\n.LP\n*\\ Constant: ","","",	HEADING,
    "@defconstx",	"\n", 	"\n.LP\n*\\ Constant: ","\n.br\n","",HEADING,
    "@deffn",		"@end", "\n.LP\n*\\ ",	"",	"",	HEADING,
    "@deffnx",		"\n", 	"\n.LP\n*\\ ",	"\n.br\n","",	HEADING,
    "@defmac",		"@end", "\n.LP\n*\\ Macro: ","","",	HEADING,
    "@defmacx",		"\n", 	"\n.LP\n*\\ Macro: ","\n.br\n","",HEADING,
    "@defmethod",	"@end", "\n.LP\n*\\ Operation on ","","",HEADING,
    "@defmethodx",	"\n", 	"\n.LP\n*\\ Operation on ","\n.br\n",
							"",	HEADING,
    "@defopt",		"@end", "\n.LP\n*\\ User Option: ","","",HEADING,
    "@defoptx",		"\n", 	"\n.LP\n*\\ User Option: ","\n.br\n",
							"",	HEADING,
    "@defspec",		"@end", "\n.LP\n*\\ Special Form: ","","",HEADING,
    "@defspecx",	"\n", 	"\n.LP\n*\\ Special Form: ","\n.br\n",
							"",	HEADING,
    "@defun",		"@end", "\n.LP\n*\\ Function: ","","",	HEADING,
    "@defunx",		"\n", 	"\n.LP\n*\\ Function: ","\n.br\n","",HEADING,
    "@defvar",		"@end", "\n.LP\n*\\ Variable: ","","",	HEADING,
    "@defvarx",		"\n", 	"\n.LP\n*\\ Variable: ","\n.br\n","",HEADING,
    "@dfn{",		"}",	"\\fI",		"",	"\\fI",	INPARA,
    "@display",		"@end", "\n.ID\n",	"\n.DE\n","",	DISPLAY,
    "@dots{",		"}",	"\\&...",	"",	"",	INPARA,
    "@eject",		"\n",	"\n.bp\n",	"",	"",	PARAGRAPH,
    "@emph{",		"}",	"\\fI",		"",	"\\fI",	INPARA,
    "@end",		"\n",	"",	"\n.sp\n.in\n", "",	END,
    "@enumerate",	"@end", "\n",		"\n",	"",	ITEMIZING,
    "@equiv{",		"}",	"\\(==",	"",	"",	CHAR,
    "@error{",		"}",	"error-->",	"",	"",	CHAR,
    "@example",		"@end", "\n.ID\n\\fR\\&\\f(CW\n", 
				"\n.DE\n","\\fR\\&\\f(CW",	DISPLAY,
    "@example{",	"}",	"\\fR\\&\\f(CW","","\\fR\\&\\f(CW",INPARA,
    "@exdent",		"\n",	"\n.LP\n",	"\n",	"",	PARAGRAPH,
    "@expansion{",	"}",	"\\(->",	"",	"",	CHAR,
    "@file{",		"}",	"\\fR\\&\\f(CW\\(if",
				"\\(is","\\fR\\&\\f(CW",	INPARA,
    "@finalout",	"\n",	"",		"\n",	"",	DISCARD,
    "@findex",		"\n",	"\n.iX \"f ",	"\"\n",	"",	INDEX,
    "@footnote{",	"}",	"\n.FS \n",	"\n.FE\n","",	FOOTNOTE,
    "@group",		"@end", "\n.KS\n",	"\n.KE\n","",	PARAGRAPH,
    "@heading",	 "\n",   "\n.bp\n.ds __ ",
    	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n", 	"\\fB",	HEADING,
    "@headings",	"\n",   "",	     "",     	"",	DISCARD,
    "@iappendix",       "\n",   "\n.bp\n.ds __ ",
       	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n", 	"\\fB",	HEADING,
    "@iappendixsec",    "\n",   "\n.ds __ ",
	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n", 	"\\fB",	HEADING,
    "@iappendixsubsec", "\n",   "\n.ds __ ",
	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n", 	"\\fB",	HEADING,
    "@ichapter",	"\n",   "\n.bp\n.ds __ ",
	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n", 	"\\fB",	HEADING,
    "@ifinfo",		"@end", "\n",		"\n",	"",	PARAGRAPH,
    "@iftex",		"@end", "",		"",	"",	PARAGRAPH,
    "@ignore",		"@end", "",		"",	"",	DISCARD,
    "@include",		"\n",	"",		"\n",	"",	INCLUDE,
    "@inforef{",	"}",	"See Info file ","",	"",	PARAGRAPH,
    "@isection",	"\n",   "\n.ds __ ",
	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n",	"\\fB",	HEADING,
    "@isubsection",     "\n",   "\n.ds __ ",
 	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n",	"\\fB",	HEADING,
    "@isubsubsection",  "\n",   "\n.ds __ ",
  	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n",	"\\fB",	HEADING,
    "@item",		"\n",	"\n.IP ",	"\\ \n","",	ITEM,
    "@itemize",		"@end", "\n",		"\n",	"",	ITEMIZING,
    "@itemx",		"\n",	"\n.IP ",	"\\ \n","",	ITEM,
    "@iunnumbered",     "\n",   "\n.bp\n.ds __ ",
 	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n", 	"\\fB",	HEADING,
    "@iunnumberedsec",  "\n",   "\n.ds __ ",
	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n", 	"\\fB",	HEADING,
    "@iunnumberedsubsec","\n",  "\n.ds __ ",
       	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n", 	"\\fB",	HEADING,
    "@i{",		"}",	"\\fI",		"",	"\\fI",	INPARA,
    "@kbd{",		"}",	"\\fR\\&\\f(CW","","\\fR\\&\\f(CW",INPARA,
    "@key{",		"}",	"\\fR\\&\\f(CW","","\\fR\\&\\f(CW",INPARA,
    "@kindex",		"\n",	"\n.iX \"k ",	"\"\n",	"",	INDEX,
    "@majorheading",    "\n",   "\n.sp 4\n.ds __ ",
	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n",	"\\fB",	HEADING,
    "@menu",		"@end", "\n.LD\n\\s8Menu: \n",
					"\\s0\n.DE\n",	"",	DISPLAY,
    "@minus{",		"}",	"\\-",		"",	"",	CHAR,
    "@need",		"\n",	"",		"\n",	"",	DISCARD,
    "@node",		"\n",	"\n.LP\n\\s8Node:",
					"\\s0\n.br\n",	"",	PARAGRAPH,
    "@noindent",	"\n",	"\n.LP\n",	"",	"",	PARAGRAPH,
    "@page",		"\n",	"\n.bp\n",	"",	"",	PARAGRAPH,
    "@pindex",		"\n",	"\n.iX \"p ",	"\"\n",	"",	INDEX,
    "@point{",		"}",	"*",		"",	"",	CHAR,
    "@printindex",	"\n",	"",		"\n",	"",	DISCARD,
    "@prints{",		"}",	"-|",		"",	"",	CHAR,
    "@print{",		"}",	"-|",		"",	"",	CHAR,
    "@pxref{",		"}",	"see section ",	"",	"",	PARAGRAPH,
    "@quotation",	"@end", "\n.QP\n.nh\n", "\n.PP\n","",	DISPLAY,
    "@refill",		"\n",	"",		"\n",	"",	DISCARD,
    "@ref{",		"}",	"\\(if",	"\\(is","",	INPARA,
    "@result",		"\n",	"\\(rh",	"\n",	"",	CHAR,
    "@result{",		"}",	"\\(rh",	"",	"",	CHAR,
    "@r{",		"}",	"\\fR",		"",	"\\fR",	INPARA,
    "@samp{",		"}",	"\\fR\\&\\f(CW\\(if",
				"\\(is","\\fR\\&\\f(CW",	INPARA,
    "@sc{",		"}",	"\\fB",		"",	"\\fB",	INPARA,
    "@section",	 "\n",   "\n.ds __ ",
      "\n.NH 2\n\\*(__ \n.XS \n\\n(H1.\\n(H2      \\*(__ \n.XE\n",
							"\\fB",	HEADING,
    "@setchapternewpage","\n",	"",		"\n",	"",	DISCARD,
    "@setfilename",	"\n",	"",		"\n",	"",	DISCARD,
    "@settitle",	"\n",	"\n.ds St ",
	     "\n.OH '\\\\*(St''%'\n.EH '%''\\\\*(St'\n","",	HEADING,
    "@smallbook",	"\n",	"",		"\n",	"",	DISCARD,
    "@smallexample",	"@end", "\n.ID\n\\fR\\&\\f(CW\n",
				"\n.DE\n","\\fR\\&\\f(CW",	DISPLAY,
    "@sp",		"\n",	"\n.sp",	"\n",	"",	PARAGRAPH,
    "@sp2",		"\n",	"\n.sp 2",	"\n",	"",	PARAGRAPH,
    "@strong{",		"}",	"\\fB",		"",	"\\fB",	INPARA,
    "@subheading",      "\n",   "\n.ds __ ",
 	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n",	"\\fB",	HEADING,
    "@subsection",      "\n",   "\n.ds __ ",
	"\n.NH 3\n\\*(__ \n.XS \n\\n(H1.\\n(H2.\\n(H3    \\*(__ \n.XE\n",
							"\\fB",	HEADING,
    "@subsubheading",   "\n",   "\n.ds __ ",
 	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n",	"\\fB",	HEADING,
    "@subsubsection",   "\n",   "\n.ds __ ",
	"\n.NH 4\n\\*(__ \n.XS \n\\n(H1.\\n(H2.\\n(H3.\\n(H4  \\*(__ \n.XE\n",
							"\\fB",	HEADING,
    "@subtext",		"\n",	"\n.ce\n",	"\n",	"",	HEADING,
    "@subtitle",	"\n",	"\n.ce\n",	"\n",	"",	HEADING,
    "@summarycontents",	"\n",	"\n.nr % 0\n.af % i\n.bp\n.PX\n",
						"",	"",	INPARA,
    "@syncodeindex",	"\n",	"",		"\n",	"",	DISCARD,
    "@synindex",	"\n",	"",		"\n",	"",	DISCARD,
    "@t",		"\n",	"\t",		"\n",	"",	CHAR,
    "@table",		"@end", "\n",		"\n",	"",	ITEMIZING,
    "@tex",		"@end", "",		"",	"",	DISCARD, 
    "@tindex",		"\n",	"\n.iX \"t ",	"\"\n",	"",	INDEX,
    "@title",		"\n",	"\n.ce\n",	"\n",	"",	HEADING,
    "@titlefont{",	"}",	"\n.ps +10\n.ce\n",
					"\n.ps -10\n",	"",	PARAGRAPH,
    "@titlepage",	"@end", "\n",		"\n.bp\n","",	PARAGRAPH,
    "@titlespec",	"@end", "\n.ce \n\\&\\*(St \n","\n","",	PARAGRAPH,
    "@t{",		"}",	"\\fR\\&\\f(CW","","\\fR\\&\\f(CW",INPARA,
    "@unnumbered",      "\n",   "\n.bp\n.ds __ ",
       	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n",	"\\fB",	HEADING,
    "@unnumberedsec",   "\n",   "\n.ds __ ",
	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n",	"\\fB",	HEADING,
    "@unnumberedsubsec","\n",   "\n.ds __ ",
	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n",	"\\fB",	HEADING,
    "@unnumberedsubsubsec","\n","\n.ds __ ",
 	"\n.XS \n\\*(__ \n.XE\n.SH \n\\*(__ \n",	"\\fB",	HEADING,
    "@var{",		"}",	"\\fI",		"",	"\\fI",INPARA,
    "@vfil",		"\n",	"",		"\n",	"",	DISCARD,
    "@vindex",		"\n",	"\n.iX \"v ",	"\"\n",	"",	INDEX,
    "@vskip",		"\n",	"",		"\n",	"",	DISCARD,
    "@w{",		"}",	"\n\\! ",	"\n",	"",	INPARA,
    "@xref{",		"}",	"See section ",	"",	"",	PARAGRAPH,
    "@{",		"",	"{",		"",	"",	ESCAPED,
    "@}",		"",	"}",		"",	"",	ESCAPED
};
