
/*
 * pidwait.c -- wait for child to exit
 *
 * $Id$
 */

#include <h/mh.h>
#include <h/signals.h>
#include <signal.h>

#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

int
pidwait (pid_t id, int sigsok)
{
    pid_t pid;
    sigset_t set, oset;

#ifdef WAITINT
    int status;
#else
    union wait status;
#endif

    if (sigsok == NOTOK) {
	/* block a couple of signals */
	sigemptyset (&set);
	sigaddset (&set, SIGINT);
	sigaddset (&set, SIGQUIT);
	SIGPROCMASK (SIG_BLOCK, &set, &oset);
    }

#ifdef HAVE_WAITPID
    pid = waitpid(id, &status, WUNTRACED);
#else
    while ((pid = wait(&status)) != NOTOK && pid != id)
	continue;
#endif

    if (sigsok == NOTOK) {
	/* reset the signal mask */
	SIGPROCMASK (SIG_SETMASK, &oset, &set);
    }

#ifdef WAITINT
    return (pid == NOTOK ? NOTOK : status);
#else
    return (pid == NOTOK ? NOTOK : status.w_status);
#endif
}
