/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1996 */
/* See the file NOTICE for conditions of use and distribution. */

/* Exim gets and frees all its store through these functions, which in
principle could do clever things, but currently don't. They are called via 
macros store_malloc and store_free, which add the tracing information that is 
used when debugging is turned on. */


#include "exim.h"

static int sequence = 0;   /* For tracing */


/*************************************************
*             Get and check store                *
*************************************************/

/* Running out of store is a total disaster for exim. Some malloc functions
do not run happily on very small sizes, nor do they document this fact. */

void *store_malloc_3(size_t size, char *filename, int linenumber)
{
void *yield;

if (size < 16) size = 16;

yield = malloc(size);
if (yield == NULL) 
  log_write(LOG_MAIN | LOG_PANIC_DIE, "failed to get %d bytes of memory", size);

if (debug_trace_memory) 
  {
  debug_printf("%08x %04d %5d (%-14s %4d)\n", yield, sequence++, size,
    filename, linenumber);
  } 

return yield;
}


/************************************************
*             Free store                        *
************************************************/

void store_free_3(void *block, char *filename, int linenumber)
{
if (debug_trace_memory) 
  {
  debug_printf("%08x %04d  free (%-14s %4d)\n", block, sequence++,
    filename, linenumber);
  } 
free(block);
}

/* End of store.c */
