/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1996 */
/* See the file NOTICE for conditions of use and distribution. */

/* Private structure for the private options. */

typedef struct {
  void *handle;
  char *file;
  char *directory; 
  char *errors_to;
  char *expand_uid;
  char *expand_gid;
  int   uid;
  int   gid;
  int   modemask;
  int   search_type;
  int  *owners;
  int  *owngroups;
  BOOL  optional;
  BOOL  forbid_file;
  BOOL  forbid_pipe;
  BOOL  freeze_missing_include; 
} aliasfile_director_options_block;

/* Data for reading the private options. */

extern optionlist aliasfile_director_options[];
extern int aliasfile_director_options_count;

/* Block containing default values. */

extern aliasfile_director_options_block aliasfile_director_option_defaults;

/* The main, initialization, tidyup, and dependency check entry points for the
director */

extern int aliasfile_director_entry(director_instance *, address_item *,
  address_item **, address_item **, address_item **, BOOL);
extern void aliasfile_director_init(director_instance *);
extern void aliasfile_director_tidyup(director_instance *);

/* End of directors/aliasfile.h */
