/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1996 */
/* See the file NOTICE for conditions of use and distribution. */


/* Private structure for the private options. */

typedef struct {
  void *handle;
  int   search_type;
  int   modemask;
  int  *owners;
  int  *owngroups;   
  char *route_file; 
  char *route_list;
  re_block *re_list; 
} domainlist_router_options_block;

/* Data for reading the private options. */

extern optionlist domainlist_router_options[];
extern int domainlist_router_options_count;

/* Block containing default values. */

extern domainlist_router_options_block domainlist_router_option_defaults;

/* The main, initialization, and tidyup entry points for the router */

extern int domainlist_router_entry(router_instance *, address_item *, 
  address_item **, address_item **);
   
extern void domainlist_router_init(router_instance *); 

extern void domainlist_router_tidyup(router_instance *);

/* End of routers/domainlist.h */
