/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1996 */
/* See the file NOTICE for conditions of use and distribution. */


#include "exim.h"


/*************************************************
*            Add new header on end of chain      *
*************************************************/

/* header_list points to the chain, and header_last points to the last
header. Both are NULL for an empty chain. */

void header_add(int type, char *format, ...)
{
int slen;
header_line *new;
va_list ap;

va_start(ap, format);
vsprintf(big_buffer, format, ap);
va_end(ap);
slen = (int)strlen(big_buffer);

new = (header_line *)store_malloc(sizeof(header_line) + slen);
strcpy(new->text, big_buffer);
new->next = NULL;
new->prev = header_last;
new->type = type;
new->slen = slen;

if (header_last == NULL) header_list = new; 
  else header_last->next = new;
header_last = new;
}


/*************************************************
*          Check the name of a header            *
*************************************************/

/* This function is necessary because the colon is allowed to be separated from 
the name by white space. If it were not, a simple strncmpic would do. */

BOOL header_checkname(header_line *h, char *name, int len)
{
char *text = h->text;
while (len-- > 0) if (tolower(*text++) != tolower(*name++)) return FALSE; 
while (isspace(*text)) text++;
return (*text == ':');   
}

/* End of header.c */
