#include "emil.h"

char *
makelong(unsigned long i, int length)
{
  unsigned char *s, *t;
  s = (char *)Yalloc(length + 1);
  t = s;
  for (;length != 0; length--)
    {
      *s = 0xFF & (i >> (length - 1)*8);
      s++;
    }
  return(t);
}


int
getlong(unsigned long *l, struct data *d)
{
  unsigned char *s;

  if (get_length(d) < 4)
    return(NOK);
  s = d->contents + d->offset;
  *l = ((unsigned long) ((*s++ <<24) & 0xff000000))|
    ((unsigned long) ((*s++ << 16) & 0xff0000))|
      ((unsigned long) ((*s++ <<8) & 0xff00))|
	((unsigned long) (*s & 0xff));

  d->offset += 4;
  return(OK);
}

unsigned long
getblong(unsigned char *s)
{
  return( (unsigned long)((unsigned long) *s++ <<24) |
    ((unsigned long) *s++ <<16) |
      ((unsigned long) *s++ <<8)|
	((unsigned long) *s));
}

int
getshort(unsigned short *l, struct data *d)
{
  unsigned char *s;

  if (get_length(d) < 2)
    return(NOK);
  s = d->contents + d->offset;
  *l = ((unsigned short) *s++ <<8)|
	((unsigned short) *s);
  d->offset += 2;
  return(OK);
}

