/*
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Michael Fischbein.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static char sccsid[] = "@(#)util.c	5.3 (Berkeley) 6/25/89";
#endif /* not lint */

#include <sys/types.h>
#include <stdio.h>
#include <ctype.h>
#include "ls.h"

void
prcopy(src, dest, len)
	const char *src;
	char *dest;
	int len;
{
	register int ch;

	while(len--) {
		ch = *src++;
		*dest++ = isprint(ch) ? ch : '?';
	}
}

void *
emalloc(size)
	u_int size;
{
	char *retval, *malloc();

	if (!(retval = malloc(size)))
		nomem();
	return(retval);
}

void
nomem()
{
	(void)fprintf(stderr, "ls: out of memory.\n");
	exit(100);
}

void
usage(ch)
char ch;
{
	(void)fprintf(stderr, "usage: ls [-1ACFGLPRXYZacdfgilnpqrstux] [file ...]\n");
	if(ch == '?'){
		(void)fprintf(stderr, "\
LS-program for FTP-server, and related support functions.\n\
Some unusual options are for generating internal databases.\n\
 -1 single column           -d nodescend into dirs\n\
 -A list '.'-files also     -f show file as directory\n\
 -C column format           -g group\n\
 -F FileType suffixes       -i inode\n\
 -G Gobbelygoo hex format   -l long format\n\
    of stat() data          -n names in NUMERIC format\n\
 -L ignore symlink          -p filetype suffixes\n\
 -P print full Path         -q '?' on unprintable chars\n\
 -R recursive mode          -r reverse sort\n\
 -X regenerate cache data   -s size display\n\
 -Y printallfiles() output  -t sort by time\n\
 -Z don't show hidden files -u by accesstime\n\
 -a Show '.' files          -x column output\n\
 -c statustime\n");
	}
	exit(101);
}
