#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include "ls.h"
#include "namemap.h"

extern void *malloc();


static FILE		*nmapf = NULL;
static struct namemap	*nmap = NULL;
static int		 nmapcnt = 0;

static FILE		*gmapf = NULL;
static struct namemap	*gmap = NULL;
static int		 gmapcnt = 0;

static void _namemap_nminit()
{
	struct stat64 stb;
	if (nmapcnt == 0) {
	  /* Try opening it */
	  if ((nmapf = fopen(_NAMEMAP_NAME,"r")) != NULL &&
	      fstat64(fileno(nmapf),&stb) == 0 &&
	      (nmap = (struct namemap *)malloc(stb.st_size)) != NULL) {
	    read(fileno(nmapf),nmap,stb.st_size);
	    nmapcnt = stb.st_size / sizeof(struct namemap);
	  } else
	    nmapcnt = -1;
	  if (nmapf != NULL) fclose(nmapf);
	}
}

static void _namemap_grinit()
{
	struct stat64 stb;
	if (gmapcnt == 0) {
	  /* Try opening it */
	  if ((gmapf = fopen(_GROUPMAP_NAME,"r")) != NULL &&
	      fstat64(fileno(gmapf),&stb) == 0 &&
	      (gmap = (struct namemap *)malloc(stb.st_size)) != NULL) {
	    read(fileno(gmapf),gmap,stb.st_size);
	    gmapcnt = stb.st_size / sizeof(struct namemap);
	  } else
	    gmapcnt = -1;
	  if (gmapf != NULL) fclose(gmapf);
	}
}

char *namemap_uid2name(uid)
int uid;
{
	_namemap_nminit();
	if (nmapcnt > 0) {
	  int lo = 0, hi= nmapcnt-1, mid;
	  while (lo <= hi) {
	    mid = (lo+hi) >> 1;
	    if (nmap[mid].id == uid) {
	      return nmap[mid].name;
	    }
	    if (nmap[mid].id > uid)
	      hi = mid-1;
	    else
	      lo = mid+1;
	  }
	}
	return NULL;
}

int namemap_name2uid(name)
char *name;
{
	int i;
	_namemap_nminit();
	for (i=0; i < nmapcnt; ++i) {
	  if (strcmp(nmap[i].name,name)==0)
	    return nmap[i].id;
	}
	return -1;
}


char *namemap_gid2name(gid)
int  gid;
{
	_namemap_grinit();
	if (gmapcnt > 0) {
	  int lo = 0, hi= gmapcnt-1, mid;
	  while (lo <= hi) {
	    mid = (lo+hi) >> 1;
	    if (gmap[mid].id == gid) {
	      return gmap[mid].name;
	    }
	    if (gmap[mid].id > gid)
	      hi = mid-1;
	    else
	      lo = mid+1;
	  }
	}
	return NULL;
}

int namemap_name2gid(name)
char *name;
{
	int i;
	_namemap_grinit();
	for (i=0; i < gmapcnt; ++i) {
	  if (strcmp(gmap[i].name,name)==0)
	    return gmap[i].id;
	}
	return -1;
}

