/*
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Michael Fischbein.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	@(#)ls.h	5.7 (Berkeley) 6/27/89
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include "readdir.h"


typedef struct _lsstruct {
	char *name;			/* file name */
	int len;			/* file name length */
	struct stat64 lstat;		/* lstat(2) for file */
} LS;

/*
 * overload -- we probably have to save blocks and/or maxlen with the lstat
 * array, so tabdir() stuffs it into unused fields in the first stat structure.
 * If there's ever a type larger than u_long, fix this.  Any calls to qsort
 * must save and restore the values.
 */
#if 0
#define	st_btotal	st_flags
#define	st_maxlen	st_gen
#else
#ifndef __svr4__
#define st_btotal       st_spare2
#define st_maxlen       st_spare3
#else
#define st_btotal       st_pad4[0]
#define st_maxlen       st_pad4[1]
#endif
#endif

#define UT_NAMESIZE     9
#ifndef	DAYSPERNYEAR
#define DAYSPERNYEAR    DAYS_PER_NYEAR
#define SECSPERDAY      SECS_PER_DAY
#endif

#ifndef	S_ISLNK
typedef int mode_t;
#define S_ISLNK(s)      ((S_IFMT&s)==S_IFLNK)
#define S_ISBLK(s)      ((S_IFMT&s)==S_IFBLK)
#define S_ISCHR(s)      ((S_IFMT&s)==S_IFCHR)
#define S_ISDIR(s)      ((S_IFMT&s)==S_IFDIR)
#endif

extern int errno;
extern char *sys_errlist[];
#define strerror(s)     sys_errlist[s]


extern int f_accesstime;	/* use time of last access */
extern int f_group;		/* show group ownership of a file */
extern int f_inode;		/* print inode */
extern int f_longform;		/* long listing format */
extern int f_singlecol;		/* use single column output */
extern int f_size;		/* list size in short listing */
extern int f_statustime;	/* use time of last mode change */
extern int f_total;		/* if precede with "total" line */
extern int f_type;		/* add type character for non-regular files */
extern int f_noreadables;	/* don't display GLOBALLY unreadable files */
extern int f_numericnames;	/* Show UID/GID in numeric format */
extern int f_printpath;		/* [mea] if true, print paths */

#define FTP_LS_DATA ".FTP_LS_DATA" /* Name of the cache file.. */

extern void  nomem(void);
extern void  prcopy(const char *src, char*dest, int len);
extern void *emalloc(u_int);
extern void  usage(char);

extern void printscol(FILE*, LS*, int);
extern void printgobbely(FILE*, LS*, int);
extern void printallfil(FILE*, LS*, int);
extern void printlong(FILE*, LS*, int);
extern void printcol(FILE*, LS*, int);

extern char *namemap_uid2name(int);
extern char *namemap_gid2name(int);
extern int   namemap_name2uid(char *);
extern int   namemap_name2gid(char *);
     

extern int acccmp(LS*,LS*), modcmp(LS*,LS*), namecmp(LS*,LS*);
extern int revacccmp(LS*,LS*), revmodcmp(LS*,LS*), revnamecmp(LS*,LS*);
extern int revstatcmp(LS*,LS*), statcmp(LS*,LS*);
extern LSDIR * regen_FTP_LS_DATA (LSDIR *, LS*, char*);
extern LSDIR * ls_opendir(char *, int, int*);
extern struct dirent *ls_readdir(LSDIR*, struct stat64*);
extern void ls_closedir(LSDIR *);
extern void displaydir(LS*, int, int);
extern void dodir(const char *, int);
extern void doargs(int, char **, int);
extern void subdir(LS*, int);
extern int tabdir(LS*, LS**, char **, int);
