#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <grp.h>
#include "ls.h"
#include "namemap.h"

void usage(char dummy)
{
  fprintf(stderr,"ls-namemap: Generates mappings of  passwd-db, and group-db into FTP's ls' map-files.\n");
  fprintf(stderr,"     Usage: ls-namemap ~ftp/etc/namemap ~ftp/etc/groupmap\n");
  fprintf(stderr,"       The FTP's ls does expect those names!\n");
  exit(64);
}

int namecmp_(_p1, _p2)
     const void *_p1, *_p2;
{
  const struct namemap *p1 = _p1, *p2 = _p2;
  return (p1->id) - (p2->id);
}

extern void *malloc();
extern void *realloc();

int already_in(nmap,ncnt,id)
struct namemap *nmap;
int ncnt, id;
{
	int i;
	for (i=0; i<ncnt;++i){
	  if (nmap[i].id == id) return 1;
	}
	return 0;
}


int
main(argc,argv)
int argc;
char **argv;
{
  FILE *namemap;
  struct passwd *pw;
  struct group  *grp;
  int namespace = 64;
  int namecnt = 0;
  struct namemap *nmap = malloc(sizeof(struct namemap)*64);

  if (argc != 3) usage('?');

  while ((pw = getpwent())) {
    if (already_in(nmap,namecnt,pw->pw_uid))
      continue;
    if (namespace <= namecnt) {
      namespace <<= 1; /* Double it */
      nmap = realloc(nmap,sizeof(struct namemap)*namespace);
    }
    strncpy(nmap[namecnt].name,pw->pw_name,sizeof(nmap[0].name)-1);
    nmap[namecnt].name[sizeof(nmap[0].name)-1] = 0;
    nmap[namecnt].id = pw->pw_uid;
    ++namecnt;
  }
  endpwent();

  qsort(nmap,namecnt,sizeof(struct namemap),namecmp_);

  namemap = fopen(argv[1],"w");
  if (!namemap) usage('?');
  write(fileno(namemap),nmap,sizeof(struct namemap)*namecnt);
  fclose(namemap);
  chmod(argv[1],0644);

  namecnt = 0;

  while ((grp = getgrent())) {
    if (already_in(nmap,namecnt,grp->gr_gid))
      continue;
    if (namespace <= namecnt) {
      namespace <<= 1; /* Double it */
      nmap = realloc(nmap,sizeof(struct namemap)*namespace);
    }
    strncpy(nmap[namecnt].name,grp->gr_name,sizeof(nmap[0].name)-1);
    nmap[namecnt].name[sizeof(nmap[0].name)-1] = 0;
    nmap[namecnt].id = grp->gr_gid;
    ++namecnt;
  }
  endgrent();

  qsort(nmap,namecnt,sizeof(struct namemap),namecmp_);

  namemap = fopen(argv[2],"w");
  if (!namemap) usage('n');
  write(fileno(namemap),nmap,sizeof(struct namemap)*namecnt);
  fclose(namemap);
  chmod(argv[2],0644);

  return 0;
}
