/*
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Michael Fischbein.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
 *  Magic files for -Z features:		[mea@nic.funet.fi]
 */
/*      FTP_LS_DATA     ".FTP_LS_DATA"	*/
/*	Cache data containing  (struct dirent)+(struct stat)
	for directory contents..       */
#define	IGNORED_NAMES	".ignored.names"
/*	Contains names of files, one per line, no extra blanks allowed,
	which are to be excluded from listing if -Z is used.	*/
#define RECURSION_IGNORED_NAMES ".recursion.ignored.names"
/*	Contains names of files, one per line, no extra blanks allowed,
	which are to be excluded from listing if -Z is used.
	This is looked at AFTER .ignored.names, and only when -R is in
	effect.							*/
#define	LINKS_AS_REALS	".links.as.reals"
/*	Presense of this file (just touch:ed 0 size file is enough)
	forces ALL symlinks to be shown as real files/directories	*/


#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1989 The Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char sccsid[] = "@(#)ls.c	5.32 (Berkeley) 8/7/89";
#endif /* not lint */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#ifndef USE_UTIMES
# include <utime.h>
#endif
#include <dirent.h>
#include <string.h>
#include <errno.h>
#include "ls.h"
#include <signal.h>

size_t (*lengthfcn)(const char *) = strlen;
int (*sortfcn)();
void (*printfcn)(FILE*, LS*, int);

int termwidth = 80;		/* default terminal width */

/* flags */
int f_accesstime;		/* use time of last access */
int f_column;			/* columnated format */
int f_group;			/* show group ownership of a file */
int f_ignorelink;		/* indirect through symbolic link operands */
int f_inode;			/* print inode */
int f_listalldot;		/* list . and .. as well */
int f_listdir;			/* list actual directory, not contents */
int f_listdot;			/* list files beginning with . */
int f_longform;			/* long listing format */
int f_needstat;			/* if need to stat files */
int f_newline = 0;		/* if precede with newline */
int f_nonprint;			/* show unprintables as ? */
int f_recursive;		/* ls subdirectories also */
int f_reversesort;		/* reverse whatever sort is used */
int f_singlecol;		/* use single column output */
int f_size;			/* list size in short listing */
int f_specialdir;		/* force params to be directories */
int f_statustime;		/* use time of last mode change */
int f_dirname = 0;		/* if precede with directory name */
int f_timesort;			/* sort by time vice name */
int f_total = 0;		/* if precede with "total" line */
int f_type;			/* add type character for non-regular files */
int f_gobbelygoo = 0;		/* [mea@nic.funet.fi] Printout in HEX style
				   of ints on structure(16),inode(32),
				   flags(16),date(32),uid(16),gid(16),
				   size(32) */
int f_noreadables = 0;		/* [mea] Don't show those files that don't
				   have global r-bit set */
int f_numericnames = 0;		/* [mea] Show numeric UID/GID, not symbolic */
int f_printpath = 0;		/* [mea] Instead of total lines etc print
				   full paths to files */
int f_3_views   = 0;		/* [mea] Hmm.. 3 different printouts */
int f_forced_regen = 0;		/* [mea] ls -X -- forced regen of .FTP_LS_DATA.
				         MUST be run as ROOT ! */
int f_printallfil = 0;		/* [mea] ls -Y */

char physroot[MAXPATHLEN];	/* [mea] `Real' path which chdir() affects... */

FILE *stdfluent = NULL;		/* [mea] ls -P(Z) -- prints paths into files */
FILE *stdgobl   = NULL;		/* [mea] ls -G(Z) -- gobbely fluent */
FILE *stdreqrlg = NULL;		/* [mea] ls -ZRlag -- regular ls... */
char  *debug = NULL;			/* FTPD_DEBUG - from environment */

void
lostconn()  /* when gets SIGPIPE or SIGURG... [mea@nic.funet.fi] */
{
	_exit(0);
}


int
main(argc, argv)
	int argc;
	char **argv;
{
#ifdef TIOCGWINSZ
	struct winsize win;
#endif
	int fsp = 0; /* Use cache files */
	int ch;
	char *ftpd_ls = NULL;
#ifndef BSD
	char stdoutbuf[BUFSIZ], stderrbuf[BUFSIZ];
#endif

	signal(SIGPIPE,lostconn);  /* to prevent loss of control.. */
	signal(SIGURG, lostconn);

#ifdef BSD
	if (isatty(fileno(stdout)))
	  setlinebuf(stdout);
	setlinebuf(stderr);
#else
	if (isatty(fileno(stdout)))
	  setvbuf(stdout,stdoutbuf,_IOLBF,BUFSIZ);
	setvbuf(stderr,stderrbuf,_IOLBF,BUFSIZ);
#endif

#ifdef USE_GETWD
	getwd(physroot);	/* Get physical root dir.. */
#else
	getcwd(physroot,sizeof(physroot));	/* Get physical root dir.. */
#endif
	if ((ftpd_ls = getenv("FTPD_LS")) != NULL) {
	  f_noreadables = 1;
	  /*	  fsp = 1;*/
	}
	debug = getenv("FTPD_DEBUG");

	/* terminal defaults to -Cq, non-terminal defaults to -1 */
	if (isatty(1)) {
	  f_nonprint = 1;
#ifdef TIOCGWINSZ
	  if (ioctl(1, TIOCGWINSZ, &win) == -1 || !win.ws_col) {
	    if ((p = getenv("COLUMNS")))
	      termwidth = atoi(p);
	  }
	  else
	    termwidth = win.ws_col;
#endif
	  f_column = 1;
	} else
	  f_singlecol = 1;

	/* root is -A automatically */
	if (!getuid())
	  f_listdot = 1;

	/* optind=1; */ /* system dependent initial value :-/ */
	while ((ch = getopt(argc, argv,
			    "?13:ACFGLPRXYZacdfgilnpqrstux")) != EOF) {
	  switch (ch) {
	    /*
	     * -1, -C and -l all override each other
	     * so shell aliasing works right
	     */

	    case 'G':
		f_gobbelygoo = !f_gobbelygoo;
		break;
	    case 'P':
		f_printpath = 1;
		break;
	    case 'X':
		f_forced_regen = 1;
		break;
	    case 'Y':
		f_printallfil = 1;
		break;
	    case 'Z':
		dup2(1,2); /* Give possible errors there... */
		f_noreadables = 1;
		break;
	    case '3':	/* Well, rather 4 views.. */
		f_3_views = 1;
		f_printpath = 1;
		f_noreadables = 1;
		if (!stdgobl) {
		  stdgobl = popen(optarg,"w");
		  break;
		}
		if (!stdfluent) {
		  stdfluent = popen(optarg,"w");
		  break;
		}
		if (!stdreqrlg) {
		  stdreqrlg = popen(optarg,"w");
		  break;
		}
		break;
	    case '1':
		f_singlecol = 1;
		f_column = f_longform = 0;
		break;
	    case 'x':	/* System V name... */
	    case 'C':
		f_column = 1;
		f_longform = f_singlecol = 0;
		break;
	    case 'l':
		f_longform = 1;
		f_column = f_singlecol = 0;
		break;
		/* -c and -u override each other */
	    case 'c':
		f_statustime = 1;
		f_accesstime = 0;
		break;
	    case 'u':
		f_accesstime = 1;
		f_statustime = 0;
		break;
	    case 'p': /* alias to 'F'... from System V */
	    case 'F':
		f_type = 1;
		break;
	    case 'n':
		f_numericnames = 1;
		break;
	    case 'L':
		f_ignorelink = 1;
		break;
	    case 'R':
		f_recursive = 1;
		break;
	    case 'a':
		if (f_listalldot && f_noreadables)
		  f_noreadables = 0;
		f_listalldot = 1;
		/* FALLTHROUGH */
	    case 'A':
		f_listdot = 1;
		break;
	    case 'd':
		f_listdir = 1;
		break;
	    case 'f':
		f_specialdir = 1;
		break;
	    case 'g':
		f_group = 1;
		break;
	    case 'i':
		f_inode = 1;
		break;
	    case 'q':
		f_nonprint = 1;
		break;
	    case 'r':
		f_reversesort = 1;
		break;
	    case 's':
		f_size = 1;
		break;
	    case 't':
		f_timesort = 1;
		break;
	    default:
	    case '?':
		usage(ch);
	  }
	}
	argc -= optind;
	argv += optind;


	/* -f turns off -F, -R, -l, -t, -s, -r, turns on -a */
	if (f_specialdir) {
	  f_longform = f_recursive = f_reversesort = f_size =
	    f_timesort = f_type = 0;
	  f_listdot = f_listalldot = 1;
	}
	if (f_printpath && !f_3_views &&
	    (f_listdot || f_listalldot || f_longform || f_reversesort ||
	     f_size || f_type || f_listdir || f_timesort || f_inode ||
	     f_nonprint)) {
	  f_printpath = 0; /* Can't do printpaths.. */
	  fprintf(stderr,"ls: WARNING: Your FTP client does improper use of NLST primitive!\n");
	}

	/* -d turns off -R */
	if (f_listdir)
	  f_recursive = 0;

	/* if need to stat files */
	f_needstat = (f_longform || f_recursive || f_timesort ||
		      f_size || f_type || f_gobbelygoo || f_noreadables);

	/* select a sort function */
	if (f_reversesort) {
	  if (!f_timesort)
	    sortfcn = revnamecmp;
	  else if (f_accesstime)
	    sortfcn = revacccmp;
	  else if (f_statustime)
	    sortfcn = revstatcmp;
	  else			/* use modification time */
	    sortfcn = revmodcmp;
	} else {
	  if (!f_timesort)
	    sortfcn = namecmp;
	  else if (f_accesstime)
	    sortfcn = acccmp;
	  else if (f_statustime)
	    sortfcn = statcmp;
	  else			/* use modification time */
	    sortfcn = modcmp;
	}

	/* select a print function */
	if (f_printallfil)
	  printfcn = printallfil;
	else if (f_gobbelygoo)
	  printfcn = printgobbely;
	else if (f_singlecol)
	  printfcn = printscol;
	else if (f_longform)
	  printfcn = printlong;
	else {
	  /*
	   * set f_column, in case f_longform selected, then turned
	   * off by f_special.
	   */
	  f_column = 1;
	  printfcn = printcol;
	}

	if (f_specialdir) {
	  if (!argc) {
	    (void)fprintf(stderr, "ls: -f requires operands.\n");
	    exit(1);
	  }
	  for (;;) {
	    if (argc > 1)
	      (void)printf("%s:\n", *argv);
	    dodir(*argv, fsp);
	    if (!*(++argv))
	      break;
	    putchar('\n');
	  }
	} else if (argc)
	  doargs(argc, argv, fsp);
	else
	  dodir(".", fsp);

	if (stdgobl)
	  pclose(stdgobl);
	if (stdfluent)
	  pclose(stdfluent);
	if (stdreqrlg)
	  pclose(stdreqrlg);

	exit(0);
}

/* [mea@nic.funet.fi]  -- ignore-table routines */
void
parse_nameset(filename,nametable)
     char *filename;
     char ***nametable;
{
	char	**NameTbl = NULL;
	char	*s;
	char	**p;
	char	line[256];
	FILE	*fp;
	int	elts = 0;
	int	Space = 0;

	*nametable = NULL;
	NameTbl = NULL;
	fp = fopen(filename,"r");
	if( !fp ) return;

	while(!feof(fp) && !ferror(fp)) {
	  *line = 0;
	  if( fgets(line,sizeof line,fp) == NULL ) break;
	  s = strchr(line,'\n');
	  if(s) *s = 0;		/* Chop of the \n */
	  if( *line == 0 ) continue;
	  if (NameTbl == NULL) {
	    NameTbl = (char **)malloc( 8 * sizeof(char *));
	    if(NameTbl == NULL) {
	      fprintf(stderr,"malloc() failure -1- -- abort!\n");
	      exit(8);
	    }
	    Space = 8;
	  }
	  if(!(s = malloc(sizeof(line)+1))) {
	    fprintf(stderr,"malloc() failure -2- -- abort!\n");
	    exit(8);
	  }
	  strcpy(s,line);
	  if( Space < (elts+2) ) {
	    /* make room - make room! */
	    Space += 8;
	    p = (char **)realloc( NameTbl, Space * sizeof( char * ) );
	    if( !p ) {
	      fprintf(stderr,"realloc() failure -3- -- abort!\n");
	      exit(8);
	    }
	    NameTbl = p;
	  }
	  /* Finally store entry into table... */
	  NameTbl[elts++] = s;
	  NameTbl[elts]   = NULL;	/* And terminate it with NULL */
	}
	fclose(fp);
	if (NameTbl) {
	  *nametable = NameTbl;
	  /* qsort(NameTbl,elts,sizeof(char *),strcmp); */
	}
	return;
}

/* [mea@nic.funet.fi] */
void
Tree_free(treeroot)
  char **treeroot;
{
	char **p = treeroot;

	while( *p ) {
	  free( *p );
	  ++p;
	}
	free( treeroot );
}

/* [mea@nic.funet.fi] */
static char *tag1p = NULL;

int
found_name(nametable,namestr)
     char **nametable;
     char *namestr;
{
	int elts;
	int low,mid,high;
	int rc;
	char **p = nametable;
	extern int strcmp();

	if (nametable == NULL) return -2;
	if (nametable == &tag1p) return 1; /* always true */

	elts = 0;
	if( !*p ) {
	  return -1;  /* No table */
	}
	while( *p ) { ++p; ++elts; }
	low = 0;
	high = elts -1;
	while(low < high) {
	  mid = (low+high) >> 1; /* Div by 2 */
	  rc = strcmp( nametable[mid],namestr );
	  if (rc == 0) return mid;
	  if (rc > 0)
	    high = mid -1;
	  else
	    low = mid + 1;
	}
	/* Small table, final check... */
	rc = strcmp( nametable[low],namestr );
	if (rc == 0) {
	  return low;
	}
	return -1;	/* No match... */
}
/* -- end of [mea@nic.funet.fi] ignore-table routines */

void
dodir(dirpath, fsp)
	const char *dirpath;
	int fsp;
{
	LS local, *stats = NULL;
	int num;
	char *names = NULL;

	local.name = dirpath;
	if (f_listdir) {
	  printf("%s\n",dirpath);
	  if (stdfluent)
	    fprintf(stdfluent,"%s\n",dirpath);
	  if (stdgobl)
	    fprintf(stdgobl,"%s\n",dirpath);
	  return;
	}
	if (lstat64(local.name, &local.lstat)) {
	  fprintf(stderr, "ls: 1 %s: %s\n", dirpath, strerror(errno));
	  return;
	}
	if ((num = tabdir(&local, &stats, &names, fsp)))
		displaydir(stats, num, fsp);
	if (stats) free(stats);
	if (names) free(names);
}



/*static*/ char path[MAXPATHLEN + 1];
static char *endofpath = path;

void
doargs(argc, argv, fsp)
	int argc, fsp;
	char **argv;
{
	LS *dstatp = NULL, *rstatp = NULL;
	int cnt, dircnt, maxlen = 0, regcnt, advice_refresh;
	LS *dstats, *rstats;
	struct stat64 sb;
	LSDIR *dirp;
	struct dirent *dp;
	int (*statfcn)(const char *, struct stat64 *);
	char top[MAXPATHLEN + 1];
	char thisdir[MAXPATHLEN + 1];
	char *p;
	char nameb[MAXPATHLEN];
	char *names = nameb;
	u_long blocks = 0;
	int namlen;

	char **ignored_names = NULL;
	char **recursion_ignored_names = NULL;
	char **links_as_reals = NULL;
	struct stat64 filestat;


	/*
	 * walk through the operands, building separate arrays of LS
	 * structures for directory and non-directory files.
	 */

	dstats = rstats = NULL;
	statfcn = (f_noreadables || f_longform ||
		   f_listdir) && !f_ignorelink ? lstat64 : stat64;
	for (dircnt = regcnt = 0; *argv; ++argv) {
	  char *s = strrchr(*argv,'/');
	  if (s && s[1] == 0) { /* Trailing '/' */
	    *s = 0;		/* Remove the trailing slash,
				   and try previous */
	    s = strrchr(*argv,'/');
	  }

#ifdef USE_GETWD
	  getwd(thisdir);
#else
	  getcwd(thisdir,sizeof(thisdir));
#endif
	  if (s) {
	    *s = 0;
	    chdir(*argv);
	    *s = '/';
	    ++s;
	  } else
	    s = *argv;

	  while (fsp) {
	    /* With active FSP */

	    /*
	     * allocate space for array of LS structures and the file names
	     * the name field will point to.  Make it big so we don't have
	     * to realloc often.
	     */

	    LS dstatb;
	    char *matchname = *s ? s : ".";

	    dstatb.name = *s ? s : ".";

	    if (debug) fprintf(stderr," *argv = `%s', *s = `%s'\n",*argv,s);

	    advice_refresh = -1;
	    dirp = NULL;
	    if ((f_forced_regen)||
		!(dirp = ls_opendir(".",fsp,&advice_refresh)) ||
		(advice_refresh==1)) {
	      struct stat64 dstb;
/*
#ifdef USE_UTIMES
	      struct timeval times[2];
	      times[0].tv_usec = 0;
	      times[1].tv_usec = 0;
#else
	      struct utimbuf times;
#endif
*/
	      stat64(".",&dstb); /* Dir change date -- if we create the file.. */
	      /* Umm.. lets try to generate it! */
	      /*	      if (!(dirp = regen_FTP_LS_DATA(dirp,&dstatb,"."))) {
		fprintf(stderr, "ls: 5b %s: %s/ %s\n",
			path, ".", strerror(errno));
		break;
	      }*/
          dirp = ls_opendir(".",fsp,&advice_refresh);
	  /*
#ifdef USE_UTIMES
	      times[0].tv_sec = dstb.st_atime;
	      times[1].tv_sec = dstb.st_mtime;
	      utimes(".",times);
#else
	      times.actime  = dstb.st_atime;
	      times.modtime = dstb.st_mtime;
	      utime(".",&times);
#endif
*/	    }

	    if (!dirp || dirp->use_dir) { /* Using normal diropen() ! */
	      ls_closedir(dirp);
	      break;
	    }

	    blocks = 0;
	    maxlen = -1;

	    while ((dp = ls_readdir(dirp,&sb))) {

	      /* Not this one ??   No, try next */
	      if (strcmp(matchname,dp->d_name) != 0) continue;

	      /* this does -A and -a */
	      p = dp->d_name;

	      /* if (p[0] == '.') {
		   if (!f_listdot)
		     break;
		   if (!f_listalldot && (!p[1] || (p[1] == '.' && !p[2])))
		     break;
		 } */
	      if (f_ignorelink && S_ISLNK(sb.st_mode)) {
		if (f_needstat && stat64(dp->d_name, &sb)) {
		  break;
		}
	      }
#if 0  /* Always store also there, just don't show them usually.. */
	      if (f_noreadables && ((sb.st_mode & S_IROTH) == 0))
		/* Unreadable files are forgotten here too */
		/* Initial pseudo value must pass this */
		break;		/* This isn't the worth.. */
#endif
	      namlen = strlen(dp->d_name);
	      if (f_nonprint)
		prcopy(dp->d_name, names, namlen);
	      else
		memcpy(names, dp->d_name, namlen);
	      names += namlen;;
	      *names++ = '\0';
#if 1
	      if (S_ISDIR(sb.st_mode) && !f_listdir) {
		if (!dstats)
		  dstatp = dstats = (LS *)emalloc((u_int)argc *
						  (sizeof(LS)));
		dstatp->name = *argv;
		dstatp->lstat = sb;
		++dstatp;
		++dircnt;
	      } else {
		if (!rstats) {
		  rstatp = rstats = (LS *)emalloc((u_int)argc *
						  (sizeof(LS)));
		  blocks = 0;
		  maxlen = -1;
		}
		rstatp->name = *argv;
		rstatp->lstat = sb;

		/* save name length for -C format */
		rstatp->len = strlen(*argv);

		if (f_nonprint)
		  prcopy(*argv, *argv, rstatp->len);

		/* calculate number of blocks if -l/-s formats */
		if (f_longform || f_size)
		  blocks += sb.st_blocks;

		/* save max length if -C format */
		if (f_column && maxlen < rstatp->len)
		  maxlen = rstatp->len;

		++rstatp;
		++regcnt;
	      }
#else
	      dstatb.name = s;
	      if (S_ISDIR(sb.st_mode) && !f_listdir) {
		for (endofpath = path, p = *argv ;
		     (*endofpath = *p++) ; ++endofpath)
		  ;
		f_dirname = 1;
		dstatb.name  = *argv;
		dstatb.lstat = sb; /* block store */
		subdir(&dstatb, fsp);
		f_newline = 1;
	      } else {
		dstatb.lstat = sb; /* Block store */
		dstatb.lstat.st_btotal = blocks;
		dstatb.lstat.st_maxlen = maxlen;
		displaydir(&dstatb, 1, fsp);
		f_newline = f_dirname = 1;
	      }
#endif
	    }
	    ls_closedir(dirp);
	    break;
	  }

	  if (!fsp) {
	    /* Without active FSP */

	    if (f_noreadables && stat64(IGNORED_NAMES,&filestat) == 0) {
	      /* A set of names to be ignored...   [mea@nic.funet.fi] */
	      parse_nameset(IGNORED_NAMES,&ignored_names);
	    }
	    if (f_noreadables && f_recursive
		&& stat64(RECURSION_IGNORED_NAMES,&filestat) == 0) {
	      /* A set of names to be ignored...   [mea@nic.funet.fi] */
	      parse_nameset(RECURSION_IGNORED_NAMES,&recursion_ignored_names);
	    }
	    if (f_noreadables && stat64(LINKS_AS_REALS,&filestat) == 0) {
	      /* A set of names to be ignored...   [mea@nic.funet.fi] */
	      if (filestat.st_size == 0)
		/* Zero size, special case giving it for all... */
		links_as_reals = &tag1p;
	      else
		parse_nameset(LINKS_AS_REALS,&links_as_reals);
	    }
	    chdir(thisdir);

	    if (found_name(ignored_names,*argv) >= 0 ) {
	      continue;		/* Really!  Ignore it! */
	    }
	    if (found_name(recursion_ignored_names,*argv) >= 0 ) {
	      continue;		/* Really!  Ignore it! */
	    }
	    statfcn = ((f_noreadables || f_longform || f_listdir) &&
		       !f_ignorelink) ?
			 lstat64 : stat64;
	    if (statfcn == lstat64 &&
		found_name(links_as_reals,*argv) >= 0)
	      statfcn = stat64;

	    if (statfcn(*argv, &sb)) {
	      if ((statfcn != stat64) || lstat64(*argv, &sb)) {
		fprintf(stderr, "ls: 2 %s: %s\n", *argv,
			strerror(errno));
		if (errno == ENOENT)
		  continue;
		exit(5);
	      }
	    }
	    if (f_noreadables && ((sb.st_mode & S_IROTH) == 0)) {
	      /* Unreadable files are forgotten here too */
	      /* printf("**unreadable: %s **\n",*argv); */
	      continue;		/* This isn't the worth.. */
	    }

	    if (S_ISDIR(sb.st_mode) && !f_listdir) {
	      if (!dstats)
		dstatp = dstats = (LS *)emalloc((u_int)argc *
						(sizeof(LS)));
	      dstatp->name = *argv;
	      dstatp->lstat = sb;
	      ++dstatp;
	      ++dircnt;
	    } else {
	      if (!rstats) {
		rstatp = rstats = (LS *)emalloc((u_int)argc *
						(sizeof(LS)));
		blocks = 0;
		maxlen = -1;
	      }
	      rstatp->name = *argv;
	      rstatp->lstat = sb;

	      /* save name length for -C format */
	      rstatp->len = strlen(*argv);

	      if (f_nonprint)
		prcopy(*argv, *argv, rstatp->len);

	      /* calculate number of blocks if -l/-s formats */
	      if (f_longform || f_size)
		blocks += sb.st_blocks;

	      /* save max length if -C format */
	      if (f_column && maxlen < rstatp->len)
		maxlen = rstatp->len;

	      ++rstatp;
	      ++regcnt;
	    }
	  }
	  chdir(thisdir);
	}
	if (maxlen<3) maxlen = 3;

	/* display regular files */
	if (regcnt) {
	  rstats[0].lstat.st_btotal = blocks;
	  rstats[0].lstat.st_maxlen = maxlen;
	  displaydir(rstats, regcnt, fsp);
	  f_newline = f_dirname = 1;
	}
	/* display directories */
	if (dircnt) {
	  register char *p;

	  f_total = 1;
	  if (dircnt > 1) {
#ifdef USE_GETWD
	    getwd(top);
#else
	    getcwd(top,sizeof(top));
#endif
	    qsort((void *)dstats, dircnt, sizeof(LS), sortfcn);
	    f_dirname = 1;
	  }
	  for (cnt = 0; cnt < dircnt; ++dstats) {
	    if (ferror(stdout)) exit (0);
	    for (endofpath = path, p = dstats->name;
		 (*endofpath = *p++);
		 ++endofpath)
	      ;
 	    subdir(dstats, fsp);
	    f_newline = 1;
	    if (++cnt < dircnt && chdir(top)) {
	      fprintf(stderr, "ls: 3 %s: %s\n",
		      top, strerror(errno));
	      exit(2);
	    }
	  }
	}
	if (ignored_names)
	  Tree_free(ignored_names);
	if (recursion_ignored_names)
	  Tree_free(recursion_ignored_names);
}

void
displaydir(stats, num, fsp)
	LS *stats;
	register int num;
	int fsp;
{
	register char *p, *savedpath;
	LS *lp;

	if (num > 1 && !f_specialdir) {
		u_long save1, save2;

		save1 = stats[0].lstat.st_btotal;
		save2 = stats[0].lstat.st_maxlen;
		qsort((char *)stats, num, sizeof(LS), sortfcn);
		stats[0].lstat.st_btotal = save1;
		stats[0].lstat.st_maxlen = save2;
	}

	printfcn(stdout,stats, num);
	if (stdfluent) {
	  int saved_newline = f_newline;
	  int saved_dirname = f_dirname;
	  int saved_total = f_total;
	  int saved_printpath = f_printpath;
	  int saved_group = f_group;
	  f_printpath = f_group = 1;
	  f_newline = f_dirname = f_total = 0;
	  printlong(stdfluent,stats, num);
	  f_printpath = saved_printpath;
	  f_newline = saved_newline;
	  f_dirname = saved_dirname;
	  f_total   = saved_total;
	  f_group   = saved_group;
	}
	if (stdreqrlg) {
	  int saved_newline = f_newline;
	  int saved_dirname = f_dirname;
	  int saved_total = f_total;
	  int saved_printpath = f_printpath;
	  int saved_group = f_group;
	  f_printpath = 0; f_group = 1;
	  f_newline = f_dirname = f_total = 1;
	  printlong(stdreqrlg, stats, num);
	  f_printpath = saved_printpath;
	  f_newline = saved_newline;
	  f_dirname = saved_dirname;
	  f_total   = saved_total;
	  f_group   = saved_group;
	}
	if (stdgobl) {
	  int saved_newline = f_newline;
	  int saved_dirname = f_dirname;
	  int saved_total = f_total;
	  int saved_printpath = f_printpath;
	  f_printpath = 1;
	  f_newline = f_dirname = f_total = 0;
	  printgobbely(stdgobl,stats, num);
	  f_printpath = saved_printpath;
	  f_newline = saved_newline;
	  f_dirname = saved_dirname;
	  f_total   = saved_total;
	}

	if (ferror(stdout)) exit (0);

	if (f_recursive) {
	  savedpath = endofpath;
	  for (lp = stats; num--; ++lp) {
	    if (!S_ISDIR(lp->lstat.st_mode))
	      continue;
	    if (f_noreadables && !(S_IROTH & lp->lstat.st_mode))
	      continue;
	    p = lp->name;
	    if (p[0] == '.' && (!p[1] || (p[1] == '.' && !p[2])))
	      continue;
	    if (endofpath != path && endofpath[-1] != '/')
	      *endofpath++ = '/';
	    for (; (*endofpath = *p++); ++endofpath) ;
	    if (f_noreadables && f_printpath) {
	      f_newline = f_dirname = f_total = 0;
	    } else if (!f_printpath)
	      f_newline = f_dirname = f_total = 1;
	    /* When -Z, don't print directory headers, but print
	       complete paths! When -Z -Z, we do!*/
	    subdir(lp, fsp);
	    *(endofpath = savedpath) = '\0';
	    chdir(physroot);
	    chdir(path);
	  }
	}
}

void
subdir(lp, fsp)
	LS *lp;
	int fsp;
{
	LS *stats = NULL;
	int num;
	char *names = NULL;

	if (f_newline && !f_printpath && !f_printallfil)
	  putchar('\n');
	if (stdreqrlg)
	  fprintf(stdreqrlg,"\n");
	if (f_dirname && !f_printpath && !f_printallfil)
	  printf("%s:\n", path);
	if (stdreqrlg)
	  fprintf(stdreqrlg,"%s:\n", path);

	if (chdir(physroot) ||
	    chdir(path)) {
	  fprintf(stderr, "ls: 4 (proot:%s)%s/ %s: %s\n",
		  physroot, path, lp->name,
		  strerror(errno));
	  return;
	}
	if ((num = tabdir(lp, &stats, &names, fsp)))
		displaydir(stats, num, fsp);
	if (stats) free(stats);
	if (names) free(names);
/*	if (chdir("..")) {
		(void)fprintf(stderr, "ls: ..: %s\n", strerror(errno));
		exit(3);
	} */
}


int
tabdir(lp, s_stats, s_names, fsp)
	LS *lp, **s_stats;
	char **s_names;
	int fsp;
{
	register int cnt, maxentry, maxlen;
	register char *p, *names, *names2;
	register LSDIR *dirp;
	int namesize, i;
	struct dirent *dp;
	u_long blocks;
	LS *stats;
	int	(*statfcn)();
	char **ignored_names = NULL;
	char **recursion_ignored_names = NULL;
	char **links_as_reals = NULL;
	struct stat64 filestat;
	int advice_refresh;
	int namlen;

	char thisdir[MAXPATHLEN];
	char *thisdirname = f_specialdir ? lp->name : ".";

	if (!fsp) {
	  if( f_noreadables && stat64(IGNORED_NAMES,&filestat) == 0) {
	    /* A set of names to be ignored...   [mea@nic.funet.fi] */
	    parse_nameset(IGNORED_NAMES,&ignored_names);
	  }
	  if (f_noreadables && f_recursive
	      && stat64(RECURSION_IGNORED_NAMES,&filestat) == 0) {
	    /* A set of names to be ignored...   [mea@nic.funet.fi] */
	    parse_nameset(RECURSION_IGNORED_NAMES,&recursion_ignored_names);
	  }
	  if( f_noreadables && stat64(LINKS_AS_REALS,&filestat) == 0) {
	    /* A set of names to be ignored...   [mea@nic.funet.fi] */
	    if (filestat.st_size == 0)
	      /* Zero size, special case giving it for all... */
	      links_as_reals = &tag1p;
	    else
	      parse_nameset(LINKS_AS_REALS,&links_as_reals);
	  }
	}

	/*
	 * allocate space for array of LS structures and the file names
	 * the name field will point to.  Make it big so we don't have
	 * to realloc often.
	 */
#define	DEFNUM	256
	maxentry = DEFNUM;
	stats    = (LS *)emalloc((u_int)DEFNUM * sizeof(LS));
	namesize = 10 * DEFNUM;
	names2   = names = emalloc(namesize);

	advice_refresh = -1;
	dirp = NULL;
	if ((fsp && f_forced_regen)||
	    !(dirp = ls_opendir(thisdirname,fsp,&advice_refresh)) ||
	    (fsp && (advice_refresh==1))) {
	  struct stat64 dstb;
/*
#ifdef USE_UTIMES
	  struct timeval times[2];
	  times[0].tv_usec = 0;
	  times[1].tv_usec = 0;
#else
	  struct utimbuf times;
#endif
*/
	  stat64(thisdirname,&dstb); /* Dir change date -- if we create the file.. */

	  /* Umm.. lets try to generate it! */
	  /*  if (!fsp ||
	      (fsp && !(dirp = regen_FTP_LS_DATA(dirp,lp,thisdirname)))) {

	    fprintf(stderr, "ls: 5 %s: %s/ %s\n", path,thisdirname,
		    strerror(errno));
	    free (stats);
	    free (names);
	    return 0;
	  }*/
          dirp = ls_opendir(thisdirname,fsp,&advice_refresh);
	  /*
#ifdef USE_UTIMES
	  times[0].tv_sec = dstb.st_atime;
	  times[1].tv_sec = dstb.st_mtime;
	  utimes(thisdirname,times);
#else
	  times.actime  = dstb.st_atime;
	  times.modtime = dstb.st_mtime;
	  utime(thisdirname,&times);
#endif
*/
	}

	if (dirp->use_dir) /* Using normal diropen() ! */
	  fsp = 0;

	blocks = 0;
	maxlen = -1;
	for (cnt = 0; (dp = ls_readdir(dirp,&stats[cnt].lstat));) {
	  if (cnt >= (maxentry-2)) {
	    maxentry *= 2;
	    if (!(stats = (LS *)realloc((char *)stats,
					(u_int)maxentry * sizeof(LS))))
	      nomem();
	  }
	  /* this does -A and -a */
	  p = dp->d_name;

	  if (!fsp) {		/* Not in FSP cache mode! */
	    if (found_name(ignored_names,dp->d_name) >= 0 )
	      continue;		/* Really!  Ignore it! */
	    if (found_name(recursion_ignored_names,dp->d_name) >= 0 )
	      continue;		/* Really!  Ignore it! */
	  }

	  /* Don't show .FTP_LS_DATA -cache files! They just confuse! */
	  if (f_noreadables &&
	      strcmp(dp->d_name,FTP_LS_DATA)==0)
	    continue;
	  statfcn = ((f_noreadables || f_longform || f_listdir) &&
		     !f_ignorelink) ?
		       lstat64 : stat64;
	  if (!fsp &&
	      statfcn == lstat64 &&
	      found_name(links_as_reals,dp->d_name) >= 0)
	    statfcn = stat64;
	  if (p[0] == '.') {
	    if (!f_listdot)
	      continue;
	    if (!f_listalldot && (!p[1] || (p[1] == '.' && !p[2])))
	      continue;
	  }
	  if (!fsp
	      || (f_ignorelink && S_ISLNK(stats[cnt].lstat.st_mode))) {
	    if (!fsp)
	      stats[cnt].lstat.st_mode = S_IROTH; /* Initial pseudo value..*/
	    if (f_needstat && statfcn(dp->d_name, &stats[cnt].lstat)
		&& !(fsp && f_ignorelink)) {
#ifdef USE_GETWD
	      getwd(thisdir);
#else
	      getcwd(thisdir,sizeof(thisdir));
#endif
	      (void)fprintf(stderr, "ls: 6 (%s)%s/ %s: %s\n",thisdir,path,
			    dp->d_name, strerror(errno));
	      continue;
	    }
	  }
	  if (f_noreadables && ((stats[cnt].lstat.st_mode & S_IROTH) == 0))
	    /* Unreadable files are forgotten here too */
	    /* Initial pseudo value must pass this */
	    continue;		/* This isn't the worth.. */

	  stats[cnt].name = (char*)(names - names2); /* Save offsets there */

	  namlen = strlen(dp->d_name);
	  if ((names - names2)+namlen+1 > namesize) {
	    /* Must expand */
	    char *onames = names2; /* Start point */
	    namesize <<= 1; /* Double it.. */
	    names2 = realloc(names2,namesize);
	    if (!names2) {
	      fprintf(stderr,"FTPD LS: Run out of memory!  Aargh!\n");
	      exit (9);
	    }
	    names = (names - onames) + names2; /* re-align.. */
	  }

	  if (f_nonprint)
	    prcopy(dp->d_name, names, namlen);
	  else
	    memcpy(names, dp->d_name, namlen);
	  names += namlen;
	  *names++ = '\0';

	  /*
	   * get the inode from the directory, so the -f flag
	   * works right.
	   */ /* DON'T ! */
	  /* stats[cnt].lstat.st_ino = dp->d_ino; */

	  /* save name length for -C format */
	  stats[cnt].len = namlen;

	  /* calculate number of blocks */
	  blocks += stats[cnt].lstat.st_blocks;

	  /* save max length if -C format */
	  if (f_column && maxlen < namlen)
	    maxlen = namlen;
	  ++cnt;
	}
	for (i = 0; i < cnt; ++i) {
	  (long)stats[i].name += (long) names2;
	}
	*s_stats = stats;
	*s_names = names2;
	if (ignored_names)
	  Tree_free(ignored_names);
	if (recursion_ignored_names)
	  Tree_free(recursion_ignored_names);
	stats[0].lstat.st_btotal = blocks;
	stats[0].lstat.st_maxlen = maxlen;
	ls_closedir(dirp);
	return(cnt);
}
