/* SUID -root piece to run ~ftp/bin/ls in regenerative mode */
/* For nic.funet.fi */

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include <sys/param.h>

#define EX_USAGE 64
#define EX_OK     0

extern struct passwd *getpwnam();
extern char *optarg;
extern int optind;
extern int opterr;

#ifndef	FTP_UID_NAME
# define FTP_UID_NAME "ftp"
#endif


void usage()
{
  fprintf(stderr,"\
Usage: ls-regen [-R]\n\
  Regenerate ftp-server's directory cache.\n\
  With  -R  option, do it recursively.\n\
  This can be run only from within the ftp's root.\n");

  exit(EX_USAGE);
}

int
main(argc,argv)
     int argc;
     char *argv[];
{
	struct passwd *pw = getpwnam(FTP_UID_NAME);
	char curdir[MAXPATHLEN];
	int homelen = 0;
	char *recursion = NULL;
	int c;

	while ((c = getopt(argc,argv,"R?")) != -1) {
	  switch (c) {
	    case 'R':
	        recursion = "-R";
		break;
	    case '?':
		usage();
		break;
	    default:
		break;
	  }
	}
	if (optind < argc)
	  usage();



	if (!pw) {
	  fprintf(stderr,"ls-regen: Can't figure out the home directory of %s\n",FTP_UID_NAME);
	  exit(9);
	}
	homelen = strlen(pw->pw_dir);
#ifdef USE_GETWD
	getwd(curdir);
#else
	getcwd(curdir,sizeof(curdir));
#endif
	if (homelen < 2 ||
	    strncmp(pw->pw_dir,curdir,homelen)!=0) {
	  fprintf(stderr,"ls-regen: You are not running this from within the anonymous FTP directory,\n          and/or system is not configured properly!\n");
	  fprintf(stderr,"CurDir='%s', ~ftp = '%s'\n",curdir,pw->pw_dir);
	  exit(8);
	}

	putenv("FTPD_LS=-Z");
	setuid(0);
	if (getuid() != 0) {
	  fprintf(stderr,"Could not turn myself to ROOT!\n");
	}
	freopen("/dev/null","w",stdout);

	sprintf(curdir,"%s/bin/ls",pw->pw_dir);

	execl(curdir,curdir,"-ZX",recursion,NULL);

	perror("exec ~ftp/bin/ls failed");
	return 255;
}
