$PACKAGE = "PLOTTER";

~handles
	PLOTTER

#include <X11/At/Axis.h>
#include <X11/At/BarPlot.h>
#include <X11/At/LabelAxis.h>
#include <X11/At/LinePlot.h>
#include <X11/At/Plot.h>
#include <X11/At/Plotter.h>
#include <X11/At/TextPlot.h>
#include <X11/At/XYAxis.h>
#include <X11/At/XYLinePlot.h>
#define castXtPointer(x) (XtPointer)(x)

~widgetClass 
AtAxis
	createCmd WafeDontManage


~widgetClass 
AtBarPlot
	createCmd WafeDontManage


void
AtBarPlotAttachData
        in: AtBarPlotWidget		# bar plot widget
	in: castXtPointer([float])	# floats
	const: AtFloat
	const: sizeof(float)
	const: 1
	const: argc-2

~widgetClass 
AtLabelAxis
	createCmd WafeDontManage

void
AtLabelAxisAttachData
        in: AtLabelAxisWidget		# label axis wiget
	in: [char *]			# strings
	const: sizeof(String)
	const: 1
	const: argc-2

~widgetClass 
AtLinePlot
	createCmd WafeDontManage

void
AtLinePlotAttachData
        in: AtLinePlotWidget		# line plot widget
	in: castXtPointer([float])	# floats
	const: AtFloat
	const: sizeof(float)
	const: 1
	const: argc-2

~widgetClass 
AtPlotter
	include <Plotter.h>
	click|motion x Position: \
		((AtPointCallbackData *)callData)->pixelx # pixel x coordinate
	click|motion y Position: \
		((AtPointCallbackData *)callData)->pixely # pixel y coordinate
	click|motion a double: \
		((AtPointCallbackData *)callData)->x1 # 1st axis x coordinate
	click|motion b double: \
		((AtPointCallbackData *)callData)->y1 # 1st axis y coordinate
 	click|motion c double: \
		((AtPointCallbackData *)callData)->x2 # 2nd axis x coordinate
	click|motion d double: \
		((AtPointCallbackData *)callData)->y2 # 2nd axis y coordinate
	drag|slide x Position: \
		((AtRectangleCallbackData *)callData)->pixelx1 \
			# pixel x lower left
	drag|slide y Position: \
		((AtRectangleCallbackData *)callData)->pixely1 \
			# pixel y lower left
	drag|slide a double: \
		((AtRectangleCallbackData *)callData)->x11 \
			# 1st axis x lower left
	drag|slide b double: \
		((AtRectangleCallbackData *)callData)->y11 \
			# 1st axis y lower left
	drag|slide c double: \
		((AtRectangleCallbackData *)callData)->x21 \
			# 2nd axis x lower left
	drag|slide d double: \
		((AtRectangleCallbackData *)callData)->y21 \
			# 2nd axis y lower left
	drag|slide X Position: \
		((AtRectangleCallbackData *)callData)->pixelx2 \
			# pixel x upper right
	drag|slide Y Position: \
		((AtRectangleCallbackData *)callData)->pixely2 \
			# pixel y upper right
	drag|slide A double: \
		((AtRectangleCallbackData *)callData)->x12 \
			# 1st axis x upper right
	drag|slide B double: \
		((AtRectangleCallbackData *)callData)->y12 \
			# 1st axis y upper right
	drag|slide C double: \
		((AtRectangleCallbackData *)callData)->x22 \
			# 2nd axis x upper right
	drag|slide D double: \
		((AtRectangleCallbackData *)callData)->y22 \
			# 2nd axis y upper right




void
AtPlotterGeneratePostscript
        in: String            		       # file name
        in: (AtPlotterWidget)AtPlotterWidget   # plotter widget
	in: String            		       # title
	in: int               		       # bounding box: x1
	in: int              		       # bounding box: y1
	in: int               		       # bounding box: x2
	in: int               		       # bounding box: y2
	in: Boolean           		       # landscape

~widgetClass 
AtTextPlot
	createCmd WafeDontManage

~widgetClass 
AtXYAxis
	createCmd WafeDontManage

~widgetClass 
AtXYLinePlot
	createCmd WafeDontManage

~require
At.inc

~bcAlias
AtXYLinePlotAttachData xyLinePlotAttachData 

void
xyLinePlotAttachData vulgo AtXYLinePlotAttachData
        in: AtXYLinePlotWidget		# xyLine plot widget
	in: [args]			# pairs of floats (xfloat/yfloat)




