#
# $Header: /home/rockware/cvs-main/operator/tcl/opTextEnglish.tcl,v 1.4 1995/03/05 22:28:26 erez Exp $
# Written by: Erez Strauss (C) All Rights Reserved 1995.
#
# This file Contains all the text that is displayed by the Operator program.
# That statement will come true eventually :-).
# This is the English version of the text. Each language will have a separate
# file.
#
# Simple proc to cause this file to be loaded.
#
proc opLangEnglish {} {}
#
#
# Menu / Buttons Labels.
#
set OPText(file) file
set OPText(run) run
set OPText(window) window
set OPText(windows) windows
#
# Dialogs Text / Messages.
#
#
# Help Text / Balloon Help.
#
# Help Topics
#  General
#   About-Operator, Operator,
#  Classes (There is a HelpCmd to change Control into OpControl).
#   OpControl, OpDirView, OpDirTree, OpDirIcons, OpAppGroup, OpXTerm
#  Menus
#   Menus, Help Menu, Windows Menu,
#  Actions
#   Drag & Drop, Remove File, Copy File, 
#  Help System
#   Help Message, Help Menu, Help Index, Balloon Help
#
# ----------------------------------------------------------------------------
#
# About Operator
#  
set {HelpTopics(about operator)} {The Operator program is a Files & Applications / Desktop Manager, based on Tcl/Tk. It has the following features: * Directory List / Tree / Icons, * Drag & Drop interface, * Applications Groups Display / Edit / Execute, ...

The operator is using the following tools (as available from ftp.aud.alcatel.com):
    Tcl/Tk    by John K. Ousterhout, Sun
    itcl      by Michael J. McLennan, AT&T
    TkPixmap  by Sven Delmas
    TkSteal   by Sven Delmas and Juergen Nickelsen
    TkIcon    by Sven Delmas
    blt       by George A. Howlett, AT&T

The Operator was written by Erez Strauss.
Send any comments to:
    Erez Strauss (e-mail: 100274.260@Compuserve.com)

Note: For more information about the Operator enter one of the following in the Help Subject field: 'Operator<Return>' or 'README<Return>'.
 You can always press button-3 inside the help message to get the help index popup menu.
}
#
# -----------------------------------------------------------------------------
# Operator
#
set HelpTopics(operator) { This is a general description of the Operator.
 The Operator program is a user friendly Files and Applications Manager (Desktop manager). The program is base on the Tcl/Tk tools.
On start up the Operator opens a Control window (see OpControl), this control window enable the user to click on an icons to raise one of the other windows that are part of the Operator.
The Other windows are
o  DirView - two lists view of a directory, one for directories and the other for files.
o  DirTree - View the directories structure and files as parts of a tree.
o  DirIcons - View a directory with an Icon for each file or directory.
o  XTerm - An xterm window wrapped inside a window with buttons and Menu.
See also: Menus, Help Menu, Windows Menu.
}
#
# -----------------------------------------------------------------------------
# Control
#
set HelpCmds(control) {set topic opcontrol}
set HelpTopics(opcontrol) { The Control window.
The Operator control window gives the user control over the operation of the Operator program. In the control window there are tree parts, the icons, the menubar and the buttons.
 In the icons area, each icon represent a window that is part of the Operator, double click on the icon will raised the window.
 The menubar contains the following menus File, Options, Windows and Help. The File has two actions one for sending mail (by default to me, send comment about Operator), and the other is Quit operator. The Options menu has setup option (most of them not yet implemented :-( ).
 For more information about the Windows and the Help Menu, please type 'Help Menu' or 'Windows Menu' in the subject line.
}
set HelpTopics(.control.menu) { Control menu contains three menu buttons: (1) File, (2) Options, (3) Help.
}
#
# -----------------------------------------------------------------------------
# DirView
#
set HelpCmds(dirview) {set topic opdirview}
set HelpTopics(opdirview) { The Directory View window.
Each 'directory View' window shows contents of a directory in two lists, one of files and the other of directories. The two lists can be ordered in horizontal or vertical position. In these windows you'll find menubar, lists, filtering fields and directory name entry.
 The filtering fields are optional. They contains the regular expressions, in the 'in' field those files that will appear in the lists and the 'out' field those file names that will not entered into the lists.
 The directory name entry enable you to move directly to any other directory by entering the other directory name and pressing the <Enter> Key.
 The menubar contains the following menus File Edit View Windows Help.
}
#
# -----------------------------------------------------------------------------
# DirTree
#
set HelpCmds(dirtree) {set topic opdirtree}
set {HelpCmds(directory tree)} {set topic opdirtree}
set HelpTopics(opdirtree) { The Directory Tree window.
Each directory tree window shows a tree of directories and files (optional).
There are three parts in such window, the menubar, the Directory tree, and Entries. The menubar contains the File, Edit, View, Windows and Help menus. The File menu contains the following operation * Rescan * Minimize * XTerm * Quit. The rescan operation reads the directory tree from the disk (or network). The minimize command, iconify the tree window. The XTerm command opens a XTerm window with current directory set to the root of the directory tree. The Quit menu option close the tree window.
The Edit menu present few editing commands, that change the directory tree. 
The View Menu controls the different parts of the Window, like whether to show the filtering entries or not, whether to show the depth entry, and the directory name entry. Updating the depth entry and pressing <Enter>, change the maximum tree depth that will be shown in the window, a -1 value in the depth entry will indicate no maximum depth. 
You can choose whether to show the files in the directory tree or not. You can also change the displayed tree to one upper directory or to your home directory.
For information about the windows and help menus please choose them from the help index popup menu (Press mouse button 3).
}
#
# -----------------------------------------------------------------------------
# DirIcons
#
set HelpCmds(diricons) {set topic opdiricons}
set HelpTopics(opdiricons) { The Directory Icons window.
 Directory Icons window is similar to the Tree and View windows type. It has menubar with File Edit View Windows and Help menus. The Windows and the Help Menus has Specific help subject, use mouse button 3 to see help information about them. The File Edit and View menus described in the DirView and DirTree help subjects.
 The Operator program display for each file type an icon.
}
#
# -----------------------------------------------------------------------------
# AppGroup
#
set HelpCmds(appgroup) {set topic opappgroup}
set HelpCmds(application) {set topic opappgroup}
set HelpTopics(opappgroup) { The Applications Groups windows.
 The Applications Windows shows applications and applications groups. Double click on application will execute the application, and double click on application group opens a new window with the applications in that group.
 Each user has a private applications list that is created from the default application list. The user can edit the default applications and add or delete applications.
 The menubar contains the following menu buttons File Edit Windows Help. The File menu contains the Save and Load commands that save and reload the private  applications list file. The Run command execute a the selected application.
 The Edit menu enable you to add new application of group, remove application or group and Update (edit) an existing item.
 The application update window contains the entry for each data field that is saved about an application. Change the entries in this window and you are changing the application, by choosing OK. You can save it into the file with menu File/Save and you can do the changes only temporary by not using the save command.
}
#
# -----------------------------------------------------------------------------
# XTerm
#
set HelpTopics(xterm) { The XTerm Window.
 The xterm window(s) provides the user with a user friendly interface to the xterm program. The XTerm window contains some buttons that perform some command inside the xterm. The xterm can be used as drag and drop target. Files dropped into the xterm are displayed with the more(1) command. Directories dropped into the xterm window cause the xterm to change directory to that directory.
}
#
# -----------------------------------------------------------------------------
# Help
#
set {HelpCmds(help system)} {set topic help}
set HelpTopics(help) { The Help Sub system.
The Operator Help sub system is composed from the following parts
* Balloon Help - popup windows with some words about the place where the mouse is in.
* Help Message window - shows a help message. Activated by F1 functions Key or Shift click on the third mouse button in all windows.
* Help Menu - a menu with few help subject and control over the balloon help activity.
* Help Index Menu - shows the help subjects that are presented in the Operator. choosing one of the options will activate the Help message window with the given subject.
}
# -----------------------------------------------------------------------------
# Menus
#
set HelpTopics(menus) { Operator Menus.
 The Operator program contains some menus. The order of the menus in the menubars is always: File Edit View Options Windows and Help. Not all the Menus appear in all the menubars. The Windows and Help Menus are the same in all menubars.
Both of them have a specific help subject, 'help menu' and windows menu'.
Please use button 3 select one of them.
}
#
# -----------------------------------------------------------------------------
# Help Menu
#
set {HelpTopics(help menu)} { The Help Menu.
 In the Help Menu you'll find the following:
* Help index sub menu that will show you Help message about the selected subject, and will change the help subject in the help message. Also when watching a help message, you can close the help message window by choosing 'Close Help Window'.
* How to use help - one of the subjects in the help system. you'll get more information about the help system in the Operator program.
* Balloon Help checkbutton - Control whether the Balloon help messages will appear. When balloon help messages are activated, you'll see a small help message when the mouse doesn't move and is inside a window item with a help message (currently not all places have balloon help messages).
* Ordering information - shows you the ~operator/etc/ORDER-FORM file inside the help message window.
* About Operator - Show more information about the Operator program and Tcl/Tk with extensions.
}
#
# -----------------------------------------------------------------------------
# Windows Menu
#
set {HelpTopics(windows menu)} { The Windows Menu.
 The windows menu appears in all the menubars that you'll see in the Operator program. This menu enable you to raise one window from a given type. In case there is no opened window from the given type you will be asked for directory name (in case of directory display types), and a new window from the requested type and directory place will be opened. The Xterm and the Clock windows are different. The Xterm always open a new XTerm window. The Clock open a new clock window and destroy and other open clock window. To raise the XTerm window you'll have to raise first the control window and double click on the wanted XTerm icon.
 If there is a selected file or directory name, the Windows menu will open the requested window in that directory.
}
#
# -----------------------------------------------------------------------------
# Drag & Drop
#
set HelpTopics(drag&drop) {The Drag and Drop is bound to Button 3.
The files/directory sources for the drag and drop are the Directory View windows and the Directory Trees windows (not yet the Icons). The Drop targets are all the three Directory displaying windows and the XTerm windows. Dropping the files in a directory displaying window will popup a dialog box with Operation choosing buttons Copy, Move, Cancel. Dropping a file name into a XTerm window will activate the 'more file-name' operation in that xterm. Dropping a directory name in XTerm window will change the current directory in that xterm window.
}
#
# -----------------------------------------------------------------------------
# Remove File
#
set {HelpTopics(remove file)} { Remove File.
 When you remove a file or directory, the file is not removed from the disk but moved into the ~/operator/trash directory (don't count on this).
 There are two ways to remove a file.
1. Double click on file with ~ at the end of the name or core file.
2. Select a file (in the Directory View or Directory Tree windows) and selecting the Edit/Remove from the menu.
}
#
# -----------------------------------------------------------------------------
# Copy file.
#
set HelpTopics(copy_file) { The copy file dialog box.
In the Copy File dialog box you are requested to choose what action will be performed.
* Copy, copy the file into the drag and drop target place and leave the original untouched.
* Move, Move the file into the drag and drop target directory and remove the original.
* Cancel, about any operation.
* Help, this help message.
}
#
# -----------------------------------------------------------------------------
# Default Message, when no other message was found.
#
set HelpTopics() {Unfortunately, there is no help information about the requested subject.
Please press the third mouse button inside the this message or the Subject entry to get a popup menu with Help Subjects. You can choose a help subject directly from that menu.
}
#
# -----------------------------------------------------------------------------
# The files: README, ORDER-FORM, ... 
# Load files when first asked for.
#
set HelpTopics(readme) {}
set HelpCmds(readme) {global HelpTopics HelpCmds OPSelf ; unset HelpCmds(readme) ; set HelpTopics(readme) [exec cat [file dirname $OPSelf]/README]}
#
set HelpTopics(order) {}
set HelpCmds(order) {global HelpTopics HelpCmds OPSelf ; unset HelpCmds(order) ; set HelpTopics(order) [exec cat [file dirname $OPSelf]/etc/ORDER-FORM]}
#
# -----------------------------------------------------------------------------
#
# Balloon Help messages.
#
#
# End of opTextEnglish.tcl.
