/*
 *--------------------------------------------------------------
 *
 * TkWmSetWmProtocols --
 *	Set the ICCCM WM_PROTOCOLS to be honored by this window.
 *	Currently, it is just WM_DELETE_WINDOW.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	A window property may get updated.
 *
 *--------------------------------------------------------------
 */

static void
TkWmSetWmProtocols(winPtr)
    TkWindow *winPtr;		/* Newly-created top-level window. */
{
    if (winPtr->wmInfoPtr->flags & WM_NEVER_MAPPED) {
	return;
    }
#ifndef X11R3
    else {
	/* assemble the WM_PROTOCOLS that we honor */
	int count = 0;
	Atom atomlist[8];
	atomlist[count++] = Tk_InternAtom(winPtr, "WM_DELETE_WINDOW");
/* 
 * 	other WM_PROTOCOLS go here -- e.g...
 * 	atomlist[count++] = Tk_InternAtom(winPtr, "WM_SAVE_YOURSELF");
 */

	/* 
	 * assign the honor list to the window not all X11R4's have 
	 * XSetWmProtocols() so use XChangeProperty() 
	 */

	/* XSetWmProtocols(winPtr->display, winPtr->window, atomlist, count); */

	XChangeProperty(winPtr->display, 
			winPtr->window, 
			Tk_InternAtom(winPtr, "WM_PROTOCOLS"),
			XA_ATOM, 32,
			PropModeReplace,
			atomlist, 
			count);

    }
#endif X11R3

    return;
}


/*
 *----------------------------------------------------------------------
 *
 * TkWmProtocolEventProc --
 *
 *	Handle a WM_PROTOCOL ICCCM event sent by the window manager to
 *	top level window.
 *
 *	The WM_PROTOCOL's currently handled are:
 *
 *		WM_DELETE_PROTOCOL:
 *
 * Results: None
 *
 * Side effects:
 *	for WM_DELETE_WINDOW:
 *		- window may be deleted if specified earlier by a 
 *		wm tcl command
 *		- a tcl command may be executed if sepcified earlier by a
 *		wm tcl command
 *	
 *
 */
void
TkWmProtocolEventProc(winPtr, eventPtr)
TkWindow *winPtr; 
XEvent *eventPtr;
{
    if ((Atom)(eventPtr->xclient.data.l)[0] ==
	Tk_InternAtom(winPtr, "WM_DELETE_WINDOW")) {

	WmInfo *wmPtr = winPtr->wmInfoPtr;

	if (wmPtr->deleteCmd) {
	    if (*(wmPtr->deleteCmd) == '\0') {
		/* callback is empty, just delete the window */
		Tk_DestroyWindow(winPtr);
	    } else {
		/* there is a callback so run it */
		(void) Tcl_Eval(winPtr->mainPtr->interp, 
				wmPtr->deleteCmd, 0, (char **)0);
	    }
	} else {
	    Tk_DestroyWindow(winPtr);
	}
    }
    /*
     * else { .. other WM_<ETC> cases go here ... }
     */
    return;
}


/* 
 *----------------------------------------------------------------------
 *
 * WmProtocolCmd
 *
 * implements 
 *
 *	wm protocol <window> delete [command_str] 
 *
 * right now just delete is supported for OPTION
 *
 * Kind of artificial, But makes it easier to merge into new
 * versions of Stock Tk.
 */
int
WmProtocolCmd(interp, CmdPtr, argc, argv)
Tcl_Interp *interp;
char **CmdPtr;
int argc;
char **argv;
{
#define Cmd (*CmdPtr)

    switch(argc) {
    case 4:
	/* 
	 * return current command 
	 */
	if (!Cmd || *Cmd == '\0') {
	    return TCL_OK;
	} else {
	    /* 
	     * chop off the <blank><window_name>
	     * and return just the cmd 
	     */
	    int x = strlen(Cmd) - strlen(argv[2]) - 1;
	    char tmpc = Cmd[x];
	    Cmd[x] = '\0';
	    {
		/* maybe should just have them put the window in the cmd */
		Tcl_AppendResult(interp, Cmd, (char *)NULL);
	    }
	    /* 
	     * tack the blank and window name back on 
	     */
	    Cmd[x] = tmpc;
	    return TCL_OK;
	}
    case 5:
	/* 
	 * (re)set command 
	 */
	if (Cmd) {
	    ckfree(Cmd);
	    Cmd = (char *)NULL;
	}
	if (*argv[4] != '\0') {
	    int x = strlen(argv[4]) + strlen(argv[2]) + 2;
	    if (!(Cmd = ckalloc(x))) {
		perror("wm protocol:");
	    } else {
		sprintf(Cmd, "%s %s", argv[4], argv[2]);
	    }
	}
	return TCL_OK;
    default:
	Tcl_AppendResult(interp, "wrong # of arguments: must be \"",
	    argv[0], " protocol window <attribute> [cmd]\"", (char *) NULL);
	return TCL_ERROR;
    }

#undef Cmd
}
