#---------------------------------------------------------------------------
#
#	Define a menu bar for the window w. The menu bar is specified
#	as a list of menu button descriptions. Each menu button descr
#	consists of a button name, a button label, and a list of triplets
#	giving menu item types, menu labels, and actions.
#
#	The optional 'init' argument allows special things (like status
#	buttons) to be placed before the menu buttons are placed.
#
#---------------------------------------------------------------------------

defwidget Menubar

defmethod Menubar new {name args} {

  args	menus init {dir horizontal} layout

  set n 1
  if { $dir == "horizontal" } {
    set packing left
    set dir "right"
  } else {
    set packing top
    set dir "bottom"
  }
  set packopts {padx 4 pady 4}
  set packing [concat $packing $packopts]

  Frame new $name -layout $layout
  defsuper $name Menubar

  if { $init != {} } {
    eval [concat $init [list $name]]
  }

  foreach desc $menus {
    if { $desc == "space" } {
      Space new *$name -layout $packing -width 6
      incr n
      continue
    }
    if { $desc == "stretch" } {
      set packing [concat $dir $packopts]
      continue
    }
    set symbol [lindex $desc 0]
    set label [lindex $desc 1]
    if { $label == {} } {
      set label $symbol
    }
    Menubutton new *$name -layout $packing \
	-text [space(restore) $label] -items [lrange $desc 2 end] \
	-symbolic $symbol -parentframe $name
  }

  return $name
}

defmethod Menubar find {name} {

  foreach child [winfo children $self] {
    if { [is $child Menubutton] && [$child slot symbolic] == $name } {
      return $child
    }
  }
  return
}

