#---------------------------------------------------------------------------
#
#	Frame Creation
#
#---------------------------------------------------------------------------

defwidget Frame

defmethod Frame new {name args} {

  args	{relief raised} width height layout

  set options [list -relief $relief -borderwidth 2 -background [Color slot bg]]
  if { $width != {} } then {
    lappend options -width $width
  }
  if { $height != {} } then {
    lappend options -height $height
  }

  eval [concat [list frame ${name}] $options]
  Frame instantiate $name $layout
}

Window addDemo Frame

defmethod Frame demo {} {

  set t [Toplevel new * -title "Primitives" -info true -resizable true]
  Message new *$t -layout left -text "Sample text. More text." -layout top
  Text new *$t -layout top -text "Hello world" -state normal

  Label new *$t -text "Label" -layout top
  Label new *$t -text "Text-Label" -layout top -edittext true
  Scale new *$t -label "Scale" -layout top
  Space new *$t -layout left 

  Pair new *$t -label "Printer" -text "Aldebaran" -layout top
  Entry new *$t -layout top -text "Initial input..." -max 10
  Inputline new *$t -layout top -text "Input" -label "Type here:" \
	-edittext true

  Button new *$t -layout top -text "Press me" -action "puts stdout ouch.."
  Frame new $t.f -layout top -relief flat
  Menubutton new *$t.f -layout left -text "Menu" -items {
	{item One action one}
	{item Two action two}
  } -parentframe $t.f
  Menubutton new *$t.f -layout left -text "Menu 2" -items {
	{item Three action three}
	{item Four action four}
  } -parentframe $t.f

  Checkbutton new *$t -text "Hello" -layout top -variable val

  Varmenubutton new *$t -layout top -items {funk punk punkt reach load} \
	-variable val -text Varmenu

  Button new $t.b -layout {padx 20 pady 20 bottom} \
	-textfont largebold -text "Dismiss" \
	-action [list $t Dismiss]
}
