/* Bos_Slots.c - operations on slots */

/* 
 *
 * /afs/cs/project/edrc/ndim/source/bos/libbos/Bos_Slots.c,v 1.2 1992/07/14 03:01:44 snl Exp
 *
 * HISTORY
 *
 * Bos_Slots.c,v
 * Revision 1.2  1992/07/14  03:01:44  snl
 * Added evanescence everywhere, plus small changes to Storage
 *
 * Revision 1.1.1.1  1992/05/08  19:45:34  snl
 * bos 1.2
 *
 * Revision 1.1  92/03/06  22:02:59  snl
 * Initial revision
 * 
 * Revision 1.2  92/01/27  16:19:32  snl
 * Port to new TCL
 * 
 * Revision 1.1  91/12/16  20:14:47  snl
 * Initial revision
 * 
 */

#ifndef lint
static char *_RCSId =
 "/afs/cs/project/edrc/ndim/source/bos/libbos/Bos_Slots.c,v 1.2 1992/07/14 03:01:44 snl Exp";
#endif /* lint */

#include "bosInt.h"

#define findSlotEntry(_obj,_name) \
 Tcl_FindHashEntry((_obj)->slots,_name)

static Tcl_HashEntry *addSlot();
Bos_Slot *_BosFindSlot();	/* semi-static */

int Bos_AddSlot(obj, slot_name, slot_type, slot_pri, slot_value)
     Bos_Object *obj;
     char *slot_name;
     Bos_Slot_Type slot_type;
     Bos_Slot_Pri slot_pri;
     _VoidPtr slot_value;
{
  Tcl_HashEntry *e;
  int want_evanescent;

  want_evanescent = (slot_type & Bos_SLOT_EVANESCENT_MASK);
  slot_type = Bos_PlainSlotType(slot_type);
  e = addSlot(obj, slot_name, slot_type, slot_pri, slot_value);
  if (e != (Tcl_HashEntry *)0 && want_evanescent) {
    Bos_Slot *s = (Bos_Slot *)Tcl_GetHashValue(e);

    s->type |= Bos_SLOT_EVANESCENT_MASK;
  }
  return (e == (Tcl_HashEntry *)0)? BOS_ALREADY: BOS_OK;
}

int Bos_CopySlot(obj, slot_name, dest)
     Bos_Object *obj;
     char *slot_name;
     Bos_Object *dest;
{
  Bos_Slot *slot;
  int s;

  slot = _BosFindSlot(obj, slot_name);
  if (slot == (Bos_Slot *)0)
    s = BOS_NOT_FOUND;
  else {
    _VoidPtr copy_val;
    Bos_Slot_Type plain_type;
    int want_evanescent;
    Tcl_HashEntry *e;

    plain_type = Bos_PlainSlotType(slot->type);
    want_evanescent = (slot->type & Bos_SLOT_EVANESCENT_MASK);
    if (plain_type != Bos_SLOT_METHOD || slot->value == (_VoidPtr)0)
      copy_val = slot->value;
    else {
      Bos_Method *m = (Bos_Method *)slot->value;
      copy_val = (_VoidPtr)m->body;
    }
    e = addSlot(dest, slot->name, plain_type, slot->pri, copy_val);
    if (e != (Tcl_HashEntry *)0 && want_evanescent) {
      Bos_Slot *s = (Bos_Slot *)Tcl_GetHashValue(e);
      
      s->type |= Bos_SLOT_EVANESCENT_MASK;
    }
    s = BOS_OK;
  }
  return s;
}

int Bos_RemoveSlot(obj, slot_name)
     Bos_Object *obj;
     char *slot_name;
{
  Tcl_HashEntry  *e;
  int s;

  e = findSlotEntry(obj, slot_name);
  if (e == (Tcl_HashEntry *)0)
    s = BOS_NOT_FOUND;
  else {
    Bos_Slot *slot;
    void destroySlot();

    slot = (Bos_Slot *)Tcl_GetHashValue(e);
    destroySlot(slot);
    Tcl_DeleteHashEntry(e);
    s = BOS_OK;
  }
  return s;
}

int Bos_SetSlot(obj, op_mask, slot_name, slot_type, slot_pri, slot_value)
     Bos_Object *obj;
     int op_mask;
     char *slot_name;
     Bos_Slot_Pri slot_pri;
     _VoidPtr slot_value;
{
  Tcl_HashEntry *entry;
  Bos_Slot *slot;
  int s;

  slot_type &= ~Bos_SLOT_EVANESCENT_MASK;
  entry = findSlotEntry(obj, slot_name);
  if (entry == (Tcl_HashEntry *)0)
    s = BOS_NOT_FOUND;
  else {
    Bos_Slot_Type plain_type;

    slot = (Bos_Slot *)Tcl_GetHashValue(entry);
    plain_type = Bos_PlainSlotType(slot->type);
    s = BOS_OK;
    if (op_mask & Bos_SET_NAME) {
      char *new_name = (char *)slot_value;

      if (new_name == (char *)0)
        return BOS_ERROR;
      else {
        Tcl_HashEntry *new_entry;
	char *new;
	Bos_Slot *s;
        void destroySlot();
        int new_p;

        new_entry = Tcl_CreateHashEntry(obj->slots, new_name, &new_p);
	if (!new_p)
	  destroySlot((Bos_Slot *)Tcl_GetHashValue(new_entry));
	Tcl_SetHashValue(new_entry, (ClientData)slot);
	Tcl_DeleteHashEntry(entry);
	new = (char *)ckalloc(strlen(new_name) + 1);
	strcpy(new, new_name);
        ckfree(slot->name);
	slot->name = new;
      }
    }
    if (op_mask & Bos_SET_VALUE) {
      if (slot->value != (_VoidPtr)0 && plain_type != Bos_SLOT_CMETHOD) {
        if (plain_type == Bos_SLOT_FOREIGN)
	  Bos_FreeCSlotValue(slot->value, slot->pri);
	else if (plain_type != Bos_SLOT_METHOD)
	  ckfree(slot->value);
	else {
          Bos_Method *method = (Bos_Method *)slot->value;

	  if (method->body != (char *)0)
	    ckfree(method->body);
	  method->flags |= Bos_METHOD_CHANGED;
	}
      }
      if (plain_type == Bos_SLOT_CMETHOD ||
          ((op_mask & Bos_SET_TYPE) && (slot_type == Bos_SLOT_CMETHOD)))
        slot->value = slot_value;
      else if (plain_type == Bos_SLOT_FOREIGN ||
               ((op_mask & Bos_SET_TYPE) && (slot_type == Bos_SLOT_FOREIGN))) {
	Bos_Slot_Subtype st = slot->pri;

        if (op_mask & Bos_SET_PRI)
	  st = slot_pri;
        slot->value = Bos_CopyCSlotValue(slot_value, st);
      } else {
        char *val_as_str = (char *)slot_value, *new_val;

	if (val_as_str == (char *)0)
	  new_val = (char *)0;
	else {
	  new_val = (char *)ckalloc(strlen(val_as_str) + 1);
	  strcpy(new_val, val_as_str);
	}
	if (plain_type == Bos_SLOT_METHOD ||
	    ((op_mask & Bos_SET_TYPE) && slot_type == Bos_SLOT_METHOD)) {
          Bos_Method *method;

          /*
	   * Already is a method; just pick up the pointer.
	   */
          if (plain_type == Bos_SLOT_METHOD)
	    method = (Bos_Method *)slot->value;
          else {
	    /*
	     * Changing to a method from something else; create
	     * the method structure and store it in slot->value
	     */
	    method = (Bos_Method *)ckalloc(sizeof(Bos_Method));
	    method->flags = (Bos_Method_Flags)0;
	    method->body = (char *)0;
	    method->proc_name = (char *)0;
	    slot->value = (_VoidPtr)method;
	  }
	  method->body = new_val;
	} else
	  slot->value = new_val;
      }
    }
    if (op_mask & Bos_SET_TYPE) {
      int was_evanescent;

      was_evanescent = (slot->type & Bos_SLOT_EVANESCENT_MASK);
      if (plain_type == Bos_SLOT_METHOD && slot_type != Bos_SLOT_METHOD &&
          !(op_mask & Bos_SET_VALUE)) {
        Bos_Method *method = (Bos_Method *)slot->value;
        char *val = method->body;

        if (method->flags & Bos_METHOD_INTERNED)
	  ckfree(method->proc_name);
	ckfree(method);
	if (slot_type == Bos_SLOT_CMETHOD)
	  slot->value = (_VoidPtr)0;
	else
          slot->value = (_VoidPtr)val;
	/*
	 * XXX Note: The TclProc bound to the method was not destroyed
         *           by the above operation, since we have no pointer
	 *           to the world in which it was interned!
	 */
      } else if (slot_type == Bos_SLOT_METHOD && plain_type != Bos_SLOT_METHOD
                 && !(op_mask & Bos_SET_VALUE)) {
        Bos_Method *method;

	method = (Bos_Method *)ckalloc(sizeof(Bos_Method));
	if (plain_type != Bos_SLOT_CMETHOD)
	  method->body = (char *)slot->value;
	else
	  method->body = (char *)0;
	method->proc_name = (char *)0;
	method->flags = (Bos_Method_Flags)0;
	slot->value = (_VoidPtr)method;
      }
      slot->type = slot_type;
      if (was_evanescent)
	slot->type |= Bos_SLOT_EVANESCENT_MASK;
    }
    if (op_mask & Bos_SET_PRI) {
      if (plain_type != Bos_SLOT_FOREIGN)
        slot->pri = slot_pri;
      else if (Bos_GetCSlotTypeName(slot_pri) != (char *)0)
        slot->pri = slot_pri;
      else
        s = BOS_NOT_FOUND;
    }
    if (op_mask & Bos_SET_EVANESCENT_ON)
      slot->type |= Bos_SLOT_EVANESCENT_MASK;
    if (op_mask & Bos_SET_EVANESCENT_OFF)
      slot->type &= ~Bos_SLOT_EVANESCENT_MASK;
  }
  return s;
}

/* Semi-Public code
 */

Bos_Slot_Type _Bos_ParseSlotType(str)
     char *str;
{
  Bos_Slot_Type stype;

  if (str == (char *)0)
    stype = Bos_SLOT_ILLEGAL;
  else {
    int evanescent = 0;

    if (*str == '.') {
      evanescent = 1;
      str++;
    }
    if (!strcmp(str, "normal"))
      stype = Bos_SLOT_NORMAL;
    else if (!strcmp(str, "method"))
      stype = Bos_SLOT_METHOD;
    else if (!strcmp(str, "object"))
      stype = Bos_SLOT_OBJECT;
    else if (!strcmp(str, "reference"))
      stype = Bos_SLOT_REFERENCE;
    else if (!strcmp(str, "foreign"))
      stype = Bos_SLOT_FOREIGN;
    else if (!strcmp(str, "cmethod"))
      stype = Bos_SLOT_CMETHOD;
    else
      stype = Bos_SLOT_ILLEGAL;
    if (stype != Bos_SLOT_ILLEGAL && evanescent)
      stype |= Bos_SLOT_EVANESCENT_MASK;
  }
  return stype;
}

/* Local procedures
 */

Bos_Slot *_BosFindSlot(obj, slot_name)
     Bos_Object *obj;
     char *slot_name;
{
  Tcl_HashEntry *entry;

  entry = findSlotEntry(obj, slot_name);
  return (entry == (Tcl_HashEntry *)0)? (Bos_Slot *)0:
    (Bos_Slot *)Tcl_GetHashValue(entry);
}

static Tcl_HashEntry *addSlot(obj, slot_name, slot_type, slot_pri, slot_value)
     Bos_Object *obj;
     char *slot_name;
     Bos_Slot_Type slot_type;
     Bos_Slot_Pri slot_pri;
     _VoidPtr slot_value;
{
  Tcl_HashEntry *entry;
  Boolean new_p;

  entry = Tcl_CreateHashEntry(obj->slots, slot_name, &new_p);
  if (new_p) {
    Bos_Slot *new_slot, *makeSlot();

    new_slot = makeSlot(slot_name, slot_type, slot_pri, slot_value);
    Tcl_SetHashValue(entry, (ClientData)new_slot);
  } else
    entry = (Tcl_HashEntry *)0;
  return entry;
}

static Bos_Slot *makeSlot(slot_name, slot_type, slot_pri, slot_value)
     char *slot_name;
     Bos_Slot_Type slot_type;
     Bos_Slot_Pri slot_pri;
     _VoidPtr slot_value;
{
  Bos_Slot *new_slot;
  void saveSlotValue();

  new_slot = (Bos_Slot *)ckalloc(sizeof(Bos_Slot));
  new_slot->name = (char *)ckalloc(strlen(slot_name) + 1);
  strcpy(new_slot->name, slot_name);
  new_slot->type = slot_type;
  new_slot->pri = slot_pri;
  new_slot->value = (_VoidPtr)0;
  saveSlotValue(new_slot, slot_value);
  return new_slot;
}

static void destroySlot(slot)
     Bos_Slot *slot;
{
  Bos_Slot_Type plain_type;

  plain_type = Bos_PlainSlotType(slot->type);
  if (slot != (Bos_Slot *)0) {
    if (slot->name != (char *)0)
      ckfree(slot->name);
    if (plain_type != Bos_SLOT_CMETHOD && slot->value != (_VoidPtr)0) {
      if (plain_type == Bos_SLOT_FOREIGN)
        Bos_FreeCSlotValue(slot->value, slot->pri);
      else if (plain_type != Bos_SLOT_METHOD)
        ckfree(slot->value);
      else {
        Bos_Method *method = (Bos_Method *)slot->value;

	if (method->body != (char *)0)
	  ckfree(method->body);
	if (method->flags & Bos_METHOD_INTERNED)
	  ckfree(method->proc_name);
	ckfree(method);
      }
    }
    ckfree(slot);
  }
}

static void saveSlotValue(slot, value)
     Bos_Slot *slot;
     _VoidPtr value;
{
  if (slot->type == Bos_SLOT_CMETHOD)
    slot->value = value;
  else if (slot->type == Bos_SLOT_FOREIGN) {
    if (slot->value != (_VoidPtr)0)
      Bos_FreeCSlotValue(slot->value, slot->pri);
    slot->value = Bos_CopyCSlotValue(value, slot->pri);
  } else if (slot->type == Bos_SLOT_METHOD) {
    Bos_Method *method = (Bos_Method *)slot->value;

    if (method == (Bos_Method *)0) {
      method = (Bos_Method *)ckalloc(sizeof(Bos_Method));
      method->body = (char *)0;
      method->proc_name = (char *)0;
      method->flags = (Bos_Method_Flags)0;
      slot->value = (_VoidPtr)method;
    }
    if (method->body != (char *)0)
      ckfree(method->body);
    method->flags |= Bos_METHOD_CHANGED;
    if (value == (_VoidPtr)0)
      method->body = (char *)0;
    else {
      char *str = (char *)value;

      method->body = (char *)ckalloc(strlen(str) + 1);
      strcpy(method->body, str);
    }
  } else {
    if (slot->value != (_VoidPtr)0)
      ckfree(slot->value);
    if (value == (_VoidPtr)0)
      slot->value = (_VoidPtr)0;
    else {
      char *str = (char *)value;

      slot->value = (char *)ckalloc(strlen(str) + 1);
      strcpy(slot->value, str);
    }
  }
}
