;;;
;;;          Copyright 1990, 1991 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;;
;;; buttons.sc -- A couple of simple buttons.
;;;

;;; $Id: buttons.sc,v 2.2 91/09/15 00:58:23 johani Exp $

(module stoxbutton)

(include "../include/masks.sch")
(include "../include/objects.sch")
(include "../include/lw-objs.sch")
(include "../include/util.sch")

(define-external dfsm stoxdfsm)
(define-external add-new-args stoxutil)
(define-external widget stoxwidget)

(include "../macros/extsyntax.sc")
(include "../macros/oos.sc")

;;;
;;; Button -- the push-button works ok but the more sophisticated
;;;           variants text-, toggle- and radio-button are not ready.
;;;
(define-class (button . args)
  (locals
   (scr ((match-arg 'parent 'no-default args) 'screen))
   (gcache (match-arg 'gcache (scr 'gcache) args))
   (gc-draw  (gcache 'gc-draw))
   (gc-clear (gcache 'gc-clear))
   (gc-invert  (gcache 'gc-invert))
   (on-action  (match-arg 'on-action (lambda (e) #f) args))
   (label (match-arg 'label #f args))
   (lsize (if label (gc-draw 'querytextextents (s8->s16 label))))
   (text (if label 
	     (list (imagetext8 'make 4 (+ 4 (lsize 'font-ascent))
			       label))))
   (width  (match-arg 'width (if label
				 (+ 8 (lsize 'overall-width))
				 30)
		      args))
   (height (match-arg 'height (if label
				  (+ 8 (lsize 'font-ascent)
				     (lsize 'font-descent))
				  20)
		      args))
   (high-light 
    (list (polyrectangle 'make `((1 1 ,(- width 3) ,(- height 3))))) )
   (rev-area
    (list (polyfillrectangle 'make `((1 1 ,(- width 2) ,(- height 2))))) )

   (semantics
    `(((Outside       . EnterNotify) Inside
				     ,(lambda (e)
					(me 'draw high-light gc-draw)
					(scr 'flush!) ))
      ((Outside       . LeaveNotify) Outside) ; Due to a server bug?
      ((Outside       . ButtonRelease) Outside)
      ((Inside        . LeaveNotify) Outside
				     ,(lambda (e)
					(me 'draw high-light gc-clear)
					(scr 'flush!) ))
      ((Inside        . EnterNotify) Inside)
      ((Inside        . ButtonRelease) Inside)
      ((Inside        . ButtonPress) InsidePressed
				     ,(lambda (e)
					(me 'draw rev-area gc-invert)
					(scr 'flush!) ))
      ((InsidePressed . LeaveNotify) Outside
				     ,(lambda (e)
					(me 'draw rev-area gc-invert)
					(me 'draw high-light gc-clear)
					(scr 'flush!) ))
      ((InsidePressed . ButtonRelease) Inside 
				       ,(lambda (e)
					  (me 'draw rev-area gc-invert)
					  (scr 'flush!)
					  (on-action e) ))
      ((Outside        . Expose) Outside
				 ,(lambda (e)
				    (if label
					(me 'draw text gc-draw) )
				    (scr 'flush!) ))
      ((Inside         . Expose) Inside
				 ,(lambda (e)
				    (me 'draw high-light gc-draw)
				    (if label
					(me 'draw text gc-draw) )
				    (scr 'flush!) ))))
   )
  (inherit
   (widget (cons* 'width width 'height height
		  'value-mask
		  (make-window-value-mask 
		   `(background-pixel ,(gcache 'background))
		   `(event-mask ,(make-bitmask 'event 'ButtonPress
					       'ButtonRelease 'EnterWindow
					       'LeaveWindow 'Exposure)))
		  'dfsm-data (list 'Outside #f semantics)
		  args)) )
  (methods
   (set-on-action! (lambda (x) (set! on-action x)))
   (get-on-action (lambda () on-action))
   (label (lambda ()
	    (if label label #f) ))
   ))

;;;
;;; Toggle-button
;;;
(define-class (toggle-button . args)
  (locals
   (scr        ((match-arg 'parent 'no-default args) 'screen))
   (gcache     (match-arg 'gcache (scr 'gcache) args))
   (gc-draw    (gcache 'gc-draw))
   (gc-clear   (gcache 'gc-clear))
   (gc-invert  (gcache 'gc-invert))
   (gc-reverse (gcache 'gc-reverse))
   (width      (match-arg 'width 10 args))
   (height     (match-arg 'height 10 args))
   (on-action  (match-arg 'on-action (lambda () #f) args))
   (off-action (match-arg 'off-action (lambda () #f) args))
   (high-light 
    (list (polyrectangle 'make `((1 1 ,(- width 3) ,(- height 3))))) )
   (toggle-area
    (list (polyfillrectangle 'make `((3 3 ,(- width 6) ,(- height 6))))) )
   (toggle-invert (lambda () (me 'draw toggle-area gc-invert) (scr 'flush!)))

   (toggle-semantics
    `(((OutOff . EnterNotify) InOff
			      ,(lambda (e)
				 (me 'draw high-light gc-draw)
				 (scr 'flush!) ))
      ((OutOff . LeaveNotify) OutOff) ; Due to a server bug?
      ((InOff  . LeaveNotify) OutOff
			      ,(lambda (e)
				 (me 'draw high-light gc-clear)
				 (scr 'flush!) ))
      ((OutOff . ButtonRelease) OutOff)
      ((InOff  . ButtonRelease) InOff)
      ((InOff  . ButtonPress) InOffPressed
			      ,(lambda (e)
				 (me 'draw toggle-area gc-invert)
				 (scr 'flush!) ))
      ((InOffPressed . LeaveNotify) OutOff
				   ,(lambda (e)
				      (me 'draw toggle-area gc-invert)
				      (me 'draw high-light gc-clear)
				      (scr 'flush!) ))
      ((InOffPressed . ButtonRelease) InOn
				      ,(lambda (e)
					 (on-action e) ))
      ((InOn . LeaveNotify) OutOn
			    ,(lambda (e)
			       (me 'draw high-light gc-reverse)
			       (scr 'flush!) ))
      ((InOn . ButtonRelease) InOn)
      ((InOn . ButtonPress) InOnPressed
			    ,(lambda (e)
			       (me 'draw toggle-area gc-invert)
			       (scr 'flush!) ))
      ((InOnPressed . ButtonRelease) InOff
				     ,(lambda (e)
					(off-action e) ))
      ((InOnPressed . LeaveNotify) OutOn
				   ,(lambda (e)
				      (me 'draw toggle-area gc-invert)
				      (me 'draw high-light gc-clear)
				      (scr 'flush!) ))
      ((OutOn . EnterNotify) InOn
			     ,(lambda (e)
				(me 'draw high-light gc-draw)
				(scr 'flush!) ))
      ((OutOn . LeaveNotify) OutOn) ; Due to a server bug?
      ((OutOn . ButtonRelease) OutOn)))

   (pushed-args (add-new-args 'border-width 1
			      'width width 'height height
			      'value-mask
			      (make-window-value-mask 
			       `(background-pixel ,(gcache 'background))
			       `(event-mask ,(make-bitmask 'event
							   'ButtonPress
							   'ButtonRelease
							   'EnterWindow
							   'LeaveWindow
							   'Exposure)))
			      'dfsm-data (list 'OutOff #f toggle-semantics)
			      args)) )
  (inherit
   (widget pushed-args) )
  (methods
   (set-on-action! (lambda (x) (set! on-action x)))
   (get-on-action (lambda () on-action))
   (set-off-action! (lambda (x) (set! off-action x)))
   (get-off-action (lambda () off-action))
   ))
