;;;
;;;              Copyright 1991 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;; atypes.sc -- this is included in requests[12].sc

(module scixatypes)

(include "../include/util.sch")
(include "../include/masks.sch")
(include "../include/objects.sch")
(include "../include/lw-objs.sch")
(include "../include/lowlevel.sch")

(include "../macros/extsyntax.sc")

;;; a-listofvalue
;;; Note: This will have to be revised wrt the new masks.
(define (a-listofvalue data buffer dpy)
  ((data 'listofvalue) buffer dpy) )

;;; a-intlist -- assembles a list of small (one byte) integers -- for those
;;;              functions that still generate lists of ints.
(define (a-intlist l buffer dpy)
  (a-string8 (list->string (map integer->char
				l))
	     buffer dpy))

;(define a-bitmask a-card32)
(define (a-bitmask data buffer dpy)
  (a-card32 (data 'mask) buffer dpy) )

;;; Ideally these types (the ones mapped on X resources) should always work on
;;; objects, but that is not practical as we then would have to create dummy
;;; objects to match things like 'None 'CopyFromParent and so on. Therefore
;;; they work on numbers as well, at a slight performace penalty.
;;;
(define a-resource    (lambda (o buffer dpy)
			(a-card32 (if (procedure? o)
				      (o 'id)
				      o)
				  buffer dpy)))
(define a-window a-resource)
(define (a-window-or-none w buffer dpy)
 (if (eq? w 'None)
     (a-card32 0 buffer dpy)
     (a-window w buffer dpy) ))

(define a-pixmap   a-resource)
(define a-cursor   a-resource)

(define (a-cursor-or-none c buffer dpy)
  (if (eq? c 'None)
      (a-card32 0 buffer dpy)
      (a-cursor c buffer dpy) ))

(define a-font     a-resource)
(define a-gcontext a-resource)
(define a-colormap a-resource)
(define a-drawable a-resource)
(define a-fontable a-resource)
(define a-atom     a-card32)
(define a-visualid a-resource)

(define a-timestamp (lambda (t buffer dpy)
		      (a-card32 (if (eq? t 'CurrentTime)
				    0
				    t)
				buffer dpy)))

(define a-keysym a-card32)

;;; color is a new datatype that is special to SCIX. It replaces card32 in
;;; the X protocol when reffering to pixel values. This enables us to keep
;;; colors as objects as long as possible.
(define a-color (lambda (o buffer dpy)
		(a-card32 (o 'pixel) buffer dpy) ))

(define (a-bitmask16 x buffer dpy)       ; Due to protocol error in req #12
  (if x
      (a-card16 (x 'mask) buffer dpy)
      (a-card16 0 buffer dpy) ))


;(define a-bitgravity a-card8)		; Eg only 0..10
;(define a-wingravity a-card8)		; Eg only 0..10
(define a-setofevent a-card32)		; With some additional restrictions
(define a-setofpointerevent a-card16)	; With some additional restrictions (J)
(define a-setofdeviceevent a-card16)	; With some additional restrictions (J)
(define a-setofkeymask a-card16)	; (J)
(define a-setofkeybutmask a-card16)	; With some additional restrictions

;;; ...or CARD8's
(define a-keycode a-card8)
(define a-button  a-card8)
(define a-request a-card8)

(define (a-bool arg buffer dpy)
  (cond ((eq? arg #t) (a-card8 1 buffer dpy))
	((eq? arg #f) (a-card8 0 buffer dpy))
	(else (error 'a-bool
		     "Argument does not evaluate to #t or #f: ~a" arg)) ))

(define a-string16 a-string8)

;;; This is not really the best way to do it, but it will work until all
;;; intlists are gone.
(define (a-listofbyte l buffer dpy)
  (cond ((pair? l) (a-intlist l buffer dpy))
	((string? l) (a-string8 l buffer dpy)) ))      

