;;;
;;;              Copyright 1991 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;;
;;; demo.sc -- this is a small wrapper application that only provide a
;;;            graphical interface to the other demonstration applications.
;;;

;;; $Id: demo.sc,v 1.4 91/09/15 01:01:19 johani Exp $

(module scixdemo (with scix stox demohello demotracker demobounce
                       demographic demowheel demofifteen))

;;; Get the module declarations for various things we use:
(include "../include/scix.sch")
(include "../include/stox.sch")
(include "../include/scixdemo.sch")

(include "../macros/extsyntax.sc")     ; The extend-syntax macro mechanism.
(include "../macros/oos.sc")           ; Our OO package.

(define (scixdemo scr)
  (let ((w (container 'make 'parent (scr 'root) 'title "SCIX Examples"))
        (gcache (graphics-cache 'make 'screen scr 'fontname "variable")) )
    (let ((m (pulldown-menu
              'make 'parent w 'gcache gcache 'label "Examples"
              'entries
              `(("Hello World" . ,(lambda () (demo-hello scr)))
                ("Tracker"     . ,(lambda () (demo-tracker scr)))
                ("Bounce"      . ,(lambda () (demo-bounce 200 500 scr)))
                ("Graphic"     . ,(lambda () (demo-graphic 400 'smart scr)))
                ("Battleships" . ,(lambda ()
                                    (display (format 
             "To run Battleships on two X servers do (demo-ship scr1 scr2)~%"))
                                    (demo-ship scr scr)))
                ("Fifteen"    . ,(lambda () (demo-fifteen 4 4 scr)))
                ("Colour Wheel" . ,(lambda () (demo-wheel 400 scr)))
                ("Recur..."    . ,(lambda () (scixdemo scr))) )))
          (cbut (button 'make 'parent w 'gcache gcache 'label "The Code"
                        'on-action
                        (lambda (e)
                          (view-textfile
                           'filename "demo/demo.sc" 'screen scr
                           'title "The Code for the Example Application"))))
          (abut (button 'make 'parent w 'gcache gcache 'label "About"
                        'on-action (lambda (e)
                                     (view-textfile 'filename "demo/About"
                                                    'title "About SCIX"
                                                    'screen scr))))
          (qbut (button 'make 'parent w 'gcache gcache 'label "Quit"
                        'on-action (lambda (e)
                                     (w 'destroywindow)
                                     (gcache 'free) ))))
      ;; Set up the "TeX-boxes":
      (w 'set-box! (vbox-to 40 (vss)
                            (hbox (hskip 3) m (hskip 10) (hfill) cbut
                                     (hskip 3) abut (hskip 3) qbut (hskip 3))
                            (vss)))
      (for-each (lambda (b) (b 'stox-activate)) (list m cbut abut qbut w))
      (scr 'flush!)
      (scix-process-events scr))))
