;;;
;;;              Copyright 1990 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;

;;; $Id: defclass.sc,v 1.4 90/07/06 00:40:16 johani Exp $

;; Author: Magnus Persson <mpersson@stkhlm.dec.com>
;;
;; The DEFINE-CLASS macro is described in the report "SCIX - A Scheme
;; Interface to the X Window System". The code is inspired by the 
;; example pp. 209-214 in "The SCHEME Programming Language", Prentice-Hall
;; 1987, by Kent Dybvig, further developed by Hakan Huss and Johan Ihren.
;;
;; I have been cautious not to shadow the variables in PARAMS. This is one
;; of the really crucial items in the implementation.

;; Utilities

;; (include "../macros/define-lw-class.sc")

(eval-when (compile eval)		; Please note absence of 'load'
  (define (flatten l)
    (if (null? l)
	'()
	(append (car l) (flatten (cdr l)))))
  
  (define (flatmap f l)
    (flatten (map f l)))
  
  (define (filter pred l) 	;  NEW
    (if (null? l)
	'()
	(let ((el (car l)))
	  (if (pred el)
	      (cons el (filter pred (cdr l)))
	      (filter pred (cdr l))))))
  
  (define (remove-dup l)	;  NEW
    (let loop ((l l) (result '()))
      (if (null? l)
	  result
	  (let* ((f (car l))
		 (r (cdr l))
		 (m (car f)))
	    (if (assq m result)
		(loop r result)
		(if (assq m r)
		    (loop r (append result (list (cons m #f))))
		    (loop r (append result (list f)))))))))
  
  (define (rem-dupl-name l1 l2)
    (define (rem-dup l rem-all)
      (if (null? l)
	  '()
	  (let ((m (car l)))
	    (if (memq m (cdr l))
		(let ((r (rem-dup (remq m (cdr l)) rem-all)))
		  (if rem-all r (cons m r)))
		(cons m (rem-dup (cdr l) rem-all))))))
    (rem-dup (append l1 (rem-dup l2 #t)) #f))

  (define (common-id? l)
    (define (f l)
      (if (null? l)
	  #f
	  (let ((val (memq (car l) (cdr l))))
	    (if val
		(car val)
		(f (cdr l))))))
    (f (flatten l)))
  
  ) ;; End of eval-when

;;   Object oriented system

(eval-when (compile load eval)
  (extend-syntax (define-class locals inherit methods init)
    ;; All parts - #1
    ((define-class (name . idlist)
       (locals (loc-var loc-val) ...)
       (inherit super ...)
       (methods (meth-name meth-val) ...)
       (init init-instr ...))
     (let ((par-coll (common-id? (list '(loc-var ...) 'idlist '(me))))
	   (mes-coll (common-id?
		      (list '(supported-messages object-desc object-class
						 object-system 
						 subclass-objects
						 superclass-objects me)
			    '(meth-name ...))))
	   (sup-coll (common-id?
		      (list (flatmap (lambda (x)
				       (if (pair? x)
					   (list (car x))
					   '()))
				     '(super ...))))))
       (cond (par-coll
	      (error 'class
		     "Name collision in parameter and/or local name list - ~a"
		     par-coll))
	     (mes-coll (error 'class "Message name not unique - ~a" mes-coll))
	     (else #t)))
     
     (with ((constructor (string->symbol (format "MAKE-~a" 'name)))
	    ((super-obj ...)
	     (map (lambda (x) (if (pair? x)
				  (cons (string->symbol (format "MAKE-~a"
								(car x)))
					(cdr x))
				  x))
		  '(super ...)))
	    (params (let ((opt-list (memq '&optional 'idlist)))
		      (if (not opt-list)
			  'idlist
			  (let loop ((idl 'idlist) (acc '()))
			    (if (eq? opt-list idl)
				(if (null? acc)
				    (cadr opt-list)
				    (begin
				      (set-cdr! (last-pair acc)
						(cadr opt-list))
				      acc))
				(loop (cdr idl)
				      (append acc
					      (list (car idl)))))))))
	    (tracing (gensym))
	    (trace-name (gensym))
	    (init-proc (gensym))
	    (obj-desc (gensym))
	    (method-list (gensym))
	    (obj-methods 'cadr)
	    (obj-methods-ref 'cdr)
	    (obj-supp-mess 'caddr)
	    (obj-supp-mess-ref 'cddr)
	    (obj-int-methods 'cadddr)
	    (obj-super-objs '(lambda (l) (car (cddddr l)))) )
       
       (define constructor
	 (lambda params
	   (let* ((me #f) (tracing #f) (trace-name 'heavy-weight-object)
			  (loc-var loc-val) ... (init-proc (lambda ()
							     init-instr ...
							     me)))
	     (letrec
		 ((obj-desc
		   (let*
		       ((method-list (map cons '(meth-name ...)
					  (list meth-val ...)))
			(super-objs
			 (map (lambda (x) (x 'object-desc (lambda () me)))
			      (list super-obj ...)))
			(super-objs-names (list (map car super-objs)))
			(org-met (map car method-list))
			(ml (remove-dup (flatmap (lambda (x)
						   (map list-copy
							(obj-methods x)))
						 super-objs)))
			(ml (append method-list (filter (lambda (el)
							  (not (memq (car el)
								     org-met)))
							ml)))
			(supp-mess (rem-dupl-name org-met
						  (map car (filter cdr ml))))
			(sub-object-thunk-list '())
			(int-methods
			 (append
			  (list
			   (cons 'supported-messages
				 (lambda () (obj-supp-mess obj-desc)))
			   (cons 'object-desc
				 (lambda o
				   (if (not (null? o))
				       (set! sub-object-thunk-list
					     (append sub-object-thunk-list
						     o)))
				   obj-desc))
			   (cons 'object-class 'name)
			   (cons 'object-system 'heavy-weight)
			   (cons 'trace
				 (lambda args
				   (set! tracing #t)
				   (if (pair? args)
				       (set! trace-name (car args) ))))
			   (cons 'untrace
				 (lambda args
				   (set! tracing #f) ))
			   (cons 'subclass-objects
				 (lambda ()
				   (map (lambda (thunk) (thunk))
					sub-object-thunk-list)))
			   (cons 'superclass-objects
				 (lambda ()
				   (map (lambda (name)
					  (me (list name 'me)))
					(car super-objs-names))))
			   (cons 'me (lambda () me)))
			  ml)))
		     (if (common-id? super-objs-names)
			 (error 'class
				"Super class name used twice - ~a"
				super-objs-names)
			 (list 'name ml supp-mess int-methods super-objs)))))
	       (let
		   ((evaluate
		     (lambda (m arg-list methods)
		       (let ((f (assq m methods)))
			 (cond ((not f)
				(error 'message "Message ~a not understood" m))
			       ((not (cdr f))
				(error 'message "Message ~a not unique" m))
			       ((not (procedure? (cdr f))) (cdr f))
			       (else (apply (cdr f) arg-list)))))))
		 (set!
		  me
		  (lambda (m . arg-list)
		    (if tracing
			(begin
			  (format #t "~a~%" (cons trace-name
						  (cons m arg-list) ))
			  (flush-buffer) ))
		    (if (pair? m)
			(let loop ((c (car m))
				   (m (cadr m))
				   (obj-list (obj-super-objs obj-desc)))
			  (let ((obj-desc (assq c obj-list)))
			    (if (not obj-desc)
				(error 'message "Class ~a is not super" c)
				(if (pair? m)
				    (loop (car m) (cadr m)
					  (obj-super-objs obj-desc))
				    (evaluate m arg-list
					      (obj-int-methods obj-desc))))))
			(evaluate m arg-list (obj-int-methods obj-desc)))))
		 (init-proc))))))))
    
    ;; No locals - #2
    ((define-class (name . idlist)
       (inherit super ...)
       (methods (meth-name meth-val) ...)
       (init init-instr ...))
     (define-class (name . idlist)
       (locals)
       (inherit super ...)
       (methods (meth-name meth-val) ...)
       (init init-instr ...)))
    
    ;; No inherit - #3 -- ought to become an define-lw-class...
    ((define-class (name . idlist)
       (locals (loc-var loc-val) ...)
       (methods (meth-name meth-val) ...)
       (init init-instr ...))
     (define-class (name . idlist)
       (locals (loc-var loc-val) ...)
       (inherit)
       (methods (meth-name meth-val) ...)
       (init init-instr ...)))
    
    ;; No methods - #4
    ((define-class (name . idlist)
       (locals (loc-var loc-val) ...)
       (inherit super ...)
       (init init-instr ...))
     (define-class (name . idlist)
       (locals (loc-var loc-val) ...)
       (inherit super ...)
       (methods)
       (init init-instr ...)))
    
    ;; No init - #5
    ((define-class (name . idlist)
       (locals (loc-var loc-val) ...)
       (inherit super ...)
       (methods (meth-name meth-val) ...))
     (define-class (name . idlist)
       (locals (loc-var loc-val) ...)
       (inherit super ...)
       (methods (meth-name meth-val) ...)
       (init)))
    
    ;; No locals, no inherit - #6 -- ought to become an define-lw-class...
    ((define-class (name . idlist)
       (methods (meth-name meth-val) ...)
       (init init-instr ...))
     (define-class (name . idlist)
       (locals)
       (inherit)
       (methods (meth-name meth-val) ...)
       (init init-instr ...)))
    
    ;; No locals, no methods - #7
    ((define-class (name . idlist)
       (inherit super ...)
       (init init-instr ...))
     (define-class (name . idlist)
       (locals)
       (inherit super ...)
       (methods)
       (init init-instr ...)))
    
    ;; No locals, no init - #8
    ((define-class (name . idlist)
       (inherit super ...)
       (methods (meth-name meth-val) ...))
     (define-class (name . idlist)
       (locals)
       (inherit super ...)
       (methods (meth-name meth-val) ...)
       (init)))
    
    ;; No inherit, no methods - #9 - useless
    ;;((define-class (name . idlist)
    ;;  (locals (loc-var loc-val) ...)
    ;;   (init init-instr ...))
    ;; (define-class (name . idlist)
    ;;   (locals (loc-var loc-val) ...)
    ;;   (inherit)
    ;;   (methods)
    ;;   (init init-instr ...)))
    
    ;; No inherit, no init - #10 -- ought to become an define-lw-class...
    ((define-class (name . idlist)
       (locals (loc-var loc-val) ...)
       (methods (meth-name meth-val) ...))
     (define-class (name . idlist)
       (locals (loc-var loc-val) ...)
       (inherit)
       (methods (meth-name meth-val) ...)
       (init)))
    
    ;; No methods, no init - #11
    ((define-class (name . idlist)
       (locals (loc-var loc-val) ...)
       (inherit super ...))
     (define-class (name . idlist)
       (locals (loc-var loc-val) ...)
       (inherit super ...)
       (methods)
       (init)))
    
    ;; Only locals - #12 - useless
    ;;((define-class (name . idlist)
    ;;   (locals (loc-var loc-val) ...))
    ;; (define-class (name . idlist)
    ;;   (locals (loc-var loc-val) ...)
    ;;   (inherit)
    ;;   (methods)
    ;;   (init)))
    
    ;; Only inherit - #13 - quite useless
    ;;((define-class (name . idlist)
    ;;   (inherit super ...))
    ;; (define-class (name . idlist)
    ;;   (locals)
    ;;   (inherit super ...)
    ;;   (methods)
    ;;   (init)))
    
    ;; Only methods - #14 - useless
    ;;((define-class (name . idlist)
    ;;   (methods (meth-name meth-val) ...))
    ;; (define-class (name . idlist)
    ;;   (locals)
    ;;   (inherit)
    ;;   (methods (meth-name meth-val) ...)
    ;;   (init)))
    
    ;; Only init - #15 - useless
    ;;((define-class (name . idlist)
    ;;   (init init-instr ...))
    ;; (define-class (name . idlist)
    ;;   (locals)
    ;;   (inherit)
    ;;   (methods)
    ;;   (init init-instr ...)))
    
    ;; Nothing - #16 - useless
    ;;((define-class (name . idlist))
    ;; (define-class (name . idlist)
    ;;   (locals)
    ;;   (inherit)
    ;;   (methods)
    ;;   (init)))
    )
  
  ) ;; End of eval-when
