;(eval-when (compile) (proclaim '(optimize (speed 3) (safety 0) (space 2))))

(defun vactor? (obj)
	(if (consp obj)
	    (eq (car obj) '&vector)))

(defun vequal (obj1 obj2)
        (or (equal obj1 obj2)
	    (vactor-equal? obj1 obj2)))
(defun vactor-equal? (v1 v2)
        (and (consp v1)
	     (consp v2)
	     (eq (car v1) '&vector)
	     (eq (car v2) '&vector)
	     (vequal (coerce (cdr v1) 'list)
		     (coerce (cdr v2) 'list))))

(defun vactor-ref (v n)
	(if (vactor? v)
	    (elt (cdr v) n)
	    (raise (list 'SE%vector '|vector-ref:|
			 '|first argument not a vector: | v))))

(defun vactor-set! (v n value)
	(if (vactor? v)
	    (setf (elt (cdr v) n)
		  value)
	    (raise (list 'SE%vector '|vector-set!:|
			 '|first argument not a vector: | v))))

(defun vactor-length (v)
	(if (vactor? v)
	    (length (cdr v))
	    (raise (list 'SE%vector '|vector-length:|
			 '|first argument not a vector: | v))))

(defun vactor->list (v)
	(if (vactor? v)
	    (coerce (cdr v) 'list)
	    (raise (list 'SE%vector '|vector->length:|
			 '|argument not a vector: | v))))

(defun list->vactor (l)
        (if (or (consp l) (null l))
	    (cons '&vector (coerce l 'sequence))
	    (raise (list 'SE%vector '|list->vector:|
			 '|argument not a list: | l))))

(defun make-vactor (args)
	(if (null (cdr args))
	    (cons '&vector (make-vactor/fill (car args) nil))
	    (if (null (cddr args))
	        (cons '&vector (make-vactor/fill (car args) (cadr args)))
		(raise (list* 'SE%vector '|make-vector:|
			      '|too many arguments: | args)))))

(defun vactor-fill! (v x)
	(if (vactor? v)
	    (fill (cdr v) x)
	    (raise (list 'SE%vector '|vector-fill!:|
			 '|first argument not a vector: | v))))

(defun make-vactor/fill (n x)
	(make-sequence '(vector t) n :initial-element x))
