; the Scheme top level read-eval-print loop,
; the Scheme file loader,
; and instructions to load the standard macros, functions, and patches
; nothing defined in std.s may be used in this file---so no macros!

; all the hand S-coded definitions are at the head of top.l and std.s

(begin
  (#!set! standard-input (lisp-eval 'keyboard))
  (#!set! standard-output (lisp-eval 'schpoport))
  (#!set! scheme-directory (lisp-eval 'scheme-directory))
  (#!set! save-defining-form (#!lambda (x) x))
  (#!set! *print-during-load* nil)
  (#!set! scheme-top-level ; for booting
    (#!lambda (v)
      (display v)
      (newline)
      (print "--> ")
      ((#!lambda (x)
	 (#!if (eq? x 'dump!)
	       (begin (#!set! scheme-top-level schemerc-top-level)
		      (remove-from-namespace 'schemerc-top-level)
		      (remove-from-namespace 'pure-load)
		      (lisp-eval '(system "rm -f scheme88")) ; unlink
		      (gc 3)
		      (print "beginning dump of 'scheme88'")
		      (newline)
		      (lisp-eval '(system:save-system "scheme88")))
	       (execute
		 (lisp-eval
		     (cons 'quote (cons (compile x) nil))))))
       (read))))
  
  (#!set! schemerc-top-level
    ((#!lambda (loop)
       (#!set! loop
	 (#!lambda (v)
	   (display v)
	   (newline)
	   (print scheme-prompt)
	   (execute
	     (compile
	       (save-defining-form (read))))))
       (#!lambda (v)
	 ((#!lambda (home)
	    (let ((msgfile (concat scheme-directory "scheme.msg")))
	      (#!if (file-exists? msgfile) (load msgfile) nil))
	    (#!set! scheme-top-level loop)
	    (#!set! global-scheme-top-level loop)
	    (declare-constant 'global-scheme-top-level)
	    (#!if home
	      ((#!lambda (schemerc)
		 (#!if (file-exists? schemerc) (load schemerc) nil))
	       (concat home
		 (#!if (eq? (lisp-eval 'host-system) 'unix)
		       "/.schemerc"
		       (#!if (eq? (lisp-eval 'host-system) 'vms)
			     "schemerc."
			     nil))))
	      nil)
	    '--------------------------------------)
	  (lisp-eval
	    '(system:getenv
	       (cond ((eq host-system 'unix) "HOME")
		     ((eq host-system 'vms) "SYS$LOGIN")))))))
     '*))
  
  (#!set! load-file
    (#!lambda (filename)
      (((#!lambda (loop)
	  (#!lambda (input-port)
	    (#!if input-port
	      (begin 
		(#!set! loop
		  (#!lambda (form)
		    (#!if (eq? form (lisp-eval '(eof)))
			  (begin (close-input-port input-port) t)
			  (begin
			    (#!if *print-during-load*
				  (writeln (execute
					     (compile
					       (save-defining-form form))))
			          (execute
			            (compile
				      (save-defining-form form))))
			    (loop (read input-port))))))
		(loop (read input-port)))
	      (begin (newline)
		     (print "[Unable to load file ")
		     (print filename)
		     (print "]")
		     (reset)))))
	'*)
       (open-input-file filename))))

  (#!set! load
    (#!lambda (filename)
       ((#!lambda (filename)
           (#!if (file-exists? filename)
	         (load-file filename)
	         (#!if (file-exists? (concat filename ".s"))
		       (load-file (concat filename ".s"))
		       (#!if (file-exists? (concat filename ".ss"))
			     (load-file (concat (filename ".ss")))
			     (begin (newline)
			            (print "[File ")
				    (print filename)
				    (print " does not exist.]")
				    (reset))))))
        (#!if (string? filename)
	      filename
	      (symbol->string filename)))))
  
  (#!set! pure-load  ; used during booting---does not save defining-forms
    (#!lambda (filename)
      (((#!lambda (loop)
	  (#!lambda (input-port)
	    (#!if input-port
	      (begin
		(#!set! loop
		  (#!lambda (form)
		    (#!if (eq? form (lisp-eval '(eof)))
			  (begin (close-input-port input-port) t)
			  (begin
			    (execute (compile form))
			    (loop (read input-port))))))
		(loop (read input-port)))
	      (begin (newline)
		     (print "[Unable to load file ")
		     (print filename)
		     (print "]")
		     (reset)))))
	'*)
       (open-input-file filename))))
  
  (print "[scheme-load std.s]") (newline)
  (pure-load (concat scheme-directory "std.s"))

  (print "[scheme-load patches.s]") (newline)
  (pure-load (concat scheme-directory "patches.s"))

  (print "[finished body of sys.s]") (newline)
  )
  
;-- debug

(print "[finished loading sys.s gracefully]") (newline)
