(define! help (lambda x
      (letrec ((print-loop
	        (lambda (lst)
		       (if lst
			   (begin (print (car lst)) (newline)
				  (print-loop (cdr lst))))))
	       (help-subject
	        (lambda (subj)
		       (print "---------------------------------------------")
		       (newline)
		       (with-input-from-file
			      (concat scheme-directory "helpfile")
			      (lambda ()
				  (iterate find-loop ((input (read)))
				       (cond ((eof-object? input)
					      (writeln "No help available for "
						       subj "."))
					     ((eq? (car input) subj)
					      (print subj)
					      (print ":  ")
					      (print-loop (cdr input)))
					     (t (find-loop (read)))))))
		       (print "---------------------------------------------")
		       (newline))))
	(print (concat scheme-directory "helpfile"))
	      (if x
                  (for-each help-subject x)
	          (begin (print "Help is available on the following:")
			 (newline)
			 (with-input-from-file
		               (concat scheme-directory "helpfile")
		                   (lambda ()
		         	        (iterate loop ((input (read)))
				            (if (eof-object? input)
					        ()
					        (cons (car input)
						      (loop (read))))))))))))



(extend-syntax (describe)
  ((describe) (help))
  ((describe item ***) (help (quote item) ***)))
