package Twilio::WebApp::Session::Drivers::mysql;
use Perlmazing;
use parent 'Twilio';
use DBI;

sub new {
	my $class = shift;
	my $self = {@_};
	my $sid = delete $self->{sid};
	my $conn = {
		host	=> 'localhost',
		port	=> '3306',
		db		=> 'Twilio',
		table	=> 'sessions',
		user	=> undef,
		pass	=> undef,
	};
	for my $i (qw(host port db table user pass)) {
		$conn->{$i} = $self->{$i} if defined $self->{$i};
		delete $self->{$i};
	}
	my $dsn = "DBI:mysql:database=$conn->{db};host=$conn->{host};port=$conn->{port};";
	for my $i (sort keys %$self) {
		$dsn .= "$i=$self->{$i};";
		delete $self->{$i};
	}
	bless $self, $class;
	$self->{sid} = $sid;
	$self->Objects->{dbh} = DBI->connect($dsn, $conn->{user}, $conn->{pass}, {RaiseError => 1});
	$self->get_sid;
	$self;
}

sub do {
	my $self = shift;
	my $sql = shift;
	eval {
		$self->Objects->{sth} = $self->dbh->prepare($sql);
		my $rv = $self->sth->execute(@_);
		$rv = 0 unless is_number $rv and $rv > 0;
		$self->Objects->{rv} = $rv;
	};
	$self->die(DBI->errstr) if $@;
	$self->rv;
}

sub last_id {
	my $self = shift;
	my @params = (@_ or (undef, undef, undef, undef));
	$self->dbh->last_insert_id(@params);
}

sub get_sid {
	my $self = shift;
	my ($rec, $error, $hashref);
	if ($self->sid and $self->do("select * from sessions where hash = ?", $self->sid)) {
		$rec = $self->sth->fetchrow_hashref;
		$hashref = eval $rec->{data};
		$error = 1 if $@;
	}
	if (not $rec or $error) {
		$self->do("insert into sessions (data) values (?)", '{}');
		my $id = $self->last_id;
		$self->do("select * from sessions where sid = ?", $id);
		$rec = $self->sth->fetchrow_hashref;
		$hashref = {};
	}
	$self->Objects->{session_data} = $hashref;
	$self->sid = $rec->{hash};
}

sub get_data {
	my $self = shift;
	if ($self->do("select * from sessions where hash = ?", $self->sid)) {
		my $rec = $self->sth->fetchrow_hashref;
		$self->session_data = eval $rec->{data};
		$self->session_data = {} if $@;
	}
	$self->session_data;
}

sub store_data {
	my $self = shift;
	my $data = shift;
	my $dump = dumped $data;
	$self->do("update sessions set data = ? where hash = ?", $dump, $self->sid);
	$data;
}

1;
