package Twilio::Codes;
use Perlmazing;
require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw($country_codes);

our $country_codes = {
	AE => {
		area_codes => {
			2	=> 'Abu Dhabi',
			4	=> 'Dubai',
			6	=> 'Sharjah',
		},
		country_name => 'United Arab Emirates',
		dialing_code => '971',
		globe_area => 'Asia',
	},
	AR => {
		area_codes => {
			11	=> 'Buenos Aires',
			221	=> 'La Plata',
			223	=> 'Mar del Plata',
			261	=> 'Mendoza',
			264	=> 'San Juan',
			291	=> 'Baha Blanca',
			297	=> 'Comodoro Rivadavia',
			299	=> 'Neuqun',
			341	=> 'Rosario',
			342	=> 'Santa Fe',
			343	=> 'Paran',
			345	=> 'Concordia',
			351	=> 'Crdoba',
			358	=> 'Ro Cuarto',
			385	=> 'Santiago del Estero',
			387	=> 'Salta',
			408	=> 'San Martn',
			424	=> 'San Pedro',
			628	=> 'San Francisco',
			2293	=> 'Tandil',
			2324	=> 'Mercedes',
			2362	=> 'Junn',
			2627	=> 'San Rafael',
			2652	=> 'San Luis',
			2901	=> 'Ushuaia',
			2920	=> 'Viedma',
			2954	=> 'Santa Rosa',
			2965	=> 'Trelew/Rawson',
			2966	=> 'Ro Gallegos',
			3461	=> 'San Nicols de los Arroyos',
			3487	=> 'Zrate',
			3525	=> 'Jess Mara',
			3717	=> 'Formosa',
			3722	=> 'Resistencia',
			3752	=> 'Posadas',
			3756	=> 'Santo Tom',
			3783	=> 'Corrientes',
			3822	=> 'La Rioja',
		},
		country_name => 'Argentina',
		dialing_code => '54',
		globe_area => 'South America',
	},
	AT => {
		area_codes => {
			1	=> 'Vienna',
			70	=> 'Linz',
			316	=> 'Graz',
			463	=> 'Klagenfurt',
			512	=> 'Innsbruck',
			662	=> 'Salzburg',
			2622	=> 'Wiener Neustadt',
			7242	=> 'Wels',
		},
		country_name => 'Austria',
		dialing_code => '43',
		globe_area => 'Europe',
	},
	AU => {
		area_codes => {
			2	=> 'Wollongong',
			3	=> 'Melbourne',
			7	=> 'Townsville',
			8	=> 'Perth',
			13	=> 'Macquarie Island',
			207	=> 'Portland',
			229	=> 'Warwick',
			620	=> 'Hamilton',
			706	=> 'Gibson',
			765	=> 'Richmond',
			770	=> 'Kingston',
			815	=> 'Forrest',
			928	=> 'Young',
		},
		country_name => 'Australia',
		dialing_code => '61',
		globe_area => 'Oceania',
	},
	BD => {
		area_codes => {
			2	=> 'Savar',
			31	=> 'Chittagong',
			41	=> 'Khulna',
			51	=> 'Bogra',
			71	=> 'Kustia',
			81	=> 'Comilla',
			91	=> 'Mymensingh',
			321	=> 'Noakhali',
			331	=> 'Feni',
			341	=> 'Cox\'s Bazar',
			351	=> 'Rangamati',
			361	=> 'Bandarban',
			371	=> 'Khagrachhari',
			381	=> 'Lakshmipur',
			402	=> 'Mongla',
			421	=> 'Jessore',
			423	=> 'Gopalgonj',
			431	=> 'Barisal',
			441	=> 'Patuakhali',
			448	=> 'Barguna',
			451	=> 'Jhenaidah',
			461	=> 'Perojpur',
			468	=> 'Bagerhat',
			471	=> 'Satkhira',
			481	=> 'Narail',
			488	=> 'Magura',
			491	=> 'Bhola',
			498	=> 'Jhalokathhi',
			521	=> 'Rangpur',
			531	=> 'Dinajpur',
			541	=> 'Gaibandha',
			551	=> 'Nilphamari',
			552	=> 'Syedpur',
			561	=> 'Thakurgaon',
			568	=> 'Panchagar',
			571	=> 'Joypurhat',
			581	=> 'Kurigram',
			591	=> 'Lalmonirhat',
			601	=> 'Shariatpur',
			628	=> 'Narsingdi',
			631	=> 'Faridpur',
			641	=> 'Rajbari',
			651	=> 'Manikgonj',
			661	=> 'Madaripur',
			681	=> 'Gazipur',
			691	=> 'Munshigonj',
			721	=> 'Rajshahi',
			731	=> 'Pabna',
			732	=> 'Ishwardi',
			741	=> 'Naogaon',
			751	=> 'Sirajgonj',
			761	=> 'Chuadanga',
			771	=> 'Natore',
			781	=> 'Nawabgonj (Chapai)',
			791	=> 'Meherpur',
			821	=> 'Sylhet',
			831	=> 'Hobigonj',
			841	=> 'Chandpur',
			851	=> 'Brahmanbaria',
			861	=> 'Moulavibazar',
			871	=> 'Sunamgonj',
			921	=> 'Tangail',
			931	=> 'Sherpur',
			941	=> 'Kishoregonj',
			951	=> 'Netrokona',
			981	=> 'Jamalpur',
			3028	=> 'Sitakundu (Barabkundu)',
			3035	=> 'Potiya',
			3036	=> 'Satkania',
			3037	=> 'Banshkhali',
			3223	=> 'Companigon (Bashurhat)',
			3224	=> 'Hatiya (Oshkhali)',
			3424	=> 'Moheshkhali',
			3427	=> 'Ukhia',
			3529	=> 'Chandraghona (Kaptai)',
			3823	=> 'Ramgoti (Char Alexander)',
			4027	=> 'Paikgacha',
			4222	=> 'Avaynagar (Noapara)',
			4225	=> 'Jhikargacha',
			4228	=> 'Sarsha (Benapol)',
			4326	=> 'Muladi',
			4332	=> 'Banaripara',
			4422	=> 'Bauphal',
			4424	=> 'Galachipa',
			4425	=> 'Khepupara',
			4623	=> 'Bhandaria',
			4662	=> 'Mongla New Port',
			4724	=> 'Kalaroa',
			5033	=> 'Shibganj',
			5222	=> 'Badargonj',
			5327	=> 'Fulbari',
			5334	=> 'Parbatipur',
			5526	=> 'Saidpur',
			6254	=> 'Palash (Ghorashal)',
			6257	=> 'Mathabdi',
			6423	=> 'Goalanda',
			7022	=> 'Bheramara',
			7023	=> 'Daulatpur',
			7622	=> 'Alamdanga',
			8023	=> 'Daudkandi',
			8032	=> 'Laksham (Daulatgonj)',
			8034	=> 'Chaudagram',
			8233	=> 'Kanaighat',
			8424	=> 'Hajigonj',
			8525	=> 'Nabinagar',
			8528	=> 'Ashugonj',
			8626	=> 'Srimangol',
			8723	=> 'Chhatak',
			8732	=> 'Taherpur',
			9028	=> 'Muktagacha',
			9033	=> 'Plulpur',
			9225	=> 'Ghatail',
			9233	=> 'Nagarpur',
			9423	=> 'Bazitpur',
			9424	=> 'Bhairab',
			9435	=> 'Mithamain',
			9524	=> 'Mohanganj',
		},
		country_name => 'Bangladesh',
		dialing_code => '880',
		globe_area => 'Asia',
	},
	BE => {
		area_codes => {
			2	=> 'Brussels',
			3	=> 'Antwerp',
			4	=> 'Lige (Luik)',
			9	=> 'Ghent',
			10	=> 'Wavre (Waver)',
			11	=> 'Hasselt',
			12	=> 'Tongeren (Tongres)',
			13	=> 'Diest',
			14	=> 'Turnhout',
			15	=> 'Mechelen (Malines)',
			16	=> 'Leuven (Louvain)',
			19	=> 'Wareme',
			50	=> 'Zeebrugge',
			51	=> 'Roeselare (Roulers)',
			52	=> 'Dendermonde',
			53	=> 'Aalst (Alost)',
			54	=> 'Ninove',
			55	=> 'Ronse',
			58	=> 'Veurne',
			59	=> 'Oostende',
			60	=> 'Chimay',
			61	=> 'Libramont',
			63	=> 'Arlon',
			64	=> 'La Louvire',
			65	=> 'Mons (Bergen)',
			67	=> 'Nivelles (Nijvel)',
			69	=> 'Tounai',
			71	=> 'Charleroi',
			80	=> 'Stavelot',
			81	=> 'Namur (Namen)',
			82	=> 'Dinant',
			83	=> 'Ciney',
			85	=> 'Huy (Hoei)',
			86	=> 'Durbuy',
			87	=> 'Verviers',
			89	=> 'Genk',
		},
		country_name => 'Belgium',
		dialing_code => '32',
		globe_area => 'Europe',
	},
	BG => {
		area_codes => {
			2	=> 'Sofia',
			32	=> 'Plovdiv',
			34	=> 'Pazardjik',
			38	=> 'Haskovo',
			42	=> 'Stara Zagora',
			44	=> 'Sliven',
			46	=> 'Yambol',
			52	=> 'Varna',
			54	=> 'Shoumen',
			56	=> 'Bourgas',
			58	=> 'Dobritch',
			62	=> 'Veliko Tarnovo',
			64	=> 'Pleven',
			66	=> 'Gabrovo',
			68	=> 'Lovetch',
			73	=> 'Blagoevgrad',
			76	=> 'Pernik',
			78	=> 'Kjustendil',
			82	=> 'Ruse',
			84	=> 'Razgrad',
			86	=> 'Silistra',
			89	=> 'Mobile Phones',
			92	=> 'Vratsa',
			94	=> 'Vidin',
			96	=> 'Montana',
			301	=> 'Smolyan',
			361	=> 'Kardjali',
			431	=> 'Kazanluk',
			601	=> 'Targovishte',
			751	=> 'Gotse Delchev',
		},
		country_name => 'Bulgaria',
		dialing_code => '359',
		globe_area => 'Europe',
	},
	BO => {
		area_codes => {
			2	=> 'Potosi',
			3	=> 'Trinidad',
			4	=> 'Tarija',
		},
		country_name => 'Bolivia',
		dialing_code => '591',
		globe_area => 'South America',
	},
	BR => {
		area_codes => {
			11	=> 'So Paulo',
			12	=> 'So Jose dos Campos',
			13	=> 'Santos',
			14	=> 'Bauru',
			15	=> 'Sorocaba',
			16	=> 'Ribeiro Preto',
			17	=> 'So Jose do Rio Preto',
			19	=> 'Campinas',
			21	=> 'Rio de Janeiro',
			22	=> 'Campos',
			24	=> 'Volta Redonda',
			27	=> 'Vitoria',
			31	=> 'Belo Horizonte',
			32	=> 'Juiz de Fora',
			33	=> 'Teofilo Otoni',
			34	=> 'Uberlandia',
			38	=> 'Montes Claros',
			41	=> 'Curitiba',
			42	=> 'Ponta Grossa',
			43	=> 'Londrina',
			47	=> 'Joinville',
			48	=> 'Florianopolis',
			51	=> 'Porto Alegre',
			53	=> 'Rio Grande',
			54	=> 'Passo Fundo',
			55	=> 'Uruguaiana',
			61	=> 'Brasilia',
			62	=> 'Goiania',
			63	=> 'Palmas',
			65	=> 'Cuiaba',
			67	=> 'Campo Grande',
			68	=> 'Rio Branco',
			69	=> 'Porto Velho',
			71	=> 'Salvador',
			73	=> 'Jequie',
			74	=> 'Juazeiro do Norte',
			75	=> 'Feira de Santana',
			77	=> 'Vitoria da Conquista',
			79	=> 'Aracaju',
			81	=> 'Recife',
			82	=> 'Maceio',
			83	=> 'Joao Pessoa',
			84	=> 'Natal',
			85	=> 'Fortaleza',
			86	=> 'Teresina',
			88	=> 'Sobral',
			91	=> 'Belm',
			92	=> 'Manaus',
			95	=> 'Boa Vista',
			96	=> 'Macapa',
			98	=> 'So Luis',
			408	=> 'Salinas',
			478	=> 'Montezuma',
			505	=> 'Santa Fe',
			532	=> 'Pelotas',
			707	=> 'Santa Rosa',
			712	=> 'Panama',
			830	=> 'Medina',
			831	=> 'Santa Cruz',
			850	=> 'Valparaiso',
			859	=> 'Alexandria',
			870	=> 'Timbo',
			916	=> 'Sacramento',
		},
		country_name => 'Brazil',
		dialing_code => '55',
		globe_area => 'South America',
	},
	BS => {
		area_codes => {
			''	=> 'Nassau',
		},
		country_name => 'Bahamas',
		dialing_code => '1242',
		globe_area => 'Central America',
	},
	BW => {
		area_codes => {
			24	=> 'Francistown',
			26	=> 'Selebi Phikwe',
			29	=> 'Letlhakane',
			31	=> 'Gaborone',
			47	=> 'Mahalapye',
			58	=> 'Jwaneng',
			62	=> 'Kasane',
			65	=> 'Ghanzi',
			68	=> 'Maun',
		},
		country_name => 'Botswana',
		dialing_code => '267',
		globe_area => 'Africa',
	},
	BY => {
		area_codes => {
			16	=> 'Brest',
			17	=> 'Minsk',
			212	=> 'Vitebsk',
			222	=> 'Mogilev',
			1511	=> 'Grodno',
			2322	=> 'Gomel',
		},
		country_name => 'Belarus',
		dialing_code => '375',
		globe_area => 'Europe',
	},
	CA => {
		area_codes => {
			204	=> 'Winnipeg, Manitoba',
			209	=> 'Tracy, Quebec',
			217	=> 'Chatham, Ontario',
			226	=> 'London, Ontario',
			250	=> 'Dawson Creek, British Columbia - North',
			270	=> 'Clinton, British Columbia',
			289	=> 'Mississauga, Ontario',
			306	=> 'Yorkton, Saskatchewan',
			343	=> 'Ottawa, Ontario',
			403	=> 'Red Deer, Alberta',
			416	=> 'Toronto, Ontario',
			418	=> 'Blanc Sablon, Quebec - North',
			438	=> 'Montral, Quebec',
			450	=> 'Longueuil, Quebec',
			506	=> 'Saint John, New Brunswick',
			519	=> 'Windsor, Newfoundland',
			587	=> 'Calgary, Alberta',
			604	=> 'Whistler, British Columbia',
			609	=> 'Trenton, Ontario',
			613	=> 'Kingston, Ontario',
			641	=> 'Truro, Nova Scotia',
			703	=> 'Woodbridge, Ontario',
			705	=> 'Timmins, Ontario',
			709	=> 'Labrador City, Labrador',
			757	=> 'Hampton, New Brunswick',
			770	=> 'Nelson, British Columbia',
			780	=> 'Lloydminster, Alberta',
			802	=> 'Woodstock, New Brunswick',
			805	=> 'Summerland, British Columbia',
			807	=> 'Thunder Bay, Ontario - Thunder Bay',
			812	=> 'Hope, British Columbia',
			819	=> 'Trois Rivires, Quebec',
			867	=> 'Rankin Inlet (Kangiqliniq), Nunavut',
			902	=> 'Summerside, Prince Edward Island',
			905	=> 'Whitby, Ontario',
			912	=> 'Glenwood, Newfoundland',
			918	=> 'Yale, British Columbia',
		},
		country_name => 'Canada',
		dialing_code => '1',
		globe_area => 'North America',
	},
	CD => {
		area_codes => {
			12	=> 'Kinshasa',
		},
		country_name => 'Congo (Dem. Rep.)',
		dialing_code => '243',
		globe_area => 'Africa',
	},
	CH => {
		area_codes => {
			21	=> 'Vevey',
			22	=> 'Geneva',
			24	=> 'Gryon (Yverdon',
			26	=> 'Fribourg',
			27	=> 'Zermatt',
			31	=> 'Berne',
			32	=> 'Neuchtel',
			33	=> 'Wengen',
			41	=> 'Zug',
			43	=> 'Zurich',
			52	=> 'Winterthur',
			56	=> 'Baden',
			61	=> 'Basel Stadt',
			62	=> 'Ammerswil (Aarau)',
			71	=> 'St. Gallen',
			81	=> 'St. Moritz',
			91	=> 'Lugano',
		},
		country_name => 'Switzerland',
		dialing_code => '41',
		globe_area => 'Europe',
	},
	CL => {
		area_codes => {
			2	=> 'Santiago',
			32	=> 'Vina del Mar',
			41	=> 'Talcahuano',
			42	=> 'Chillan',
			45	=> 'Temuco',
			51	=> 'La Serena',
			52	=> 'Copiapo',
			53	=> 'Ovalle',
			55	=> 'Calama',
			57	=> 'Iquique',
			58	=> 'Arica',
			61	=> 'Punta Arenas',
			63	=> 'Valdivia',
			64	=> 'Osorno',
			65	=> 'Puerto Montt',
			71	=> 'Talca',
			72	=> 'Rancagua',
			75	=> 'Curico',
		},
		country_name => 'Chile',
		dialing_code => '56',
		globe_area => 'South America',
	},
	CN => {
		area_codes => {
			10	=> 'Beijing',
			20	=> 'Guangzhou',
			21	=> 'Shanghai',
			22	=> 'Tianjin',
			23	=> 'Chongqing',
			24	=> 'Shenyang',
			25	=> 'Nanjing',
			27	=> 'Wuhan',
			28	=> 'Chengdu',
			29	=> 'Xi an',
			270	=> 'Stanley',
			311	=> 'Shijiazhuang',
			312	=> 'Baoding',
			313	=> 'Zhangjiakou',
			314	=> 'Chengde',
			315	=> 'Tangshan',
			351	=> 'Taiyuan',
			352	=> 'Datong',
			353	=> 'Yangquan',
			371	=> 'Zhengzhou',
			372	=> 'Anyang',
			373	=> 'Xinyang',
			377	=> 'Nanyang',
			378	=> 'Kaifeng',
			379	=> 'Luoyang',
			411	=> 'Dalian',
			412	=> 'Anshan',
			413	=> 'Fushun',
			414	=> 'Benxi',
			415	=> 'Dandong',
			416	=> 'Jinzhou',
			417	=> 'Yingkou',
			419	=> 'Liaoyang',
			421	=> 'Chaoyang',
			431	=> 'Changchun',
			432	=> 'Jilin',
			433	=> 'Yanji',
			434	=> 'Siping',
			451	=> 'Harbin',
			452	=> 'Qiqihar',
			456	=> 'Aihui',
			457	=> 'Mohe',
			459	=> 'Daqing',
			467	=> 'Mudanjiang',
			471	=> 'Hohhot',
			472	=> 'Baotou',
			475	=> 'Tongliao',
			476	=> 'Chifeng',
			511	=> 'Zhenjiang',
			512	=> 'Changshu',
			513	=> 'Nantong',
			514	=> 'Yangzhou',
			516	=> 'Xuzhou',
			519	=> 'Changzhou',
			531	=> 'Jinan',
			532	=> 'Qingdao',
			533	=> 'Zibo',
			536	=> 'Weifang',
			537	=> 'Jining',
			551	=> 'Hefei',
			552	=> 'Bengbu',
			553	=> 'Wuhu',
			556	=> 'Anqing',
			571	=> 'Hangzhou',
			572	=> 'Huzhou',
			574	=> 'Ningbo',
			575	=> 'Shaoxing',
			576	=> 'Linhai',
			577	=> 'Wenzhou',
			579	=> 'Yiwu',
			591	=> 'Fuzhou',
			592	=> 'Xiamen',
			595	=> 'Quanzhou',
			596	=> 'Zhangzhou',
			599	=> 'Wuyishan',
			714	=> 'Huangshi',
			716	=> 'Jiangling',
			730	=> 'Yueyang',
			731	=> 'Liuyang',
			732	=> 'Xiangtan',
			736	=> 'Changde',
			739	=> 'Shaoyang',
			750	=> 'Jiangmen',
			751	=> 'Shaoguan',
			752	=> 'Huizhou',
			754	=> 'Shantou',
			755	=> 'Shenzhen',
			757	=> 'Foshan',
			759	=> 'Zhanjiang',
			771	=> 'Nanning',
			772	=> 'Liuzhou',
			773	=> 'Guilin',
			776	=> 'Baise',
			778	=> 'Hechi',
			779	=> 'Beihai',
			791	=> 'Nanchang',
			792	=> 'Jiujiang',
			797	=> 'Ganzhou',
			798	=> 'Jingdezhen',
			814	=> 'Yongchuan',
			816	=> 'Mianyang',
			831	=> 'Yibin',
			834	=> 'Xichang',
			835	=> 'Ya An',
			851	=> 'Guiyang',
			852	=> 'Zunyi',
			853	=> 'Anshun',
			859	=> 'Xinyi',
			871	=> 'Kunming',
			872	=> 'Dali',
			878	=> 'Chuxiong',
			891	=> 'Lhasa',
			894	=> 'Linzhi',
			898	=> 'Haikou',
			910	=> 'Xianyang',
			911	=> 'Yan An',
			912	=> 'Yulin',
			913	=> 'Weinan',
			915	=> 'Ankang',
			916	=> 'Hanzhong',
			917	=> 'Baoji',
			931	=> 'Lanzhou',
			933	=> 'Pingliang',
			937	=> 'Jiuquan',
			938	=> 'Tianshui',
			939	=> 'Wudu',
			951	=> 'Yinchuan',
			971	=> 'Xinjin',
			976	=> 'Yushu',
			991	=> 'Urumqi',
			994	=> 'Qitai',
			997	=> 'Akesu',
			998	=> 'Kashi',
			999	=> 'Yining',
			3011	=> 'Zhumadian',
			4435	=> 'Dunhua',
			4458	=> 'Changbai',
			4615	=> 'Shuangcheng',
			4617	=> 'Jixi',
			4638	=> 'Suifenhe',
			4652	=> 'Hailun',
			4665	=> 'Nenjiang',
			4813	=> 'Erlianhaote',
			4823	=> 'Guyang',
			4868	=> 'Linxi',
			5033	=> 'Fuding',
			5430	=> 'Lijing',
			5482	=> 'Xin an',
			5834	=> 'Haining',
			7038	=> 'Yiyang',
			7420	=> 'Zhijiang',
			7683	=> 'Maoming',
			7888	=> 'Fengcheng',
			8003	=> 'Dongfang',
			8221	=> 'Jiangjin',
			8269	=> 'Guang an',
			8425	=> 'Meishan',
			8869	=> 'Yuanmou',
			8885	=> 'Ruili',
			9003	=> 'Tacheng',
			9022	=> 'Hami',
			9041	=> 'Miquan',
			9473	=> 'Dunhuang',
		},
		country_name => 'China',
		dialing_code => '86',
		globe_area => 'Asia',
	},
	CO => {
		area_codes => {
			1	=> 'Bogota',
			2	=> 'Palmira',
			4	=> 'Medellin',
			5	=> 'Santa Marta',
			6	=> 'Pereira',
			7	=> 'Cucuta',
			8	=> 'Villavicencio',
			27	=> 'Pasto',
			222	=> 'Buenaventura',
			831	=> 'Soledad',
		},
		country_name => 'Colombia',
		dialing_code => '57',
		globe_area => 'South America',
	},
	CR => {
		area_codes => {
			719	=> 'Limon',
			''	=> 'San Jos',
		},
		country_name => 'Costa Rica',
		dialing_code => '506',
		globe_area => 'Central America',
	},
	CU => {
		area_codes => {
			5	=> 'Varadero',
			7	=> 'Havana (Ciudad La Habana)',
			8	=> 'Viales',
			21	=> 'Guantanamo Bay Naval Air Stati',
			22	=> 'Los Reynaldos',
			23	=> 'Yara',
			24	=> 'Velasco',
			31	=> 'Vasquez',
			32	=> 'Vertientes',
			33	=> 'Venezuela',
			41	=> 'Sancti Spritus',
			42	=> 'Villa Clara',
			43	=> 'Aguada de Pasajeros',
			45	=> 'Crdenas',
			52	=> 'Matanzas',
			59	=> 'Jagey Grande',
			61	=> 'Nueva Gerona',
			62	=> 'San Nicols de Bari',
			63	=> 'Silvio Caro',
			64	=> 'Tapaste',
			66	=> 'La Salud',
			67	=> 'Quivicn',
			82	=> 'Pinar del Rio',
			84	=> 'Sbalo',
			85	=> 'Lopez Pea',
			86	=> 'Pablo de Torriente',
			225	=> 'Palma Soriano',
			226	=> 'Santiago de Cuba',
			338	=> 'Yarual',
			432	=> 'Cienfuegos',
			650	=> 'San Antonio de Los Baos',
			680	=> 'Playa Baracoa',
			686	=> 'Guanajay',
			692	=> 'Santa Cruz del Norte',
			789	=> 'MOBILE PHONES',
			6929	=> 'Canas',
		},
		country_name => 'Cuba',
		dialing_code => '53',
		globe_area => 'Central America',
	},
	CY => {
		area_codes => {
			22	=> 'Nicosia',
			23	=> 'Famagusta',
			24	=> 'Lrnaca',
			25	=> 'Limassol',
			26	=> 'Pafos',
			''	=> 'Cabo Kormakitis',
		},
		country_name => 'Cyprus',
		dialing_code => '357',
		globe_area => 'Europe',
	},
	CZ => {
		area_codes => {
			48	=> 'Liberec',
			54	=> 'Brno',
			69	=> 'Ostrava',
			166	=> 'Cheb',
			377	=> 'Plzen',
			712	=> 'Tabor',
			''	=> 'Prague',
		},
		country_name => 'Czech Republic',
		dialing_code => '420',
		globe_area => 'Europe',
	},
	DE => {
		area_codes => {
			30	=> 'Berlin',
			40	=> 'Hamburg',
			69	=> 'Offenbach',
			89	=> 'Munich',
			201	=> 'Essen',
			202	=> 'Wuppertal',
			203	=> 'Duisburg',
			208	=> 'Oberhausen',
			209	=> 'Gelsenkirchen',
			211	=> 'Dsseldorf',
			212	=> 'Solingen',
			214	=> 'Leverkusen',
			221	=> 'Cologne',
			228	=> 'Bonn',
			231	=> 'Dortmund',
			241	=> 'Aachen',
			251	=> 'Munster',
			261	=> 'Koblenz',
			271	=> 'Siegen',
			331	=> 'Potsdam',
			335	=> 'Frankfurt an der Oder',
			341	=> 'Leipzig',
			345	=> 'Halle',
			351	=> 'Dresden',
			355	=> 'Cottbus',
			361	=> 'Erfurt',
			365	=> 'Gera',
			371	=> 'Chemnitz',
			375	=> 'Zwickau',
			381	=> 'Rostock',
			385	=> 'Schwerin',
			391	=> 'Magdeburg',
			395	=> 'Neubrandenburg',
			421	=> 'Bremen',
			431	=> 'Kiel',
			441	=> 'Oldenburg',
			451	=> 'Lbeck',
			471	=> 'Bremerhaven',
			511	=> 'Hannover',
			521	=> 'Bielefeld',
			531	=> 'Braunschweig',
			541	=> 'Osnabrck',
			561	=> 'Kassel',
			611	=> 'Wiesbaden',
			621	=> 'Mannheim',
			681	=> 'Saarbrcken',
			711	=> 'Stuttgart',
			721	=> 'Karlsruhe',
			731	=> 'Ulm',
			761	=> 'Freiburg',
			821	=> 'Augsburg',
			841	=> 'Ingolstadt',
			911	=> 'Nuremberg',
			931	=> 'Wrzburg',
			941	=> 'Regensburg',
			2041	=> 'Bottrop',
			2131	=> 'Neuss',
			2151	=> 'Krefeld',
			2161	=> 'Mnchengladbach',
			2191	=> 'Remscheid',
			2202	=> 'Bergisch Gladbach',
			2323	=> 'Herne',
			2331	=> 'Hagen',
			2361	=> 'Recklinghausen',
			2381	=> 'Hamm',
			5121	=> 'Hildesheim',
			5251	=> 'Paderborn',
			5341	=> 'Salzgitter',
			5361	=> 'Wolfsburg',
			6131	=> 'Mainz',
			6151	=> 'Darmstadt',
			6221	=> 'Heidelberg',
			7131	=> 'Heilbronn',
			7141	=> 'Ludwigsburg',
			7231	=> 'Pforzheim',
			9131	=> 'Erlangen',
			''	=> 'Gttingen',
		},
		country_name => 'Germany',
		dialing_code => '49',
		globe_area => 'Europe',
	},
	DK => {
		area_codes => {
			''	=> 'Roskilde',
		},
		country_name => 'Denmark',
		dialing_code => '45',
		globe_area => 'Europe',
	},
	DZ => {
		area_codes => {
			21	=> 'Algiers',
			27	=> 'Chlef',
			29	=> 'Tamanrasset',
			31	=> 'Constantine',
			32	=> 'El Oued',
			33	=> 'Beskra',
			34	=> 'Jijel',
			35	=> 'Bordj Bou Arreridj',
			37	=> 'Tebessa',
			38	=> 'Skikda',
			41	=> 'Oran',
			43	=> 'Tlemcen',
			49	=> 'Tindouf',
		},
		country_name => 'Algeria',
		dialing_code => '213',
		globe_area => 'Africa',
	},
	EC => {
		area_codes => {
			2	=> 'Quito',
			4	=> 'Guayaquil',
		},
		country_name => 'Ecuador',
		dialing_code => '593',
		globe_area => 'South America',
	},
	EE => {
		area_codes => {
			76	=> 'Valga',
			''	=> 'Tallinn',
		},
		country_name => 'Estonia',
		dialing_code => '372',
		globe_area => 'Europe',
	},
	EG => {
		area_codes => {
			2	=> 'Cairo',
			3	=> 'Alexandria',
			48	=> 'Shibn el Km',
			55	=> 'Zagazig',
			62	=> 'Suez',
			64	=> 'Ismailia',
			65	=> 'Hurghada',
			66	=> 'Port Said',
			68	=> 'El Arish',
			69	=> 'El Tor',
			88	=> 'Assiut',
			95	=> 'Luxor',
			96	=> 'Qina',
			97	=> 'Aswan',
		},
		country_name => 'Egypt',
		dialing_code => '20',
		globe_area => 'Africa',
	},
	ES => {
		area_codes => {
			81	=> 'La Corua',
			91	=> 'Madrid',
			93	=> 'Barcelona',
			94	=> 'Bilbao',
			95	=> 'Sevilla',
			96	=> 'Valencia',
			407	=> 'Oviedo',
			920	=> 'vila',
			922	=> 'Tenerife',
			923	=> 'Salamanca',
			924	=> 'Badajoz',
			925	=> 'Toledo',
			927	=> 'Caceres',
			928	=> 'Las Palmas',
			942	=> 'Santander',
			947	=> 'Burgos',
			948	=> 'Pamplona',
			949	=> 'Guadalajara',
			950	=> 'Almera',
			952	=> 'Melilla',
			953	=> 'Jaen',
			956	=> 'Cadiz',
			957	=> 'Cordoba',
			958	=> 'Granada',
			959	=> 'Huelva',
			967	=> 'Albacete',
			968	=> 'Murcia',
			969	=> 'Cuenca',
			970	=> 'Durango',
			971	=> 'Palma de Mallorca',
			972	=> 'Girona',
			973	=> 'Lerida',
			974	=> 'Huesca',
			976	=> 'Zaragoza',
			977	=> 'Tarragona',
			980	=> 'Zamora',
			982	=> 'Lugo',
			983	=> 'Valladolid',
			986	=> 'Pontevedra',
			987	=> 'Leon',
			988	=> 'Orense',
		},
		country_name => 'Spain',
		dialing_code => '34',
		globe_area => 'Europe',
	},
	FI => {
		area_codes => {
			2	=> 'Turku',
			3	=> 'Vammala',
			5	=> 'Lappeenranta',
			6	=> 'Vasa',
			8	=> 'Ylivieska',
			9	=> 'Vantaa',
			13	=> 'Lieksa',
			14	=> 'Saarijrvi',
			15	=> 'Savonlinna',
			16	=> 'Tornio',
			17	=> 'Varkaus',
			18	=> 'Mariehamn',
			19	=> 'Porvoo',
		},
		country_name => 'Finland',
		dialing_code => '358',
		globe_area => 'Europe',
	},
	FJ => {
		area_codes => {
			''	=> 'Suva',
		},
		country_name => 'Fiji',
		dialing_code => '679',
		globe_area => 'Oceania',
	},
	FR => {
		area_codes => {
			1	=> 'Saint Denis',
			2	=> 'Tours',
			3	=> 'Strasbourg',
			4	=> 'Villeurbanne',
			5	=> 'Toulouse',
			478	=> 'Macon',
			859	=> 'Versailles',
		},
		country_name => 'France',
		dialing_code => '33',
		globe_area => 'Europe',
	},
	GB => {
		area_codes => {
			20	=> 'London',
			23	=> 'Southampton',
			24	=> 'Coventry',
			28	=> 'Belfast City',
			29	=> 'Cardiff',
			113	=> 'Leeds',
			114	=> 'Sheffield',
			115	=> 'Nottingham',
			116	=> 'Leicester',
			117	=> 'Bristol',
			118	=> 'Reading',
			121	=> 'West Bromwich',
			131	=> 'Edinburgh',
			141	=> 'Glasgow',
			151	=> 'Liverpool',
			161	=> 'Stockport',
			191	=> 'Sunderland',
			205	=> 'Chelsea',
			207	=> 'Portland',
			217	=> 'Lincoln',
			229	=> 'Warwick',
			251	=> 'Gosport',
			302	=> 'Dover',
			563	=> 'Chester',
			605	=> 'Worthing',
			620	=> 'Stafford',
			720	=> 'Westminster',
			757	=> 'Windsor',
			774	=> 'Worcester',
			781	=> 'Weymouth',
			859	=> 'Carlisle',
			913	=> 'Winchester',
			1202	=> 'Poole',
			1204	=> 'Bolton',
			1206	=> 'Colchester',
			1223	=> 'Cambridge',
			1224	=> 'Aberdeen',
			1253	=> 'Blackpool',
			1254	=> 'Blackburn',
			1273	=> 'Brighton',
			1274	=> 'Bradford',
			1293	=> 'Crawley',
			1323	=> 'Eastbourne',
			1332	=> 'Derby',
			1384	=> 'Dudley',
			1452	=> 'Gloucester',
			1473	=> 'Ipswich',
			1482	=> 'Kingston upon Hull',
			1484	=> 'Huddersfield',
			1582	=> 'Luton',
			1603	=> 'Norwich',
			1604	=> 'Northampton',
			1642	=> 'Middlesbrough',
			1709	=> 'Rotherham',
			1733	=> 'Peterborough',
			1744	=> 'St. Helens',
			1752	=> 'Plymouth',
			1753	=> 'Slough',
			1772	=> 'Preston',
			1792	=> 'Swansea',
			1793	=> 'Swindon',
			1865	=> 'Oxford',
			1902	=> 'Wolverhampton',
			1904	=> 'York',
			1908	=> 'Milton Keynes',
			1922	=> 'Walsall',
			1923	=> 'Watford',
			1952	=> 'Telford',
		},
		country_name => 'United Kingdom',
		dialing_code => '44',
		globe_area => 'Europe',
	},
	GR => {
		area_codes => {
			21	=> 'Athens',
			210	=> 'Piraeus',
			231	=> 'Thessaloniki',
			241	=> 'Larissa',
			251	=> 'Kavala',
			261	=> 'Patra',
			271	=> 'Tripolis',
			281	=> 'Iraklion',
			2221	=> 'Halkida',
			2222	=> 'Kymi',
			2223	=> 'Aliveri',
			2224	=> 'Karystos',
			2226	=> 'Loutra Aidipsou',
			2227	=> 'Mantoudi',
			2228	=> 'Psachna',
			2229	=> 'Eretria',
			2231	=> 'Lamia',
			2232	=> 'Domokos',
			2233	=> 'Atalanti',
			2234	=> 'Amfikleia',
			2235	=> 'Kam.Vourla',
			2236	=> 'Makrakomi',
			2237	=> 'Karpenisi',
			2238	=> 'Stilida',
			2241	=> 'Rhodes',
			2242	=> 'Kos',
			2243	=> 'Kalimnos',
			2244	=> 'Archagelos',
			2245	=> 'Karpathos',
			2246	=> 'Salakos',
			2247	=> 'Leros',
			2251	=> 'Mitilini',
			2252	=> 'Agiasos',
			2253	=> 'Kalloni',
			2254	=> 'Mirina',
			2261	=> 'Livadeia',
			2262	=> 'Thiva',
			2263	=> 'Vilia',
			2264	=> 'Domvrena',
			2265	=> 'Amfissa',
			2266	=> 'Lidoriki',
			2267	=> 'Distomo',
			2268	=> 'Aliartos',
			2271	=> 'Chios',
			2272	=> 'Kardamila',
			2273	=> 'Samos',
			2274	=> 'Volissos',
			2275	=> 'Ag. Kirikos',
			2281	=> 'Siros',
			2282	=> 'Andros',
			2283	=> 'Tinos',
			2284	=> 'Paros',
			2285	=> 'Naxos',
			2286	=> 'Thira',
			2287	=> 'Milos',
			2288	=> 'Kea',
			2289	=> 'Mikonos',
			2291	=> 'Lagonisi',
			2292	=> 'Lavrion',
			2293	=> 'Ag. Sotira',
			2294	=> 'Rafina',
			2295	=> 'Afidnes',
			2296	=> 'Megara',
			2297	=> 'Aegina',
			2298	=> 'Poros',
			2299	=> 'Markopoulo',
			2310	=> 'Kalamaria',
			2321	=> 'Serres',
			2322	=> 'Nigrita',
			2323	=> 'Sidirokastro',
			2324	=> 'Zichni',
			2325	=> 'Herakleia',
			2327	=> 'Rodopoli',
			2331	=> 'Veroia',
			2332	=> 'Naousa',
			2341	=> 'Kilkis',
			2343	=> 'Polikastro',
			2351	=> 'Katerini',
			2352	=> 'Plaka',
			2353	=> 'Aeginio',
			2371	=> 'Polygyros',
			2372	=> 'Arnea',
			2373	=> 'Moudania',
			2374	=> 'Kassandreia',
			2375	=> 'Nikitas',
			2376	=> 'Stratoni',
			2377	=> 'Ierissos',
			2381	=> 'Edessa',
			2382	=> 'Giannitsa',
			2384	=> 'Aridea',
			2385	=> 'Florina',
			2386	=> 'Amynteo',
			2391	=> 'Chlkidona',
			2392	=> 'Perea',
			2393	=> 'Lagadikia',
			2394	=> 'Lagadas',
			2395	=> 'Sochos',
			2396	=> 'Vasilika',
			2397	=> 'Asprovalta',
			2399	=> 'Kallikrateia',
			2422	=> 'Almyros',
			2423	=> 'Kala Nera',
			2424	=> 'Skopelos',
			2425	=> 'Velestino',
			2426	=> 'Zagora',
			2427	=> 'Skiathos',
			2431	=> 'Trikala',
			2432	=> 'Kalabaka',
			2433	=> 'Farkadona',
			2434	=> 'Pyli',
			2441	=> 'Karditsa',
			2443	=> 'Sofades',
			2444	=> 'Palamas',
			2445	=> 'Mouzaki',
			2461	=> 'Kozani',
			2462	=> 'Grevena',
			2463	=> 'Ptolemaida',
			2464	=> 'Servia',
			2465	=> 'Siatista',
			2467	=> 'Kastoria',
			2491	=> 'Farsala',
			2492	=> 'Tyrnavos',
			2493	=> 'Elassona',
			2494	=> 'Agia',
			2495	=> 'Makrychori',
			2521	=> 'Drama',
			2522	=> 'Prosotsani',
			2523	=> 'K. Nevrokopi',
			2524	=> 'Paranesti',
			2531	=> 'Komotini',
			2532	=> 'Sapes',
			2533	=> 'Xylagani',
			2534	=> 'Iasmos',
			2535	=> 'Kallisti',
			2541	=> 'Xanthi',
			2542	=> 'Stavroupoli',
			2544	=> 'Echinos',
			2551	=> 'Alexandroupolis',
			2552	=> 'Orestiada',
			2553	=> 'Didymoticho',
			2554	=> 'Soufli',
			2555	=> 'Feres',
			2556	=> 'Kyprinos',
			2591	=> 'Chrysoupoli',
			2592	=> 'Eleftheroupoli',
			2593	=> 'Limenari',
			2594	=> 'Peramos',
			2610	=> 'Patras',
			2621	=> 'Pyrgos',
			2622	=> 'Amaliada',
			2623	=> 'Lechena',
			2624	=> 'Anc. Olympia',
			2625	=> 'Krestena',
			2626	=> 'Andritsena',
			2631	=> 'Messologi',
			2632	=> 'Aitoliko',
			2634	=> 'Nafpaktos',
			2635	=> 'Mataraga',
			2641	=> 'Agrinion',
			2642	=> 'Amfilochia',
			2643	=> 'Vonitsa',
			2644	=> 'Thermo',
			2645	=> 'Lefkada',
			2646	=> 'Fyties',
			2647	=> 'Chalkiopoulo',
			2653	=> 'Karies',
			2654	=> 'Perdika',
			2655	=> 'Konitsa',
			2656	=> 'Tampouria',
			2657	=> 'Delvinaki',
			2658	=> 'Zitsa',
			2659	=> 'Kalentzi',
			2661	=> 'Corfu',
			2662	=> 'Lefkimi Corfu',
			2663	=> 'Skripero Corfu',
			2664	=> 'Filiates',
			2665	=> 'Igoumenitsa',
			2666	=> 'Paramythia',
			2671	=> 'Argostoli',
			2674	=> 'Sami',
			2681	=> 'Arta',
			2682	=> 'Prveza',
			2683	=> 'Philippiada',
			2684	=> 'Kanalaki',
			2685	=> 'Voulgareli',
			2691	=> 'Aegio',
			2692	=> 'Kalavrita',
			2694	=> 'Chalandritsa',
			2695	=> 'Zakynthos',
			2696	=> 'Akrata',
			2721	=> 'Kalamata',
			2722	=> 'Messini',
			2723	=> 'Pylos',
			2724	=> 'Meligalas',
			2725	=> 'Koroni',
			2731	=> 'Sparti',
			2732	=> 'Molaoi',
			2733	=> 'Gytheio',
			2735	=> 'Skala',
			2736	=> 'Kythira',
			2741	=> 'Korinthos',
			2742	=> 'Kiato',
			2743	=> 'Xylokastro',
			2744	=> 'Loutraki',
			2746	=> 'Nemea',
			2747	=> 'Kalianoi',
			2751	=> 'Argos',
			2752	=> 'Nafplion',
			2753	=> 'Lygourgio',
			2754	=> 'Kranidi',
			2755	=> 'Astros',
			2757	=> 'Leonidio',
			2761	=> 'Kyparissia',
			2763	=> 'Gargalianoi',
			2765	=> 'Kopanaki',
			2791	=> 'Megalopoli',
			2792	=> 'Kastri',
			2795	=> 'Vitina',
			2796	=> 'Levidi',
			2797	=> 'Tropea',
			2810	=> 'Heraklion (Iraklion)',
			2821	=> 'Chania',
			2822	=> 'Kissamos',
			2823	=> 'Kantanos',
			2824	=> 'Kolympari',
			2825	=> 'Vamos',
			2831	=> 'Rethymno',
			2832	=> 'Spili',
			2833	=> 'Amari',
			2834	=> 'Perama',
			2841	=> 'Ag. Nikolaos',
			2842	=> 'Ierapetra',
			2843	=> 'Sitia',
			2844	=> 'Tzermiades',
			2891	=> 'Arkalochori',
			2892	=> 'Moires',
			2893	=> 'Pyrgos (Creta)',
			2894	=> 'Ag. Varvara',
			2895	=> 'Viannos',
			2897	=> 'Limin Chersonisou',
			22410	=> 'Rdhos',
			24210	=> 'Volos',
			28210	=> 'Khania/Souda',
		},
		country_name => 'Greece',
		dialing_code => '30',
		globe_area => 'Europe',
	},
	GT => {
		area_codes => {
			2	=> 'Guatemala City',
			309	=> 'San Jose',
			''	=> 'Quetzaltenango',
		},
		country_name => 'Guatemala',
		dialing_code => '502',
		globe_area => 'Central America',
	},
	HN => {
		area_codes => {
			2	=> 'Tegucigalpa',
			5	=> 'San Pedro Sula',
		},
		country_name => 'Honduras',
		dialing_code => '504',
		globe_area => 'Central America',
	},
	HR => {
		area_codes => {
			1	=> 'Zagreb',
			20	=> 'Dubrovnik',
			21	=> 'Split',
			22	=> 'Sibenik',
			23	=> 'Zadar',
			31	=> 'Osijek',
			32	=> 'Vinkovci',
			33	=> 'Virovitica',
			34	=> 'Pozega',
			35	=> 'Slavonski Brod',
			40	=> 'Cakovec',
			42	=> 'Varazdin',
			43	=> 'Bjelovar',
			44	=> 'Sisak',
			47	=> 'Karlovac',
			48	=> 'Koprivnica',
			49	=> 'Krapina',
			51	=> 'Rijeka',
			52	=> 'Pazin',
			53	=> 'Gospic',
			95	=> 'Mobile Phones',
		},
		country_name => 'Croatia',
		dialing_code => '385',
		globe_area => 'Europe',
	},
	HU => {
		area_codes => {
			1	=> 'Budapest/lorinc',
			22	=> 'Szkesfehrvr',
			23	=> 'Biatorbgy',
			24	=> 'Szigetszentmikls',
			25	=> 'Dunajvrosi',
			26	=> 'Szentendre',
			27	=> 'Vacs',
			28	=> 'Gdllo',
			29	=> 'Monor',
			32	=> 'Salgtarjn',
			33	=> 'Esztergom',
			34	=> 'Tatabnya',
			35	=> 'Balassagyarmat',
			36	=> 'Eger',
			37	=> 'Gyngys',
			42	=> 'Nyregyhza',
			44	=> 'Mtszalka',
			45	=> 'Kisvrda',
			46	=> 'Miskolc',
			47	=> 'Szerencs',
			48	=> 'zd',
			49	=> 'Mezokvesd',
			52	=> 'Debrecen',
			53	=> 'Cegld',
			54	=> 'Berettyjfalu',
			56	=> 'Szolnok',
			57	=> 'Jszberny',
			59	=> 'Karcag',
			62	=> 'Szeged',
			63	=> 'Szentes',
			66	=> 'Bkscsaba',
			68	=> 'Oroshza',
			69	=> 'Mohcs',
			72	=> 'Pecsvarad',
			73	=> 'Szigetvr',
			74	=> 'Szekszrd',
			75	=> 'Paks',
			76	=> 'Kecskemt',
			77	=> 'Kiskunhalas',
			78	=> 'Kiskors',
			79	=> 'Baja',
			80	=> 'Dorgicse',
			82	=> 'Kaposvr',
			83	=> 'Keszthely',
			84	=> 'Sifok',
			85	=> 'Marcali',
			87	=> 'Tapolca',
			88	=> 'Veszprm',
			89	=> 'Ppa',
			92	=> 'Zalaegerszeg',
			93	=> 'Nagykanizsa',
			94	=> 'Szombathely',
			95	=> 'Srvr',
			96	=> 'Gyr',
			99	=> 'Sopron',
		},
		country_name => 'Hungary',
		dialing_code => '36',
		globe_area => 'Europe',
	},
	ID => {
		area_codes => {
			4	=> 'Sulawesi Islet',
			5	=> 'Malaku Islets',
			6	=> 'North Sumatra',
			9	=> 'Irian',
			21	=> 'Jakarta',
			22	=> 'Betung',
			23	=> 'Cirebon',
			24	=> 'Semarang',
			25	=> 'Bogor',
			26	=> 'Sumedang',
			27	=> 'Yogyakarta',
			28	=> 'Purwakarta',
			29	=> 'Demak',
			31	=> 'Surabaya',
			32	=> 'Jombang',
			33	=> 'Jember',
			34	=> 'Malang',
			35	=> 'Madiun',
			36	=> 'Denpasar',
			37	=> 'Sumbawa',
			38	=> 'Ende',
			39	=> 'Kupang',
			61	=> 'Medan',
			71	=> 'Palembang',
			72	=> 'Tanjungkarang',
			75	=> 'West Sumatra',
			76	=> 'Riau',
			77	=> 'Batang',
			265	=> 'Tasikmalaya',
			285	=> 'Pekalongan',
			291	=> 'Kudus',
			362	=> 'Singaraja',
			370	=> 'Mataram',
			411	=> 'Makassar',
			431	=> 'Manado',
			511	=> 'Banjarmasin',
			541	=> 'Samarinda',
			542	=> 'Balikpapan',
			622	=> 'Pematangsiantar',
			761	=> 'Pekanbaru',
			770	=> 'Bintan',
			778	=> 'Sekurang',
			911	=> 'Ambon',
			921	=> 'Ternate',
			967	=> 'Jayapura',
			''	=> 'Tegal',
		},
		country_name => 'Indonesia',
		dialing_code => '62',
		globe_area => 'Asia',
	},
	IE => {
		area_codes => {
			1	=> 'Dublin',
			21	=> 'Cork',
			41	=> 'Drogheda',
			45	=> 'Kildare',
			51	=> 'Waterford',
			52	=> 'Tipperary',
			53	=> 'Wexford',
			61	=> 'Limerick',
			64	=> 'Killarney',
			65	=> 'Ennis',
			66	=> 'Tralee',
			71	=> 'Sligo',
			91	=> 'Galway City',
			402	=> 'Arklow',
			506	=> 'Tullamore',
		},
		country_name => 'Ireland',
		dialing_code => '353',
		globe_area => 'Europe',
	},
	IL => {
		area_codes => {
			2	=> 'Jerusalem',
			3	=> 'Tel Aviv',
			4	=> 'Tsefat',
			8	=> 'Rehovot',
			9	=> 'Raanana',
		},
		country_name => 'Israel',
		dialing_code => '972',
		globe_area => 'Asia',
	},
	IN => {
		area_codes => {
			11	=> 'New Delhi',
			20	=> 'Pune (formerly Poona)',
			22	=> 'Thane',
			33	=> 'Kolkatta (formerly Calcutta)',
			40	=> 'Hyderabad',
			44	=> 'Tiruvallur',
			79	=> 'Ahmedabad',
			80	=> 'Bangalore',
			120	=> 'New Okhla Industrial Development Authority',
			121	=> 'Meerut',
			124	=> 'Gurgaon',
			129	=> 'Faridabad',
			131	=> 'Muzaffarnagar',
			132	=> 'Saharanpur',
			135	=> 'Dehradun',
			141	=> 'Jaipur',
			144	=> 'Sariska',
			145	=> 'Pushkar',
			151	=> 'Bikaner',
			154	=> 'Ganganagar',
			161	=> 'Ludhiana',
			164	=> 'Bathinda',
			172	=> 'Panchkula',
			175	=> 'Patiala',
			177	=> 'Simla',
			180	=> 'Panipat',
			181	=> 'Jullundur',
			183	=> 'Amritsar',
			191	=> 'Jammu',
			193	=> 'Anantnag',
			194	=> 'Srinagar',
			199	=> 'Udhampur',
			217	=> 'Solapur',
			231	=> 'Kolhapur',
			233	=> 'Sangli',
			253	=> 'Nasik',
			257	=> 'Jalgaon',
			260	=> 'Silvassa',
			261	=> 'Surat',
			265	=> 'Vadodara (Baroda)',
			268	=> 'Nadiad',
			278	=> 'Bhavnagar',
			281	=> 'Rajkot',
			285	=> 'Junagadh',
			288	=> 'Jamnagar',
			291	=> 'Jodhpur',
			294	=> 'Udaipur',
			326	=> 'Sindri',
			341	=> 'Kulti',
			342	=> 'Bardhaman',
			354	=> 'Darjeeling',
			360	=> 'Itanagar',
			361	=> 'Guwahati',
			364	=> 'Shillong',
			370	=> 'Kohima',
			373	=> 'Dibrugarh',
			374	=> 'Tinsukia',
			381	=> 'Agartala',
			389	=> 'Aizawl',
			413	=> 'Puducherry',
			416	=> 'Vellore',
			422	=> 'Coimbatore',
			423	=> 'Ootacamund',
			424	=> 'Erode',
			431	=> 'Tiruchirapalli',
			451	=> 'Dindigul',
			452	=> 'Madurai',
			461	=> 'Thoothukudi',
			462	=> 'Tirunelveli',
			468	=> 'Pathanamthitta',
			471	=> 'Thiruvananthapuram',
			474	=> 'Kollam',
			477	=> 'Alappuzha',
			481	=> 'Kottayam',
			483	=> 'Ponnani',
			484	=> 'Kochi',
			486	=> 'Painavu',
			487	=> 'Thrissur',
			490	=> 'Thalassery',
			491	=> 'Palakkad',
			494	=> 'Kasaragod',
			495	=> 'Kozhikode',
			510	=> 'Jhansi',
			512	=> 'Kanpur',
			515	=> 'Unnao',
			522	=> 'Lucknow',
			535	=> 'Raebareli',
			542	=> 'Varanasi',
			548	=> 'Ghazipur',
			551	=> 'Gorakhpur',
			562	=> 'Agra',
			565	=> 'Mathura',
			571	=> 'Aligarh',
			581	=> 'Bareilly',
			591	=> 'Moradabad',
			595	=> 'Rampur',
			612	=> 'Patna',
			621	=> 'Muzaffarpur',
			631	=> 'Gaya',
			641	=> 'Bhagalpur',
			651	=> 'Ranchi',
			657	=> 'Jamshedpur',
			661	=> 'Rourkela',
			663	=> 'Sambalpur',
			671	=> 'Cuttack',
			674	=> 'Bhubaneswar',
			680	=> 'Berhampur',
			685	=> 'Nabarangpur',
			712	=> 'Nagpur',
			721	=> 'Amravati',
			724	=> 'Akola',
			731	=> 'Indore',
			733	=> 'Khandwa',
			734	=> 'Ujjain',
			744	=> 'Kota',
			747	=> 'Bundi',
			751	=> 'Gwalior',
			755	=> 'Bhopal',
			761	=> 'Jabalpur',
			771	=> 'Raipur',
			821	=> 'Mysore',
			832	=> 'Vasco da Gama',
			863	=> 'Guntur',
			866	=> 'Vijayawada',
			870	=> 'Warangal',
			877	=> 'Tirumala',
			891	=> 'Visakhapatnam',
			1234	=> 'Bagpat',
			1332	=> 'Roorkee',
			1342	=> 'Bijnor',
			1362	=> 'Mussooree',
			1427	=> 'Dausa',
			1435	=> 'Tonk',
			1462	=> 'Beawar',
			1482	=> 'Bhilwara',
			1552	=> 'Hanumangarh',
			1562	=> 'Churu',
			1572	=> 'Sikar',
			1582	=> 'Nagaur',
			1595	=> 'Jhunjhunu',
			1632	=> 'Firozpur',
			1633	=> 'Muktsar',
			1636	=> 'Moga',
			1639	=> 'Faridkot',
			1652	=> 'Mansa',
			1672	=> 'Sangrur',
			1679	=> 'Barnala',
			1763	=> 'Fatehgarh Sahib',
			1822	=> 'Kapurthala',
			1823	=> 'Nawanshahr',
			1852	=> 'Tarn Taran Sahib',
			1874	=> 'Gurdaspur',
			1881	=> 'Rupnagar',
			1882	=> 'Hoshiarpur',
			1922	=> 'Kathua',
			1933	=> 'Pampore',
			1952	=> 'Baramulla',
			1954	=> 'Sopore',
			2162	=> 'Satara',
			2353	=> 'Ratnagiri',
			2382	=> 'Latur',
			2432	=> 'Aurangabad',
			2442	=> 'Beed',
			2452	=> 'Parbhani',
			2456	=> 'Hingoli',
			2462	=> 'Nanded',
			2472	=> 'Osmanabad',
			2482	=> 'Jalna',
			2489	=> 'Karjat',
			2562	=> 'Dhule',
			2564	=> 'Nandurbar',
			2637	=> 'Navsari',
			2642	=> 'Bharuch',
			2692	=> 'Anand',
			2712	=> 'Gandhinagar',
			2832	=> 'Bhuj',
			2922	=> 'Jaisalmer',
			2952	=> 'Rajsamand',
			2962	=> 'Banswara',
			2964	=> 'Dungarpur',
			2972	=> 'Jalore',
			2974	=> 'Mount Abu',
			2982	=> 'Barmer',
			3192	=> 'Port Blair',
			3222	=> 'Midnapore',
			3228	=> 'Tamluk',
			3242	=> 'Bankura',
			3252	=> 'Purulia',
			3462	=> 'Suri',
			3472	=> 'Krishnanagar',
			3482	=> 'Baharampur',
			3512	=> 'Malda',
			3522	=> 'Balurghat',
			3523	=> 'Raiganj',
			3561	=> 'Jalpaiguri',
			3582	=> 'Cooch Behar',
			3592	=> 'Gangtok',
			3637	=> 'Cherrapunji',
			3672	=> 'Nagaon',
			3772	=> 'Sibsagar',
			3842	=> 'Silchar',
			3852	=> 'Imphal',
			3862	=> 'Dimapur',
			4142	=> 'Cuddalore',
			4146	=> 'Viluppuram',
			4175	=> 'Thiruvannaamalai',
			4286	=> 'Namakkal',
			4322	=> 'Pudukkottai',
			4324	=> 'Karur',
			4328	=> 'Perambalur',
			4342	=> 'Dharmapuri',
			4343	=> 'Krishnagiri',
			4362	=> 'Thanjavur',
			4365	=> 'Nagapattinam',
			4366	=> 'Tiruvarur',
			4546	=> 'Theni',
			4562	=> 'Virudunagar',
			4567	=> 'Ramanathapuram',
			4575	=> 'Sivaganga',
			4652	=> 'Nagercoil',
			4896	=> 'Kavaratti',
			4936	=> 'Kalpetta',
			5162	=> 'Orai',
			5176	=> 'Lalitpur',
			5192	=> 'Banda',
			5194	=> 'Chitrakuta',
			5195	=> 'Mau',
			5240	=> 'Fatehpur',
			5248	=> 'Barabanki',
			5250	=> 'Bhinga',
			5252	=> 'Bahraich',
			5262	=> 'Gonda',
			5263	=> 'Balrampur',
			5271	=> 'Akbarpur',
			5278	=> 'Faizabad',
			5281	=> 'Mahoba',
			5282	=> 'Hamirpur',
			5331	=> 'Manjhanpur',
			5342	=> 'Pratapgarh',
			5362	=> 'Sultanpur',
			5412	=> 'Chandauli',
			5414	=> 'Gyanpur',
			5442	=> 'Mirzapur',
			5444	=> 'Robertsganj',
			5452	=> 'Jaunpur',
			5462	=> 'Azamgarh',
			5498	=> 'Ballia',
			5523	=> 'Maharajganj',
			5542	=> 'Basti',
			5544	=> 'Naugarh',
			5547	=> 'Khalilabad',
			5564	=> 'Padrauna',
			5568	=> 'Deoria',
			5612	=> 'Firozabad',
			5619	=> 'Fathepur Sikri',
			5642	=> 'Dholpur',
			5644	=> 'Bharatpur',
			5672	=> 'Mainpuri',
			5683	=> 'Auraiya',
			5688	=> 'Etawah',
			5692	=> 'Fatehgarh',
			5694	=> 'Kannauj',
			5722	=> 'Hathras',
			5732	=> 'Bulandshahr',
			5742	=> 'Etah',
			5832	=> 'Badaun',
			5842	=> 'Shahjahanpur',
			5852	=> 'Hardoi',
			5862	=> 'Sitapur',
			5872	=> 'Lakhimpur',
			5882	=> 'Pilibhit',
			5922	=> 'Amroha',
			5946	=> 'Haldwani',
			6114	=> 'Jehanabad',
			6119	=> 'Nalanda',
			6152	=> 'Chhapra',
			6154	=> 'Siwan',
			6156	=> 'Gopalganj',
			6182	=> 'Arrah',
			6183	=> 'Buxar',
			6184	=> 'Sasaram',
			6189	=> 'Bhabua',
			6222	=> 'Sheohar',
			6224	=> 'Hajipur',
			6226	=> 'Sitamarhi',
			6243	=> 'Begusarai',
			6244	=> 'Khagaria',
			6252	=> 'Motihari',
			6254	=> 'Bettiah',
			6272	=> 'Darbhanga',
			6274	=> 'Samastipur',
			6276	=> 'Madhubani',
			6324	=> 'Nawada',
			6341	=> 'Sheikhpura',
			6344	=> 'Munger',
			6345	=> 'Jamui',
			6346	=> 'Lakhisarai',
			6424	=> 'Banka',
			6432	=> 'Deoghar',
			6452	=> 'Katihar',
			6453	=> 'Araria',
			6454	=> 'Purnia',
			6466	=> 'Kishanganj',
			6473	=> 'Supaul',
			6476	=> 'Madhepura',
			6478	=> 'Saharsa',
			6524	=> 'Gumla',
			6542	=> 'Bokaro Steel City',
			6546	=> 'Hazaribagh',
			6622	=> 'Sundergarh',
			6641	=> 'Debagarh',
			6645	=> 'Jharsuguda',
			6646	=> 'Bargarh',
			6652	=> 'Balangir',
			6654	=> 'Sonepur',
			6670	=> 'Bhawanipatna',
			6678	=> 'Nuapada',
			6724	=> 'Jagatsinghpur',
			6727	=> 'Kendrapara',
			6752	=> 'Puri',
			6753	=> 'Nayagarh',
			6755	=> 'Khordha',
			6762	=> 'Dhenkanal',
			6764	=> 'Angul',
			6766	=> 'Kendujhar',
			6782	=> 'Balasore',
			6784	=> 'Bhadrak',
			6792	=> 'Baripada',
			6811	=> 'Chhatrapur',
			6815	=> 'Paralakhemundi',
			6841	=> 'Boudh',
			6842	=> 'Phulbani',
			6852	=> 'Koraput',
			6856	=> 'Rayagada',
			6861	=> 'Malkangiri',
			7132	=> 'Gadchiroli',
			7141	=> 'Betul',
			7152	=> 'Wardha',
			7162	=> 'Chhindwara',
			7172	=> 'Chandrapur',
			7182	=> 'Gondia',
			7184	=> 'Bhandara',
			7232	=> 'Yavatmal',
			7252	=> 'Washim',
			7262	=> 'Buldhana',
			7272	=> 'Dewas',
			7282	=> 'Khargone',
			7290	=> 'Barwani',
			7292	=> 'Dhar',
			7325	=> 'Burhanpur',
			7364	=> 'Shajapur',
			7372	=> 'Rajgarh',
			7392	=> 'Jhabua',
			7412	=> 'Ratlam',
			7422	=> 'Mandsaur',
			7423	=> 'Neemuch',
			7432	=> 'Jhalawar',
			7453	=> 'Baran',
			7462	=> 'Sawai Madhopur',
			7464	=> 'Karauli',
			7492	=> 'Shivpuri',
			7522	=> 'Datia',
			7530	=> 'Sheopur',
			7532	=> 'Morena',
			7534	=> 'Bhind',
			7542	=> 'Guna',
			7562	=> 'Sehore',
			7574	=> 'Hoshangabad',
			7577	=> 'Harda',
			7582	=> 'Sagar',
			7592	=> 'Vidisha',
			7622	=> 'Katni',
			7632	=> 'Balaghat',
			7638	=> 'Damoh',
			7642	=> 'Mandla',
			7652	=> 'Shahdol',
			7662	=> 'Rewa',
			7672	=> 'Satna',
			7682	=> 'Chhatarpur',
			7683	=> 'Tikamgarh',
			7692	=> 'Seoni',
			7732	=> 'Panna',
			7792	=> 'Narsinghpur',
			7822	=> 'Sidhi',
			8252	=> 'Manipal',
			8342	=> 'Margao',
			8554	=> 'Anantapur',
			8572	=> 'Chittorgarh',
			8743	=> 'Bhadrachalam',
			8812	=> 'Eluru',
		},
		country_name => 'India',
		dialing_code => '91',
		globe_area => 'Asia',
	},
	IQ => {
		area_codes => {
			1	=> 'Baghdad',
			30	=> 'Hilla',
			32	=> 'Kerbela',
			33	=> 'Najaf',
			40	=> 'Basra',
			42	=> 'Nasiriya',
			50	=> 'Kirkuk',
			53	=> 'Sulaimaniya',
			60	=> 'Mousil',
			66	=> 'Irbil',
		},
		country_name => 'Iraq',
		dialing_code => '964',
		globe_area => 'Asia',
	},
	IR => {
		area_codes => {
			21	=> 'Tehran',
			242	=> 'Zanjan',
			311	=> 'Esfahan',
			352	=> 'Yazd',
			411	=> 'Tabriz',
			511	=> 'Mashhad',
		},
		country_name => 'Iran',
		dialing_code => '98',
		globe_area => 'Asia',
	},
	IT => {
		area_codes => {
			2	=> 'Milan',
			6	=> 'Vatican City',
			10	=> 'Genoa',
			11	=> 'Turin',
			19	=> 'Savona',
			30	=> 'Brescia',
			31	=> 'Como',
			35	=> 'Bergamo',
			39	=> 'Monza',
			40	=> 'Trieste',
			41	=> 'Venice',
			45	=> 'Verona',
			50	=> 'Pisa',
			51	=> 'Bologna',
			55	=> 'Florence',
			59	=> 'Modena',
			70	=> 'Cagliari',
			71	=> 'Ancona',
			75	=> 'Perugia',
			79	=> 'Sassari',
			80	=> 'Bari',
			81	=> 'Naples',
			85	=> 'Pescara',
			89	=> 'Salerno',
			90	=> 'Messina',
			91	=> 'Palermo',
			95	=> 'Catania',
			99	=> 'Taranto',
			131	=> 'Alessandria',
			143	=> 'Novi Lgure',
			165	=> 'Aosta',
			171	=> 'Cuneo',
			184	=> 'San Remo',
			185	=> 'Rapallo',
			187	=> 'La Spezia',
			321	=> 'Novara',
			324	=> 'Domodossola',
			332	=> 'Varese',
			372	=> 'Cremona',
			422	=> 'Treviso',
			425	=> 'Rovigo',
			432	=> 'Udine',
			434	=> 'Pordenone',
			436	=> 'Cortina d Ampezzo',
			444	=> 'Vicenza',
			461	=> 'Trento',
			471	=> 'Bolzano',
			473	=> 'Merano',
			474	=> 'Brunico',
			481	=> 'Gorizia',
			521	=> 'Parma',
			522	=> 'Reggio Emilia',
			523	=> 'Piacenza',
			532	=> 'Ferrara',
			541	=> 'Rimini',
			542	=> 'Imola',
			544	=> 'Ravenna',
			549	=> 'San Marino',
			564	=> 'Grosseto',
			571	=> 'Empoli',
			574	=> 'Prato',
			577	=> 'Siena',
			583	=> 'Lucca',
			586	=> 'Livorno',
			721	=> 'Pesaro',
			736	=> 'Ascoli Piceno',
			743	=> 'Spoleto',
			744	=> 'Terni',
			746	=> 'Rieti',
			761	=> 'Viterbo',
			763	=> 'Orvieto',
			766	=> 'Civitavecchia',
			771	=> 'Formia',
			774	=> 'Tivoli',
			775	=> 'Frosinone',
			776	=> 'Cassino',
			784	=> 'Nuoro',
			823	=> 'Caserta',
			831	=> 'Brindisi',
			832	=> 'Lecce',
			861	=> 'Teramo',
			862	=> 'L Aquila',
			871	=> 'Chieti',
			872	=> 'Lanciano',
			873	=> 'Vasto',
			874	=> 'Campobasso',
			875	=> 'Termoli',
			881	=> 'Foggia',
			923	=> 'Trapani',
			924	=> 'Alcamo',
			931	=> 'Siracusa',
			961	=> 'Catanzaro',
			963	=> 'Vibo Valentia',
			965	=> 'Reggio Calabria',
			971	=> 'Potenza',
		},
		country_name => 'Italy',
		dialing_code => '39',
		globe_area => 'Europe',
	},
	JP => {
		area_codes => {
			3	=> 'Tokyo',
			6	=> 'Toyonaka',
			11	=> 'Sapporo',
			22	=> 'Sendai',
			25	=> 'Niigata',
			28	=> 'Utsunomiya',
			42	=> 'Hachioji',
			43	=> 'Choshi',
			44	=> 'Kawasaki',
			45	=> 'Yokohama',
			47	=> 'Matsudo',
			48	=> 'Omiya',
			52	=> 'Nagoya',
			54	=> 'Shizuoka',
			58	=> 'Gifu',
			66	=> 'Osaka',
			72	=> 'Sakai',
			73	=> 'Wakayama',
			75	=> 'Kyoto',
			76	=> 'Kanazawa',
			78	=> 'Kobe',
			79	=> 'Himeji',
			82	=> 'Hiroshima',
			86	=> 'Kurashiki',
			89	=> 'Matsuyama',
			92	=> 'Fukuoka',
			93	=> 'Kitakyushu',
			95	=> 'Nagasaki',
			96	=> 'Kumamoto',
			98	=> 'Okinawa',
			99	=> 'Kagoshima',
			138	=> 'Hakodate',
			166	=> 'Asahikawa',
			177	=> 'Aomori',
			196	=> 'Morioka',
			258	=> 'Nagaoka',
			262	=> 'Nagano',
			263	=> 'Matsumoto',
			292	=> 'Mito',
			427	=> 'Machida',
			482	=> 'Kawaguchi',
			552	=> 'Kofu',
			564	=> 'Okazaki',
			565	=> 'Toyota',
			568	=> 'Kasugai',
			584	=> 'Ogaki',
			592	=> 'Tsu',
			724	=> 'Kishiwada',
			729	=> 'Yao',
			748	=> 'Yokkaichi',
			764	=> 'Toyama',
			766	=> 'Takaoka',
			774	=> 'Uji',
			823	=> 'Kure',
			832	=> 'Shimonoseki',
			836	=> 'Ube',
			839	=> 'Yamaguchi',
			862	=> 'Okayama',
			878	=> 'Takamatsu',
			942	=> 'Kurume',
			956	=> 'Sasebo',
			985	=> 'Miyazaki',
			9445	=> 'Omuta',
		},
		country_name => 'Japan',
		dialing_code => '81',
		globe_area => 'Asia',
	},
	KE => {
		area_codes => {
			20	=> 'Nairobi',
			41	=> 'Mombasa',
			42	=> 'Malindi',
			43	=> 'Voi',
			46	=> 'Garissa',
			51	=> 'Nakuru',
			52	=> 'Kericho',
			54	=> 'Kitale',
			56	=> 'Kakamega',
			57	=> 'Kisumu',
			58	=> 'Kisii',
			64	=> 'Meru',
			67	=> 'Thika',
			69	=> 'Marsabit',
		},
		country_name => 'Kenya',
		dialing_code => '254',
		globe_area => 'Africa',
	},
	KP => {
		area_codes => {
			2	=> 'Pyongyang',
		},
		country_name => 'Korea (North)',
		dialing_code => '850',
		globe_area => 'Asia',
	},
	KR => {
		area_codes => {
			2	=> 'Seoul',
			32	=> 'Incheon',
			52	=> 'Ulsan',
			62	=> 'Kwangju',
			64	=> 'Cheju',
		},
		country_name => 'Korea (South)',
		dialing_code => '82',
		globe_area => 'Asia',
	},
	KZ => {
		area_codes => {
			310	=> 'Zhezkazgan',
			311	=> 'Uralsk',
			312	=> 'Atyrau',
			313	=> 'Aktjubinsk',
			315	=> 'Petropavlovsk',
			318	=> 'Pavlodar',
			321	=> 'Karaganda',
			324	=> 'Kzyl Orda',
			325	=> 'Shymkent',
			326	=> 'Zhambyl',
			327	=> 'Alma Ata',
			336	=> 'Leninogorsk',
			7172	=> 'Astana',
			73622	=> 'Baikonur',
		},
		country_name => 'Kazakhstan',
		dialing_code => '7',
		globe_area => 'Asia',
	},
	MA => {
		area_codes => {
			22	=> 'Casablanca',
			37	=> 'Rabat',
			39	=> 'Tetouan',
			44	=> 'Marrakesh',
			55	=> 'Meknes',
			56	=> 'Oujda',
			548	=> 'Agadir',
			5399	=> 'Tangier',
		},
		country_name => 'Morocco',
		dialing_code => '212',
		globe_area => 'Africa',
	},
	MK => {
		area_codes => {
			2	=> 'Skopje',
			31	=> 'Kumanovo',
			32	=> 'Sveti Nikole',
			33	=> 'Vinica',
			34	=> 'Valandovo',
			42	=> 'Gostivar',
			43	=> 'Veles',
			44	=> 'Tetovo',
			45	=> 'Kichevo',
			46	=> 'Struga',
			47	=> 'Resen',
			48	=> 'Prilep',
		},
		country_name => 'Macedonia',
		dialing_code => '389',
		globe_area => 'Europe',
	},
	MN => {
		area_codes => {
			11	=> 'Ulaanbaatar',
			''	=> 'Hovdo',
		},
		country_name => 'Mongolia',
		dialing_code => '976',
		globe_area => 'Asia',
	},
	MX => {
		area_codes => {
			33	=> 'Guadalajara',
			55	=> 'Mexico City',
			81	=> 'Monterrey',
			222	=> 'Puebla',
			229	=> 'Veracruz',
			322	=> 'Puerto Vallarta',
			443	=> 'Morelia',
			444	=> 'San Luis Potos',
			449	=> 'Aguascalientes',
			461	=> 'Celaya',
			462	=> 'Irapuato',
			477	=> 'Len',
			614	=> 'Chihuahua',
			618	=> 'Durango',
			624	=> 'Cabo San Lucas',
			631	=> 'Nogales',
			646	=> 'Ensenada',
			656	=> 'Ciudad Jurez',
			662	=> 'Hermosillo',
			664	=> 'Tijuana',
			667	=> 'Culiacn',
			668	=> 'Los Mochis',
			669	=> 'Mazatln',
			686	=> 'Mexicali',
			744	=> 'Acapulco',
			777	=> 'Cuernavaca',
			815	=> 'Toluca',
			833	=> 'Tampico',
			844	=> 'Saltillo',
			861	=> 'Progreso',
			867	=> 'Nuevo Laredo',
			871	=> 'Torren',
			899	=> 'Reynosa',
			932	=> 'Jalapa Enrquez',
			938	=> 'Ciudad del Carmen',
			951	=> 'Oaxaca de Jurez',
			961	=> 'Ixtapa',
			971	=> 'Juchitn',
			981	=> 'Campeche',
			984	=> 'Playa del Carmen',
			987	=> 'Cozumel',
			993	=> 'Villahermosa',
			998	=> 'Cancn',
			999	=> 'Mrida',
		},
		country_name => 'Mexico',
		dialing_code => '52',
		globe_area => 'North America',
	},
	MY => {
		area_codes => {
			3	=> 'Kuala Lumpur',
			4	=> 'Penang',
			5	=> 'Ipoh',
			6	=> 'Seremban',
			7	=> 'Johor Bahru',
			8	=> 'Sibu',
			9	=> 'Kuantan',
		},
		country_name => 'Malaysia',
		dialing_code => '60',
		globe_area => 'Asia',
	},
	NG => {
		area_codes => {
			1	=> 'Lagos',
			2	=> 'Ibadan',
			9	=> 'Abuja',
			30	=> 'Ado Ekiti',
			31	=> 'Ilorin',
			33	=> 'New Bussa',
			34	=> 'Akure',
			35	=> 'Oshogbo',
			36	=> 'Ile Ife',
			37	=> 'Ijebu Ode',
			38	=> 'Oyo',
			39	=> 'Abeokuta',
			41	=> 'Wukari',
			42	=> 'Enugu',
			43	=> 'Abakaliki',
			44	=> 'Makurdi',
			45	=> 'Ogoja',
			46	=> 'Onitsha',
			47	=> 'Lafia',
			48	=> 'Awka',
			50	=> 'Ikare',
			51	=> 'Owo',
			52	=> 'Edo',
			53	=> 'Warri',
			54	=> 'Sapele',
			55	=> 'Agbor',
			56	=> 'Asaba',
			57	=> 'Auchi',
			58	=> 'Lokoja',
			59	=> 'Okitipupa',
			60	=> 'Sokobo',
			61	=> 'Kafanchau',
			62	=> 'Kaduna',
			63	=> 'Gusau',
			64	=> 'Kano Nigeria',
			65	=> 'Katsina',
			66	=> 'Niger Sate',
			67	=> 'Kontagora',
			68	=> 'Birnin',
			69	=> 'Zaria',
			70	=> 'Pank Shin',
			71	=> 'Azare',
			72	=> 'Gombe',
			73	=> 'Jos',
			74	=> 'Damaturu',
			75	=> 'Yola',
			76	=> 'Maiduguri',
			77	=> 'Bauchi',
			78	=> 'Hadejia',
			79	=> 'Jalingo',
			82	=> 'Aba',
			83	=> 'Owerri',
			84	=> 'Port Harcourt',
			85	=> 'Uyo',
			86	=> 'Ahoada',
			87	=> 'Calabar',
			88	=> 'Umuahia',
			89	=> 'Yenegoa',
		},
		country_name => 'Nigeria',
		dialing_code => '234',
		globe_area => 'Africa',
	},
	NL => {
		area_codes => {
			10	=> 'Rotterdam',
			13	=> 'Tilburg',
			15	=> 'Delft',
			20	=> 'Amsterdam',
			23	=> 'Hoofddorp',
			24	=> 'Nijmegen',
			26	=> 'Arnhem',
			30	=> 'Zeist',
			33	=> 'Amersfoort',
			35	=> 'Hilversum',
			36	=> 'Almere',
			38	=> 'Zwolle',
			40	=> 'Eindhoven',
			43	=> 'Maastricht',
			45	=> 'Hoensbroek',
			50	=> 'Hoogkerk',
			53	=> 'Enschede',
			55	=> 'Apeldoorn',
			70	=> 'The Hague (Den Haag)',
			71	=> 'Leiden',
			73	=> 'Vught',
			75	=> 'Zaandam',
			76	=> 'Breda',
			78	=> 'Dordrecht',
			79	=> 'Zoetermeer',
			318	=> 'Ede',
			570	=> 'Deventer',
			591	=> 'Emmen',
			''	=> 'Philipsburg',
		},
		country_name => 'Netherlands',
		dialing_code => '31',
		globe_area => 'Europe',
	},
	NO => {
		area_codes => {
			2	=> 'Oslo',
			5	=> 'Haugesund',
			33	=> 'Larvik',
			35	=> 'Porsgrunn',
			37	=> 'Arendal',
			69	=> 'Moss',
		},
		country_name => 'Norway',
		dialing_code => '47',
		globe_area => 'Europe',
	},
	NZ => {
		area_codes => {
			3	=> 'Timaru',
			4	=> 'Wellington',
			6	=> 'Palmerston North',
			7	=> 'Tauranga Harbour',
			9	=> 'Auckland',
			765	=> 'Richmond',
			812	=> 'Westport',
		},
		country_name => 'New Zealand',
		dialing_code => '64',
		globe_area => 'Oceania',
	},
	OM => {
		area_codes => {
			24	=> 'Muscat',
		},
		country_name => 'Oman',
		dialing_code => '968',
		globe_area => 'Asia',
	},
	PE => {
		area_codes => {
			1	=> 'Lima',
			14	=> 'Callao',
			34	=> 'Ica',
			44	=> 'Trujillo',
			54	=> 'Tacna',
			74	=> 'Piura',
			84	=> 'Cusco',
			94	=> 'Iquitos',
		},
		country_name => 'Peru',
		dialing_code => '51',
		globe_area => 'South America',
	},
	PG => {
		area_codes => {
			''	=> 'Port Moresby',
		},
		country_name => 'Papua New Guinea',
		dialing_code => '675',
		globe_area => 'Oceania',
	},
	PH => {
		area_codes => {
			2	=> 'Quezon City',
			32	=> 'Cebu City',
			33	=> 'Iloilo',
			34	=> 'Bacolod City',
			46	=> 'Cavite',
			48	=> 'Puerto Princesa City',
			53	=> 'Tacloban City',
			56	=> 'Masbate',
			62	=> 'Zamboanga',
			75	=> 'Dagupan City',
			82	=> 'Davao City',
			83	=> 'General Santos',
			93	=> 'San Pablo City',
			309	=> 'San Jose',
			452	=> 'Tarlac',
			455	=> 'Angeles City',
			818	=> 'San Fernando',
			831	=> 'Santa Cruz',
		},
		country_name => 'Philippines',
		dialing_code => '63',
		globe_area => 'Asia',
	},
	PK => {
		area_codes => {
			21	=> 'Karachi',
			41	=> 'Faisalabad',
			42	=> 'Lahore',
			51	=> 'Rawalpindi',
			61	=> 'Multan',
			81	=> 'Quetta',
			91	=> 'Peshawar',
			221	=> 'Hyderabad',
			431	=> 'Gujranwala',
			441	=> 'Sahiwal',
			442	=> 'Okara',
			451	=> 'Sargodha',
			524	=> 'Sialkot',
		},
		country_name => 'Pakistan',
		dialing_code => '92',
		globe_area => 'Asia',
	},
	PL => {
		area_codes => {
			10	=> 'Przemysl',
			12	=> 'Krakow',
			14	=> 'Tarnow',
			22	=> 'Warsaw',
			24	=> 'Plock',
			25	=> 'Siedlce',
			32	=> 'Zabrze',
			34	=> 'Czstochowa',
			36	=> 'Rybnik',
			41	=> 'Kielce',
			42	=> 'Otwock',
			50	=> 'Elblag',
			58	=> 'Hel',
			59	=> 'Tychy',
			61	=> 'Pozna',
			62	=> 'Kalisz',
			68	=> 'Zielona Gora',
			71	=> 'Wroclaw',
			76	=> 'Legnica',
			81	=> 'Lublin',
			84	=> 'Zamosc',
			85	=> 'Bialystok',
			87	=> 'Suwalki',
			91	=> 'Szczecin',
			92	=> 'Stargard Szczecinski',
			94	=> 'Koszalin',
			95	=> 'Gorzw Wielkopolski',
			936	=> 'Swinoujscie',
		},
		country_name => 'Poland',
		dialing_code => '48',
		globe_area => 'Europe',
	},
	PT => {
		area_codes => {
			21	=> 'Lisbon',
			22	=> 'Vila Nova de Gaia',
			232	=> 'Viseu',
			233	=> 'Figueira da Foz',
			234	=> 'Aveiro',
			239	=> 'Coimbra',
			243	=> 'Santarem',
			244	=> 'Leiria',
			245	=> 'Portalegre',
			253	=> 'Braga',
			258	=> 'Viana do Castelo',
			259	=> 'Vila Real',
			262	=> 'Caldar Da Rainha',
			265	=> 'Setbal',
			266	=> 'vora',
			268	=> 'Estremoz',
			271	=> 'Guarda',
			272	=> 'Castelo Branco',
			273	=> 'Braganca',
			275	=> 'Covilha',
			276	=> 'Chaves',
			278	=> 'Mirandela',
			281	=> 'Tavira',
			282	=> 'Portimo',
			283	=> 'Odemira',
			284	=> 'Beja',
			285	=> 'Moura',
			286	=> 'Castro Verd',
			289	=> 'Faro',
			292	=> 'Horta',
			296	=> 'Ponta Delgada',
			297	=> 'Funchal',
		},
		country_name => 'Portugal',
		dialing_code => '351',
		globe_area => 'Europe',
	},
	PY => {
		area_codes => {
			21	=> 'Asuncin',
			31	=> 'Concepcion',
			71	=> 'Encarnacion',
			86	=> 'Pilar',
			521	=> 'Coronel Oviedo',
		},
		country_name => 'Paraguay',
		dialing_code => '595',
		globe_area => 'South America',
	},
	RO => {
		area_codes => {
			21	=> 'Bucharest',
			231	=> 'Botosani',
			232	=> 'Iasi',
			233	=> 'Ceahlau',
			234	=> 'Bacau',
			236	=> 'Galati',
			237	=> 'Focsani',
			238	=> 'Buzau',
			239	=> 'Braila',
			240	=> 'Sulina',
			241	=> 'Constanta',
			242	=> 'Calarasi',
			243	=> 'Slobozia',
			244	=> 'Ploiesti',
			245	=> 'Tirgoviste',
			246	=> 'Giurgiu',
			247	=> 'Rosiori de Vede',
			248	=> 'Pitesti',
			249	=> 'Slatina',
			251	=> 'Craiova',
			252	=> 'Drobeta Turnu Severin',
			254	=> 'Petrosani',
			255	=> 'Caransebes',
			256	=> 'Timisoara',
			257	=> 'Arad',
			259	=> 'Oradea',
			261	=> 'Satu Mare',
			262	=> 'Sighetu Marmatiei',
			264	=> 'Cluj Napoca',
			266	=> 'Gheorgheni',
			268	=> 'Brasov',
			269	=> 'Talmaciu',
		},
		country_name => 'Romania',
		dialing_code => '40',
		globe_area => 'Europe',
	},
	RU => {
		area_codes => {
			302	=> 'Chita',
			343	=> 'Yekaterinburg',
			351	=> 'Chelyabinsk',
			352	=> 'Kurgan',
			383	=> 'Novosibirsk',
			388	=> 'Gorno Altaysk',
			401	=> 'Kaliningrad',
			416	=> 'Amursk',
			471	=> 'Kursk',
			472	=> 'Belgorod',
			473	=> 'Voronezh',
			474	=> 'Lipetsk',
			475	=> 'Tambov',
			481	=> 'Smolensk',
			482	=> 'Tver',
			483	=> 'Bryansk',
			484	=> 'Kaluga',
			485	=> 'Yaroslavl',
			487	=> 'Tula',
			491	=> 'Ryazan',
			492	=> 'Vladimir',
			493	=> 'Ivanovo',
			494	=> 'Kostroma',
			495	=> 'Moscow',
			812	=> 'St. Petersburg',
			814	=> 'Petrozavodsk',
			817	=> 'Vologda',
			820	=> 'Cherepovets',
			821	=> 'Syktyvkar',
			833	=> 'Kirov',
			834	=> 'Saransk',
			836	=> 'Yoshkar Ola',
			842	=> 'Ulyanovsk',
			843	=> 'Kazan',
			862	=> 'Sochi',
			863	=> 'Rostov',
			867	=> 'Vladikavkaz',
			871	=> 'Groznyy',
			879	=> 'Mineral nyye Vody',
			3012	=> 'Ulan Ude',
			3412	=> 'Izhevsk',
			3422	=> 'Perm',
			3462	=> 'Surgut',
			3472	=> 'Ufa',
			3532	=> 'Orenburg',
			3812	=> 'Omsk',
			3822	=> 'Tomsk',
			3842	=> 'Kemerovo',
			3852	=> 'Barnaul',
			3912	=> 'Krasnoyarsk',
			3952	=> 'Irkutsk',
			4112	=> 'Yakutsk',
			4152	=> 'Petropavlovsk Kamchatskiy',
			4212	=> 'Khabarovsk',
			4232	=> 'Vladivostok',
			8152	=> 'Murmansk',
			8182	=> 'Arkhangelsk',
			8262	=> 'Orel',
			8352	=> 'Cheboksary',
			8412	=> 'Penza',
			8422	=> 'Ul\'yanovsk',
			8442	=> 'Volgograd',
			8452	=> 'Saratov',
			8462	=> 'Samara',
			8512	=> 'Astrakhan',
			8552	=> 'Naberezhnye Chelny',
			8612	=> 'Krasnodar',
			8652	=> 'Stavropol',
			39113	=> 'Tura',
			39152	=> 'Norilsk',
			41322	=> 'Magadan',
			42722	=> 'Anadyr',
			81622	=> 'Novgorod',
			86117	=> 'Novorossiysk',
			87822	=> 'Cherkessk',
		},
		country_name => 'Russia',
		dialing_code => '7',
		globe_area => 'Europe',
	},
	SA => {
		area_codes => {
			1	=> 'Shaqra',
			2	=> 'Rabigh',
			3	=> 'Dammam',
			6	=> 'Ha il',
			7	=> 'Najran',
		},
		country_name => 'Saudi Arabia',
		dialing_code => '966',
		globe_area => 'Asia',
	},
	SE => {
		area_codes => {
			8	=> 'Stockholm',
			11	=> 'Norrkping',
			13	=> 'Linkping',
			16	=> 'Eskilstuna',
			18	=> 'Uppsala',
			21	=> 'Vsters',
			23	=> 'Falun',
			26	=> 'Gvle',
			31	=> 'Gothenburg (Gteborg)',
			33	=> 'Bors',
			35	=> 'Halmstad',
			36	=> 'Jnkping',
			40	=> 'Malm',
			42	=> 'Helsingborg',
			44	=> 'Kristianstad',
			54	=> 'Karlstad',
			60	=> 'Sundsvall',
			63	=> 'stersund',
			90	=> 'Ume',
			120	=> 'tvidaberg',
			121	=> 'Sderkping',
			122	=> 'Finspng',
			123	=> 'Valdemarsvik',
			125	=> 'Vikbolandet',
			140	=> 'Trans',
			141	=> 'Motala',
			142	=> 'Mjlby',
			143	=> 'Vadstena',
			144	=> 'deshg',
			150	=> 'Katrineholm',
			151	=> 'Vingker',
			152	=> 'Strngns',
			155	=> 'Nykping',
			156	=> 'Trosa',
			157	=> 'Flen',
			158	=> 'Gnesta',
			159	=> 'Mariefred',
			171	=> 'Enkping',
			173	=> 'regrund',
			174	=> 'Alunda',
			175	=> 'Hallstavik',
			176	=> 'Norrtlje',
			220	=> 'Hallstahammar',
			221	=> 'Kping',
			222	=> 'Skinnskatteberg',
			223	=> 'Fagersta',
			224	=> 'Sala',
			225	=> 'Hedemora',
			226	=> 'Avesta',
			227	=> 'Kungsr',
			240	=> 'Ludvika',
			241	=> 'Gagnef',
			243	=> 'Borlnge',
			246	=> 'Svrdsj',
			247	=> 'Leksand',
			248	=> 'Rttvik',
			251	=> 'lvdalen',
			253	=> 'Idre',
			258	=> 'Furudal',
			270	=> 'Sderhamn',
			271	=> 'Alfta',
			278	=> 'Bollns',
			280	=> 'Malung',
			281	=> 'Vansbro',
			290	=> 'Hofors',
			291	=> 'Hedesunda',
			292	=> 'Trnsj',
			293	=> 'Tierp',
			294	=> 'Karlholmsbruk',
			295	=> 'rbyhus',
			297	=> 'Ockelbo',
			300	=> 'Kungsbacka',
			301	=> 'Hinds',
			302	=> 'Lerum',
			303	=> 'Kunglv',
			304	=> 'Orust',
			320	=> 'Kinna',
			321	=> 'Ulricehamn',
			322	=> 'Alingss',
			325	=> 'Svenljunga',
			340	=> 'Varberg',
			345	=> 'Hyltebruk',
			346	=> 'Falkenberg',
			370	=> 'Vrnamo',
			371	=> 'Gislaved',
			372	=> 'Ljungby',
			380	=> 'Nssj',
			381	=> 'Eksj',
			382	=> 'Svsj',
			383	=> 'Vetlanda',
			390	=> 'Grnna',
			392	=> 'Mullsj',
			393	=> 'Vaggeryd',
			410	=> 'Trelleborg',
			411	=> 'Ystad',
			413	=> 'Eslv',
			414	=> 'Simrishamn',
			415	=> 'Hrby',
			416	=> 'Sjbo',
			417	=> 'Tomelilla',
			418	=> 'Landskrona',
			430	=> 'Laholm',
			431	=> 'ngelholm',
			433	=> 'Markaryd',
			435	=> 'Klippan',
			451	=> 'Hssleholm',
			454	=> 'Karlshamn',
			455	=> 'Karlskrona',
			456	=> 'Slvesborg',
			457	=> 'Ronneby',
			459	=> 'Ryd',
			470	=> 'Vxj',
			471	=> 'Emmaboda',
			472	=> 'Alvesta',
			474	=> 'seda',
			476	=> 'lmhult',
			477	=> 'Tingsryd',
			478	=> 'Lessebo',
			479	=> 'Osby',
			480	=> 'Kalmar',
			481	=> 'Nybro',
			485	=> 'land',
			486	=> 'Torss',
			490	=> 'Vstervik',
			491	=> 'Oskarshamn',
			492	=> 'Vimmerby',
			493	=> 'Gamleby',
			494	=> 'Kisa',
			495	=> 'Hultsfred',
			496	=> 'Mariannelund',
			498	=> 'Gotland',
			499	=> 'Mnsters',
			500	=> 'Skvde',
			501	=> 'Mariestad',
			502	=> 'Tidaholm',
			503	=> 'Hjo',
			504	=> 'Tibro',
			505	=> 'Karlsborg',
			506	=> 'Treboda',
			510	=> 'Lidkping',
			511	=> 'Skara',
			512	=> 'Vara',
			513	=> 'Herrljunga',
			514	=> 'Grstorp',
			515	=> 'Falkping',
			520	=> 'Trollhttan',
			521	=> 'Vnersborg',
			522	=> 'Uddevalla',
			523	=> 'Lysekil',
			524	=> 'Munkedal',
			525	=> 'Grebbestad',
			526	=> 'Strmstad',
			528	=> 'Frgelanda',
			530	=> 'Mellerud',
			531	=> 'Bengtsfors',
			532	=> 'ml',
			533	=> 'Sffle',
			534	=> 'Ed',
			550	=> 'Kristinehamn',
			551	=> 'Gullspng',
			552	=> 'Deje',
			553	=> 'Molkom',
			554	=> 'Kil',
			555	=> 'Grums',
			560	=> 'Torsby',
			563	=> 'Hagfors',
			564	=> 'Sysslebck',
			565	=> 'Sunne',
			570	=> 'Arvika',
			571	=> 'Charlottenberg',
			573	=> 'rjng',
			580	=> 'Kopparberg',
			581	=> 'Lindesberg',
			582	=> 'Hallsberg',
			583	=> 'Askersund',
			584	=> 'Lax',
			585	=> 'Fjugesta',
			586	=> 'Karlskoga',
			587	=> 'Nora',
			589	=> 'Arboga',
			590	=> 'Filipstad',
			591	=> 'Hllefors',
			611	=> 'Hrnsand',
			612	=> 'Kramfors',
			613	=> 'Ullnger',
			620	=> 'Sollefte',
			621	=> 'Junsele',
			622	=> 'Nsker',
			623	=> 'Ramsele',
			624	=> 'Backe',
			640	=> 'Krokom',
			642	=> 'Lit',
			643	=> 'Hallen',
			644	=> 'Hammerdal',
			645	=> 'Fllinge',
			647	=> 're',
			650	=> 'Hudiksvall',
			651	=> 'Ljusdal',
			652	=> 'Bergsj',
			653	=> 'Delsbo',
			657	=> 'Los',
			660	=> 'rnskldsvik',
			661	=> 'Bredbyn',
			662	=> 'Bjrna',
			670	=> 'Strmsund',
			671	=> 'Hoting',
			672	=> 'Gaddede',
			680	=> 'Sveg',
			682	=> 'Rtan',
			684	=> 'Hede',
			687	=> 'Svenstavik',
			690	=> 'nge',
			691	=> 'Torpshammar',
			692	=> 'Liden',
			693	=> 'Brcke',
			695	=> 'Stugun',
			696	=> 'Hammarstrand',
			910	=> 'Skellefte',
			911	=> 'Pite',
			912	=> 'Byske',
			913	=> 'Lvnger',
			914	=> 'Burtrsk',
			915	=> 'Bastutrsk',
			916	=> 'Jrn',
			918	=> 'Norsj',
			920	=> 'Lule',
			921	=> 'Boden',
			922	=> 'Haparanda',
			923	=> 'Kalix',
			924	=> 'Rne',
			925	=> 'Lakatrsk',
			926	=> 'verkalix',
			927	=> 'vertorne',
			928	=> 'Harads',
			929	=> 'lvsbyn',
			930	=> 'Nordmaling',
			932	=> 'Bjurholm',
			933	=> 'Vindeln',
			934	=> 'Robertsfors',
			935	=> 'Vnns',
			940	=> 'Vilhelmina',
			941	=> 'sele',
			942	=> 'Dorotea',
			943	=> 'Fredrika',
			950	=> 'Lycksele',
			951	=> 'Storuman',
			952	=> 'Sorsele',
			953	=> 'Mal',
			954	=> 'Trnaby',
			960	=> 'Arvidsjaur',
			961	=> 'Arjeplog',
			970	=> 'Gllivare',
			971	=> 'Jokkmokk',
			973	=> 'Porjus',
			975	=> 'Hakkas',
			976	=> 'Vuollerim',
			977	=> 'Korpilombolo',
			978	=> 'Pajala',
			980	=> 'Kiruna',
			981	=> 'Vittangi',
		},
		country_name => 'Sweden',
		dialing_code => '46',
		globe_area => 'Europe',
	},
	SK => {
		area_codes => {
			2	=> 'Bratislava',
			31	=> 'Dujansk Streda',
			32	=> 'Trencn',
			33	=> 'Trnava',
			34	=> 'Senica',
			35	=> 'Nov Zmky',
			36	=> 'Levice 36',
			37	=> 'Nitra',
			38	=> 'Topol\'cany',
			43	=> 'Martin',
			45	=> 'Zvolen',
			46	=> 'Prievidza',
			47	=> 'Lucenec',
			48	=> 'Bansk Bystrica',
			52	=> 'Poprad',
			54	=> 'Bardejov',
			55	=> 'Kosice',
			56	=> 'Michalovce',
			57	=> 'Humenn',
		},
		country_name => 'Slovakia',
		dialing_code => '421',
		globe_area => 'Europe',
	},
	SY => {
		area_codes => {
			11	=> 'Zamalkah',
			12	=> 'Yabrood',
			13	=> 'Zabadani',
			14	=> 'Quneitra',
			15	=> 'Tafass',
			16	=> 'Sweidaa',
			21	=> 'Tel Refat',
			22	=> 'Tel Abiad',
			23	=> 'Sarakeb',
			25	=> 'Menbej',
			31	=> 'Telbisseh',
			33	=> 'Tel Salhab',
			34	=> 'Palmyra',
			41	=> 'Tesshrin',
			43	=> 'Tartous',
			51	=> 'Deir Ezzour',
			52	=> 'Raas Al',
			53	=> 'Malekiha',
		},
		country_name => 'Syria',
		dialing_code => '963',
		globe_area => 'Asia',
	},
	TH => {
		area_codes => {
			2	=> 'Bangkok',
			34	=> 'Kanchanaburi',
			38	=> 'Pattaya City',
			39	=> 'Chanthaburi',
			42	=> 'Nong Khai',
			43	=> 'Khon Kaen',
			44	=> 'Nakhon Ratchasima',
			45	=> 'Ubon Ratchathani',
			53	=> 'Chiang Mai',
			54	=> 'Lampang',
			55	=> 'Phitsanulok',
			74	=> 'Songkhla',
			76	=> 'Phuket',
			77	=> 'Surat Thani',
		},
		country_name => 'Thailand',
		dialing_code => '66',
		globe_area => 'Asia',
	},
	TM => {
		area_codes => {
			12	=> 'Ashgabat',
			322	=> 'Dashhowuz',
			378	=> 'Turkmenbashi',
		},
		country_name => 'Turkmenistan',
		dialing_code => '993',
		globe_area => 'Asia',
	},
	TN => {
		area_codes => {
			1	=> 'Tunis',
			2	=> 'Bizerte',
			3	=> 'Sousse',
			4	=> 'Sfax',
			5	=> 'Gabes',
			6	=> 'Tozeur',
			8	=> 'Tabarka',
		},
		country_name => 'Tunisia',
		dialing_code => '216',
		globe_area => 'Africa',
	},
	TR => {
		area_codes => {
			212	=> 'Istanbul Avrupa (Europe side)',
			216	=> 'Istanbul Asya (Asia side)',
			222	=> 'Eskisehir',
			224	=> 'Bursa',
			226	=> 'Yalova',
			228	=> 'Bilecik',
			232	=> 'Izmir',
			236	=> 'Manisa',
			242	=> 'Antalya',
			246	=> 'Isparta',
			248	=> 'Burdur',
			252	=> 'Mugla',
			256	=> 'Aydin',
			258	=> 'Denizli',
			262	=> 'Kocaeli',
			264	=> 'Sakarya',
			266	=> 'Balikesir',
			272	=> 'Afyon',
			274	=> 'Kutahya',
			284	=> 'Edirne',
			286	=> 'Canakkale',
			288	=> 'Kirklareli',
			312	=> 'Ankara',
			318	=> 'Kirikkale',
			322	=> 'Adana',
			324	=> 'Icel (Mersin)',
			326	=> 'Hatay',
			332	=> 'Konya',
			338	=> 'Karaman',
			342	=> 'Gaziantep',
			344	=> 'Kahramanmaras',
			346	=> 'Sivas',
			352	=> 'Kayseri',
			354	=> 'Yozgat',
			356	=> 'Tokat',
			358	=> 'Amasya',
			362	=> 'Samsun',
			364	=> 'Corum',
			366	=> 'Kastamonu',
			372	=> 'Zonguldak',
			374	=> 'Bolu',
			376	=> 'Cankiri',
			378	=> 'Bartin',
			382	=> 'Aksaray',
			386	=> 'Kirsehir',
			388	=> 'Nigde',
			412	=> 'Diyarbakir',
			414	=> 'Sanliurfa',
			416	=> 'Adiyaman',
			422	=> 'Malatya',
			424	=> 'Elazig',
			426	=> 'Bingol',
			428	=> 'Tunceli',
			432	=> 'Van',
			434	=> 'Bitus',
			436	=> 'Mus',
			438	=> 'Hakkari',
			442	=> 'Erzurum',
			446	=> 'Erzincan',
			452	=> 'Ordu',
			454	=> 'Giresun',
			456	=> 'Gumushane',
			458	=> 'Bayburt',
			462	=> 'Trabzon',
			464	=> 'Rize',
			466	=> 'Artvin',
			472	=> 'Agri',
			474	=> 'Kars',
			476	=> 'Igdir',
			478	=> 'Ardahan',
			482	=> 'Mardin',
			484	=> 'Siirt',
			486	=> 'Sirnak',
			488	=> 'Batman',
		},
		country_name => 'Turkey',
		dialing_code => '90',
		globe_area => 'Europe',
	},
	TW => {
		area_codes => {
			2	=> 'Taipei',
			3	=> 'Taoyuan',
			4	=> 'Taichung',
			5	=> 'Chiayi',
			6	=> 'Tainan',
			7	=> 'Kaohsiung',
			8	=> 'Pingtung',
			38	=> 'Hualian',
			89	=> 'Taitung',
		},
		country_name => 'Taiwan',
		dialing_code => '886',
		globe_area => 'Asia',
	},
	UA => {
		area_codes => {
			31	=> 'Uzhgorod',
			34	=> 'Ivano Frankivsk',
			36	=> 'Rivne',
			38	=> 'Khmelnitskiy',
			44	=> 'Kiev',
			46	=> 'Chernigov',
			47	=> 'Cherkassy',
			51	=> 'Nikolaev',
			52	=> 'Kirovograd',
			53	=> 'Poltava',
			54	=> 'Sumy',
			55	=> 'Kherson',
			56	=> 'Dniprodzerzhynsk',
			61	=> 'Zaporozhye',
			62	=> 'Donetsk',
			69	=> 'Sevastopol',
			322	=> 'Lviv',
			432	=> 'Vinnitsa',
			562	=> 'Dnepropetrovsk',
			564	=> 'Kryvyi Rih',
			572	=> 'Kharkov',
			642	=> 'Lugansk',
			652	=> 'Simferopol',
			3522	=> 'Ternopil',
			3722	=> 'Chernivtsi',
			4744	=> 'Uman',
		},
		country_name => 'Ukraine',
		dialing_code => '380',
		globe_area => 'Europe',
	},
	US => {
		area_codes => {
			0	=> 'Fremont, Nebraska',
			201	=> 'West New York, New Jersey',
			202	=> 'Washington, District of Columbia',
			203	=> 'Waterbury, Connecticut',
			204	=> 'Brandon, Mississippi',
			205	=> 'Tuscaloosa, Alabama',
			207	=> 'Waterville, Maine',
			208	=> 'Pocatello, Idaho',
			209	=> 'Volcano, Hawaii',
			210	=> 'San Antonio, Texas',
			213	=> 'Los Angeles, California',
			214	=> 'Mesquite, Nevada',
			216	=> 'Cleveland, Tennessee',
			217	=> 'Urbana, Illinois',
			218	=> 'Moorhead, Minnesota',
			219	=> 'Valparaiso, Indiana',
			224	=> 'Palatine, Illinois',
			225	=> 'Baton Rouge, Louisiana',
			228	=> 'Pascagoula, Mississippi',
			229	=> 'Pelham, Alabama',
			239	=> 'Naples, Florida',
			240	=> 'Gaithersburg, Maryland',
			250	=> 'Victoria, Texas',
			252	=> 'Rocky Mount, North Carolina',
			254	=> 'Waco, Texas',
			256	=> 'Huntsville, Alabama',
			260	=> 'Fort Wayne, Indiana',
			262	=> 'West Bend, Wisconsin',
			267	=> 'Philadelphia, Pennsylvania',
			269	=> 'Battle Creek, Michigan',
			270	=> 'Paducah, Kentucky',
			276	=> 'Roanoke, Virginia',
			281	=> 'Pasadena, Texas',
			301	=> 'Silver Spring, Maryland',
			302	=> 'Dover, New Hampshire',
			303	=> 'Shawnee, Kansas',
			304	=> 'Parkersburg, West Virginia',
			305	=> 'Miami, Florida',
			307	=> 'Sheridan, Wyoming',
			308	=> 'Kearney, Nebraska',
			309	=> 'Peoria, Arizona',
			310	=> 'Torrance, California',
			312	=> 'Chicago, Illinois',
			313	=> 'Redford, Michigan',
			314	=> 'Florissant, Missouri',
			315	=> 'Syracuse, Utah',
			316	=> 'Wichita, Kansas',
			317	=> 'Plainfield, Indiana',
			318	=> 'Shreveport, Louisiana',
			319	=> 'Cedar Rapids, Iowa',
			321	=> 'Sanford, Maine',
			323	=> 'Hollywood, Florida',
			325	=> 'San Angelo, Texas',
			330	=> 'Youngstown, Ohio',
			331	=> 'Oswego, Illinois',
			334	=> 'Dothan, West Virginia',
			336	=> 'Thomasville, North Carolina',
			337	=> 'Sulphur, Louisiana',
			352	=> 'Spring Hill, Tennessee',
			361	=> 'Corpus Christi, Texas',
			385	=> 'West Jordan, Utah',
			386	=> 'Palm Coast, Florida',
			401	=> 'Woonsocket, Rhode Island',
			402	=> 'Omaha, Nebraska',
			404	=> 'Forest Park, Georgia',
			405	=> 'Yukon, Oklahoma',
			406	=> 'Missoula, Montana',
			407	=> 'Orlando, Florida',
			408	=> 'Sunnyvale, California',
			409	=> 'Texas City, Texas',
			410	=> 'Towson, Maryland',
			412	=> 'Pittsburgh, Pennsylvania',
			413	=> 'Westfield, Massachusetts',
			414	=> 'Wauwatosa, Wisconsin',
			415	=> 'San Rafael, California',
			417	=> 'Springfield, Tennessee',
			419	=> 'Toledo, Ohio',
			423	=> 'Morristown, Tennessee',
			424	=> 'Redondo Beach, California',
			425	=> 'Redmond, Oregon',
			430	=> 'Texarkana, Texas',
			432	=> 'Midland, Michigan',
			434	=> 'Lynchburg, Virginia',
			435	=> 'Tooele, Utah',
			440	=> 'Strongsville, Ohio',
			442	=> 'Vista, California',
			443	=> 'Severna Park, Maryland',
			447	=> 'Champaign, Illinois',
			475	=> 'Westport, Connecticut',
			478	=> 'Jeffersonville, Indiana',
			479	=> 'Van Buren, Arkansas',
			480	=> 'Tempe, Arizona',
			484	=> 'Easton, Pennsylvania',
			501	=> 'Sherwood, Arkansas',
			502	=> 'Louisville, Kentucky',
			503	=> 'Salem, Oregon',
			504	=> 'New Orleans, Louisiana',
			505	=> 'Santa Fe, New Mexico',
			507	=> 'Winona, Minnesota',
			508	=> 'Worcester, Massachusetts',
			510	=> 'Union City, Georgia',
			512	=> 'Austin, Minnesota',
			513	=> 'Middletown, Ohio',
			515	=> 'Garden City, Kansas',
			517	=> 'Reading, Michigan',
			518	=> 'Albany, Oregon',
			519	=> 'Waterloo, Iowa',
			520	=> 'Tucson, Arizona',
			530	=> 'Redding, California',
			540	=> 'Staunton, Virginia',
			541	=> 'Pendleton, Oregon',
			551	=> 'Union City, New Jersey',
			559	=> 'Visalia, California',
			561	=> 'West Palm Beach, Florida',
			562	=> 'Long Beach, Mississippi',
			563	=> 'Muscatine, Iowa',
			567	=> 'Mansfield, Ohio',
			573	=> 'Sikeston, Missouri',
			574	=> 'South Bend, Indiana',
			575	=> 'Roswell, New Mexico',
			580	=> 'Lawton, Oklahoma',
			585	=> 'Rochester, New Hampshire',
			586	=> 'Warren, Ohio',
			601	=> 'Natchez, Mississippi',
			602	=> 'Phoenix, Arizona',
			603	=> 'Nashua, New Hampshire',
			604	=> 'Richmond, Kentucky',
			605	=> 'Sioux Falls, South Dakota',
			606	=> 'Ashland, Kentucky',
			608	=> 'Madison, Alabama',
			609	=> 'Vineland, New Jersey',
			610	=> 'West Chester, Pennsylvania',
			612	=> 'Minneapolis, Minnesota',
			613	=> 'Belleville, New Jersey',
			614	=> 'Columbus, Nebraska',
			615	=> 'Smyrna, Tennessee',
			616	=> 'Holland, Michigan',
			617	=> 'Weymouth, Massachusetts',
			619	=> 'San Diego, California',
			620	=> 'Moscow, Idaho',
			626	=> 'West Covina, California',
			630	=> 'Wheeling, West Virginia',
			636	=> 'Wentzville, Missouri',
			641	=> 'Mason City, Iowa',
			650	=> 'Mountain View, Hawaii',
			651	=> 'Stillwater, Minnesota',
			657	=> 'Yorba Linda, California',
			660	=> 'Kansas City, Kansas',
			661	=> 'Lancaster, Pennsylvania',
			662	=> 'Tupelo, Mississippi',
			681	=> 'Morgantown, West Virginia',
			682	=> 'Fort Worth, Texas',
			701	=> 'West Fargo, North Dakota',
			702	=> 'North Las Vegas, Nevada',
			703	=> 'Alexandria, Louisiana',
			704	=> 'Statesville, North Carolina',
			707	=> 'Vallejo, California',
			708	=> 'Tinley Park, Illinois',
			712	=> 'Sioux City, Iowa',
			713	=> 'Sugar Land, Texas',
			714	=> 'Orange, New Jersey',
			715	=> 'Eau Claire, Wisconsin',
			717	=> 'Harrisburg, Pennsylvania',
			719	=> 'Pueblo, Colorado',
			720	=> 'Westminster, Colorado',
			724	=> 'Sharon, Pennsylvania',
			727	=> 'Palm Harbor, Florida',
			730	=> 'Alton, Illinois',
			731	=> 'Dyersburg, Tennessee',
			734	=> 'Wyandotte, Michigan',
			740	=> 'Marion, Ohio',
			752	=> 'Pomona, California',
			754	=> 'Fort Lauderdale, Florida',
			757	=> 'Portsmouth, New Hampshire',
			760	=> 'Victorville, California',
			762	=> 'Dalton, Georgia',
			763	=> 'Saint Michael, Minnesota',
			765	=> 'Marion, Iowa',
			769	=> 'Vicksburg, Mississippi',
			770	=> 'Roswell, Georgia',
			774	=> 'Franklin, Massachusetts',
			775	=> 'Sparks, Nevada',
			781	=> 'Woburn, Massachusetts',
			785	=> 'Topeka, Kansas',
			786	=> 'Miami Beach, Florida',
			787	=> 'San Juan, Puerto Rico',
			801	=> 'Springville, Utah',
			802	=> 'Rutland, Vermont',
			803	=> 'Sumter, South Carolina',
			804	=> 'Petersburg, Virginia',
			805	=> 'Thousand Oaks, California',
			806	=> 'Lubbock, Texas',
			808	=> 'Waimea, Hawaii',
			810	=> 'Southfield, Michigan',
			812	=> 'Terre Haute, Indiana',
			813	=> 'Tampa, Florida',
			814	=> 'Erie, Colorado',
			815	=> 'Union, New Jersey',
			816	=> 'Independence, Kentucky',
			817	=> 'Arlington, Virginia',
			818	=> 'Glendale, Arizona',
			828	=> 'Hickory, North Carolina',
			830	=> 'New Braunfels, Texas',
			831	=> 'Watsonville, California',
			832	=> 'The Woodlands, Texas',
			835	=> 'Bethlehem, Pennsylvania',
			843	=> 'Charleston, West Virginia',
			847	=> 'Wheeling, Illinois',
			848	=> 'Edison, New Jersey',
			850	=> 'Tallahassee, Florida',
			857	=> 'Winthrop, Massachusetts',
			859	=> 'Winchester, Kentucky',
			860	=> 'West Hartford, Connecticut',
			862	=> 'Wayne, New Jersey',
			863	=> 'Lakeland, Florida',
			864	=> 'Spartanburg, South Carolina',
			865	=> 'Sevierville, Tennessee',
			867	=> 'Fort Smith, Arkansas',
			870	=> 'West Memphis, Arkansas',
			878	=> 'New Castle, Pennsylvania',
			901	=> 'Memphis, Tennessee',
			903	=> 'Tyler, Texas',
			904	=> 'Jacksonville, Arkansas',
			905	=> 'Burlington, Vermont',
			906	=> 'Wakefield, Michigan',
			907	=> 'Sitka, Alaska',
			908	=> 'Toms River, New Jersey',
			909	=> 'Upland, California',
			910	=> 'Wilmington, North Carolina',
			912	=> 'Statesboro, Georgia',
			913	=> 'Overland Park, Kansas',
			915	=> 'El Paso, Texas',
			916	=> 'Sacramento, California',
			918	=> 'Tulsa, Oklahoma',
			919	=> 'Wilson, North Carolina',
			920	=> 'Sheboygan, Wisconsin',
			925	=> 'Walnut Creek, California',
			928	=> 'Yuma, Arizona',
			931	=> 'Tullahoma, Tennessee',
			936	=> 'Nacogdoches, Texas',
			937	=> 'Dayton, Ohio',
			939	=> 'Ponce, Puerto Rico',
			940	=> 'Wichita Falls, Texas',
			941	=> 'Sarasota, Florida',
			947	=> 'Waterford, Michigan',
			949	=> 'San Clemente, California',
			951	=> 'Riverside, California',
			952	=> 'Shakopee, Minnesota',
			954	=> 'Pompano Beach, Florida',
			956	=> 'Weslaco, Texas',
			970	=> 'Montrose, Colorado',
			971	=> 'Woodburn, Oregon',
			972	=> 'Wylie, Texas',
			973	=> 'Newark, Ohio',
			978	=> 'Peabody, Massachusetts',
			979	=> 'College Station, Texas',
			980	=> 'Shelby, North Carolina',
			985	=> 'Slidell, Louisiana',
			989	=> 'Saginaw, Michigan',
		},
		country_name => 'United States',
		dialing_code => '1',
		globe_area => 'North America',
	},
	UY => {
		area_codes => {
			2	=> 'Montevideo',
			36	=> 'Durazno',
			42	=> 'Punta del Este',
			45	=> 'Treinta y Tres',
			62	=> 'Rivera',
			63	=> 'Tacuarembo',
			64	=> 'Melo',
			73	=> 'Salto',
			324	=> 'Las Piedras',
			664	=> 'Paso de los Toros',
			772	=> 'Artigas',
		},
		country_name => 'Uruguay',
		dialing_code => '598',
		globe_area => 'South America',
	},
	UZ => {
		area_codes => {
			65	=> 'Bukhara',
			66	=> 'Samarkand',
			71	=> 'Tashkent',
		},
		country_name => 'Uzbekistan',
		dialing_code => '998',
		globe_area => 'Asia',
	},
	VE => {
		area_codes => {
			212	=> 'Los Teques',
			241	=> 'Valencia',
			242	=> 'Puerto Cabello',
			243	=> 'Maracay',
			251	=> 'Barquisimeto',
			261	=> 'Maracaibo',
			264	=> 'Cabimas',
			268	=> 'Coro',
			274	=> 'Mrida',
			276	=> 'San Cristobal',
			281	=> 'Barcelona',
			285	=> 'Ciudad Guayana',
			291	=> 'Maturin',
			293	=> 'Cumana',
		},
		country_name => 'Venezuela',
		dialing_code => '58',
		globe_area => 'South America',
	},
	VN => {
		area_codes => {
			4	=> 'Hanoi City',
			8	=> 'Saigon',
			18	=> 'Hoa Binh',
			19	=> 'Ha Giang',
			20	=> 'Lao Cai',
			22	=> 'Son La',
			23	=> 'Lai Chau',
			25	=> 'Lang Son',
			26	=> 'Cao Bang',
			27	=> 'Tuyen Quang',
			29	=> 'Yen Bai',
			30	=> 'Ninh Binh',
			31	=> 'Haiphong',
			33	=> 'Quant Ninh',
			34	=> 'Ha Tay',
			36	=> 'Thai Binh',
			37	=> 'Thanh Hoa',
			38	=> 'Nghe An',
			39	=> 'Ha Tinh',
			50	=> 'Dak Lak',
			52	=> 'Quang Binh',
			53	=> 'Quang Tri',
			54	=> 'Thua Thien Hue',
			55	=> 'Quang Ngai',
			56	=> 'Qui Nhon',
			57	=> 'Phu Yen',
			58	=> 'Nha Trang',
			59	=> 'Gia Lai',
			60	=> 'Kon Tum',
			61	=> 'Dong Nai',
			62	=> 'Phan Thiet',
			63	=> 'Thuan Lam Dong',
			64	=> 'Vung Tu',
			66	=> 'Tay Ninh',
			67	=> 'Dong Thap',
			68	=> 'Nin Thuan',
			70	=> 'Vinh Long',
			71	=> 'Can Tho',
			72	=> 'Long An',
			73	=> 'Tien Giang',
			74	=> 'Tra Vinh',
			76	=> 'Long Xuyen',
			77	=> 'Kien Giang',
			78	=> 'Minh Hai',
			79	=> 'Soc Trang',
			210	=> 'Phu Tho',
			211	=> 'Vinh Phu',
			240	=> 'Bac Giang',
			241	=> 'Bac Ninh',
			280	=> 'Thai Nguyen',
			281	=> 'Bac Kan',
			320	=> 'Hai Duong',
			321	=> 'Hung Yen',
			350	=> 'Nam Dinh',
			351	=> 'Ha Nam',
			510	=> 'Quang Nam',
			651	=> 'Binh Phuoc',
			780	=> 'Ca Mau',
			781	=> 'Bac Lieu',
		},
		country_name => 'Vietnam',
		dialing_code => '84',
		globe_area => 'Asia',
	},
	YE => {
		area_codes => {
			1	=> 'San`a',
			2	=> 'Aden',
			4	=> 'Ta izz',
		},
		country_name => 'Yemen',
		dialing_code => '967',
		globe_area => 'Asia',
	},
	ZA => {
		area_codes => {
			11	=> 'Vereeniging',
			12	=> 'Pretoria',
			21	=> 'Cape Town',
			31	=> 'Durban',
			41	=> 'Uitenhage',
			51	=> 'Bloemfontein',
			57	=> 'Welkom',
			431	=> 'East London',
			712	=> 'George',
			835	=> 'Bethlehem',
		},
		country_name => 'South Africa',
		dialing_code => '27',
		globe_area => 'Africa',
	},
};

for my $i (keys %$country_codes) {
	# Ensure case compatibility - not a big deal on memory usage, we deal with references, not copies.
	$country_codes->{lc $i} = $country_codes->{$i};
	$country_codes->{uc $i} = $country_codes->{$i};
}

1;
