package Twilio::AvailablePhoneNumbers;
use Perlmazing;
use parent 'Twilio::Collection';

sub subresource_name {
	'countries';
}

sub subresource_module {
	'Twilio::AvailablePhoneNumbers::Country';
}

sub default_filter {
	'country_code';
}

sub list {
	my $self = shift;
	if (@_) {
		unshift @_, $self;
		goto &Countries;
	} else {
		$self->use_instead('Countries');
	}
}

sub Countries {
	my $wantarray = wantarray;
	my $self = shift;
	my $code = shift;
	my @call = caller(0);
	if ($code) {
		$self->die("Countries method expects a valid two-characters country code as argument - ") unless $code =~ /\w{2}/i;
		$code = uc $code;
	} elsif (defined $wantarray and not $wantarray) {
		$self->die("Countries method in scalar context (or chained method call) must receive a valid two-characters country code as argument - ");
	} elsif (not $wantarray) {
		warn "Useless call to Countries method in void context at $call[1] line $call[2]\n";
		return;
	}
	my $url = $self->account_url;
	my $r;
	if ($code) {
		return Twilio::AvailablePhoneNumbers::Country->new (
			Twilio			=> $self->Twilio,
			country_code	=> $code,
		);
	} else {
		$r = $self->Twilio->get("$url/AvailablePhoneNumbers.json", {PageSize => 1000});
		my @countries = @{$r->{countries}};
		while ($r->{next_page_uri}) {
			$r = $self->Twilio->get($self->get_root_url.$r->{next_page_uri}, {PageSize => 1000});
			push @countries, @{$r->{countries}};
		}
		for my $i (@countries) {
			push @{$self->{countries}}, Twilio::AvailablePhoneNumbers::Country->new (
				Twilio		=> $self->Twilio,
				%$i,
			);
		}
		return @{$self->{countries}};
	}
}

1;