package Twilio::Twiml::Command;
use Perlmazing;
use Twilio::Functions;
use overload (
	fallback	=> 1,
	'""'		=> 'SCALAR',
);

sub SCALAR {
	my $self = shift;
	my $caller = caller;
	return $self if $caller eq __PACKAGE__;
	$self->to_string;
}

sub new {
	my $class = shift;
	my $self = {@_};
	bless $self, $class;
}

sub to_string {
	my $self = shift;
	my $string = "<$self->{command} ";
	for my $i (sort keys %{$self->{params}}) {
		my $key = escape_html lcfirst modern_to_camel $i;
		my $val = escape_html $self->{params}->{$i};
		$val = '' unless defined $val;
		for my $x ($key, $val) {
			$x =~ s/"/\\"/;
		}
		$key = qq["$key"] if $key =~ /\W/;
		next unless not_empty $key;
		$string .= qq[$key="$val" ];
	}
	chop $string;
	if ($self->{content}) {
		my @content;
		if (isa_array $self->{content}) {
			@content = @{$self->{content}};
		} else {
			push @content, $self->{content};
		}
		$string .= ">\n";
		for my $i (@content) {
			my $str;
			my $is_command = (is_blessed($i) and $i->isa(__PACKAGE__));
			if ($is_command) {
				$str = $i->to_string;
			} else {
				$str = escape_html trim join "\n", trim split /\n/, $i;
			}
			my @lines = split /\n/, $str;
			if (@lines == 1 and not $is_command) {
				chop $string;
				$string .= $lines[0];
			} else {
				for my $line (@lines) {
					$string .= ($self->{Twiml}->{indentation} or '').$line."\n";
				}
			}
		}
		$string .= "</$self->{command}>\n";
	} else {
		$string .= "/>\n";
	}
	$string = qq[<?xml version="1.0" encoding="UTF-8"?>\n$string] if $self->{command} eq 'Response';
	$string;
}

1;
