package main;

use strict;
use warnings;

use Test::More 0.40;

plan( tests => 24 );

require_ok( 'Astro::SpaceTrack' )
    or BAIL_OUT( "Can't load Astro::SpaceTrack. Unable to test further." );

i_can( 'new' );
i_can( 'amsat' );
i_can( 'attribute_names' );
i_can( 'banner' );
i_can( 'celestrak' );
i_can( 'content_source' );
i_can( 'content_type' );
i_can( 'file' );
i_can( 'get' );
i_can( 'help' );
i_can( 'iridium_status' );
i_can( 'login' );
i_can( 'names' );
i_can( 'retrieve' );
i_can( 'search_date' );
i_can( 'search_id' );
i_can( 'search_name' );
i_can( 'set' );
i_can( 'shell' );
i_can( 'source' );
i_can( 'spaceflight' );
i_can( 'spacetrack' );

is_deeply( scalar Astro::SpaceTrack->attribute_names(), [ qw{
    addendum
    banner
    cookie_expires
    debug_url
    direct
    domain_space_track
    dump_headers
    fallback
    filter
    iridium_status_format
    max_range
    password
    scheme_space_track
    session_cookie
    url_iridium_status_kelso
    url_iridium_status_mccants
    url_iridium_status_sladen
    username
    verbose
    webcmd
    with_name
    } ], 'Attribute list is correct' );


sub i_can {
    my ( $method ) = @_;
    @_ = ( Astro::SpaceTrack->can( $method ),
	"Astro::Spacetrack->can( '$method' )" );
    goto &ok;
}

1;

__END__

#! ex: set textwidth=72 :
