#!/usr/bin/perl -w

use Test::More tests => 3;
use Mac::Finder::DSStore::BuddyAllocator;
use IO::File;

#
# This is a simple test that reads in a file actually generated by
# the Finder and makes sure the metadata is as expected.
#

$fn = 't/store1';

$store = Mac::Finder::DSStore::BuddyAllocator->open(new IO::File $fn, '<');
ok($store->listBlocks(), 'Freelist is consistent');
is_deeply($store->{toc}, { 'DSDB' => 1 }, 'TOC is as expected');
is_deeply($store->{offsets}, [ 4107, 69, 1034 ], 'Block offsets as expected');
$store->close;


