#!perl

# t/manifest-write.t #

#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Plugin-Manifest-Write.
#
#   perl-Dist-Zilla-Plugin-Manifest-Write is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by the Free Software
#   Foundation, either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Plugin-Manifest-Write is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
#   PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Plugin-Manifest-Write. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

use strict;
use warnings;
use lib 't';

use Test::More;
use Test::Routine::Util;
use ManifestWriteTester;

plan tests => 6;

my $class = 'ManifestWriteTester';

#   No source providers are specified, files will be recognized as "3rd party". However, default
#   metainfo providers work: `MANIFEST` and `META.yml` should be recognized properly.
run_tests( 'No source providers', $class, {
    ini_body => [
        'GatherDir',
        [ 'Manifest::Write' ],
        'MetaYAML',
    ],
    manifest => [
        'MANIFEST     #  metainfo file generated by Manifest::Write',
        'META.yml     #  metainfo file generated by MetaYAML',
        'dist.ini     # 3rd party file added by GatherDir',
        'lib/Dummy.pm # 3rd party file added by GatherDir',
        # There is no lines "Dummy file added by GatherDir"
    ],
} );

#   Source provider is specified, files will should be recognized as "Dummy" (it is name of
#   distibution).
run_tests( 'Source provider specified', $class, {
    ini_body => [
        'GatherDir',
        [ 'Manifest::Write', { source_providers => 'GatherDir' } ],
        #                                           ^^^^^^^^^
        'MetaYAML',
    ],
    manifest =>
    [
        'MANIFEST     #  metainfo file generated by Manifest::Write',
        'META.yml     #  metainfo file generated by MetaYAML',
        'dist.ini     #     Dummy file added by GatherDir',
        #                   ^^^^^               ^^^^^^^^^
        'lib/Dummy.pm #     Dummy file added by GatherDir',
        #                   ^^^^^               ^^^^^^^^^
    ],
} );

run_tests( 'Multiple source providers in the same line', $class, {
    ini_body => [
        'GatherDir',
        [ 'GenerateFile', { filename => 'README', content => 'Yep.', } ],
        [ 'Manifest::Write', { source_providers => 'GatherDir GenerateFile' } ],
        #                                           ^^^^^^^^^^^^^^^^^^^^^^
        'MetaYAML',
    ],
    manifest =>
    [
        'MANIFEST     #  metainfo file generated by Manifest::Write',
        'META.yml     #  metainfo file generated by MetaYAML',
        'README       #     Dummy file added by GenerateFile',
        #                   ^^^^^               ^^^^^^^^^^^^
        'dist.ini     #     Dummy file added by GatherDir',
        #                   ^^^^^               ^^^^^^^^^
        'lib/Dummy.pm #     Dummy file added by GatherDir',
        #                   ^^^^^               ^^^^^^^^^
    ],
} );

#   Specifying any metainfo provider kills all default metainfo providers.
run_tests( 'Explicit metainfo_providers kills default metaproviders', $class, {
    ini_body => [
        'GatherDir',
        [ 'Manifest::Write', { source_providers => 'GatherDir', metainfo_providers => '' } ],
        #                                                                             ^^
        'MetaYAML',
    ],
    manifest =>
    [
        'MANIFEST     # 3rd party file generated by Manifest::Write',
        #               ^^^^^^^^^^^^^^
        'META.yml     # 3rd party file generated by MetaYAML',
        #               ^^^^^^^^^^^^^^
        'dist.ini     #     Dummy file added by GatherDir',
        'lib/Dummy.pm #     Dummy file added by GatherDir',
    ],
} );

run_tests( 'Multiple source providers in different lines', $class, {
    ini_body => [
        'GatherDir',
        [ 'GenerateFile', { filename => 'README', content => 'Yep.', } ],
        [ 'Manifest::Write', { source_providers => [ 'GatherDir', 'GenerateFile' ] } ],
        #                                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
        'MetaYAML',
    ],
    manifest =>
    [
        'MANIFEST     #  metainfo file generated by Manifest::Write',
        'META.yml     #  metainfo file generated by MetaYAML',
        'README       #     Dummy file added by GenerateFile',
        #                   ^^^^^               ^^^^^^^^^^^^
        'dist.ini     #     Dummy file added by GatherDir',
        #                   ^^^^^               ^^^^^^^^^
        'lib/Dummy.pm #     Dummy file added by GatherDir',
        #                   ^^^^^               ^^^^^^^^^
    ],
} );

#   Adding `PkgVersion` — it modifies Perl module.
run_tests( 'Munger in action', $class, {
    ini_body => [
        'GatherDir',
        [ 'Manifest::Write', { source_providers => 'GatherDir' } ],
        'PkgVersion',
        #^^^^^^^^^^         # `PkgVersion` is a file munger.
        'MetaYAML',
    ],
    manifest =>
    [
        'MANIFEST     #  metainfo file generated by Manifest::Write',
        'META.yml     #  metainfo file generated by MetaYAML',
        'dist.ini     #     Dummy file added by GatherDir',
        'lib/Dummy.pm #     Dummy file added by GatherDir and modified by PkgVersion',
        #                                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^
    ],
} );

done_testing();

exit( 0 );

# end of file #
