# ex/Dist/Zilla/Plugin/Manifest/Write/FileSize.pm #
#
#   This file is part of perl-Dist-Zilla-Plugin-Manifest-Write.
#
#   This module is used as synopsis in `Dist/Zilla/Plugin/Manifest/Write.pm`. Heding and trailing
#   blocks of comments will be stripped. Having this module in a separate file allows us to test
#   it, see `xt/synopsis.t`.
#

package Dist::Zilla::Plugin::Manifest::Write::FileSize;

use Moose;
use namespace::autoclean;
use parent 'Dist::Zilla::Plugin::Manifest::Write';
our $VERSION = '0.007';

#   Overload any method or modify it with all the Moose power, e. g.:
around _comment => sub {
    my ( $orig, $self, $file ) = @_;
    my $comment = $self->$orig( $file );
    if ( $file->name ne $self->manifest ) {
        $comment .= sprintf( ' (%d bytes)', length( $file->encoded_content ) );
    };
    return $comment;
};

__PACKAGE__->meta->make_immutable;
1;

# end of file #
