# $Id$

# use 5.008;
use ExtUtils::MakeMaker;
use ExtUtils::PkgConfig;
use Getopt::Long;

# minimum required version of dependencies we need to build
our %build_reqs = (
	'rpm' => '4.9.0',
);
our %PREREQ_PM = (
        Carp => 0,
        'Digest::SHA1' => 0,
        DynaLoader => 0,
        Exporter => 0,
        'File::Temp' => 0,
        'MDV::Packdrakeng' => 0,
	'ExtUtils::Depends'   => '0.300',
	'ExtUtils::PkgConfig' => '1.00', # for finding rpm-devel
);

my $rpmv;
GetOptions(
    'rpmversion=s' => \$rpmv,
    'rebuildh' => \my $rebh,
);

# Writing a fake Makefile ensures that CPAN will pick up the correct
# dependencies and install them.
unless (eval "use ExtUtils::Depends '$PREREQ_PM{'ExtUtils::Depends'}';"
           . "use ExtUtils::PkgConfig '$PREREQ_PM{'ExtUtils::PkgConfig'}';"
           . "1") {
   warn "$@\n";
   WriteMakefile(
         NAME         => 'URPM',
         PREREQ_FATAL => 1,
         PREREQ_PM    => \%PREREQ_PM,
   );
   exit 1; # not reached
}

my %cfg;
unless (eval { %cfg = ExtUtils::PkgConfig->find("rpm >= $build_reqs{rpm}"); 1 })
{
	warn $@;
	exit 0;
}

my $rpmheaderlocation = '/usr/include';

foreach (qw(
    /usr/include
    /usr/local/include
    )) {
    if (-d "$_/rpm") {
        $rpmheaderlocation = "$_/rpm";
        last;
    }
}

$rpmheaderlocation or die "Can't find rpmheader location";

$rpmv ||= $cfg{modversion};
open(my $FH, "> src/rpmversion.h") or die "Can't open rpmversion.h";
print $FH "/* File generated by Mafile.PL\n";
print $FH ' * $Id$' . "\n";
print $FH " */\n\n";
print $FH "#ifndef RPMVERSION_H\n#define RPMVERSION_H\n\n";
foreach (qw(
    4.9.0
    4.9.1
    4.9.1.1
    4.9.1.2
    4.12.90
    )) {
    my $v = $_;
    $v =~ s/\./_/g;
    print $FH "#define RPM$v\n";
    $rpmv =~ /^\Q$_/ and last;
}
print $FH "\n#endif\n";
close($FH);
exit 0 if $rebh;

my @rpmconstantfiles = qw(
    rpmconstant.c
    rpmconstant.h
    rpmconstant_internal.c
    rpmh2tbl
    );

my ($obj, $ldd, $fl) =
    -f '/usr/include/rpmconstant/rpmconstant.h' ?
    ('', '-lrpmconstant', '-DHAVE_RPMCONSTANT') :
    ('src/rpmconstant.o src/rpmconstant_internal.o src/rpmconstanttbl.o', '', '');

sub MY::postamble() {
        my $first = <<RPMCONSTTBL;
src/rpmversion.h:
	\$(PERL) Makefile.PL --rebuildh

src/rpmconstanttbl.c: Makefile rpmh2tbl
	perl src/rpmh2tbl $rpmheaderlocation/*.h > \$@

RPMCONSTTBL
	# This code is to reduce duplication of files
	# in fact it is only usefull for the maintainers of this module
	# if you get the module from CPAN, those files are already here
	# if you're building from svn, you need rpmconstant directory
	my $second = "copyrpmconstant: " . join(" ", @rpmconstantfiles) . "\n\n";
	if (-d '../rpmconstant') {
            foreach (@rpmconstantfiles) {
                $second .= "$_: ../rpmconstant/$_\n\tcp -a \$< src/\$@\n\n";
            }
	}

	$first . $second;
}

sub MY::postamble() {
    <<MAKECHANGELOG;
.PHONY: ChangeLog copyrpmconstant

copyrpmconstant:
	make -C src copyrpmconstant

ChangeLog:
	LC_ALL=C svn update && LC_ALL=C svn log --verbose > \$@

rpm: dist
	rpm --rmsource --define "_sourcedir `pwd`" -ba perl-Hdlist.spec
MAKECHANGELOG
}

WriteMakefile(
    NAME	 => 'RPM4',
    VERSION_FROM => 'lib/RPM4.pm',
    'EXE_FILES'  => [ qw(bin/rpm_produced bin/rpmresign bin/hrpmreb) ],
    depend => { dist => 'copyrpmconstant' },
    LICENSE      => 'gpl_2',
    META_MERGE => {
	'meta-spec' => { version => 2 },
	release_status => 'testing'
    },
    MIN_PERL_VERSION => '5.008001',
    CONFIGURE_REQUIRES => {
	'ExtUtils::MakeMaker' => '6.64',
	'ExtUtils::PkgConfig' => '0',
	'Getopt::Long' => '0',
    },
    PREREQ_PM    => \%PREREQ_PM,
    dist => { COMPRESS => "xz", SUFFIX => ".xz" },
    OBJECT       => "src/RPM4.o $obj",
    INC	         => "-I$rpmheaderlocation",
#    LIBS         => "-lrpmsign -lrpm -lrpmio -lrpmbuild -lpopt -lz -lbz2 $ldd",
    LIBS	=> [ $cfg{libs} . ' -lrpmbuild' ],
    'CCFLAGS'    => "-Wall $fl",
    depend       => { "src/RPM4.xs" => join(" ", map { "src/$_" } @rpmconstantfiles) },
);
