# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package JobAd::GEN::Position;

use strict;
use warnings;

use base 'JobAd';
use JSON;
use Gantry::Utils::TablePerms;

use JobAd::Model::position qw(
    $POSITION
);
use Gantry::Plugins::Calendar qw(
    do_calendar_month
    calendar_month_js
);



#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Position' );

    my $real_location = $self->location() || '';
    if ( $real_location ) {
        $real_location =~ s{/+$}{};
        $real_location .= '/';
    }

    my @header_options = (
        {
            text => 'Add',
            link => $real_location . "add",
            type => 'create',
        },
    );

    my $retval = {
        headings       => [
            'N Openings',
            'Location',
        ],
    };

    my %param = $self->get_param_hash;

    my $search = {};
    if ( $param{ search } ) {
        my $form = $self->form();

        my @searches;
        foreach my $field ( @{ $form->{ fields } } ) {
            if ( $field->{ searchable } ) {
                push( @searches,
                    ( $field->{ name } => { 'like', "%$param{ search }%"  } )
                );
            }
        }

        $search = {
            -or => \@searches
        } if scalar( @searches ) > 0;
    }

    my @row_options = (
        {
            text => 'Edit',
            type => 'update',
        },
        {
            text => 'Delete',
            type => 'delete',
        },
    );

    my $perm_obj = Gantry::Utils::TablePerms->new(
        {
            site           => $self,
            real_location  => $real_location,
            header_options => \@header_options,
            row_options    => \@row_options,
        }
    );

    $retval->{ header_options } = $perm_obj->real_header_options;

    my $limit_to_user_id = $perm_obj->limit_to_user_id;
    $search->{ user_id } = $limit_to_user_id if ( $limit_to_user_id );

    my $schema = $self->get_schema();
    my @rows   = $POSITION->get_listing(
        {
            schema   => $schema,
            where    => $search,
        }
    );

    ROW:
    foreach my $row ( @rows ) {
        last ROW if $perm_obj->hide_all_data;

        my $id = $row->id;

        push(
            @{ $retval->{rows} }, {
                orm_row => $row,
                data => [
                    $row->n_openings,
                    $row->location,
                ],
                options => $perm_obj->real_row_options( $row ),
            }
        );
    }

    if ( $param{ json } ) {
        $self->template_disable( 1 );

        my $obj = {
            headings        => $retval->{ headings },
            header_options  => $retval->{ header_options },
            rows            => $retval->{ rows },
        };

        my $json = objToJson( $obj, { skipinvalid => 1 } );
        return( $json );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
sub form {
    my ( $self, $row ) = @_;

    my $selections = $POSITION->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        name       => 'position',
        row        => $row,
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        javascript => $self->calendar_month_js( 'position' ),
        fields     => [
            {
                name => 'n_openings',
                constraint => qr{^\d $},
                label => 'N Openings',
                type => 'text',
                is => 'int4',
            },
            {
                name => 'location',
                label => 'Location',
                type => 'text',
                is => 'varchar',
            },
            {
                options => $selections->{job},
                name => 'job',
                label => 'Job',
                type => 'select',
                is => 'int4',
            },
            {
                date_select_text => 'Select Date',
                name => 'closes',
                label => 'Closes',
                type => 'text',
                is => 'date',
            },
            {
                name => 'boss',
                label => 'Boss',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'pay',
                label => 'Pay',
                type => 'text',
                is => 'varchar',
            },
        ],
    };
} # END form

1;

=head1 NAME

JobAd::GEN::Position - generated support module for JobAd::Position

=head1 SYNOPSIS

In JobAd::Position:

    use base 'JobAd::GEN::Position';

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in JobAd::Position to provide the methods below.
Feel free to override them.

=head1 METHODS

=over 4

=item do_main

=item form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

