package Gantry::Docs::TOC;

=head1 NAME

Gantry::Docs::TOC - Table of Contents for Gantry::Docs::* documentation modules

=head1 What should I read?

This document is a brief annotated list of each Gantry::Docs::* module.

=over 4

=item About.pm

Describes the history, features, and motivation behind Gantry.

=item DBConn.pm

Explains how database connection information flows from app configuration
to DBI.  The process should be seamless for app developers, but if you
need to work on the engines or add support for in ORMs, you may find
useful information here.

=item FAQ.pm

A list of questions we think people are likely to ask along with answers.
This is not a philosphical document, it is filled with code examples.

=item QuickStart.pm

If you are new Gantry and want to get your first app running with a minimum
of fuss, this is for you.

=item TOC.pm

This document.

=item Tutorial.pm

More detailed than the Quick Start, this document walks through building
a simple application with Gantry.

=item Why.pm

Explains you should use a framework at all, whether it is Gantry or
one of the many others.

=back
