require 5.005;
use ExtUtils::MakeMaker;
use File::Spec;
use strict;

sub MY::metafile {
  package MY;
  my $self = shift;
  if (!eval { require YAML; 1 })
  {
    warn ("YAML not installed, 'make dist' will not override 'META.yml'.");
    return $self->SUPER::metafile_target(@_);
  };

  require YAML::Node;
  my $node = YAML::Node->new({});

  $node->{name}                 = $self->{DISTNAME};
  $node->{version}              = $self->{VERSION};
  $node->{version_from}         = $self->{VERSION_FROM};
  $node->{license}              = 'perl';
  $node->{distribution_type}    = 'module';
  $node->{generated_by}         = "$self->{DISTNAME} version $self->{VERSION}";
  $node->{installdirs}          = 'site';
  $node->{requires}             = $self->{PREREQ_PM};

  my $dump = YAML::Dump( $node );

  $dump =~ s/^(.*)$/\t\$(NOECHO) \$(ECHO) "$1" >>META.yml/gm;
  $dump =~ s/>>META\.yml/>META.yml/;

  "metafile:\n$dump";
}

my $tmpl = File::Spec->catfile("Info.pm.tmpl");
my $info_pm = File::Spec->catfile("lib", "Image", "Info.pm");
my $idir = File::Spec->catdir("lib", "Image", "Info");
opendir(DIR, $idir) || die "Can't opendir $idir: $!";
my (@code,@desc, $desc);
for my $file (sort readdir(DIR)) {
    next unless $file =~ /^([a-zA-Z]\w*)\.pm$/;
    my $format = $1;

    open(F, File::Spec->catfile($idir, $file)) || die "Can't open '$idir/$file': $!";
    my @magic;
    my @desc;
    while (<F>) {
	if (/^=begin\s+register\b/ ... /^=end\s+register\b/) {
	    next if /^=(begin|end)/;
	    if (/^MAGIC:\s+(.*)/) {
		push(@magic, $1);
		next;
	    }
	    push(@desc, $_);
	}
    }
    die "Missing magic for $format" unless @magic;
    for (@magic) {
	if (m:^/:) {
	    push(@code, qq(return "$format" if $_;));
	}
	else {
	    push(@code, qq(return "$format" if \$_ eq $_;));
	}
    }

    # trim
    shift(@desc) while @desc && $desc[0]  =~ /^\s*$/;
    pop(@desc)   while @desc && $desc[-1] =~ /^\s*$/;

    $desc .= "\n=item $format\n" unless @desc && $desc[0] =~ /^=item/;
    $desc .= "\n" . join("", @desc);

}
closedir(DIR);

my $code = "sub determine_file_format
{
   local(\$_) = \@_;
   " . join("\n   ", @code) . "
   return undef;
}
";

# Copy template to top level module with substitutions
open(TMPL, $tmpl) || die "Can't open $tmpl: $!";
open(INFO, ">$info_pm") || die "Can't create $info_pm: $!";
print INFO <<"EOT";
# This file is autogenerated from $tmpl.
# Please do not edit!!

EOT

while (<TMPL>) {
    if (/^%%DETERMINE_FILE_FORMAT%%/) {
        $_ = $code;
    }
    elsif (/^%%FORMAT_DESC%%/) {
       $_ = $desc;
    }
    print INFO $_;
}
close(INFO);
close(TMPL);

WriteMakefile(
    NAME         => 'Image::Info',
    AUTHOR       => 'Gisle Aas <gisle@ActiveState.com',
    VERSION_FROM => $info_pm,
    PREREQ_PM	=>
	{
		($] < 5.008 ? ('IO::String' => 1.03) : ()),
		'Test::Simple' => 0,
	},
    ABSTRACT_FROM	=> 'lib/Image/Info.pm',
    AUTHOR		=> 'Gisle Aas <gisle@ActiveState.com',
    PREREQ_FATAL	=> 1,  # can't work w/o proper prereqs
    clean        => { FILES => $info_pm },
    dist         => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
);

