#!perl

use strict;
use warnings;

use Moo;
use Test::More tests => 10;
use Test::NoWarnings;
use Test::Differences;

extends qw(
    Locale::Utils::Autotranslator
);

sub translate_text {
    my ($self, $msgid) = @_;

    return "<$msgid>";
}

PARAGRAPHS: {
    my $auto_translator = __PACKAGE__
        ->new(
            language  => 'de',
            bytes_max => 2 * 10 + 2,
        );
    my $msgstr = $auto_translator->translate_any_msgid(<<'EOT');
1234567890
1234567890

1234567890
1234567890
EOT
    eq_or_diff
        $msgstr,
        <<'EOT',
<1234567890
1234567890>

<1234567890
1234567890>
EOT
        'msgstr';
    is
        $auto_translator->translation_count,
        1,
        'translation count';
    is
        $auto_translator->item_translation_count,
        2,
        'item translation count';
}

LINES: {
    my $auto_translator = __PACKAGE__
        ->new(
            language  => 'de',
            bytes_max => 2 * 10,
        );
    my $msgstr = $auto_translator->translate_any_msgid(<<'EOT');
1234567890
1234567890

1234567890
1234567890
EOT
    eq_or_diff
        $msgstr,
        <<'EOT',
<1234567890>
<1234567890>

<1234567890>
<1234567890>
EOT
        'msgstr';
    is
        $auto_translator->translation_count,
        1,
        'translation count';
    is
        $auto_translator->item_translation_count,
        4,
        'item translation count';
}

PARAGRAPGS_AND_LINES: {
    my $auto_translator = __PACKAGE__
        ->new(
            language  => 'de',
            bytes_max => 2 * 10 + 2,
        );
    my $msgstr = $auto_translator->translate_any_msgid(<<'EOT');
1234567890
1234567890

1234567890
1234567890
1234567890
EOT
    eq_or_diff
        $msgstr,
        <<'EOT',
<1234567890
1234567890>

<1234567890>
<1234567890>
<1234567890>
EOT
        'msgstr';
    is
        $auto_translator->translation_count,
        1,
        'translation count';
    is
        $auto_translator->item_translation_count,
        4,
        'item translation count';
}
