use BSON::Document;
use Data::Dump;
use MongoDB::Client;
use MongoDB::Database;
use MongoDB::Collection;
use MongoDB::Cursor;

# Returns a connection to the Database
role Art::Behavior::Connectable {

    has Str $.client-uri;
    has Str $.database-name;
    has MongoDB::Client $.client;
    has MongoDB::Database $.database;

    # Forced behavior on object creation
    submethod TWEAK() {
        self.connect($!client-uri, $!database-name);
    }

    method connect (Str $client-uri, Str $database-name) {
        my MongoDB::Client $.client .= new(:uri($client-uri));
        my MongoDB::Database $.database = $.client.database($database-name);
    }
}
