package Date::Manip::TZ::amthul00;
# Copyright (c) 2008-2011 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Mon Jan 10 15:36:06 EST 2011
#    Data version: tzdata2010o
#    Code version: tzcode2010n

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::amthul00 - Support for the America/Thule time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.21';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,1,19,24,52],'-04:35:08',[-4,-35,-8],
          'LMT',0,[1916,7,28,4,35,7],[1916,7,27,23,59,59],
          '0001010200:00:00','0001010119:24:52','1916072804:35:07','1916072723:59:59' ],
     ],
   1916 =>
     [
        [ [1916,7,28,4,35,8],[1916,7,28,0,35,8],'-04:00:00',[-4,0,0],
          'AST',0,[1991,3,31,5,59,59],[1991,3,31,1,59,59],
          '1916072804:35:08','1916072800:35:08','1991033105:59:59','1991033101:59:59' ],
     ],
   1991 =>
     [
        [ [1991,3,31,6,0,0],[1991,3,31,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1991,9,29,4,59,59],[1991,9,29,1,59,59],
          '1991033106:00:00','1991033103:00:00','1991092904:59:59','1991092901:59:59' ],
        [ [1991,9,29,5,0,0],[1991,9,29,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1992,3,29,5,59,59],[1992,3,29,1,59,59],
          '1991092905:00:00','1991092901:00:00','1992032905:59:59','1992032901:59:59' ],
     ],
   1992 =>
     [
        [ [1992,3,29,6,0,0],[1992,3,29,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1992,9,27,4,59,59],[1992,9,27,1,59,59],
          '1992032906:00:00','1992032903:00:00','1992092704:59:59','1992092701:59:59' ],
        [ [1992,9,27,5,0,0],[1992,9,27,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1993,4,4,5,59,59],[1993,4,4,1,59,59],
          '1992092705:00:00','1992092701:00:00','1993040405:59:59','1993040401:59:59' ],
     ],
   1993 =>
     [
        [ [1993,4,4,6,0,0],[1993,4,4,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1993,10,31,4,59,59],[1993,10,31,1,59,59],
          '1993040406:00:00','1993040403:00:00','1993103104:59:59','1993103101:59:59' ],
        [ [1993,10,31,5,0,0],[1993,10,31,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1994,4,3,5,59,59],[1994,4,3,1,59,59],
          '1993103105:00:00','1993103101:00:00','1994040305:59:59','1994040301:59:59' ],
     ],
   1994 =>
     [
        [ [1994,4,3,6,0,0],[1994,4,3,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1994,10,30,4,59,59],[1994,10,30,1,59,59],
          '1994040306:00:00','1994040303:00:00','1994103004:59:59','1994103001:59:59' ],
        [ [1994,10,30,5,0,0],[1994,10,30,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1995,4,2,5,59,59],[1995,4,2,1,59,59],
          '1994103005:00:00','1994103001:00:00','1995040205:59:59','1995040201:59:59' ],
     ],
   1995 =>
     [
        [ [1995,4,2,6,0,0],[1995,4,2,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1995,10,29,4,59,59],[1995,10,29,1,59,59],
          '1995040206:00:00','1995040203:00:00','1995102904:59:59','1995102901:59:59' ],
        [ [1995,10,29,5,0,0],[1995,10,29,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1996,4,7,5,59,59],[1996,4,7,1,59,59],
          '1995102905:00:00','1995102901:00:00','1996040705:59:59','1996040701:59:59' ],
     ],
   1996 =>
     [
        [ [1996,4,7,6,0,0],[1996,4,7,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1996,10,27,4,59,59],[1996,10,27,1,59,59],
          '1996040706:00:00','1996040703:00:00','1996102704:59:59','1996102701:59:59' ],
        [ [1996,10,27,5,0,0],[1996,10,27,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1997,4,6,5,59,59],[1997,4,6,1,59,59],
          '1996102705:00:00','1996102701:00:00','1997040605:59:59','1997040601:59:59' ],
     ],
   1997 =>
     [
        [ [1997,4,6,6,0,0],[1997,4,6,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1997,10,26,4,59,59],[1997,10,26,1,59,59],
          '1997040606:00:00','1997040603:00:00','1997102604:59:59','1997102601:59:59' ],
        [ [1997,10,26,5,0,0],[1997,10,26,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1998,4,5,5,59,59],[1998,4,5,1,59,59],
          '1997102605:00:00','1997102601:00:00','1998040505:59:59','1998040501:59:59' ],
     ],
   1998 =>
     [
        [ [1998,4,5,6,0,0],[1998,4,5,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1998,10,25,4,59,59],[1998,10,25,1,59,59],
          '1998040506:00:00','1998040503:00:00','1998102504:59:59','1998102501:59:59' ],
        [ [1998,10,25,5,0,0],[1998,10,25,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1999,4,4,5,59,59],[1999,4,4,1,59,59],
          '1998102505:00:00','1998102501:00:00','1999040405:59:59','1999040401:59:59' ],
     ],
   1999 =>
     [
        [ [1999,4,4,6,0,0],[1999,4,4,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1999,10,31,4,59,59],[1999,10,31,1,59,59],
          '1999040406:00:00','1999040403:00:00','1999103104:59:59','1999103101:59:59' ],
        [ [1999,10,31,5,0,0],[1999,10,31,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2000,4,2,5,59,59],[2000,4,2,1,59,59],
          '1999103105:00:00','1999103101:00:00','2000040205:59:59','2000040201:59:59' ],
     ],
   2000 =>
     [
        [ [2000,4,2,6,0,0],[2000,4,2,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2000,10,29,4,59,59],[2000,10,29,1,59,59],
          '2000040206:00:00','2000040203:00:00','2000102904:59:59','2000102901:59:59' ],
        [ [2000,10,29,5,0,0],[2000,10,29,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2001,4,1,5,59,59],[2001,4,1,1,59,59],
          '2000102905:00:00','2000102901:00:00','2001040105:59:59','2001040101:59:59' ],
     ],
   2001 =>
     [
        [ [2001,4,1,6,0,0],[2001,4,1,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2001,10,28,4,59,59],[2001,10,28,1,59,59],
          '2001040106:00:00','2001040103:00:00','2001102804:59:59','2001102801:59:59' ],
        [ [2001,10,28,5,0,0],[2001,10,28,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2002,4,7,5,59,59],[2002,4,7,1,59,59],
          '2001102805:00:00','2001102801:00:00','2002040705:59:59','2002040701:59:59' ],
     ],
   2002 =>
     [
        [ [2002,4,7,6,0,0],[2002,4,7,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2002,10,27,4,59,59],[2002,10,27,1,59,59],
          '2002040706:00:00','2002040703:00:00','2002102704:59:59','2002102701:59:59' ],
        [ [2002,10,27,5,0,0],[2002,10,27,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2003,4,6,5,59,59],[2003,4,6,1,59,59],
          '2002102705:00:00','2002102701:00:00','2003040605:59:59','2003040601:59:59' ],
     ],
   2003 =>
     [
        [ [2003,4,6,6,0,0],[2003,4,6,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2003,10,26,4,59,59],[2003,10,26,1,59,59],
          '2003040606:00:00','2003040603:00:00','2003102604:59:59','2003102601:59:59' ],
        [ [2003,10,26,5,0,0],[2003,10,26,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2004,4,4,5,59,59],[2004,4,4,1,59,59],
          '2003102605:00:00','2003102601:00:00','2004040405:59:59','2004040401:59:59' ],
     ],
   2004 =>
     [
        [ [2004,4,4,6,0,0],[2004,4,4,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2004,10,31,4,59,59],[2004,10,31,1,59,59],
          '2004040406:00:00','2004040403:00:00','2004103104:59:59','2004103101:59:59' ],
        [ [2004,10,31,5,0,0],[2004,10,31,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2005,4,3,5,59,59],[2005,4,3,1,59,59],
          '2004103105:00:00','2004103101:00:00','2005040305:59:59','2005040301:59:59' ],
     ],
   2005 =>
     [
        [ [2005,4,3,6,0,0],[2005,4,3,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2005,10,30,4,59,59],[2005,10,30,1,59,59],
          '2005040306:00:00','2005040303:00:00','2005103004:59:59','2005103001:59:59' ],
        [ [2005,10,30,5,0,0],[2005,10,30,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2006,4,2,5,59,59],[2006,4,2,1,59,59],
          '2005103005:00:00','2005103001:00:00','2006040205:59:59','2006040201:59:59' ],
     ],
   2006 =>
     [
        [ [2006,4,2,6,0,0],[2006,4,2,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2006,10,29,4,59,59],[2006,10,29,1,59,59],
          '2006040206:00:00','2006040203:00:00','2006102904:59:59','2006102901:59:59' ],
        [ [2006,10,29,5,0,0],[2006,10,29,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2007,3,11,5,59,59],[2007,3,11,1,59,59],
          '2006102905:00:00','2006102901:00:00','2007031105:59:59','2007031101:59:59' ],
     ],
   2007 =>
     [
        [ [2007,3,11,6,0,0],[2007,3,11,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2007,11,4,4,59,59],[2007,11,4,1,59,59],
          '2007031106:00:00','2007031103:00:00','2007110404:59:59','2007110401:59:59' ],
        [ [2007,11,4,5,0,0],[2007,11,4,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2008,3,9,5,59,59],[2008,3,9,1,59,59],
          '2007110405:00:00','2007110401:00:00','2008030905:59:59','2008030901:59:59' ],
     ],
   2008 =>
     [
        [ [2008,3,9,6,0,0],[2008,3,9,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2008,11,2,4,59,59],[2008,11,2,1,59,59],
          '2008030906:00:00','2008030903:00:00','2008110204:59:59','2008110201:59:59' ],
        [ [2008,11,2,5,0,0],[2008,11,2,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2009,3,8,5,59,59],[2009,3,8,1,59,59],
          '2008110205:00:00','2008110201:00:00','2009030805:59:59','2009030801:59:59' ],
     ],
   2009 =>
     [
        [ [2009,3,8,6,0,0],[2009,3,8,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2009,11,1,4,59,59],[2009,11,1,1,59,59],
          '2009030806:00:00','2009030803:00:00','2009110104:59:59','2009110101:59:59' ],
        [ [2009,11,1,5,0,0],[2009,11,1,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2010,3,14,5,59,59],[2010,3,14,1,59,59],
          '2009110105:00:00','2009110101:00:00','2010031405:59:59','2010031401:59:59' ],
     ],
   2010 =>
     [
        [ [2010,3,14,6,0,0],[2010,3,14,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2010,11,7,4,59,59],[2010,11,7,1,59,59],
          '2010031406:00:00','2010031403:00:00','2010110704:59:59','2010110701:59:59' ],
        [ [2010,11,7,5,0,0],[2010,11,7,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2011,3,13,5,59,59],[2011,3,13,1,59,59],
          '2010110705:00:00','2010110701:00:00','2011031305:59:59','2011031301:59:59' ],
     ],
   2011 =>
     [
        [ [2011,3,13,6,0,0],[2011,3,13,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2011,11,6,4,59,59],[2011,11,6,1,59,59],
          '2011031306:00:00','2011031303:00:00','2011110604:59:59','2011110601:59:59' ],
        [ [2011,11,6,5,0,0],[2011,11,6,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2012,3,11,5,59,59],[2012,3,11,1,59,59],
          '2011110605:00:00','2011110601:00:00','2012031105:59:59','2012031101:59:59' ],
     ],
   2012 =>
     [
        [ [2012,3,11,6,0,0],[2012,3,11,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2012,11,4,4,59,59],[2012,11,4,1,59,59],
          '2012031106:00:00','2012031103:00:00','2012110404:59:59','2012110401:59:59' ],
        [ [2012,11,4,5,0,0],[2012,11,4,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2013,3,10,5,59,59],[2013,3,10,1,59,59],
          '2012110405:00:00','2012110401:00:00','2013031005:59:59','2013031001:59:59' ],
     ],
   2013 =>
     [
        [ [2013,3,10,6,0,0],[2013,3,10,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2013,11,3,4,59,59],[2013,11,3,1,59,59],
          '2013031006:00:00','2013031003:00:00','2013110304:59:59','2013110301:59:59' ],
        [ [2013,11,3,5,0,0],[2013,11,3,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2014,3,9,5,59,59],[2014,3,9,1,59,59],
          '2013110305:00:00','2013110301:00:00','2014030905:59:59','2014030901:59:59' ],
     ],
   2014 =>
     [
        [ [2014,3,9,6,0,0],[2014,3,9,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2014,11,2,4,59,59],[2014,11,2,1,59,59],
          '2014030906:00:00','2014030903:00:00','2014110204:59:59','2014110201:59:59' ],
        [ [2014,11,2,5,0,0],[2014,11,2,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2015,3,8,5,59,59],[2015,3,8,1,59,59],
          '2014110205:00:00','2014110201:00:00','2015030805:59:59','2015030801:59:59' ],
     ],
   2015 =>
     [
        [ [2015,3,8,6,0,0],[2015,3,8,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2015,11,1,4,59,59],[2015,11,1,1,59,59],
          '2015030806:00:00','2015030803:00:00','2015110104:59:59','2015110101:59:59' ],
        [ [2015,11,1,5,0,0],[2015,11,1,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2016,3,13,5,59,59],[2016,3,13,1,59,59],
          '2015110105:00:00','2015110101:00:00','2016031305:59:59','2016031301:59:59' ],
     ],
   2016 =>
     [
        [ [2016,3,13,6,0,0],[2016,3,13,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2016,11,6,4,59,59],[2016,11,6,1,59,59],
          '2016031306:00:00','2016031303:00:00','2016110604:59:59','2016110601:59:59' ],
        [ [2016,11,6,5,0,0],[2016,11,6,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2017,3,12,5,59,59],[2017,3,12,1,59,59],
          '2016110605:00:00','2016110601:00:00','2017031205:59:59','2017031201:59:59' ],
     ],
   2017 =>
     [
        [ [2017,3,12,6,0,0],[2017,3,12,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2017,11,5,4,59,59],[2017,11,5,1,59,59],
          '2017031206:00:00','2017031203:00:00','2017110504:59:59','2017110501:59:59' ],
        [ [2017,11,5,5,0,0],[2017,11,5,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2018,3,11,5,59,59],[2018,3,11,1,59,59],
          '2017110505:00:00','2017110501:00:00','2018031105:59:59','2018031101:59:59' ],
     ],
   2018 =>
     [
        [ [2018,3,11,6,0,0],[2018,3,11,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2018,11,4,4,59,59],[2018,11,4,1,59,59],
          '2018031106:00:00','2018031103:00:00','2018110404:59:59','2018110401:59:59' ],
        [ [2018,11,4,5,0,0],[2018,11,4,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2019,3,10,5,59,59],[2019,3,10,1,59,59],
          '2018110405:00:00','2018110401:00:00','2019031005:59:59','2019031001:59:59' ],
     ],
   2019 =>
     [
        [ [2019,3,10,6,0,0],[2019,3,10,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2019,11,3,4,59,59],[2019,11,3,1,59,59],
          '2019031006:00:00','2019031003:00:00','2019110304:59:59','2019110301:59:59' ],
        [ [2019,11,3,5,0,0],[2019,11,3,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2020,3,8,5,59,59],[2020,3,8,1,59,59],
          '2019110305:00:00','2019110301:00:00','2020030805:59:59','2020030801:59:59' ],
     ],
   2020 =>
     [
        [ [2020,3,8,6,0,0],[2020,3,8,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2020,11,1,4,59,59],[2020,11,1,1,59,59],
          '2020030806:00:00','2020030803:00:00','2020110104:59:59','2020110101:59:59' ],
        [ [2020,11,1,5,0,0],[2020,11,1,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2021,3,14,5,59,59],[2021,3,14,1,59,59],
          '2020110105:00:00','2020110101:00:00','2021031405:59:59','2021031401:59:59' ],
     ],
   2021 =>
     [
        [ [2021,3,14,6,0,0],[2021,3,14,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2021,11,7,4,59,59],[2021,11,7,1,59,59],
          '2021031406:00:00','2021031403:00:00','2021110704:59:59','2021110701:59:59' ],
        [ [2021,11,7,5,0,0],[2021,11,7,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2022,3,13,5,59,59],[2022,3,13,1,59,59],
          '2021110705:00:00','2021110701:00:00','2022031305:59:59','2022031301:59:59' ],
     ],
   2022 =>
     [
        [ [2022,3,13,6,0,0],[2022,3,13,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2022,11,6,4,59,59],[2022,11,6,1,59,59],
          '2022031306:00:00','2022031303:00:00','2022110604:59:59','2022110601:59:59' ],
        [ [2022,11,6,5,0,0],[2022,11,6,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2023,3,12,5,59,59],[2023,3,12,1,59,59],
          '2022110605:00:00','2022110601:00:00','2023031205:59:59','2023031201:59:59' ],
     ],
   2023 =>
     [
        [ [2023,3,12,6,0,0],[2023,3,12,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2023,11,5,4,59,59],[2023,11,5,1,59,59],
          '2023031206:00:00','2023031203:00:00','2023110504:59:59','2023110501:59:59' ],
        [ [2023,11,5,5,0,0],[2023,11,5,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2024,3,10,5,59,59],[2024,3,10,1,59,59],
          '2023110505:00:00','2023110501:00:00','2024031005:59:59','2024031001:59:59' ],
     ],
   2024 =>
     [
        [ [2024,3,10,6,0,0],[2024,3,10,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2024,11,3,4,59,59],[2024,11,3,1,59,59],
          '2024031006:00:00','2024031003:00:00','2024110304:59:59','2024110301:59:59' ],
        [ [2024,11,3,5,0,0],[2024,11,3,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2025,3,9,5,59,59],[2025,3,9,1,59,59],
          '2024110305:00:00','2024110301:00:00','2025030905:59:59','2025030901:59:59' ],
     ],
   2025 =>
     [
        [ [2025,3,9,6,0,0],[2025,3,9,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2025,11,2,4,59,59],[2025,11,2,1,59,59],
          '2025030906:00:00','2025030903:00:00','2025110204:59:59','2025110201:59:59' ],
        [ [2025,11,2,5,0,0],[2025,11,2,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2026,3,8,5,59,59],[2026,3,8,1,59,59],
          '2025110205:00:00','2025110201:00:00','2026030805:59:59','2026030801:59:59' ],
     ],
   2026 =>
     [
        [ [2026,3,8,6,0,0],[2026,3,8,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2026,11,1,4,59,59],[2026,11,1,1,59,59],
          '2026030806:00:00','2026030803:00:00','2026110104:59:59','2026110101:59:59' ],
        [ [2026,11,1,5,0,0],[2026,11,1,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2027,3,14,5,59,59],[2027,3,14,1,59,59],
          '2026110105:00:00','2026110101:00:00','2027031405:59:59','2027031401:59:59' ],
     ],
   2027 =>
     [
        [ [2027,3,14,6,0,0],[2027,3,14,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2027,11,7,4,59,59],[2027,11,7,1,59,59],
          '2027031406:00:00','2027031403:00:00','2027110704:59:59','2027110701:59:59' ],
        [ [2027,11,7,5,0,0],[2027,11,7,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2028,3,12,5,59,59],[2028,3,12,1,59,59],
          '2027110705:00:00','2027110701:00:00','2028031205:59:59','2028031201:59:59' ],
     ],
   2028 =>
     [
        [ [2028,3,12,6,0,0],[2028,3,12,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2028,11,5,4,59,59],[2028,11,5,1,59,59],
          '2028031206:00:00','2028031203:00:00','2028110504:59:59','2028110501:59:59' ],
        [ [2028,11,5,5,0,0],[2028,11,5,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2029,3,11,5,59,59],[2029,3,11,1,59,59],
          '2028110505:00:00','2028110501:00:00','2029031105:59:59','2029031101:59:59' ],
     ],
   2029 =>
     [
        [ [2029,3,11,6,0,0],[2029,3,11,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2029,11,4,4,59,59],[2029,11,4,1,59,59],
          '2029031106:00:00','2029031103:00:00','2029110404:59:59','2029110401:59:59' ],
        [ [2029,11,4,5,0,0],[2029,11,4,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2030,3,10,5,59,59],[2030,3,10,1,59,59],
          '2029110405:00:00','2029110401:00:00','2030031005:59:59','2030031001:59:59' ],
     ],
   2030 =>
     [
        [ [2030,3,10,6,0,0],[2030,3,10,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2030,11,3,4,59,59],[2030,11,3,1,59,59],
          '2030031006:00:00','2030031003:00:00','2030110304:59:59','2030110301:59:59' ],
        [ [2030,11,3,5,0,0],[2030,11,3,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2031,3,9,5,59,59],[2031,3,9,1,59,59],
          '2030110305:00:00','2030110301:00:00','2031030905:59:59','2031030901:59:59' ],
     ],
   2031 =>
     [
        [ [2031,3,9,6,0,0],[2031,3,9,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2031,11,2,4,59,59],[2031,11,2,1,59,59],
          '2031030906:00:00','2031030903:00:00','2031110204:59:59','2031110201:59:59' ],
        [ [2031,11,2,5,0,0],[2031,11,2,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[2032,3,14,5,59,59],[2032,3,14,1,59,59],
          '2031110205:00:00','2031110201:00:00','2032031405:59:59','2032031401:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '-03:00:00',
                'stdoff' => '-04:00:00',
               },
   'rules'  => {
                '03' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '8',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '1',
                         'abb'     => 'ADT',
                        },
                '11' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '0',
                         'abb'     => 'AST',
                        },
               },
);

1;
