#!/usr/bin/perl -w
# vim: syntax=perl
use strict;

# ------------------------------------------------------------------------------
# Library Test Harness
#
# CHANGES MADE HERE WILL BE OVERWRITTEN NEXT TIME `[#sys/proc/zname]` IS RUN!
# ------------------------------------------------------------------------------
# This script was generated by `[#sys/proc/zname]` on [#sys/proc/tstamp]
# ------------------------------------------------------------------------------

use Test::More tests => 124;

BEGIN {
  use_ok('Hub',':all')
};

our $result;

  ok(&t1, "");

  ok(&t2, "");

  ok(&t3, "");

  ok(&t4, "");

  ok(&t5, "");

  ok(&t6, "");

  ok(&t7, "");

  ok(&t8, "");

  ok(&t9, "");

  ok(&t10, "");

  ok(&t11, "");

  ok(&t12, "");

  ok(&t13, "");

  ok(&t14, "");

  ok(&t15, "");

  ok(&t16, "");

  ok(&t17, "");

  ok(&t18, "");

  ok(&t19, "Hash");

  ok(&t20, "Array");

  ok(&t21, "Scalar");

  ok(&t22, "Scalar (ref)");

  ok(&t23, "Nothing");

  ok(&t24, "Multiple values");

  ok(!&t25, "");

  ok(&t26, "none are defined");

  ok(&t27, "only one is defined");

  ok(&t28, "both are defined");

  ok(&t29, "one is defined");

  ok(&t30, "");

  ok(&t31, "");

  ok(&t32, "");

  ok(&t33, "");

  ok(&t34, "");

  ok(&t35, "");

  ok(&t36, "");

  ok(&t37, "at-underscore contains everyting but the '-with' option");

  ok(&t38, "Test return value");

  ok(&t39, "");

  ok(&t40, "");

  ok(&t41, "");

  ok(&t42, "");

  ok(&t43, "");

  ok(&t44, "");

  ok(&t45, "");

  ok(&t46, "");

  ok(&t47, "");

  ok(&t48, "");

  ok(&t49, "");

  ok(&t50, "");

  ok(&t51, "");

  ok(&t52, "Two integers");

  ok(&t53, "Three integers");

  ok(&t54, "Three integers");

  ok(&t55, "One integer");

  ok(&t56, "Undefined value");

  ok(&t57, "Zero");

  ok(&t58, "Three decimal values");

  ok(&t59, "Three decimal values");

  ok(&t60, "3 divided by 2 is 1R1");

  ok(&t61, "");

  ok(&t62, "");

  ok(&t63, "");

  ok(&t64, "");

  ok(&t65, "");

  ok(&t66, "");

  ok(&t67, "");

  ok(&t68, "");

  ok(&t69, "");

  ok(&t70, "");

  ok(&t71, "Simple (alphabetical) sort");

  ok(&t72, "");

  ok(&t73, "");

  ok(&t74, "");

  ok(&t75, "");

  ok(&t76, "");

  ok(&t77, "");

  ok(&t78, "");

  ok(&t79, "");

  ok(&t80, "");

  ok(&t81, "");

  ok(&t82, "");

  ok(&t83, "");

  ok(&t84, "");

  ok(&t85, "");

  ok(&t86, "");

  ok(&t87, "");

  ok(&t88, "");

  ok(&t89, "");

  ok(&t90, "");

  ok(&t91, "");

  ok(&t92, "");

  ok(&t93, "");

  ok(&t94, "");

  ok(&t95, "");

  ok(&t96, "");

  ok(&t97, "");

  ok(&t98, "");

  ok(&t99, "");

  ok(&t100, "");

  ok(&t101, "");

  ok(&t102, "");

  ok(&t103, "");

  ok(&t104, "");

  ok(&t105, "");

  ok(&t106, "");

  ok(&t107, "");

  ok(&t108, "");

  ok(&t109, "");

  ok(&t110, "");

  ok(&t111, "");

  ok(&t112, "");

  ok(&t113, "");

  ok(&t114, "");

  ok(&t115, "");

  ok(&t116, "");

  ok(&t117, "");

  ok(&t118, "");

  ok(&t119, "");

  ok(&t120, "");

  ok(&t121, "");

  ok(&t122, "");

  ok(!&t123, "");


  # ------------------------------------------------------------------------------
# t1 - Match
# Generated from ../lib/Hub/Parse/Parser.pm line: 117
# ------------------------------------------------------------------------------

sub t1 {
  $result = eval {my $parser = mkinst( 'Parser', -template => 'Hello [#who]' );
              ${$parser->populate( { who => 'World' } )};
};
  $@ and die $@;
  return $result eq "Hello World";
}#t1

  # ------------------------------------------------------------------------------
# t2 - Match
# Generated from ../lib/Hub/Knots/SortedHash.pm line: 94
# ------------------------------------------------------------------------------

sub t2 {
  $result = eval {
  my %h = ();
  tie %h, 'Hub::Knots::SortedHash';
  $h{'first'} = "Apple";
  $h{'second'} = "Banana";
  $h{'third'} = "Pear";
  join ';', values %h;

};
  $@ and die $@;
  return $result eq "Apple;Banana;Pear";
}#t2

  # ------------------------------------------------------------------------------
# t3 - False
# Generated from ../lib/Hub/Perl/Compare.pm line: 73
# ------------------------------------------------------------------------------

sub t3 {
  $result = eval {compare('eq','',undef);
};
  $@ and die $@;
  return $result ? 0 : 1;
}#t3

  # ------------------------------------------------------------------------------
# t4 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 74
# ------------------------------------------------------------------------------

sub t4 {
  $result = eval {compare('eq','abc','abc');
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t4

  # ------------------------------------------------------------------------------
# t5 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 75
# ------------------------------------------------------------------------------

sub t5 {
  $result = eval {compare('ne','abc','Abc');
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t5

  # ------------------------------------------------------------------------------
# t6 - False
# Generated from ../lib/Hub/Perl/Compare.pm line: 76
# ------------------------------------------------------------------------------

sub t6 {
  $result = eval {compare('eq','abc',undef);
};
  $@ and die $@;
  return $result ? 0 : 1;
}#t6

  # ------------------------------------------------------------------------------
# t7 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 77
# ------------------------------------------------------------------------------

sub t7 {
  $result = eval {compare('!~','abc','A');
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t7

  # ------------------------------------------------------------------------------
# t8 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 78
# ------------------------------------------------------------------------------

sub t8 {
  $result = eval {compare('=~','abc','a');
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t8

  # ------------------------------------------------------------------------------
# t9 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 79
# ------------------------------------------------------------------------------

sub t9 {
  $result = eval {compare('==',1234,1234);
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t9

  # ------------------------------------------------------------------------------
# t10 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 80
# ------------------------------------------------------------------------------

sub t10 {
  $result = eval {compare('>=',1234,1234);
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t10

  # ------------------------------------------------------------------------------
# t11 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 81
# ------------------------------------------------------------------------------

sub t11 {
  $result = eval {compare('eqic','abc','Abc');
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t11

  # ------------------------------------------------------------------------------
# t12 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 82
# ------------------------------------------------------------------------------

sub t12 {
  $result = eval {compare('==',undef,undef);
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t12

  # ------------------------------------------------------------------------------
# t13 - False
# Generated from ../lib/Hub/Perl/Compare.pm line: 83
# ------------------------------------------------------------------------------

sub t13 {
  $result = eval {compare('==',0,undef);
};
  $@ and die $@;
  return $result ? 0 : 1;
}#t13

  # ------------------------------------------------------------------------------
# t14 - Match
# Generated from ../lib/Hub/Perl/Compare.pm line: 84
# ------------------------------------------------------------------------------

sub t14 {
  $result = eval {my @numbers = ( 20, 1, 10, 2 );
              join ';', sort { &compare('<=>',$a,$b) } @numbers;
};
  $@ and die $@;
  return $result eq "1;2;10;20";
}#t14

  # ------------------------------------------------------------------------------
# t15 - Match
# Generated from ../lib/Hub/Misc/Transform.pm line: 22
# ------------------------------------------------------------------------------

sub t15 {
  $result = eval {safestr( 'Dogs (Waters, Gilmour) 17:06' );
};
  $@ and die $@;
  return $result eq "Dogs_20__28_Waters_2c__20_Gilmour_29__20_17_3a_06";
}#t15

  # ------------------------------------------------------------------------------
# t16 - Match
# Generated from ../lib/Hub/Misc/Transform.pm line: 144
# ------------------------------------------------------------------------------

sub t16 {
  $result = eval {populate('mu[#foo]m', { foo => 'shroo' });
};
  $@ and die $@;
  return $result eq "mushroom";
}#t16

  # ------------------------------------------------------------------------------
# t17 - Match
# Generated from ../lib/Hub/Misc/Transform.pm line: 145
# ------------------------------------------------------------------------------

sub t17 {
  $result = eval {ref(populate('a[#b]c', { b => 'bee' }, '-as_ref=1'));
};
  $@ and die $@;
  return $result eq "SCALAR";
}#t17

  # ------------------------------------------------------------------------------
# t18 - Match
# Generated from ../lib/Hub/Misc/Transform.pm line: 163
# ------------------------------------------------------------------------------

sub t18 {
  $result = eval {  my $hash = {
    'class'   => "foodidly",
    'name'    => "bobsmith",
    'height'  => "5px",
    'junk'    => "ignore me",
  };
  hashtoattrs($hash, ['junk']);
};
  $@ and die $@;
  return $result eq "class=\"foodidly\" height=\"5px\" name=\"bobsmith\"";
}#t18

  # ------------------------------------------------------------------------------
# t19 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 68
# ------------------------------------------------------------------------------

sub t19 {
  $result = eval {sizeof( { a=>1, b=>2, c=>3 } );
};
  $@ and die $@;
  return $result eq "3";
}#t19

  # ------------------------------------------------------------------------------
# t20 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 69
# ------------------------------------------------------------------------------

sub t20 {
  $result = eval {sizeof( [ 'a1', 'b2', 'c3' ] );
};
  $@ and die $@;
  return $result eq "3";
}#t20

  # ------------------------------------------------------------------------------
# t21 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 70
# ------------------------------------------------------------------------------

sub t21 {
  $result = eval {sizeof( "abc"                );
};
  $@ and die $@;
  return $result eq "3";
}#t21

  # ------------------------------------------------------------------------------
# t22 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 71
# ------------------------------------------------------------------------------

sub t22 {
  $result = eval {sizeof( \"abc"               );
};
  $@ and die $@;
  return $result eq "3";
}#t22

  # ------------------------------------------------------------------------------
# t23 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 72
# ------------------------------------------------------------------------------

sub t23 {
  $result = eval {sizeof( undef                );
};
  $@ and die $@;
  return $result eq "0";
}#t23

  # ------------------------------------------------------------------------------
# t24 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 73
# ------------------------------------------------------------------------------

sub t24 {
  $result = eval {sizeof( "a", "b", "c"        );
};
  $@ and die $@;
  return $result eq "3";
}#t24

  # ------------------------------------------------------------------------------
# t25 - Abort
# Generated from ../lib/Hub/Perl/Language.pm line: 129
# ------------------------------------------------------------------------------

sub t25 {
  $result = eval {my $compression = check( '-test=eval', 'use IO::Zlib' ) ? 1 : 0;
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

  # ------------------------------------------------------------------------------
# t26 - False
# Generated from ../lib/Hub/Perl/Language.pm line: 139
# ------------------------------------------------------------------------------

sub t26 {
  $result = eval {check( undef, undef, undef );
};
  $@ and die $@;
  return $result ? 0 : 1;
}#t26

  # ------------------------------------------------------------------------------
# t27 - False
# Generated from ../lib/Hub/Perl/Language.pm line: 140
# ------------------------------------------------------------------------------

sub t27 {
  $result = eval {check( 1, undef );
};
  $@ and die $@;
  return $result ? 0 : 1;
}#t27

  # ------------------------------------------------------------------------------
# t28 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 141
# ------------------------------------------------------------------------------

sub t28 {
  $result = eval {check( 1, 1 );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t28

  # ------------------------------------------------------------------------------
# t29 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 142
# ------------------------------------------------------------------------------

sub t29 {
  $result = eval {check( 1, undef, -opr => 'or' );

};
  $@ and die $@;
  return $result ? 1 : 0;
}#t29

  # ------------------------------------------------------------------------------
# t30 - False
# Generated from ../lib/Hub/Perl/Language.pm line: 144
# ------------------------------------------------------------------------------

sub t30 {
  $result = eval {check( -opr => 'xor', 1, 1 );
};
  $@ and die $@;
  return $result ? 0 : 1;
}#t30

  # ------------------------------------------------------------------------------
# t31 - False
# Generated from ../lib/Hub/Perl/Language.pm line: 145
# ------------------------------------------------------------------------------

sub t31 {
  $result = eval {check( -opr => 'xor', undef, undef );

};
  $@ and die $@;
  return $result ? 0 : 1;
}#t31

  # ------------------------------------------------------------------------------
# t32 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 147
# ------------------------------------------------------------------------------

sub t32 {
  $result = eval {check( -opr => 'xor', undef, 1 );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t32

  # ------------------------------------------------------------------------------
# t33 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 148
# ------------------------------------------------------------------------------

sub t33 {
  $result = eval {check( -opr => 'xor', 1, undef );

};
  $@ and die $@;
  return $result ? 1 : 0;
}#t33

  # ------------------------------------------------------------------------------
# t34 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 150
# ------------------------------------------------------------------------------

sub t34 {
  $result = eval {check( -opr => 'xor', 1, undef, 1, undef );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t34

  # ------------------------------------------------------------------------------
# t35 - False
# Generated from ../lib/Hub/Perl/Language.pm line: 151
# ------------------------------------------------------------------------------

sub t35 {
  $result = eval {check( -opr => 'xor', 1, undef, 1, 1, undef );
};
  $@ and die $@;
  return $result ? 0 : 1;
}#t35

  # ------------------------------------------------------------------------------
# t36 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 152
# ------------------------------------------------------------------------------

sub t36 {
  $result = eval {check( -opr => 'xor', undef, 1, undef, 1 );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t36

  # ------------------------------------------------------------------------------
# t37 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 284
# ------------------------------------------------------------------------------

sub t37 {
  $result = eval {
   sub myjoin {
      my $opts = Hub::opts( \@_ );
      return join( $$opts{'with'}, @_ );
   }

   myjoin( 'a', 'b', '-with=;', 'c', 'd' );
};
  $@ and die $@;
  return $result eq "a;b;c;d";
}#t37

  # ------------------------------------------------------------------------------
# t38 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 394
# ------------------------------------------------------------------------------

sub t38 {
  $result = eval {
  my $obj = mkinst( 'Object' );
  my @result = objopts( [ $obj ] );
  join( ',', map { ref($_) } @result );

};
  $@ and die $@;
  return $result eq "Hub::Base::Object,";
}#t38

  # ------------------------------------------------------------------------------
# t39 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 429
# ------------------------------------------------------------------------------

sub t39 {
  $result = eval {  my $opts = cmdopts(['--letters=a', '++letters=b', '++letters=c']);
  join('-', @{$$opts{'letters'}});
};
  $@ and die $@;
  return $result eq "a-b-c";
}#t39

  # ------------------------------------------------------------------------------
# t40 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 581
# ------------------------------------------------------------------------------

sub t40 {
  $result = eval {Hub::expect( -match => 'and|or|xor', 'and' );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t40

  # ------------------------------------------------------------------------------
# t41 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 582
# ------------------------------------------------------------------------------

sub t41 {
  $result = eval {Hub::expect( HASH => {}, HASH => {} );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t41

  # ------------------------------------------------------------------------------
# t42 - Abort
# Generated from ../lib/Hub/Perl/Language.pm line: 583
# ------------------------------------------------------------------------------

sub t42 {
  $result = eval {Hub::expect( -blessed => {} );
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

  # ------------------------------------------------------------------------------
# t43 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 584
# ------------------------------------------------------------------------------

sub t43 {
  $result = eval {Hub::expect( -blessed => mkinst( 'Object' ) );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t43

  # ------------------------------------------------------------------------------
# t44 - Abort
# Generated from ../lib/Hub/Perl/Language.pm line: 585
# ------------------------------------------------------------------------------

sub t44 {
  $result = eval {Hub::expect( -match => 'and|or|xor', 'if', 'or', 'and' );
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

  # ------------------------------------------------------------------------------
# t45 - Abort
# Generated from ../lib/Hub/Perl/Language.pm line: 586
# ------------------------------------------------------------------------------

sub t45 {
  $result = eval {Hub::expect( ARRAY => {} );
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

  # ------------------------------------------------------------------------------
# t46 - Abort
# Generated from ../lib/Hub/Perl/Language.pm line: 587
# ------------------------------------------------------------------------------

sub t46 {
  $result = eval {Hub::expect( -blessed => 'abc' );
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

  # ------------------------------------------------------------------------------
# t47 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 588
# ------------------------------------------------------------------------------

sub t47 {
  $result = eval {Hub::expect( -ref => 'HASH', {} );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t47

  # ------------------------------------------------------------------------------
# t48 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 589
# ------------------------------------------------------------------------------

sub t48 {
  $result = eval {Hub::expect( -ref => 'HASH', mkinst('Object') );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t48

  # ------------------------------------------------------------------------------
# t49 - Abort
# Generated from ../lib/Hub/Perl/Language.pm line: 625
# ------------------------------------------------------------------------------

sub t49 {
  $result = eval {Hub::fear( HASH => {} );
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

  # ------------------------------------------------------------------------------
# t50 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 626
# ------------------------------------------------------------------------------

sub t50 {
  $result = eval {Hub::fear( HASH => [] );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t50

  # ------------------------------------------------------------------------------
# t51 - Abort
# Generated from ../lib/Hub/Perl/Language.pm line: 639
# ------------------------------------------------------------------------------

sub t51 {
  $result = eval {abort( -msg => 'Goddamn hippies' );
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

  # ------------------------------------------------------------------------------
# t52 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 696
# ------------------------------------------------------------------------------

sub t52 {
  $result = eval {Hub::min(1,2);
};
  $@ and die $@;
  return $result eq "1";
}#t52

  # ------------------------------------------------------------------------------
# t53 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 697
# ------------------------------------------------------------------------------

sub t53 {
  $result = eval {Hub::min(2,1,3);
};
  $@ and die $@;
  return $result eq "1";
}#t53

  # ------------------------------------------------------------------------------
# t54 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 698
# ------------------------------------------------------------------------------

sub t54 {
  $result = eval {Hub::min(2,-1,3);
};
  $@ and die $@;
  return $result eq "-1";
}#t54

  # ------------------------------------------------------------------------------
# t55 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 699
# ------------------------------------------------------------------------------

sub t55 {
  $result = eval {Hub::min(1);
};
  $@ and die $@;
  return $result eq "1";
}#t55

  # ------------------------------------------------------------------------------
# t56 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 700
# ------------------------------------------------------------------------------

sub t56 {
  $result = eval {Hub::min(1,undef);
};
  $@ and die $@;
  return $result eq "1";
}#t56

  # ------------------------------------------------------------------------------
# t57 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 701
# ------------------------------------------------------------------------------

sub t57 {
  $result = eval {Hub::min(undef,1,0);
};
  $@ and die $@;
  return $result eq "0";
}#t57

  # ------------------------------------------------------------------------------
# t58 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 702
# ------------------------------------------------------------------------------

sub t58 {
  $result = eval {Hub::min(.009,1.001);
};
  $@ and die $@;
  return $result eq "0.009";
}#t58

  # ------------------------------------------------------------------------------
# t59 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 716
# ------------------------------------------------------------------------------

sub t59 {
  $result = eval {Hub::max(.009,-1.01,2,undef,0);
};
  $@ and die $@;
  return $result eq "2";
}#t59

  # ------------------------------------------------------------------------------
# t60 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 731
# ------------------------------------------------------------------------------

sub t60 {
  $result = eval {join(',',Hub::intdiv(3,2));
};
  $@ and die $@;
  return $result eq "1,1";
}#t60

  # ------------------------------------------------------------------------------
# t61 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 767
# ------------------------------------------------------------------------------

sub t61 {
  $result = eval {join('',@{rmval([1,2,3,4],3)});
};
  $@ and die $@;
  return $result eq "124";
}#t61

  # ------------------------------------------------------------------------------
# t62 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 842
# ------------------------------------------------------------------------------

sub t62 {
  $result = eval {
  my $x = 'like catfood';
  Hub::checksum( 'my', { cats => 'breath' }, ( 'smells', $x ) );

};
  $@ and die $@;
  return $result eq "2023611966";
}#t62

  # ------------------------------------------------------------------------------
# t63 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 1251
# ------------------------------------------------------------------------------

sub t63 {
  $result = eval {join( ';', dice( "a{b{c}}c{d}" ) );
};
  $@ and die $@;
  return $result eq "a;{b{c}};c;{d}";
}#t63

  # ------------------------------------------------------------------------------
# t64 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 1321
# ------------------------------------------------------------------------------

sub t64 {
  $result = eval {indexmatch("abracadabra", "[cd]")
};
  $@ and die $@;
  return $result eq "4";
}#t64

  # ------------------------------------------------------------------------------
# t65 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 1322
# ------------------------------------------------------------------------------

sub t65 {
  $result = eval {indexmatch("abracadabra", "a", 3)
};
  $@ and die $@;
  return $result eq "3";
}#t65

  # ------------------------------------------------------------------------------
# t66 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 1323
# ------------------------------------------------------------------------------

sub t66 {
  $result = eval {indexmatch("abracadabra", "d{2,2}")
};
  $@ and die $@;
  return $result eq "-1";
}#t66

  # ------------------------------------------------------------------------------
# t67 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 1324
# ------------------------------------------------------------------------------

sub t67 {
  $result = eval {indexmatch("scant", "can", "-after=1")
                - indexmatch("scant", "can")
};
  $@ and die $@;
  return $result eq "3";
}#t67

  # ------------------------------------------------------------------------------
# t68 - Match
# Generated from ../lib/Hub/Console/Output.pm line: 96
# ------------------------------------------------------------------------------

sub t68 {
  $result = eval {ps( 10, "this is really short but splits on ten chars" );


};
  $@ and die $@;
  return $result eq "this is re
ally short
 but split
s on ten c
hars";
}#t68

  # ------------------------------------------------------------------------------
# t69 - Match
# Generated from ../lib/Hub/Console/Output.pm line: 104
# ------------------------------------------------------------------------------

sub t69 {
  $result = eval {ps( 10, "this is really short but splits on ten chars", 3 );

};
  $@ and die $@;
  return $result eq "this is re
   ally short
    but split
   s on ten c
   hars";
}#t69

  # ------------------------------------------------------------------------------
# t70 - Match
# Generated from ../lib/Hub/Console/Output.pm line: 345
# ------------------------------------------------------------------------------

sub t70 {
  $result = eval {indenttext(4,"Hello\nWorld")
};
  $@ and die $@;
  return $result eq "    Hello
    World";
}#t70

  # ------------------------------------------------------------------------------
# t71 - Match
# Generated from ../lib/Hub/Perl/Sort.pm line: 24
# ------------------------------------------------------------------------------

sub t71 {
  $result = eval {    my @months = qw/Jan Feb Mar/;
    my @sorted = anon_sort( \@months );
    return join ',', @sorted;
};
  $@ and die $@;
  return $result eq "Feb,Jan,Mar";
}#t71

  # ------------------------------------------------------------------------------
# t72 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 936
# ------------------------------------------------------------------------------

sub t72 {
  $result = eval {fixpath( "../../../users/newuser/web/bin/../src/screens" );
};
  $@ and die $@;
  return $result eq "../../../users/newuser/web/src/screens";
}#t72

  # ------------------------------------------------------------------------------
# t73 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 939
# ------------------------------------------------------------------------------

sub t73 {
  $result = eval {fixpath( "users/newuser/web/" );
};
  $@ and die $@;
  return $result eq "users/newuser/web";
}#t73

  # ------------------------------------------------------------------------------
# t74 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 942
# ------------------------------------------------------------------------------

sub t74 {
  $result = eval {fixpath( "users/../web/bin/../src" );
};
  $@ and die $@;
  return $result eq "web/src";
}#t74

  # ------------------------------------------------------------------------------
# t75 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 945
# ------------------------------------------------------------------------------

sub t75 {
  $result = eval {fixpath( "users//newuser" );
};
  $@ and die $@;
  return $result eq "users/newuser";
}#t75

  # ------------------------------------------------------------------------------
# t76 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 948
# ------------------------------------------------------------------------------

sub t76 {
  $result = eval {fixpath( "users//newuser/./files" );
};
  $@ and die $@;
  return $result eq "users/newuser/files";
}#t76

  # ------------------------------------------------------------------------------
# t77 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 951
# ------------------------------------------------------------------------------

sub t77 {
  $result = eval {fixpath( "http://site/users//newuser" );
};
  $@ and die $@;
  return $result eq "http://site/users/newuser";
}#t77

  # ------------------------------------------------------------------------------
# t78 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 953
# ------------------------------------------------------------------------------

sub t78 {
  $result = eval {fixpath( '/home/hub/build/../../../out/doc/pod' );
};
  $@ and die $@;
  return $result eq "/out/doc/pod";
}#t78

  # ------------------------------------------------------------------------------
# t79 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 994
# ------------------------------------------------------------------------------

sub t79 {
  $result = eval {getpath( "/etc/passwd" )
};
  $@ and die $@;
  return $result eq "/etc";
}#t79

  # ------------------------------------------------------------------------------
# t80 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 995
# ------------------------------------------------------------------------------

sub t80 {
  $result = eval {getpath( "/usr/local/bin" )
};
  $@ and die $@;
  return $result eq "/usr/local";
}#t80

  # ------------------------------------------------------------------------------
# t81 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1024
# ------------------------------------------------------------------------------

sub t81 {
  $result = eval {getname("../../../users/newuser/web/data/p001/batman-small.jpg");
};
  $@ and die $@;
  return $result eq "batman-small.jpg";
}#t81

  # ------------------------------------------------------------------------------
# t82 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1026
# ------------------------------------------------------------------------------

sub t82 {
  $result = eval {getname("../../../users/newuser/web/data/p001");
};
  $@ and die $@;
  return $result eq "p001";
}#t82

  # ------------------------------------------------------------------------------
# t83 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1028
# ------------------------------------------------------------------------------

sub t83 {
  $result = eval {getname("/var/log/*.log");
};
  $@ and die $@;
  return $result eq "*.log";
}#t83

  # ------------------------------------------------------------------------------
# t84 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1041
# ------------------------------------------------------------------------------

sub t84 {
  $result = eval {getext( "/foo/bar/filename.ext" )
};
  $@ and die $@;
  return $result eq "ext";
}#t84

  # ------------------------------------------------------------------------------
# t85 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1043
# ------------------------------------------------------------------------------

sub t85 {
  $result = eval {getext( "filename.cgi" )
};
  $@ and die $@;
  return $result eq "cgi";
}#t85

  # ------------------------------------------------------------------------------
# t86 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1108
# ------------------------------------------------------------------------------

sub t86 {
  $result = eval {relpath("/home/docs", "/home/docs/install");
};
  $@ and die $@;
  return $result eq "..";
}#t86

  # ------------------------------------------------------------------------------
# t87 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1109
# ------------------------------------------------------------------------------

sub t87 {
  $result = eval {relpath("/home/src", "/home/docs/install");
};
  $@ and die $@;
  return $result eq "../../src";
}#t87

  # ------------------------------------------------------------------------------
# t88 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1111
# ------------------------------------------------------------------------------

sub t88 {
  $result = eval {relpath("/home/docs/README.txt", "/home/docs");
};
  $@ and die $@;
  return $result eq "README.txt";
}#t88

  # ------------------------------------------------------------------------------
# t89 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1113
# ------------------------------------------------------------------------------

sub t89 {
  $result = eval {relpath("README.txt", "/DEBUG");
};
  $@ and die $@;
  return $result eq "README.txt";
}#t89

  # ------------------------------------------------------------------------------
# t90 - True
# Generated from ../lib/Hub.pm line: 319
# ------------------------------------------------------------------------------

sub t90 {
  $result = eval {ref(mkinst('Object')) eq 'Hub::Base::Object';
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t90

  # ------------------------------------------------------------------------------
# t91 - Abort
# Generated from ../lib/Hub.pm line: 320
# ------------------------------------------------------------------------------

sub t91 {
  $result = eval {mkinst('DoesNotExist');
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

  # ------------------------------------------------------------------------------
# t92 - Abort
# Generated from ../lib/Hub.pm line: 468
# ------------------------------------------------------------------------------

sub t92 {
  $result = eval {Hub::blahblahblah();

};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

  # ------------------------------------------------------------------------------
# t93 - True
# Generated from ../lib/Hub/Misc/Time.pm line: 69
# ------------------------------------------------------------------------------

sub t93 {
  $result = eval {datetime( );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t93

  # ------------------------------------------------------------------------------
# t94 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 70
# ------------------------------------------------------------------------------

sub t94 {
  $result = eval {datetime( 1045837284 );
};
  $@ and die $@;
  return $result =~ "02\/..\/2003 ..:..:24";
}#t94

  # ------------------------------------------------------------------------------
# t95 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 71
# ------------------------------------------------------------------------------

sub t95 {
  $result = eval {datetime( 1045837284, -nosec );
};
  $@ and die $@;
  return $result =~ "02\/..\/2003 ..:..";
}#t95

  # ------------------------------------------------------------------------------
# t96 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 72
# ------------------------------------------------------------------------------

sub t96 {
  $result = eval {datetime( 1045837284, -noyear );
};
  $@ and die $@;
  return $result =~ "02\/.. ..:..:24";
}#t96

  # ------------------------------------------------------------------------------
# t97 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 73
# ------------------------------------------------------------------------------

sub t97 {
  $result = eval {datetime( 1045837284, -ampm );
};
  $@ and die $@;
  return $result =~ "02\/..\/2003 ..:..:24am";
}#t97

  # ------------------------------------------------------------------------------
# t98 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 74
# ------------------------------------------------------------------------------

sub t98 {
  $result = eval {datetime( 1045837284, -nozeros );
};
  $@ and die $@;
  return $result =~ "2\/..\/2003 .:..:24";
}#t98

  # ------------------------------------------------------------------------------
# t99 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 75
# ------------------------------------------------------------------------------

sub t99 {
  $result = eval {datetime( 1045837284, -notime );
};
  $@ and die $@;
  return $result =~ "02\/..\/2003";
}#t99

  # ------------------------------------------------------------------------------
# t100 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 76
# ------------------------------------------------------------------------------

sub t100 {
  $result = eval {datetime( 1045837284, -nodate );
};
  $@ and die $@;
  return $result =~ "..:..:24";
}#t100

  # ------------------------------------------------------------------------------
# t101 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 77
# ------------------------------------------------------------------------------

sub t101 {
  $result = eval {datetime( 1045837284, -letter );
};
  $@ and die $@;
  return $result =~ "February .., 2003 ..:..:24";
}#t101

  # ------------------------------------------------------------------------------
# t102 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 81
# ------------------------------------------------------------------------------

sub t102 {
  $result = eval {datetime( 1045837284, -ampm, -nosec );              
};
  $@ and die $@;
  return $result =~ "02\/..\/2003 ..:..am";
}#t102

  # ------------------------------------------------------------------------------
# t103 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 84
# ------------------------------------------------------------------------------

sub t103 {
  $result = eval {datetime( 1045837284, -nosec, -nozeros, -noyear );
};
  $@ and die $@;
  return $result =~ "2\/.. .:..";
}#t103

  # ------------------------------------------------------------------------------
# t104 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 23
# ------------------------------------------------------------------------------

sub t104 {
  $result = eval {keydepth( 'and:then:came:the:rain' )
};
  $@ and die $@;
  return $result eq "4";
}#t104

  # ------------------------------------------------------------------------------
# t105 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 35
# ------------------------------------------------------------------------------

sub t105 {
  $result = eval {vartype( );
};
  $@ and die $@;
  return $result eq "";
}#t105

  # ------------------------------------------------------------------------------
# t106 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 36
# ------------------------------------------------------------------------------

sub t106 {
  $result = eval {vartype( "clr-bg" );
};
  $@ and die $@;
  return $result eq "clr";
}#t106

  # ------------------------------------------------------------------------------
# t107 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 37
# ------------------------------------------------------------------------------

sub t107 {
  $result = eval {vartype( "clr-bg", "default" );
};
  $@ and die $@;
  return $result eq "clr";
}#t107

  # ------------------------------------------------------------------------------
# t108 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 38
# ------------------------------------------------------------------------------

sub t108 {
  $result = eval {vartype( "whatev", "default" );
};
  $@ and die $@;
  return $result eq "default";
}#t108

  # ------------------------------------------------------------------------------
# t109 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 39
# ------------------------------------------------------------------------------

sub t109 {
  $result = eval {vartype( "whatev" );
};
  $@ and die $@;
  return $result eq "";
}#t109

  # ------------------------------------------------------------------------------
# t110 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 40
# ------------------------------------------------------------------------------

sub t110 {
  $result = eval {vartype( "a:b:c" );
};
  $@ and die $@;
  return $result eq "";
}#t110

  # ------------------------------------------------------------------------------
# t111 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 41
# ------------------------------------------------------------------------------

sub t111 {
  $result = eval {vartype( "x-a:b:c" );
};
  $@ and die $@;
  return $result eq "x";
}#t111

  # ------------------------------------------------------------------------------
# t112 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 42
# ------------------------------------------------------------------------------

sub t112 {
  $result = eval {vartype( "a:b:x-c" );
};
  $@ and die $@;
  return $result eq "x";
}#t112

  # ------------------------------------------------------------------------------
# t113 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 59
# ------------------------------------------------------------------------------

sub t113 {
  $result = eval {varroot( "p001:items:1002:text-description" );
};
  $@ and die $@;
  return $result eq "p001";
}#t113

  # ------------------------------------------------------------------------------
# t114 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 60
# ------------------------------------------------------------------------------

sub t114 {
  $result = eval {varroot( "p001" );
};
  $@ and die $@;
  return $result eq "p001";
}#t114

  # ------------------------------------------------------------------------------
# t115 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 73
# ------------------------------------------------------------------------------

sub t115 {
  $result = eval {varname( "p001:items:1002:text-desc" );
};
  $@ and die $@;
  return $result eq "text-desc";
}#t115

  # ------------------------------------------------------------------------------
# t116 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 74
# ------------------------------------------------------------------------------

sub t116 {
  $result = eval {varname( "p001" );
};
  $@ and die $@;
  return $result eq "p001";
}#t116

  # ------------------------------------------------------------------------------
# t117 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 88
# ------------------------------------------------------------------------------

sub t117 {
  $result = eval {varparent( "p001:items:12:1000" );
};
  $@ and die $@;
  return $result eq "p001:items:12";
}#t117

  # ------------------------------------------------------------------------------
# t118 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 89
# ------------------------------------------------------------------------------

sub t118 {
  $result = eval {varparent( "p001:items:10:subs:100" );
};
  $@ and die $@;
  return $result eq "p001:items:10:subs";
}#t118

  # ------------------------------------------------------------------------------
# t119 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 90
# ------------------------------------------------------------------------------

sub t119 {
  $result = eval {varparent( "p001" );
};
  $@ and die $@;
  return $result eq "";
}#t119

  # ------------------------------------------------------------------------------
# t120 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 105
# ------------------------------------------------------------------------------

sub t120 {
  $result = eval {dotaddr("p004:proj:1000");
};
  $@ and die $@;
  return $result eq "p004.proj.1000";
}#t120

  # ------------------------------------------------------------------------------
# t121 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 106
# ------------------------------------------------------------------------------

sub t121 {
  $result = eval {dotaddr("p004:proj:1000:name");
};
  $@ and die $@;
  return $result eq "p004.proj.1000.name";
}#t121

  # ------------------------------------------------------------------------------
# t122 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 107
# ------------------------------------------------------------------------------

sub t122 {
  $result = eval {dotaddr("p001");
};
  $@ and die $@;
  return $result eq "p001";
}#t122

  # ------------------------------------------------------------------------------
# t123 - Defined
# Generated from ../lib/Hub/Data/Address.pm line: 108
# ------------------------------------------------------------------------------

sub t123 {
  $result = eval {dotaddr("");
};
  $@ and die $@;
  return defined $result ? 1 : 0;
}#t123

