use strict;
use warnings;
use Test::More 0.88;
# This is a relatively nice way to avoid Test::NoWarnings breaking our
# expectations by adding extra tests, without using no_plan.  It also helps
# avoid any other test module that feels introducing random tests, or even
# test plans, is a nice idea.
our $success = 0;
END { $success && done_testing; }

# List our own version used to generate this
my $v = "\nGenerated by Dist::Zilla::Plugin::ReportVersions::Tiny v1.10\n";

eval {                     # no excuses!
    # report our Perl details
    my $want = '5.006';
    $v .= "perl: $] (wanted $want) on $^O from $^X\n\n";
};
defined($@) and diag("$@");

# Now, our module version dependencies:
sub pmver {
    my ($module, $wanted) = @_;
    $wanted = " (want $wanted)";
    my $pmver;
    eval "require $module;";
    if ($@) {
        if ($@ =~ m/Can't locate .* in \@INC/) {
            $pmver = 'module not found.';
        } else {
            diag("${module}: $@");
            $pmver = 'died during require.';
        }
    } else {
        my $version;
        eval { $version = $module->VERSION; };
        if ($@) {
            diag("${module}: $@");
            $pmver = 'died during VERSION check.';
        } elsif (defined $version) {
            $pmver = "$version";
        } else {
            $pmver = '<undef>';
        }
    }

    # So, we should be good, right?
    return sprintf('%-45s => %-10s%-15s%s', $module, $pmver, $wanted, "\n");
}

eval { $v .= pmver('App::AltSQL','any version') };
eval { $v .= pmver('App::Cmd','any version') };
eval { $v .= pmver('App::cpanminus::reporter','any version') };
eval { $v .= pmver('App::cpanoutdated','any version') };
eval { $v .= pmver('App::gh','any version') };
eval { $v .= pmver('CPAN::Mini','any version') };
eval { $v .= pmver('CPAN::Mini::Inject','any version') };
eval { $v .= pmver('Capture::Tiny','any version') };
eval { $v .= pmver('Carp::Always','any version') };
eval { $v .= pmver('Carp::Always::Color','any version') };
eval { $v .= pmver('Class::Method::Modifiers','any version') };
eval { $v .= pmver('Class::Method::Modifiers::Fast','any version') };
eval { $v .= pmver('Config::JFDI','any version') };
eval { $v .= pmver('DBD::SQLite','1.31') };
eval { $v .= pmver('DBIx::Class','0.08192') };
eval { $v .= pmver('DBIx::Class::Migration','any version') };
eval { $v .= pmver('DBIx::Class::Schema::Loader','0.07010') };
eval { $v .= pmver('DateTime','any version') };
eval { $v .= pmver('DateTime::Format::DB2','any version') };
eval { $v .= pmver('DateTime::Format::DBI','any version') };
eval { $v .= pmver('DateTime::Format::MySQL','any version') };
eval { $v .= pmver('DateTime::Format::Pg','any version') };
eval { $v .= pmver('Devel::Confess','any version') };
eval { $v .= pmver('Directory::Scratch','any version') };
eval { $v .= pmver('Dist::Zilla::App::Command::issues','any version') };
eval { $v .= pmver('Dist::Zilla::PluginBundle::RSRCHBOY','any version') };
eval { $v .= pmver('ExtUtils::MakeMaker','any version') };
eval { $v .= pmver('File::Spec','any version') };
eval { $v .= pmver('File::chdir','any version') };
eval { $v .= pmver('IO::Handle','any version') };
eval { $v .= pmver('IPC::Open3','any version') };
eval { $v .= pmver('L','any version') };
eval { $v .= pmver('Moo','any version') };
eval { $v .= pmver('MooX::Cmd','any version') };
eval { $v .= pmver('MooX::Types::MooseLike','any version') };
eval { $v .= pmver('MooseX::App::Cmd','any version') };
eval { $v .= pmver('MooseX::AutoDestruct','0.007') };
eval { $v .= pmver('MooseX::RelatedClasses','any version') };
eval { $v .= pmver('MooseX::Types::Perl','any version') };
eval { $v .= pmver('Path::Class','any version') };
eval { $v .= pmver('Perl::Critic','any version') };
eval { $v .= pmver('Perl::Tidy','any version') };
eval { $v .= pmver('Pod::Cpandoc','any version') };
eval { $v .= pmver('Regexp::Debugger','any version') };
eval { $v .= pmver('Reindeer','0.016') };
eval { $v .= pmver('Smart::Args','any version') };
eval { $v .= pmver('Smart::Comments','any version') };
eval { $v .= pmver('Sub::Exporter','any version') };
eval { $v .= pmver('Sub::Install','any version') };
eval { $v .= pmver('TAP::Harness::Restricted','any version') };
eval { $v .= pmver('Task::CPAN::Reporter','any version') };
eval { $v .= pmver('Test::CheckDeps','0.010') };
eval { $v .= pmver('Test::Moose::More','0.017') };
eval { $v .= pmver('Test::More','0.94') };
eval { $v .= pmver('Test::Routine','0.015') };
eval { $v .= pmver('Test::TempDir::Tiny','any version') };
eval { $v .= pmver('Try::Tiny','any version') };
eval { $v .= pmver('V','any version') };
eval { $v .= pmver('aliased','any version') };
eval { $v .= pmver('autobox::Colors','any version') };
eval { $v .= pmver('autobox::Core','any version') };
eval { $v .= pmver('autobox::JSON','any version') };
eval { $v .= pmver('autobox::dump','any version') };
eval { $v .= pmver('autodie','2.22') };
eval { $v .= pmver('common::sense','any version') };
eval { $v .= pmver('lib::if::dev','any version') };
eval { $v .= pmver('local::lib','any version') };
eval { $v .= pmver('namespace::autoclean','any version') };
eval { $v .= pmver('opts','0.05') };
eval { $v .= pmver('strict','any version') };
eval { $v .= pmver('strictures','any version') };
eval { $v .= pmver('warnings','any version') };


# All done.
$v .= <<'EOT';

Thanks for using my code.  I hope it works for you.
If not, please try and include this output in the bug report.
That will help me reproduce the issue and solve your problem.

EOT

diag($v);
ok(1, "we really didn't test anything, just reporting data");
$success = 1;

# Work around another nasty module on CPAN. :/
no warnings 'once';
$Template::Test::NO_FLUSH = 1;
exit 0;
