package Tk::Airports;

#
#  Copyright (c) 2005 Renee Baecker (module@renee-baecker.de)
#

use 5.006001;
use strict;
use warnings;
use Carp;

require Tk;
require Tk::Toplevel;
require Tk::HList;

our @ISA = qw(Tk::Derived Tk::Toplevel);
our $VERSION = '0.02';

Construct Tk::Widget 'Airports';

########
# ToDo:
# 
# *) translation of cities into national names
# *) allow other fonts
# *) option for specifying the return values (code,city,all)
# *) option for specifying the delimiter

sub Show{
  my ($cw) = @_;
  $cw->Popup();
  $cw->waitVariable(\$cw->{Selected});
  $cw->withdraw;
  $cw->{Selected} = [""] unless(defined $cw->{Selected});
  return wantarray ? @{$cw->{Selected}} : join("; ",@{$cw->{Selected}});
}# Show

sub Accept{
  my ($cw) = @_;
  my $airport = [map{substr($_,0,3)}$cw->Subwidget('airports')->Getselected()];
  $airport = [""] unless($airport);
  $cw->{Selected} = $airport;
}# Accept

sub Cancel{
  my ($cw) = @_;
  $cw->{Selected} = undef;
  $cw->withdraw;
}#Cancel

sub Populate{
  my ($cw,$args) = @_;
  
  $cw->SUPER::Populate($args);
  $cw->ConfigSpecs(
            -selectmode => ['PASSIVE', 'selectmode', 'Selectmode', 'single'   ],
            -order      => ['PASSIVE', 'order'     , 'Order'     , 'code'     ],
            -font       => ['PASSIVE', 'font'      , 'Font'      , 'Courier 8'],
            -filename   => ['PASSIVE', 'filename'  , 'Filename'  , ''         ],
                  );
  $cw->protocol('WM_DELETE_WINDOW' => ['Cancel', $cw]);
  
  # Label
  $cw->Label(-text => 'Airports worldwide')->pack();
  
  # Search Frame  
  my $entry_var = '';
  my $frm = $cw->Component('Frame' => 'search_frame')->pack();
  $frm->Label(-text => 'Search')->pack(-anchor => 'w', 
                                       -side   => 'left',);
  my $se = $frm->Component('Entry'       => 'search_entry',
                           -textvariable => \$entry_var,
                          )->pack(-anchor => 'w',
                                  -side => 'left',);
  $frm->Button(-text    => 'search',
               -command => ['Search',$cw],
              )->pack(-anchor => 'w',);
  $se->bind('<Return>' => [$cw => 'Search']);
  
  # Airport list
  my @allowed_selectmodes = qw(single multiple extended);
  my $tmp_selectmode = $args->{-selectmode} || 'single';
  my ($selectmode) = grep{/$tmp_selectmode/i}@allowed_selectmodes;
  $selectmode ||= 'single';
  my $hl = $cw->Component('ScrlListbox'   => 'airports',
                         -width           => 40,
                         -scrollbars      => 'ose',
                         -selectmode      => $selectmode,
                         -exportselection => 0,
                         -font            => 'Courier 8',
                         ); 
  # insert airports
  my @list  = ();
  my $error = 0;
  if(exists $args->{-filename}){
    unless(open(my $fh,"<",$args->{-filename})){
      $error = 1;
    }
    else{
      my @lines = <$fh>;
      if($lines[0] =~ /^[A-Z]{3} - .*$/){
        @list = @lines;
      }
      else{
        $error = 1;
      }
      close $fh;
    }
  }
  if(!exists $args->{-filename} || $error){
    _getAirports();
  }
  
  if(exists $args->{-order} && $args->{-order} eq 'city'){
    @list = sort{substr($a,6) cmp substr($b,6)}@list;
  }
  
  for(0..(scalar(@list)-1)){
    $hl->insert('end',$list[$_]);
  }
  
  $hl->pack();
  $hl->bind('<Double-1>' => [$cw => 'Accept']);
  $hl->bind('<Button-1>' => sub{$hl->focus()});
  $hl->bind('<Return>'   => [$cw => 'Accept']);
  
  # ok-Button
  $cw->Button(-text => 'ok', -command => ['Accept',$cw])->pack();
  
  return $cw;
}# Populate

sub Search{
  my ($cw) = @_;
  $cw->Subwidget('airports')->delete(0.0,'end');
  my $pattern = $cw->Subwidget('search_frame')->Subwidget('search_entry')->get();
  $pattern =~ s//oe/g;
  $pattern =~ s//ae/g;
  $pattern =~ s//ue/g;
  my @list = grep{/$pattern/i}_getAirports();
  for(0..(scalar(@list)-1)){
    $cw->Subwidget('airports')->insert('end',$list[$_]);
  }
}# Search

sub _getAirports{
  my @airports = (
                  'AAL - Aalborg DK',
                  'AAM - Mala Mala ZA',
                  'AAN - Al Ain AE',
                  'AAQ - Anapa RU',
                  'AAR - Aarhus DK',
                  'ABC - Albacete ES',
                  'ABE - Allentown PA US',
                  'ABI - Abilene TX US',
                  'ABJ - Abidjan CI',
                  'ABQ - Albuquerque NM US',
                  'ABR - Aberdeen SD US',
                  'ABT - Al-Baha Al-Aqiq SA',
                  'ABV - Abuja NG',
                  'ABX - Albury NS AU',
                  'ABY - Albany GA US',
                  'ABZ - Aberdeen GB',
                  'ACA - Acapulco MX',
                  'ACC - Accra GH',
                  'ACE - Lanzarote ES',
                  'ACH - Altenrhein CH',
                  'ACK - Nantucket MA US',
                  'ACT - Waco TX US',
                  'ACV - Arcata CA US',
                  'ACY - Atlantic City NJ US',
                  'ADA - Adana TR',
                  'ADB - Izmir TR',
                  'ADD - Addis Ababa ET',
                  'ADE - Aden Int\'l YE',
                  'ADK - Adak Is. AK US',
                  'ADL - Adelaide SA AU',
                  'ADQ - Kodiak AK US',
                  'ADZ - San Andres Is. CO',
                  'AED - Aleneva AK US',
                  'AEP - Buenos Aires-Newbery BA AR',
                  'AER - Adler/Sochi RU',
                  'AES - Aalesund NO',
                  'AEX - Alexandria LA US',
                  'AEY - Akureyri IS',
                  'AFA - San Rafael MD AR',
                  'AFT - Afutara SB',
                  'AGA - Agadir MA',
                  'AGH - Angelholm/Helsingborg SE',
                  'AGP - Malaga ES',
                  'AGS - Augusta GA US',
                  'AGT - Ciudad del Este PY',
                  'AGU - Aguascalientes MX',
                  'AHB - Abha SA',
                  'AHN - Athens GA US',
                  'AHO - Alghero IT',
                  'AIA - Alliance NE US',
                  'AIC - Airok MH',
                  'AIM - Ailuk Is. MH',
                  'AJA - Ajaccio FR',
                  'AJF - Jouf SA',
                  'AJI - Agri TR',
                  'AJR - Arvidsjaur SE',
                  'AJU - Aracaju SE BR',
                  'AKB - Atka AK US',
                  'AKJ - Asahikawa JP',
                  'AKL - Auckland NZ',
                  'AKN - King Salmon AK US',
                  'AKS - Auki Gwaunaru\'u SB',
                  'ALA - Almaty KZ',
                  'ALB - Albany NY US',
                  'ALC - Alicante ES',
                  'ALF - Alta NO',
                  'ALG - Algiers DZ',
                  'ALO - Waterloo IA US',
                  'ALP - Aleppo SY',
                  'ALS - Alamosa CO US',
                  'ALW - Walla Walla WA US',
                  'ALY - Alexandria EG',
                  'AMA - Amarillo TX US',
                  'AMD - Ahmedabad IN',
                  'AMM - Amman JO',
                  'AMS - Amsterdam-Schiphol NL',
                  'ANC - Anchorage AK US',
                  'ANF - Antofagasta CL',
                  'ANI - Aniak AK US',
                  'ANU - Antigua V.C. AG',
                  'ANX - Andenes NO',
                  'AOC - Altenburg DE',
                  'AOI - Ancona IT',
                  'AOJ - Aomori JP',
                  'AOK - Karpathos GR',
                  'AOO - Altoona PA US',
                  'AOR - Alor MY',
                  'APF - Naples FL US',
                  'APN - Alpena MI US',
                  'APW - Apia WS',
                  'AQI - Qaisumah SA',
                  'AQP - Arequipa PE',
                  'ARH - Arkhangelsk RU',
                  'ARI - Arica CL',
                  'ARM - Armidale NS AU',
                  'ARN - Stockholm-Arlanda SE',
                  'ART - Watertown NY US',
                  'ASB - Ashgabat TM',
                  'ASD - Andros Town BS',
                  'ASE - Aspen CO US',
                  'ASF - Astrakhan RU',
                  'ASJ - Amami JP',
                  'ASM - Asmara ER',
                  'ASP - Alice Spgs NT AU',
                  'ASR - Kayseri TR',
                  'ASU - Asuncion PY',
                  'ATC - Arthur\'s Town BS',
                  'ATD - Atoifi SB',
                  'ATH - Athens GR',
                  'ATL - Atlanta GA US',
                  'ATQ - Amritsar Raja Sansi IN',
                  'ATW - Appleton WI US',
                  'ATY - Watertown SD US',
                  'ATZ - Assiut EG',
                  'AUA - Aruba AW',
                  'AUG - Augusta ME US',
                  'AUH - Abu Dhabi AE',
                  'AUL - Aur Is. MH',
                  'AUS - Austin TX US',
                  'AVL - Asheville NC US',
                  'AVN - Avignon FR',
                  'AVP - Scranton PA US',
                  'AVV - Avalon VI AU',
                  'AXA - Anguilla AI',
                  'AXD - Alexandroupolis GR',
                  'AXM - Armenia CO',
                  'AXP - Spring Pt Springpoint BS',
                  'AXT - Akita JP',
                  'AYQ - Ayers Rock NT AU',
                  'AYT - Antalya TR',
                  'AZO - Kalamazoo MI US',
                  'BAH - Bahrain BH',
                  'BAL - Batman TR',
                  'BAQ - Barranquilla CO',
                  'BAS - Balalae SB',
                  'BAV - Baotou CN',
                  'BAX - Barnaul RU',
                  'BAY - Baia Mare RO',
                  'BBA - Balmaceda CL',
                  'BBU - Bucharest-Baneasa RO',
                  'BCI - Barcaldine QL AU',
                  'BCL - Barra Colorado CR',
                  'BCM - Bacau RO',
                  'BCN - Barcelona ES',
                  'BDA - Bermuda BM',
                  'BDB - Bundaberg QL AU',
                  'BDL - Hartford CT US',
                  'BDS - Brindisi IT',
                  'BDU - Bardufoss NO',
                  'BEB - Benbecula GB',
                  'BEG - Belgrade CS',
                  'BEL - Belem PA BR',
                  'BEN - Benghazi LY',
                  'BES - Brest FR',
                  'BET - Bethel AK US',
                  'BEU - Bedourie QL AU',
                  'BEW - Beira MZ',
                  'BEY - Beirut LB',
                  'BFD - Bradford PA US',
                  'BFF - Scottsbluff NE US',
                  'BFI - Seattle Boeing Fld Int\'l WA US',
                  'BFL - Bakersfield CA US',
                  'BFN - Bloemfontein ZA',
                  'BFS - Belfast GB',
                  'BGA - Bucaramanga CO',
                  'BGF - Bangui CF',
                  'BGI - Bridgetown BB',
                  'BGM - Binghamton NY US',
                  'BGO - Bergen NO',
                  'BGR - Bangor ME US',
                  'BGY - Milan-Orio Al Serio IT',
                  'BHB - Bar Harbour ME US',
                  'BHD - Belfast City GB',
                  'BHE - Blenheim NZ',
                  'BHH - Bisha SA',
                  'BHI - Bahia Blanca BA AR',
                  'BHM - Birmingham AL US',
                  'BHX - Birmingham GB',
                  'BIA - Bastia FR',
                  'BII - Bikini Atoll MH',
                  'BIL - Billings MT US',
                  'BIO - Bilbao ES',
                  'BIQ - Biarritz FR',
                  'BIS - Bismarck ND US',
                  'BJF - Batsfjord NO',
                  'BJI - Bemidji MN US',
                  'BJL - Banjul GM',
                  'BJM - Bujumbura BI',
                  'BJV - Bodrum Milas TR',
                  'BJX - Leon/Guanajuato MX',
                  'BJZ - Badajoz ES',
                  'BKI - Kota Kinabalu MY',
                  'BKK - Bangkok TH',
                  'BKO - Bamako ML',
                  'BKQ - Blackall QL AU',
                  'BKW - Beckley WV US',
                  'BLE - Borlange/Falun SE',
                  'BLF - Bluefield WV US',
                  'BLI - Bellingham WA US',
                  'BLK - Blackpool GB',
                  'BLL - Billund DK',
                  'BLQ - Bologna IT',
                  'BLR - Bangalore IN',
                  'BLT - Blackwater QL AU',
                  'BLZ - Blantyre MW',
                  'BMA - Stockholm-Bromma SE',
                  'BME - Broome WA AU',
                  'BMI - Bloomington IL US',
                  'BMP - Brampton Is. QL AU',
                  'BNA - Nashville TN US',
                  'BNE - Brisbane QL AU',
                  'BNJ - Bonn Rail DE',
                  'BNK - Ballina NS AU',
                  'BNN - Bronnoysund NO',
                  'BNY - Bellona SB',
                  'BOD - Bordeaux FR',
                  'BOG - Bogota CO',
                  'BOH - Bournemouth GB',
                  'BOI - Boise ID US',
                  'BOJ - Bourgas BG',
                  'BOM - Mumbai IN',
                  'BON - Bonaire AN',
                  'BOO - Bodo NO',
                  'BOS - Boston MA US',
                  'BPS - Porto Seguro BA BR',
                  'BPT - Beaumont TX US',
                  'BPX - Bangda CN',
                  'BQK - Brunswick GA US',
                  'BQL - Boulia QL AU',
                  'BQN - Aguadilla PR',
                  'BQS - Blagoveschensk RU',
                  'BRC - San Carlos RN AR',
                  'BRD - Brainerd MN US',
                  'BRE - Bremen DE',
                  'BRI - Bari IT',
                  'BRK - Bourke NS AU',
                  'BRL - Burlington IA US',
                  'BRN - Berne CH',
                  'BRO - Brownsville TX US',
                  'BRQ - Brno Turany CZ',
                  'BRR - Barra N Bay GB',
                  'BRS - Bristol GB',
                  'BRU - Brussels BE',
                  'BRW - Barrow AK US',
                  'BSB - Brasilia DF BR',
                  'BSL - Basel/Mulhouse CH',
                  'BTK - Bratsk RU',
                  'BTM - Butte MT US',
                  'BTR - Baton Rouge LA US',
                  'BTS - Bratislava SK',
                  'BTU - Bintulu MY',
                  'BTV - Burlington VT US',
                  'BUA - Buka PG',
                  'BUC - Burketown QL AU',
                  'BUD - Budapest HU',
                  'BUF - Buffalo NY US',
                  'BUQ - Bulawayo ZW',
                  'BUR - Burbank CA US',
                  'BVA - Paris Beauvais-Tille FR',
                  'BVB - Boa Vista RR BR',
                  'BVG - Berlevag NO',
                  'BVI - Birdsville QL AU',
                  'BWI - Baltimore MD US',
                  'BWK - Bol HR',
                  'BWN - Bandar Seri Begawan BN',
                  'BWT - Burnie TS AU',
                  'BZE - Belize City BZ',
                  'BZG - Bydgoszcz PL',
                  'BZN - Bozeman MT US',
                  'BZO - Bolzano IT',
                  'BZV - Brazzaville CG',
                  'CAE - Columbia SC US',
                  'CAG - Cagliari IT',
                  'CAI - Cairo EG',
                  'CAK - Akron/Canton OH US',
                  'CAL - Campbeltown GB',
                  'CAN - Guangzhou CN',
                  'CAY - Cayenne GF',
                  'CAZ - Cobar NS AU',
                  'CBR - Canberra AC AU',
                  'CCC - Cayo CU',
                  'CCF - Carcassonne FR',
                  'CCJ - Kozhikode IN',
                  'CCK - Cocos Islands CC',
                  'CCP - Concepcion CL',
                  'CCS - Caracas VE',
                  'CCU - Kolkata IN',
                  'CDB - Cold Bay AK US',
                  'CDC - Cedar City UT US',
                  'CDG - Paris-Ch. De Gaulle FR',
                  'CDR - Chadron NE US',
                  'CDV - Cordova AK US',
                  'CEB - Cebu PH',
                  'CEC - Crescent City CA US',
                  'CEI - Chiang Rai TH',
                  'CEK - Chelyabinsk RU',
                  'CEN - Ciudad Obregon MX',
                  'CEZ - Cortez CO US',
                  'CFE - Clermont-Ferrand FR',
                  'CFR - Caen FR',
                  'CFS - Coffs Harbour NS AU',
                  'CFU - Kerkyra I. GR',
                  'CGB - Cuiaba MT BR',
                  'CGH - Sao Paulo-Congonhas SP BR',
                  'CGI - Cape Girardeau MO US',
                  'CGK - Jakarta ID',
                  'CGN - Cologne/Bonn DE',
                  'CGO - Zhengzhou CN',
                  'CGP - Chittagong BD',
                  'CGQ - Changchun CN',
                  'CGR - Campo Grande MS BR',
                  'CHA - Chattanooga TN US',
                  'CHC - Christchurch NZ',
                  'CHO - Charlottesville VA US',
                  'CHQ - Chania GR',
                  'CHS - Charleston SC US',
                  'CHY - Choiseul Bay SB',
                  'CIA - Rome-Ciampino IT',
                  'CIC - Chico CA US',
                  'CID - Cedar Rapids IA US',
                  'CIU - Sault Ste Marie MI US',
                  'CIW - Canouan Is. VC',
                  'CIX - Chiclayo PE',
                  'CJC - Calama CL',
                  'CJJ - Cheongju KR',
                  'CJS - Ciudad Juarez MX',
                  'CJU - Jeju KR',
                  'CKB - Clarksburg WV US',
                  'CKG - Chongqing CN',
                  'CKY - Conakry GN',
                  'CLD - San Diego-Carlsbad CA US',
                  'CLE - Cleveland OH US',
                  'CLJ - Cluj Napoca RO',
                  'CLL - College Stn TX US',
                  'CLO - Cali CO',
                  'CLQ - Colima MX',
                  'CLT - Charlotte NC US',
                  'CLY - Calvi FR',
                  'CMA - Cunnamulla QL AU',
                  'CMB - Colombo-Bandaranayake LK',
                  'CME - Ciudad Del Carmen MX',
                  'CMH - Columbus OH US',
                  'CMI - Champaign IL US',
                  'CMN - Casablanca MA',
                  'CMU - Kundiawa PG',
                  'CMX - Hancock MI US',
                  'CNB - Coonamble NS AU',
                  'CND - Constanta RO',
                  'CNF - Belo Horizonte-Tancredo Neves MG BR',
                  'CNJ - Cloncurry QL AU',
                  'CNP - Neerlerit Inaat GL',
                  'CNQ - Corrientes CR AR',
                  'CNS - Cairns QL AU',
                  'CNX - Chiang Mai TH',
                  'COD - Cody WY US',
                  'COK - Kochi IN',
                  'COO - Cotonou BJ',
                  'COR - Cordoba CD AR',
                  'COS - Colorado Spgs CO US',
                  'COU - Columbia MO US',
                  'CPC - San Martin DeLos Andes NE AR',
                  'CPE - Campeche MX',
                  'CPH - Copenhagen DK',
                  'CPO - Copiapo CL',
                  'CPQ - Campinas SP BR',
                  'CPR - Casper WY US',
                  'CPT - Cape Town ZA',
                  'CRD - Comodoro Rivadavia CB AR',
                  'CRI - Crooked Is. BS',
                  'CRK - Luzon Is. PH',
                  'CRL - Brussels-Charleroi BE',
                  'CRP - Corpus Christi TX US',
                  'CRV - Crotone IT',
                  'CRW - Charleston WV US',
                  'CSG - Columbus GA US',
                  'CSX - Changsha CN',
                  'CSY - Cheboksary RU',
                  'CTA - Catania IT',
                  'CTC - Catamarca CA AR',
                  'CTG - Cartagena CO',
                  'CTL - Charleville QL AU',
                  'CTM - Chetumal MX',
                  'CTS - Sapporo-Chitose JP',
                  'CTU - Chengdu CN',
                  'CUC - Cucuta CO',
                  'CUL - Culiacan MX',
                  'CUN - Cancun MX',
                  'CUR - Curacao AN',
                  'CUU - Chihuahua MX',
                  'CUZ - Cuzco PE',
                  'CVG - Cincinnati OH US',
                  'CVJ - Cuernavaca MX',
                  'CVM - Ciudad Victoria MX',
                  'CVN - Clovis Muni NM US',
                  'CVT - Coventry Baginton GB',
                  'CWA - Wausau WI US',
                  'CWB - Curitiba PR BR',
                  'CWL - Cardiff GB',
                  'CXJ - Caxias Do Sul RS BR',
                  'CYO - Cayo Largo CU',
                  'CYS - Cheyenne WY US',
                  'CZM - Cozumel MX',
                  'CZS - Cruzeiro Do Sul AC BR',
                  'CZX - Changzhou CN',
                  'DAB - Daytona Beach FL US',
                  'DAC - Dhaka Zia BD',
                  'DAD - Da Nang VN',
                  'DAL - Dallas-Love TX US',
                  'DAM - Damascus SY',
                  'DAR - Dar Es Salaam TZ',
                  'DAY - Dayton-Cox OH US',
                  'DBO - Dubbo NS AU',
                  'DBQ - Dubuque IA US',
                  'DBV - Dubrovnik HR',
                  'DCA - Washington-Reagan DC US',
                  'DCF - Dominica Cane DM',
                  'DDC - Dodge City KS US',
                  'DEC - Decatur IL US',
                  'DEL - Delhi IN',
                  'DEN - Denver CO US',
                  'DFW - Dallas/Ft Worth TX US',
                  'DGE - Mudgee NS AU',
                  'DGO - Durango MX',
                  'DHN - Dothan AL US',
                  'DIK - Dickinson ND US',
                  'DIL - Dili Comoro ID',
                  'DIY - Diyarbakir TR',
                  'DJE - Djerba TN',
                  'DKI - Dunk Is. QL AU',
                  'DKR - Dakar SN',
                  'DLA - Douala CM',
                  'DLC - Dalian CN',
                  'DLG - Dillingham AK US',
                  'DLH - Duluth MN US',
                  'DLM - Dalaman TR',
                  'DMD - Doomadgee QL AU',
                  'DME - Moscow-Domodedovo RU',
                  'DMM - Dammam SA',
                  'DNA - Okinawa-Kadena JP',
                  'DNH - Dunhuang CN',
                  'DNK - Dnepropetrovsk UA',
                  'DNR - Dinard FR',
                  'DNZ - Denizli TR',
                  'DOH - Doha QA',
                  'DOK - Donetsk UA',
                  'DOM - Dominica DM',
                  'DPO - Devonport TS AU',
                  'DPS - Denpasar ID',
                  'DRO - Durango CO US',
                  'DRS - Dresden DE',
                  'DRT - Del Rio Int\'l TX US',
                  'DRW - Darwin NT AU',
                  'DSA - Doncaster Sheffield GB',
                  'DSM - Des Moines IA US',
                  'DTM - Dortmund DE',
                  'DTW - Detroit MI US',
                  'DUB - Dublin IE',
                  'DUD - Dunedin NZ',
                  'DUJ - Dubois PA US',
                  'DUR - Durban ZA',
                  'DUS - Dusseldorf DE',
                  'DUT - Dutch Harbor AK US',
                  'DVL - Devils Lake ND US',
                  'DWD - Dawadmi SA',
                  'DXB - Dubai AE',
                  'DYG - Dayong CN',
                  'DYR - Anadyr RU',
                  'DYU - Dushanbe TJ',
                  'DZA - Dzaoudzi YT',
                  'EAL - El Arish EG',
                  'EAM - Nejran SA',
                  'EAR - Kearney NE US',
                  'EAS - San Sebastian ES',
                  'EAT - Wenatchee WA US',
                  'EAU - Eau Claire WI US',
                  'EBB - Entebbe UG',
                  'EBJ - Esbjerg DK',
                  'EBO - Ebon MH',
                  'EBU - St Etienne FR',
                  'ECN - Ercan CY',
                  'EDI - Edinburgh GB',
                  'EDR - Edward Rvr QL AU',
                  'EFL - Kefallinia GR',
                  'EGC - Bergerac FR',
                  'EGE - Vail/Eagle CO US',
                  'EGM - Sege SB',
                  'EGO - Belgorod RU',
                  'EGS - Egilsstadir IS',
                  'EIN - Eindhoven NL',
                  'EIS - Beef Is. VG',
                  'EJA - Barrancabermeja CO',
                  'EJH - Wedjh SA',
                  'EJT - Mili Atoll Enijet MH',
                  'EKO - Elko NV US',
                  'ELH - N Eleuthera BS',
                  'ELM - Corning NY US',
                  'ELP - El Paso TX US',
                  'ELQ - Gassim SA',
                  'ELS - E London ZA',
                  'EMA - Nottingham/E. Midlands GB',
                  'EMD - Emerald QL AU',
                  'ENA - Kenai AK US',
                  'ENF - Enontekio FI',
                  'ENS - Enschede Twente NL',
                  'ENT - Enewetak Is. MH',
                  'EQS - Esquel CB AR',
                  'ERC - Erzincan TR',
                  'ERF - Erfurt DE',
                  'ERI - Erie PA US',
                  'ERZ - Erzurum TR',
                  'ESB - Ankara-Esenboga TR',
                  'ESC - Escanaba MI US',
                  'ESR - El Salvador CL',
                  'ESS - Essen DE',
                  'ETH - Elat IL',
                  'ETZ - Metz/Nancy FR',
                  'EUG - Eugene OR US',
                  'EUN - Laayoune Hassan Isl. MA',
                  'EUX - St. Eustatius AN',
                  'EVE - Harstad/Narvik NO',
                  'EVN - Yerevan AM',
                  'EVV - Evansville IN US',
                  'EWN - New Bern NC US',
                  'EWR - Newark NJ US',
                  'EXT - Exeter GB',
                  'EYW - Key W FL US',
                  'EZE - Buenos Aires-Pistarini BA AR',
                  'EZS - Elazig TR',
                  'FAE - Faroe Islands FO',
                  'FAI - Fairbanks AK US',
                  'FAO - Faro PT',
                  'FAR - Fargo ND US',
                  'FAT - Fresno CA US',
                  'FAY - Fayetteville NC US',
                  'FBM - Lubumbashi CD',
                  'FCA - Kalispell MT US',
                  'FCO - Rome-Fiumicino IT',
                  'FDE - Forde Bringeland NO',
                  'FDF - Ft De France MQ',
                  'FDH - Friedrichshafen DE',
                  'FEN - Fernando De Noronha FN BR',
                  'FEZ - Fez Sais MA',
                  'FHU - Ft Huachuca Libby AAF AZ US',
                  'FIH - Kinshasa CD',
                  'FKB - Karlsruhe/Baden DE',
                  'FKI - Kisangani CD',
                  'FKL - Franklin PA US',
                  'FKS - Fukushima JP',
                  'FLG - Grand Canyon AZ US',
                  'FLL - Ft. Lauderdale FL US',
                  'FLN - Florianopolis SC BR',
                  'FLO - Florence SC US',
                  'FLR - Florence-Peretola IT',
                  'FMA - Formosa FO AR',
                  'FMN - Farmington NM US',
                  'FMO - Muenster DE',
                  'FNA - Freetown SL',
                  'FNC - Funchal PT',
                  'FNI - Nimes FR',
                  'FNJ - Pyongyang Sunan KP',
                  'FNT - Flint MI US',
                  'FOC - Fuzhou CN',
                  'FOD - Ft. Dodge IA US',
                  'FOR - Fortaleza CE BR',
                  'FPO - Freeport Grand Bahama BS',
                  'FRA - Frankfurt DE',
                  'FRE - Fera Is. SB',
                  'FRL - Forli IT',
                  'FRO - Floro NO',
                  'FRS - Flores GT',
                  'FRU - Bishkek KG',
                  'FSC - Figari FR',
                  'FSD - Sioux Falls SD US',
                  'FSM - Ft. Smith AR US',
                  'FTE - El Calafate AR',
                  'FUE - Puerto del Rosario Fuerteventura ES',
                  'FUJ - Fukue JP',
                  'FUK - Fukuoka JP',
                  'FUN - Funafuti Atol TV',
                  'FWA - Ft. Wayne IN US',
                  'GAJ - Yamagata JP',
                  'GBD - Great Bend KS US',
                  'GBE - Gaborone BW',
                  'GCC - Gillette WY US',
                  'GCI - Guernsey GB',
                  'GCK - Garden City KS US',
                  'GCM - Grand Cayman Is. KY',
                  'GDL - Guadalajara MX',
                  'GDN - Gdansk PL',
                  'GDV - Glendive MT US',
                  'GDX - Magadan RU',
                  'GEG - Spokane WA US',
                  'GEO - Georgetown GY',
                  'GEV - Gallivare SE',
                  'GFK - Grand Forks ND US',
                  'GGG - Gladewater TX US',
                  'GGT - George Town BS',
                  'GGW - Glasgow MT US',
                  'GHB - Governors Harbour BS',
                  'GIB - Gibraltar GI',
                  'GIG - Rio De Janeiro-Intl RJ BR',
                  'GIS - Gisborne NZ',
                  'GIZ - Gizan SA',
                  'GJA - Guanaja HN',
                  'GJT - Grand Junction CO US',
                  'GKA - Goroka PG',
                  'GLA - Glasgow GB',
                  'GLF - Golfito CR',
                  'GLH - Greenville MS US',
                  'GLT - Gladstone QL AU',
                  'GMA - Gemena CD',
                  'GMP - Seoul-Gimpo KR',
                  'GNB - Lyon-St. Geoirs FR',
                  'GND - Grenada GD',
                  'GNV - Gainesville FL US',
                  'GOA - Genoa IT',
                  'GOH - Nuuk GL',
                  'GOI - Goa IN',
                  'GOJ - Nizhniy RU',
                  'GOM - Goma CD',
                  'GOQ - Golmud CN',
                  'GOT - Gothenburg-Landvetter SE',
                  'GOV - Gove NT AU',
                  'GPA - Patras GR',
                  'GPT - Gulfport MS US',
                  'GRB - Green Bay WI US',
                  'GRI - Grand Is. NE US',
                  'GRJ - George ZA',
                  'GRK - Killeen-Gray TX US',
                  'GRO - Gerona ES',
                  'GRQ - Groningen NL',
                  'GRR - Grand Rapids MI US',
                  'GRU - Sao Paulo-Guarulhos SP BR',
                  'GRX - Granada ES',
                  'GRY - Grimsey IS',
                  'GRZ - Graz AT',
                  'GSE - Gothenburg-Saeve SE',
                  'GSO - Greensboro/Winston-Salem NC US',
                  'GSP - Greenville-Spartanburg SC US',
                  'GST - Gustavus AK US',
                  'GTE - Groote NT AU',
                  'GTF - Great Falls MT US',
                  'GTR - Columbus MS US',
                  'GUA - Guatemala City GT',
                  'GUB - Guerrero MX',
                  'GUC - Gunnison CO US',
                  'GUM - Guam GU',
                  'GUR - Alotau PG',
                  'GVA - Geneva CH',
                  'GWT - Westerland DE',
                  'GWY - Galway IE',
                  'GYD - Baku AZ',
                  'GYE - Guayaquil EC',
                  'GYM - Guaymas MX',
                  'GYN - Goiania GO BR',
                  'GZO - Gizo SB',
                  'GZT - Gaziantep TR',
                  'HAA - Hasvik NO',
                  'HAC - Hachijo Jima JP',
                  'HAD - Halmstad SE',
                  'HAH - Moroni KM',
                  'HAJ - Hanover DE',
                  'HAK - Haikou CN',
                  'HAM - Hamburg DE',
                  'HAN - Hanoi VN',
                  'HAS - Hail SA',
                  'HAU - Haugesund NO',
                  'HAV - Havana CU',
                  'HBA - Hobart TS AU',
                  'HBE - Alexandria EG',
                  'HDB - Heidelberg DE',
                  'HDF - Heringsdorf DE',
                  'HDN - Hayden CO US',
                  'HDS - Hoedspruit ZA',
                  'HDY - Hat Yai TH',
                  'HEK - Heihe CN',
                  'HEL - Helsinki FI',
                  'HER - Heraklion GR',
                  'HET - Hohhot CN',
                  'HFE - Hefei CN',
                  'HFT - Hammerfest NO',
                  'HGD - Hughenden QL AU',
                  'HGH - Hangzhou CN',
                  'HGN - Mae Hong Son TH',
                  'HGR - Hagerstown MD US',
                  'HGU - Mount Hagen PG',
                  'HHH - Hilton Head SC US',
                  'HHN - Frankfurt-Hahn DE',
                  'HIB - Chisholm MN US',
                  'HID - Horn Is. QL AU',
                  'HII - Lake Havasu City AZ US',
                  'HIJ - Hiroshima JP',
                  'HIN - Jinju KR',
                  'HIR - Honiara SB',
                  'HIS - Hayman Is. QL AU',
                  'HKD - Hakodate JP',
                  'HKG - Hong Kong HK',
                  'HKK - Hokitika NZ',
                  'HKN - Hoskins PG',
                  'HKT - Phuket TH',
                  'HKY - Hickory NC US',
                  'HLA - Lanseria ZA',
                  'HLD - Hailar CN',
                  'HLF - Hultsfred SE',
                  'HLN - Helena MT US',
                  'HLZ - Hamilton NZ',
                  'HMA - Khanty Mansiysk RU',
                  'HME - Hassi Messaoud DZ',
                  'HMO - Hermosillo MX',
                  'HMV - Hemavan SE',
                  'HNA - Morioka JP',
                  'HND - Tokyo-Haneda JP',
                  'HNL - Honolulu HI US',
                  'HOF - Hofuf SA',
                  'HOG - Holguin CU',
                  'HOM - Homer AK US',
                  'HOQ - Hof DE',
                  'HOR - Horta PT',
                  'HOU - Houston-Hobby TX US',
                  'HOV - Orsta-Volda NO',
                  'HPN - Westchester County NY US',
                  'HRB - Harbin CN',
                  'HRE - Harare ZW',
                  'HRG - Hurghada EG',
                  'HRK - Kharkov UA',
                  'HRL - Harlingen TX US',
                  'HSG - Saga JP',
                  'HSV - Huntsville AL US',
                  'HTA - Chita RU',
                  'HTI - Hamilton Is. QL AU',
                  'HTS - Ashland KY US',
                  'HUX - Huatulco MX',
                  'HUY - Humberside GB',
                  'HVB - Hervey Bay QL AU',
                  'HVG - Honningsvag Valan NO',
                  'HVN - New Haven CT US',
                  'HVR - Havre MT US',
                  'HYA - Hyannis MA US',
                  'HYD - Hyderabad IN',
                  'HYS - Hays KS US',
                  'IAD - Washington-Dulles DC US',
                  'IAH - Houston-Bush TX US',
                  'IAS - Iasi RO',
                  'IBZ - Ibiza ES',
                  'ICI - Cicia FJ',
                  'ICN - Seoul-Incheon KR',
                  'ICT - Wichita KS US',
                  'IDA - Idaho Falls ID US',
                  'IFJ - Isafjordur IS',
                  'IGA - Inagua BS',
                  'IGM - Kingman AZ US',
                  'IGR - Iguazu MI AR',
                  'IGU - Iguassu Falls PR BR',
                  'IKA - Imam Khomeini IR',
                  'IKT - Irkutsk RU',
                  'ILI - Iliamna AK US',
                  'ILM - Wilmington NC US',
                  'ILY - Islay GB',
                  'ILZ - Zilina SK',
                  'IMT - Iron Mtn. MI US',
                  'INC - Yinchuan CN',
                  'IND - Indianapolis IN US',
                  'INI - Nis CS',
                  'INL - Falls Falls MN US',
                  'INN - Innsbruck AT',
                  'INV - Inverness GB',
                  'IOA - Ioannina GR',
                  'IOM - Isle Of Man GB',
                  'IPC - Easter Is. CL',
                  'IPH - Ipoh MY',
                  'IPL - El Centro CA US',
                  'IPT - Williamsport PA US',
                  'IQQ - Iquique CL',
                  'IQT - Iquitos PE',
                  'IRA - Kirakira SB',
                  'IRJ - La Rioja LR AR',
                  'IRK - Kirksville MO US',
                  'ISA - Mount Isa QL AU',
                  'ISB - Islamabad PK',
                  'ISG - Ishigaki JP',
                  'ISN - Williston ND US',
                  'ISO - Kinston Stallings NC US',
                  'ISP - Islip NY US',
                  'IST - Istanbul TR',
                  'ITH - Ithaca NY US',
                  'ITM - Osaka-Itami JP',
                  'ITO - Hilo HI US',
                  'IUE - Niue Is. NU',
                  'IVC - Invercargill NZ',
                  'IVL - Ivalo FI',
                  'IWD - Ironwood MI US',
                  'IWJ - Iwami JP',
                  'IYK - Inyokern CA US',
                  'IZO - Izumo JP',
                  'JAC - Jackson Hole WY US',
                  'JAL - Jalapa MX',
                  'JAN - Jackson MS US',
                  'JAT - Jabot MH',
                  'JAV - Ilulissat GL',
                  'JAX - Jacksonville FL US',
                  'JCK - Julia Creek QL AU',
                  'JED - Jeddah SA',
                  'JEG - Aasiaat GL',
                  'JEJ - Jeh MH',
                  'JER - Jersey States GB',
                  'JFK - New York-JFK NY US',
                  'JFR - Paamiut GL',
                  'JGN - Jiayuguan CN',
                  'JGR - Groennedal GL',
                  'JGS - Ji an/Jing Gang Shan CN',
                  'JHB - Johor Bahru MY',
                  'JHG - Jinghong CN',
                  'JHM - Kapalua HI US',
                  'JHS - Sisimiut GL',
                  'JHW - Jamestown NY US',
                  'JIB - Djibouti DJ',
                  'JIK - Ikaria Is. GR',
                  'JJU - Qaqortoq GL',
                  'JKG - Jonkoping SE',
                  'JKH - Chios GR',
                  'JLN - Joplin MO US',
                  'JMK - Mikonos GR',
                  'JMS - Jamestown ND US',
                  'JNB - Johannesburg ZA',
                  'JNN - Nanortalik GL',
                  'JNS - Narsaq GL',
                  'JNU - Juneau AK US',
                  'JNX - Naxos GR',
                  'JOE - Joensuu FI',
                  'JOI - Joinville SC BR',
                  'JPA - Joao Pessoa PB BR',
                  'JQA - Qaarsut GL',
                  'JRO - Kilimanjaro TZ',
                  'JSH - Sitia GR',
                  'JSI - Skiathos GR',
                  'JST - Johnstown PA US',
                  'JSU - Maniitsoq GL',
                  'JSY - Syros Is. GR',
                  'JTR - Thira GR',
                  'JTY - Astypalaia Is. GR',
                  'JUJ - Jujuy PJ AR',
                  'JUL - Juliaca PE',
                  'JUV - Upernavik GL',
                  'JYV - Jyvaskyla FI',
                  'JZH - Song Pan CN',
                  'KAJ - Kajaani FI',
                  'KAN - Kano NG',
                  'KAO - Kuusamo FI',
                  'KAT - Kaitaia NZ',
                  'KBP - Kiev-Borispol UA',
                  'KBR - Kota Bharu MY',
                  'KBT - Kaben MH',
                  'KBV - Krabi TH',
                  'KCH - Kuching MY',
                  'KCZ - Kochi JP',
                  'KDV - Kandavu FJ',
                  'KEF - Reykjavik-Keflavik IS',
                  'KEJ - Kemerovo RU',
                  'KEL - Kiel DE',
                  'KEM - Kemi FI',
                  'KGA - Kananga CD',
                  'KGD - Kaliningrad RU',
                  'KGE - Kagau SB',
                  'KGF - Karaganda KZ',
                  'KGI - Kalgoorlie WA AU',
                  'KGL - Kigali RW',
                  'KGP - Kogalym RU',
                  'KGS - Kos GR',
                  'KHH - Kaohsiung TW',
                  'KHI - Karachi PK',
                  'KHN - Nanchang CN',
                  'KHV - Khabarovsk RU',
                  'KID - Kristianstad SE',
                  'KIJ - Niigata JP',
                  'KIM - Kimberley ZA',
                  'KIN - Kingston- Manley JM',
                  'KIO - Kili Is. MH',
                  'KIR - Kerry IE',
                  'KIS - Kisumu KE',
                  'KIT - Kithira GR',
                  'KIV - Chisinau MD',
                  'KIX - Osaka-Kansai JP',
                  'KJA - Krasnojarsk RU',
                  'KKC - Khon Kaen TH',
                  'KKE - Kerikeri NZ',
                  'KKJ - Kita Kyushu JP',
                  'KKN - Kirkenes NO',
                  'KLR - Kalmar SE',
                  'KLU - Klagenfurt AT',
                  'KLV - Karlovy Vary CZ',
                  'KLX - Kalamata GR',
                  'KMC - King Khalid Mil. City SA',
                  'KMG - Kunming CN',
                  'KMI - Miyazaki JP',
                  'KMJ - Kumamoto JP',
                  'KMQ - Komatsu JP',
                  'KNX - Kununurra WA AU',
                  'KOA - Kona HI US',
                  'KOI - Kirkwall GB',
                  'KOJ - Kagoshima JP',
                  'KOK - Kokkola/Pietarsaari FI',
                  'KPO - Pohang KR',
                  'KRF - Kramfors SE',
                  'KRK - Krakow PL',
                  'KRN - Kiruna SE',
                  'KRO - Kurgan RU',
                  'KRP - Karup DK',
                  'KRR - Krasnodar RU',
                  'KRS - Kristiansand Kjevik NO',
                  'KRT - Khartoum SD',
                  'KSA - Kosrae FM',
                  'KSC - Kosice Barca SK',
                  'KSD - Karlstad SE',
                  'KSF - Kassel DE',
                  'KSJ - Kasos Is. GR',
                  'KSN - Kostanay KZ',
                  'KSO - Kastoria GR',
                  'KSU - Kristiansund NO',
                  'KSY - Kars TR',
                  'KTA - Karratha WA AU',
                  'KTM - Kathmandu NP',
                  'KTN - Ketchikan AK US',
                  'KTP - Kingston-Tinson JM',
                  'KTT - Kittila FI',
                  'KTW - Katowice PL',
                  'KUA - Kuantan MY',
                  'KUF - Samara RU',
                  'KUH - Kushiro JP',
                  'KUL - Kuala Lumpur MY',
                  'KUN - Kaunas LT',
                  'KUO - Kuopio FI',
                  'KUS - Kulusuk GL',
                  'KUT - Kutaisi GE',
                  'KUV - Gunsan KR',
                  'KVA - Kavala GR',
                  'KVD - Gyandzha AZ',
                  'KVG - Kavieng PG',
                  'KWA - Kwajalein MH',
                  'KWE - Guiyang CN',
                  'KWI - Kuwait KW',
                  'KWJ - Gwangju KR',
                  'KWL - Guilin CN',
                  'KWM - Kowanyama QL AU',
                  'KWZ - Kolwezi CD',
                  'KXF - Koro Is. FJ',
                  'KXK - Komsomolsk Na Amure RU',
                  'KYA - Konya TR',
                  'KZI - Kozani GR',
                  'KZN - Kazan RU',
                  'KZS - Kastelorizo GR',
                  'LAD - Luanda AO',
                  'LAE - Lae Nadzab PG',
                  'LAI - Lannion FR',
                  'LAN - Lansing MI US',
                  'LAP - La Paz Leon MX',
                  'LAR - Laramie WY US',
                  'LAS - Las Vegas NV US',
                  'LAU - Lamu KE',
                  'LAW - Lawton OK US',
                  'LAX - Los Angeles CA US',
                  'LBA - Leeds/Bradford GB',
                  'LBB - Lubbock TX US',
                  'LBC - Hamburg-Luebeck DE',
                  'LBD - Khudzhand TJ',
                  'LBE - Latrobe PA US',
                  'LBF - N Platte NE US',
                  'LBL - Liberal KS US',
                  'LBS - Labasa FJ',
                  'LBU - Labuan MY',
                  'LBV - Libreville GA',
                  'LCA - Larnaca CY',
                  'LCE - La Ceiba HN',
                  'LCG - La Coruna ES',
                  'LCH - Lake Charles LA US',
                  'LCJ - Lodz PL',
                  'LCY - London City GB',
                  'LDB - Londrina PR BR',
                  'LDE - Lourdes/Tarbes FR',
                  'LDH - Lord Howe Is. NS AU',
                  'LDU - Lahad Datu MY',
                  'LDY - Londonderry GB',
                  'LEA - Learmonth WA AU',
                  'LEB - Hanover NH US',
                  'LED - St. Petersburg RU',
                  'LEH - Le Havre FR',
                  'LEI - Almeria ES',
                  'LEJ - Leipzig DE',
                  'LEN - Leon ES',
                  'LEV - Bureta FJ',
                  'LEX - Lexington KY US',
                  'LFT - Lafayette LA US',
                  'LFW - Lome TG',
                  'LGA - New York-La Guardia NY US',
                  'LGB - Long Beach CA US',
                  'LGI - Deadmans Cay BS',
                  'LGK - Langkawi MY',
                  'LGS - Malargue MD AR',
                  'LGW - London-Gatwick GB',
                  'LHE - Lahore PK',
                  'LHG - Lightning Ridge NS AU',
                  'LHR - London-Heathrow GB',
                  'LHW - Lanzhou CN',
                  'LIG - Limoges FR',
                  'LIH - Kauai Is. HI US',
                  'LIK - Likiep Is. MH',
                  'LIL - Lille FR',
                  'LIM - Lima PE',
                  'LIN - Milan-Linate IT',
                  'LIR - Liberia CR',
                  'LIS - Lisbon PT',
                  'LIT - Little Rock AR US',
                  'LJG - Lijiang City CN',
                  'LJU - Ljubljana SI',
                  'LKB - Lakeba FJ',
                  'LKL - Lakselv NO',
                  'LKN - Leknes NO',
                  'LLA - Lulea SE',
                  'LLU - Alluitsup Paa GL',
                  'LLW - Lilongwe MW',
                  'LML - Lae Is. MH',
                  'LMM - Los Mochis MX',
                  'LMN - Limbang MY',
                  'LMP - Lampedusa IT',
                  'LMT - Klamath Falls OR US',
                  'LNK - Lincoln NE US',
                  'LNS - Lancaster PA US',
                  'LNV - Lihir Is. PG',
                  'LNY - Lanai City HI US',
                  'LNZ - Linz AT',
                  'LOS - Lagos NG',
                  'LOV - Monclova MX',
                  'LPA - Las Palmas ES',
                  'LPB - La Paz BO',
                  'LPI - Linkoping SE',
                  'LPL - Liverpool GB',
                  'LPP - Lappeenranta FI',
                  'LPQ - Luang Prabang LA',
                  'LRD - Laredo TX US',
                  'LRE - Longreach QL AU',
                  'LRH - La Rochelle FR',
                  'LRM - La Romana DO',
                  'LRS - Leros GR',
                  'LRT - Lorient FR',
                  'LSC - La Serena CL',
                  'LSE - La Crosse WI US',
                  'LSI - Shetland Islands GB',
                  'LST - Launceston TS AU',
                  'LTN - London-Luton GB',
                  'LTO - Loreto MX',
                  'LUG - Lugano CH',
                  'LUM - Luxi CN',
                  'LUN - Lusaka ZM',
                  'LUQ - San Luis SL AR',
                  'LUX - Luxembourg LU',
                  'LVI - Livingstone ZM',
                  'LWB - Lewisburg WV US',
                  'LWN - Gyoumri AM',
                  'LWO - Lvov Snilow UA',
                  'LWS - Lewiston ID US',
                  'LWT - Lewistown MT US',
                  'LXA - Lhasa CN',
                  'LXR - Luxor EG',
                  'LXS - Limnos GR',
                  'LYC - Lycksele SE',
                  'LYG - Lianyungang CN',
                  'LYH - Lynchburg VA US',
                  'LYI - Linyi CN',
                  'LYR - Longyearbyen SJ',
                  'LYS - Lyon-Satolas FR',
                  'LZC - Lazaro MX',
                  'LZH - Liuzhou CN',
                  'LZR - Lizard Is. QL AU',
                  'MAA - Chennai IN',
                  'MAD - Madrid ES',
                  'MAF - Midland TX US',
                  'MAG - Madang PG',
                  'MAH - Menorca ES',
                  'MAJ - Majuro MH',
                  'MAM - Matamoros MX',
                  'MAN - Manchester GB',
                  'MAO - Manaus AM BR',
                  'MAR - Maracaibo VE',
                  'MAS - Manus Is. PG',
                  'MAV - Maloelap Is. MH',
                  'MAY - Mangrove Cay BS',
                  'MAZ - Mayaguez PR',
                  'MBA - Mombasa KE',
                  'MBD - Mmabatho ZA',
                  'MBE - Monbetsu JP',
                  'MBH - Maryborough QL AU',
                  'MBJ - Montego Bay JM',
                  'MBL - Manistee MI US',
                  'MBS - Bay City MI US',
                  'MBX - Maribor SI',
                  'MCG - Mcgrath AK US',
                  'MCI - Kansas City MO US',
                  'MCK - Mccook NE US',
                  'MCN - Macon GA US',
                  'MCO - Orlando FL US',
                  'MCP - Macapa AP BR',
                  'MCT - Muscat OM',
                  'MCV - Mcarthur Rvr NT AU',
                  'MCW - Mason City IA US',
                  'MCX - Makhachkala RU',
                  'MCY - Sunshine Coast QL AU',
                  'MCZ - Maceio AL BR',
                  'MDC - Manado ID',
                  'MDE - Medellin CO',
                  'MDG - Mudanjiang CN',
                  'MDK - Mbandaka CD',
                  'MDQ - Mar Del Plata BA AR',
                  'MDT - Harrisburg PA US',
                  'MDU - Mendi PG',
                  'MDW - Chicago-Midway IL US',
                  'MDZ - Mendoza MD AR',
                  'MED - Madinah SA',
                  'MEH - Mehamn NO',
                  'MEI - Meridian Key MS US',
                  'MEL - Melbourne AU',
                  'MEM - Memphis TN US',
                  'MES - Medan ID',
                  'MEX - Mexico City MX',
                  'MFE - Mcallen TX US',
                  'MFJ - Moala FJ',
                  'MFM - Macau MO',
                  'MFR - Medford OR US',
                  'MGA - Managua NI',
                  'MGB - Mount Gambier SA AU',
                  'MGF - Maringa PR BR',
                  'MGH - Margate ZA',
                  'MGM - Montgomery AL US',
                  'MGW - Morgantown WV US',
                  'MHD - Mashad IR',
                  'MHG - Mannheim DE',
                  'MHH - Marsh Harbour BS',
                  'MHK - Manhattan KS US',
                  'MHP - Minsk 1 BY',
                  'MHQ - Mariehamn FI',
                  'MHT - Manchester NH US',
                  'MHU - Mount Hotham VI AU',
                  'MIA - Miami FL US',
                  'MID - Merida MX',
                  'MIG - Mian Yang CN',
                  'MIJ - Mili Is. MH',
                  'MIK - Mikkeli FI',
                  'MIR - Monastir TN',
                  'MJB - Mejit Is. MH',
                  'MJE - Majkin MH',
                  'MJF - Mosjoen NO',
                  'MJM - Mbuji Mayi CD',
                  'MJN - Majunga MG',
                  'MJT - Mytilene GR',
                  'MJV - Murcia ES',
                  'MKE - Milwaukee WI US',
                  'MKG - Muskegon MI US',
                  'MKK - Hoolehua HI US',
                  'MKL - Jackson TN US',
                  'MKY - Mackay QL AU',
                  'MLA - Malta MT',
                  'MLB - Melbourne FL US',
                  'MLE - Male MV',
                  'MLH - Basel/Mulhouse FR CH',
                  'MLI - Moline IL US',
                  'MLM - Morelia MX',
                  'MLN - Melilla ES',
                  'MLO - Milos GR',
                  'MLS - Miles City MT US',
                  'MLU - Monroe LA US',
                  'MLX - Malatya TR',
                  'MMB - Memanbetsu JP',
                  'MME - Durham/Tees Valley GB',
                  'MMJ - Matsumoto JP',
                  'MMK - Murmansk RU',
                  'MMX - Malmo Sturup SE',
                  'MMY - Miyako Jima JP',
                  'MNG - Maningrida NT AU',
                  'MNI - Montserrat Bramble MS',
                  'MNL - Manila PH',
                  'MNY - Mono SB',
                  'MOB - Mobile AL US',
                  'MOD - Modesto CA US',
                  'MOL - Molde Aro NO',
                  'MOT - Minot ND US',
                  'MOV - Moranbah QL AU',
                  'MPK - Mokpo KR',
                  'MPL - Montpellier FR',
                  'MPM - Maputo MZ',
                  'MPN - Mount Pleasant FK',
                  'MPW - Mariupol UA',
                  'MQF - Magnitogorsk RU',
                  'MQL - Mildura VI AU',
                  'MQM - Mardin TR',
                  'MQN - Mo I Rana NO',
                  'MQP - Nelspruit ZA',
                  'MQT - Marquette MI US',
                  'MRS - Marseille FR',
                  'MRU - Mauritius MU',
                  'MRV - Mineralnye RU',
                  'MRY - Carmel CA US',
                  'MRZ - Moree NS AU',
                  'MSJ - Misawa JP',
                  'MSL - Florence AL US',
                  'MSN - Madison Dane WI US',
                  'MSO - Missoula MT US',
                  'MSP - Minneapolis/St Paul MN US',
                  'MSQ - Minsk 2 BY',
                  'MSR - Mus TR',
                  'MSS - Massena NY US',
                  'MST - Maastricht/Aachen NL',
                  'MSU - Maseru Moshoeshoe LS',
                  'MSY - New Orleans LA US',
                  'MTJ - Montrose CO US',
                  'MTR - Monteria CO',
                  'MTS - Manzini SZ',
                  'MTT - Minatitlan MX',
                  'MTY - Monterrey MX',
                  'MUA - Munda SB',
                  'MUC - Munich DE',
                  'MVD - Montevideo UY',
                  'MVY - Martha\'s Vineyard MA US',
                  'MWA - Marion IL US',
                  'MWH - Moses Lake WA US',
                  'MXH - Moro PG',
                  'MXL - Mexicali MX',
                  'MXP - Milan-Malpensa IT',
                  'MXS - Maota WS',
                  'MXX - Mora SE',
                  'MYD - Malindi KE',
                  'MYE - Miyake Jima JP',
                  'MYG - Mayaguana BS',
                  'MYJ - Matsuyama JP',
                  'MYR - Myrtle Beach SC US',
                  'MYY - Miri MY',
                  'MZL - Manizales CO',
                  'MZT - Mazatlan MX',
                  'MZV - Mulu MY',
                  'NAA - Narrabri NS AU',
                  'NAJ - Nakhichevan AZ',
                  'NAN - Nadi FJ',
                  'NAP - Naples IT',
                  'NAQ - Qaanaaq GL',
                  'NAS - Nassau BS',
                  'NAT - Natal RN BR',
                  'NBO - Nairobi-Jomo Kenyatta KE',
                  'NCE - Nice FR',
                  'NCL - Newcastle GB',
                  'NCY - Annecy Meythe FR',
                  'NDJ - Ndjamena TD',
                  'NDK - Namdrik Is. MH',
                  'NER - Neryungri RU',
                  'NEV - Nevis KN',
                  'NGB - Ningbo CN',
                  'NGI - Ngau Is. FJ',
                  'NGO - Nagoya JP',
                  'NGS - Nagasaki JP',
                  'NIM - Niamey NE',
                  'NJC - Nizhnevartovsk RU',
                  'NKC - Nouakchott MR',
                  'NKG - Nanking CN',
                  'NKM - Nagoya Komaki AFB JP',
                  'NLA - Ndola ZM',
                  'NLD - Nuevo Laredo MX',
                  'NLK - Norfolk Is. NF',
                  'NMA - Namangan UZ',
                  'NNB - Santa Ana SB',
                  'NNG - Nanning CN',
                  'NNM - Naryan Mar RU',
                  'NOB - Nosara Beach CR',
                  'NOC - Knock IE',
                  'NOJ - Nojabrxsk RU',
                  'NOS - Nossi be Fascene MG',
                  'NOU - Noumea NC',
                  'NOZ - Novokuznetsk RU',
                  'NPE - Napier Hastings NZ',
                  'NPL - New Plymouth NZ',
                  'NQN - Neuquen NE AR',
                  'NQY - Newquay GB',
                  'NRK - Norrkoping SE',
                  'NRN - Dusseldorf Niederrhein DE',
                  'NRT - Tokyo-Narita JP',
                  'NSI - Yaounde-Nsimalen CM',
                  'NSK - Noril\'sk RU',
                  'NSN - Nelson NZ',
                  'NST - Nakhon Si Thammarat TH',
                  'NTE - Nantes FR',
                  'NTG - Nantong CN',
                  'NTL - Newcastle-Williamtown NS AU',
                  'NTN - Normanton QL AU',
                  'NTQ - Wajima JP',
                  'NTY - Sun City ZA',
                  'NUE - Nuremberg, DE',
                  'NUX - Novy Urengoy RU',
                  'NVK - Narvik NO',
                  'NVT - Navegantes SC BR',
                  'NWI - Norwich GB',
                  'NYM - Nadym RU',
                  'NYO - Stockholm-Skavsta SE',
                  'OAJ - Jacksonville NC US',
                  'OAK - Oakland CA US',
                  'OAX - Oaxaca MX',
                  'OBO - Obihiro JP',
                  'OCJ - Ocho Rios JM',
                  'ODS - Odessa UA',
                  'OER - Ornskoldsvik SE',
                  'OGG - Kahului HI US',
                  'OGS - Ogdensburg NY US',
                  'OGZ - Vladikavkaz RU',
                  'OHD - Ohrid MK',
                  'OIM - Oshima JP',
                  'OIT - Oita JP',
                  'OKA - Okinawa-Naha JP',
                  'OKC - Oklahoma City OK US',
                  'OKD - Sapporo-Okadama JP',
                  'OKJ - Okayama JP',
                  'OKO - Tokyo Yokota AFB JP',
                  'OKY - Oakey QL AU',
                  'OLB - Olbia IT',
                  'OLF - Wolf Pt MT US',
                  'OMA - Omaha NE US',
                  'OME - Nome AK US',
                  'OMR - Oradea RO',
                  'OMS - Omsk RU',
                  'ONG - Mornington QL AU',
                  'ONJ - Odate JP',
                  'ONT - Ontario CA US',
                  'OOL - Gold Coast QL AU',
                  'OPO - Porto PT',
                  'ORB - Orebro SE',
                  'ORD - Chicago-O\'Hare IL US',
                  'ORF - Norfolk VA US',
                  'ORK - Cork IE',
                  'ORY - Paris-Orly FR',
                  'OSD - Ostersund SE',
                  'OSI - Osijek HR',
                  'OSK - Oskarshamn SE',
                  'OSL - Oslo NO',
                  'OSR - Ostrava CZ',
                  'OSY - Namsos NO',
                  'OSZ - Koszalin PL',
                  'OTH - N Bend OR US',
                  'OTP - Bucharest-Otopeni RO',
                  'OTR - Coto CR',
                  'OTZ - Kotzebue AK US',
                  'OUA - Ouagadougou BF',
                  'OUD - Oujda MA',
                  'OUL - Oulu FI',
                  'OVB - Novosibirsk RU',
                  'OVD - Asturias ES',
                  'OWB - Owensboro KY US',
                  'OXB - Bissau GW',
                  'OXR - Oxnard CA US',
                  'OZZ - Ouarzazate MA',
                  'PAD - Paderborn DE',
                  'PAH - Paducah KY US',
                  'PAP - Port Au Prince HT',
                  'PAS - Paros GR',
                  'PAZ - Poza Rica MX',
                  'PBC - Puebla Huejotsingo MX',
                  'PBI - W Palm Beach FL US',
                  'PBM - Paramaribo SR',
                  'PBO - Paraburdoo WA AU',
                  'PBP - Punta Islita CR',
                  'PDG - Padang Tabing ID',
                  'PDL - Ponta Delgada Nordela PT',
                  'PDP - Punta Del Este UY',
                  'PDS - Piedras Negras MX',
                  'PDT - Pendleton OR US',
                  'PDX - Portland OR US',
                  'PEE - Perm RU',
                  'PEG - Perugia IT',
                  'PEI - Pereira CO',
                  'PEK - Beijing CN',
                  'PEM - Puerto Maldonado PE',
                  'PEN - Penang MY',
                  'PER - Perth WA AU',
                  'PEW - Peshawar PK',
                  'PEZ - Penza RU',
                  'PFB - Passo Fundo RS BR',
                  'PFN - Panama City FL US',
                  'PFO - Paphos CY',
                  'PGA - Page AZ US',
                  'PGF - Perpignan FR',
                  'PGV - Greenville NC US',
                  'PHC - Port Harcourt NG',
                  'PHE - Port Hedland WA AU',
                  'PHF - Newport News VA US',
                  'PHL - Philadelphia PA US',
                  'PHS - Phitsanulok TH',
                  'PHW - Phalaborwa ZA',
                  'PHX - Phoenix AZ US',
                  'PIA - Peoria IL US',
                  'PIB - Laurel MS US',
                  'PIH - Pocatello ID US',
                  'PIK - Glasgow-Prestwick GB',
                  'PIR - Pierre SD US',
                  'PIS - Poitiers FR',
                  'PIT - Pittsburgh PA US',
                  'PIU - Piura PE',
                  'PIX - Pico Is. PT',
                  'PJM - Puerto Jimenez CR',
                  'PKB - Marietta OH US',
                  'PKC - Petropavlovsk Kamchats RU',
                  'PLB - Plattsburgh NY US',
                  'PLD - Playa Samara CR',
                  'PLN - Pellston MI US',
                  'PLO - Port Lincoln SA AU',
                  'PLQ - Palanga LT',
                  'PLS - Providenciales TC',
                  'PLU - Belo Horizonte-Pampulha MG BR',
                  'PLZ - Port Elizabeth ZA',
                  'PMC - Puerto Montt CL',
                  'PMF - Milan Parma IT',
                  'PMI - Palma Mallorca ES',
                  'PMO - Palermo IT',
                  'PMR - Palmerston NZ',
                  'PMV - Porlamar VE',
                  'PMZ - Palmar Sur CR',
                  'PNA - Pamplona ES',
                  'PNC - Ponca City OK US',
                  'PNH - Phnom Penh KH',
                  'PNI - Pohnpei FM',
                  'PNK - Pontianak ID',
                  'PNL - Pantelleria IT',
                  'PNP - Popondetta PG',
                  'PNR - Pointe Noire CG',
                  'PNS - Pensacola FL US',
                  'PNZ - Petrolina PE BR',
                  'POA - Porto Alegre RS BR',
                  'POM - Port Moresby PG',
                  'POP - Puerto Plata DO',
                  'POR - Pori FI',
                  'POS - Port Of Spain TT',
                  'POZ - Poznan PL',
                  'PPG - Pago Pago AS',
                  'PPP - Proserpine QL AU',
                  'PPT - Papeete PF',
                  'PQI - Presque Isle ME US',
                  'PQQ - Port Macquarie NS AU',
                  'PRC - Prescott AZ US',
                  'PRG - Prague CZ',
                  'PRI - Praslin Is. SC',
                  'PRN - Pristina CS',
                  'PSA - Florence-Gal Galilei IT',
                  'PSC - Pasco WA US',
                  'PSE - Ponce PR',
                  'PSG - Petersburg AK US',
                  'PSO - Pasto CO',
                  'PSP - Palm Springs CA US',
                  'PSR - Pescara IT',
                  'PSS - Posadas MI AR',
                  'PTG - Pietersburg ZA',
                  'PTP - Pointe a Pitre GP',
                  'PTY - Panama City PA',
                  'PUF - Pau FR',
                  'PUG - Port Augusta SA AU',
                  'PUJ - Punta Cana DO',
                  'PUQ - Punta Arenas CL',
                  'PUS - Busan KR',
                  'PUW - Pullman WA US',
                  'PUY - Pula HR',
                  'PVD - Providence RI US',
                  'PVG - Shanghai-Pu Dong CN',
                  'PVH - Porto Velho RO BR',
                  'PVK - Preveza GR',
                  'PVR - Puerto Vallarta MX',
                  'PWM - Portland ME US',
                  'PWQ - Pavlodar KZ',
                  'PXM - Puerto Escondido MX',
                  'PXO - Porto Santo PT',
                  'PZB - Pietermaritzburg ZA',
                  'PZI - Pan Zhi Hua CN',
                  'QDU - Dusseldorf Stn DE',
                  'QEF - Egelsbach Stn. DE',
                  'QFB - Freiburg Stn. DE',
                  'QFZ - Saarbruecken Rail DE',
                  'QJY - Kolobrzeg Bus PL',
                  'QJZ - Nantes Rail FR',
                  'QKL - Cologne Stn. DE',
                  'QLJ - Lucerne Stn. CH',
                  'QLS - Lausanne Stn. CH',
                  'QRO - Queretaro MX',
                  'QWU - Wuerzburg Stn. DE',
                  'QXB - Aix en Provence Stn. FR',
                  'QXG - Angers Rail FR',
                  'QZX - Fictitious Pt Gmt ZZ',
                  'RAB - Rabaul PG',
                  'RAE - Arar SA',
                  'RAH - Rafha SA',
                  'RAK - Marrakech MA',
                  'RAP - Rapid City SD US',
                  'RAR - Rarotonga CK',
                  'RBA - Rabat MA',
                  'RBR - Rio Branco AC BR',
                  'RBV - Ramata SB',
                  'RCB - Richards Bay ZA',
                  'RCH - Riohacha CO',
                  'RCM - Richmond QL AU',
                  'RDD - Redding CA US',
                  'RDM - Bend OR US',
                  'RDU - Durham NC US',
                  'RDZ - Rodez FR',
                  'REC - Recife PE BR',
                  'REG - Reggio Calabria IT',
                  'REL - Trelew CB AR',
                  'REN - Orenburg RU',
                  'REP - Siem Reap KH',
                  'RES - Resistencia CH AR',
                  'RET - Rost Stolport NO',
                  'REU - Reus ES',
                  'REX - Reynosa MX',
                  'RFD - Rockford Gtr Rockford IL US',
                  'RGA - Rio Grande TF AR',
                  'RGL - Rio Gallegos SC AR',
                  'RGN - Yangon MM',
                  'RHI - Rhinelander WI US',
                  'RHO - Rhodes GR',
                  'RIC - Richmond VA US',
                  'RIS - Rishiri JP',
                  'RIW - Riverton WY US',
                  'RIX - Riga LV',
                  'RJK - Rijeka HR',
                  'RJL - Logrono ES',
                  'RKD - Rockland ME US',
                  'RKS - Rock Springs WY US',
                  'RKT - Ras Al Khaimah AE',
                  'RKV - Reykjavik-Domestic IS',
                  'RLG - Rostock DE',
                  'RMA - Roma QL AU',
                  'RMF - Marsa EG',
                  'RMI - Rimini IT',
                  'RNA - Arona SB',
                  'RNB - Ronneby SE',
                  'RNL - Rennell SB',
                  'RNN - Bornholm DK',
                  'RNO - Reno/Tahoe NV US',
                  'RNP - Rongelap Is. MH',
                  'RNS - Rennes FR',
                  'ROA - Roanoke VA US',
                  'ROB - Monrovia LR',
                  'ROC - Rochester NY US',
                  'ROK - Rockhampton QL AU',
                  'ROP - Rota MP',
                  'ROR - Koror PW',
                  'ROS - Rosario SF AR',
                  'ROT - Rotorua NZ',
                  'ROV - Rostov RU',
                  'RRS - Roros NO',
                  'RSA - Santa Rosa LP AR',
                  'RSD - Rock Sound S Eleuthera BS',
                  'RST - Rochester MN US',
                  'RSU - Yeosu KR',
                  'RSW - Ft Myers FL US',
                  'RTA - Rotuma Is. FJ',
                  'RTB - Roatan HN',
                  'RTM - Rotterdam NL',
                  'RTW - Saratov RU',
                  'RUH - Riyadh SA',
                  'RUN - St Denis de la Reunion RE',
                  'RUT - Rutland VT US',
                  'RVK - Roervik NO',
                  'RVN - Rovaniemi FI',
                  'RVT - Ravensthorpe WA AU',
                  'RZE - Rzeszow PL',
                  'SAB - Saba Is. AN',
                  'SAF - Santa Fe NM US',
                  'SAH - Sana\'a YE',
                  'SAL - San Salvador SV',
                  'SAN - San Diego-Lindberg CA US',
                  'SAP - San Pedro Sula HN',
                  'SAQ - San Andros BS',
                  'SAT - San Antonio TX US',
                  'SAV - Savannah GA US',
                  'SAW - Sabiha Gokcen/Istanbul TR',
                  'SBA - Santa Barbara CA US',
                  'SBH - St Barthelemy GP',
                  'SBN - South Bend IN US',
                  'SBP - San Luis Obispo CA US',
                  'SBW - Sibu MY',
                  'SBY - Salisbury/Ocean City MD US',
                  'SBZ - Sibiu RO',
                  'SCC - Prudhoe Bay/Deadhorse AK US',
                  'SCE - State College PA US',
                  'SCL - Santiago CL',
                  'SCN - Saarbruecken DE',
                  'SCQ - Santiago De Compostela ES',
                  'SCV - Suceava RO',
                  'SCW - Syktyvkar RU',
                  'SCX - Salina Cruz MX',
                  'SCZ - Santa Cruz Is SB',
                  'SDE - Santiago Del Estero SE AR',
                  'SDF - Louisville KY US',
                  'SDJ - Sendai JP',
                  'SDK - Sandakan MY',
                  'SDL - Sundsvall SE',
                  'SDN - Sandane NO',
                  'SDP - Sand Pt AK US',
                  'SDQ - Santo Domingo DO',
                  'SDR - Santander ES',
                  'SDU - Rio De Janeiro-Santos Dumont RJ BR',
                  'SDV - Tel Aviv Yafo-Sde Dov IL',
                  'SDY - Sidney MT US',
                  'SEA - Seattle/Tacoma WA US',
                  'SEN - Southend Muni GB',
                  'SEZ - Mahe Is. Seychelles SC',
                  'SFJ - Kangerlussuaq GL',
                  'SFN - Santa Fe SF AR',
                  'SFO - San Francisco CA US',
                  'SFQ - Sanliurfa TR',
                  'SFT - Skelleftea SE',
                  'SGC - Surgut RU',
                  'SGD - Sonderborg DK',
                  'SGE - Siegen Siegerland DE',
                  'SGF - Springfield MO US',
                  'SGN - Ho Chi Minh City VN',
                  'SGO - St George QL AU',
                  'SGU - St George UT US',
                  'SHA - Shanghai-Hongqiao CN',
                  'SHB - Nakashibetsu JP',
                  'SHD - Staunton VA US',
                  'SHE - Shenyang CN',
                  'SHJ - Sharjah AE',
                  'SHM - Shirahama JP',
                  'SHR - Sheridan WY US',
                  'SHV - Shreveport LA US',
                  'SHW - Sharurah SA',
                  'SID - Sal CV',
                  'SIN - Singapore SG',
                  'SIP - Simferopol UA',
                  'SIR - Sion CH',
                  'SIT - Sitka AK US',
                  'SJC - San Jose CA US',
                  'SJD - Los Cabos MX',
                  'SJJ - Sarajevo BA',
                  'SJO - San Jose CR',
                  'SJT - San Angelo TX US',
                  'SJU - San Juan PR',
                  'SJY - Seinajoki FI',
                  'SKB - St Kitts KN',
                  'SKD - Samarkand UZ',
                  'SKE - Skien NO',
                  'SKG - Thessaloniki GR',
                  'SKN - Stokmarknes NO',
                  'SKP - Skopje MK',
                  'SKU - Skiros GR',
                  'SKX - Saransk RU',
                  'SLA - Salta SA AR',
                  'SLC - Salt Lake City UT US',
                  'SLD - Sliac SK',
                  'SLK - Saranac NY US',
                  'SLL - Salalah OM',
                  'SLN - Salina KS US',
                  'SLP - San Luis Potosi MX',
                  'SLU - St Lucia-Vigie LC',
                  'SLW - Saltillo MX',
                  'SLY - Salehard RU',
                  'SLZ - Sao Luiz MA BR',
                  'SMA - Santa Maria Vila Do Porto PT',
                  'SMF - Sacramento CA US',
                  'SMI - Samos GR',
                  'SML - Stella Maris Estate BS',
                  'SMR - Santa Marta CO',
                  'SMX - Santa Maria CA US',
                  'SNA - Orange County CA US',
                  'SNN - Shannon IE',
                  'SNP - St Paul Is. AK US',
                  'SOB - Saarmelleek/Balaton HU',
                  'SOF - Sofia BG',
                  'SOG - Sogndal NO',
                  'SOJ - Sorkjosen NO',
                  'SOU - Southampton GB',
                  'SOW - Show Low AZ US',
                  'SPC - Santa Cruz De La Palma ES',
                  'SPI - Springfield IL US',
                  'SPN - Saipan MP',
                  'SPS - Wichita Falls TX US',
                  'SPU - Split HR',
                  'SQO - Storuman SE',
                  'SRP - Stord NO',
                  'SRQ - Bradenton FL US',
                  'SSA - Salvador BA BR',
                  'SSG - Malabo GQ',
                  'SSH - Sharm El Sheikh EG',
                  'SSJ - Sandnessjoen NO',
                  'STC - St Cloud MN US',
                  'STG - St George Is. AK US',
                  'STI - Santiago DO',
                  'STL - St Louis MO US',
                  'STN - London-Stansted GB',
                  'STR - Stuttgart DE',
                  'STT - St Thomas Is. VI',
                  'STX - St Croix Is. VI',
                  'SUB - Surabaya ID',
                  'SUF - Lamezia Terme IT',
                  'SUJ - Satu Mare RO',
                  'SUN - Sun Valley ID US',
                  'SUV - Suva FJ',
                  'SUX - Sioux City IA US',
                  'SVC - Silver City Grant Cty NM US',
                  'SVD - St Vincent VC',
                  'SVG - Stavanger NO',
                  'SVJ - Svolvaer NO',
                  'SVL - Savonlinna FI',
                  'SVO - Moscow-Sheremetyevo RU',
                  'SVQ - Sevilla ES',
                  'SVU - Savusavu FJ',
                  'SVX - Ekaterinburg RU',
                  'SWA - Shantou CN',
                  'SWF - Newburgh NY US',
                  'SXB - Strasbourg FR',
                  'SXF - Berlin-Schoenefeld DE',
                  'SXM - St Maarten AN',
                  'SYD - Sydney NS AU',
                  'SYM - Simao CN',
                  'SYO - Shonai JP',
                  'SYR - Syracuse NY US',
                  'SYX - Sanya CN',
                  'SYY - Stornoway GB',
                  'SYZ - Shiraz IR',
                  'SZF - Samsun TR',
                  'SZG - Salzburg AT',
                  'SZX - Shenzhen CN',
                  'SZZ - Szczecin PL',
                  'TAB - Tobago TT',
                  'TAE - Daegu KR',
                  'TAK - Takamatsu JP',
                  'TAM - Tampico MX',
                  'TAO - Qingdao CN',
                  'TAP - Tapachula MX',
                  'TAS - Tashkent UZ',
                  'TAT - Poprad SK',
                  'TBI - The Bight BS',
                  'TBN - Ft. Leonard Wood MO US',
                  'TBS - Tbilisi GE',
                  'TBU - Nuku\'Alofa TO',
                  'TCB - Treasure Cay BS',
                  'TCO - Tumaco CO',
                  'TCP - Taba Int\'l EG',
                  'TCQ - Tacna PE',
                  'TER - Terceira Is. PT',
                  'TEX - Telluride CO US',
                  'TFN - Tenerife Norte ES',
                  'TFS - Tenerife Sur ES',
                  'TGD - Podgorica CS',
                  'TGG - Kuala Terengganu MY',
                  'TGM - Tirgu Mures RO',
                  'TGU - Tegucigalpa HN',
                  'TGZ - Tuxtla Gutierrez MX',
                  'THE - Teresina PI BR',
                  'THF - Berlin-Tempelhof DE',
                  'THN - Trollhattan SE',
                  'THO - Thorshofn IS',
                  'THR - Tehran IR',
                  'THU - Pituffik GL',
                  'TIA - Tirana Rinas AL',
                  'TIC - Tinak Is. MH',
                  'TIF - Taif SA',
                  'TIJ - Tijuana MX',
                  'TIP - Tripoli LY',
                  'TIU - Timaru NZ',
                  'TIV - Tivat CS',
                  'TIZ - Tari PG',
                  'TJM - Tyumen RU',
                  'TKK - Truk FM',
                  'TKN - Tokunoshima JP',
                  'TKS - Tokushima JP',
                  'TKU - Turku FI',
                  'TLC - Toluca MX',
                  'TLH - Tallahassee FL US',
                  'TLL - Tallinn EE',
                  'TLN - Toulon FR',
                  'TLS - Toulouse FR',
                  'TLV - Tel Aviv Yafo-Ben Gurion IL',
                  'TMM - Tamatave MG',
                  'TMP - Tampere FI',
                  'TMS - Sao Tome ST',
                  'TMU - Tambor CR',
                  'TMW - Tamworth NS AU',
                  'TNA - Jinan CN',
                  'TNG - Tangier MA',
                  'TNO - Tamarindo CR',
                  'TNR - Antananarivo MG',
                  'TOF - Tomsk RU',
                  'TOL - Toledo OH US',
                  'TOS - Tromso NO',
                  'TOY - Toyama JP',
                  'TPA - Tampa FL US',
                  'TPE - Taipei TW',
                  'TPP - Tarapoto PE',
                  'TPQ - Tepic MX',
                  'TPR - Tom Price WA AU',
                  'TRC - Torreon MX',
                  'TRD - Trondheim NO',
                  'TRE - Tiree GB',
                  'TRF - Oslo-Sandefjord NO',
                  'TRG - Tauranga NZ',
                  'TRI - Tri-Cities VA US',
                  'TRN - Turin IT',
                  'TRS - Trieste IT',
                  'TRU - Trujillo PE',
                  'TRV - Thiruvananthapuram IN',
                  'TRW - Tarawa KI',
                  'TRZ - Tiruchirapally IN',
                  'TSE - Astana KZ',
                  'TSF - Venice-Treviso IT',
                  'TSJ - Tsushima JP',
                  'TSN - Tianjin CN',
                  'TSR - Timisoara RO',
                  'TST - Trang TH',
                  'TSV - Townsville QL AU',
                  'TTB - Tortoli Arbatax IT',
                  'TTJ - Tottori JP',
                  'TTQ - Tortuquero CR',
                  'TUC - Tucuman TU AR',
                  'TUF - Tours FR',
                  'TUI - Turaif SA',
                  'TUL - Tulsa OK US',
                  'TUN - Tunis TN',
                  'TUO - Taupo NZ',
                  'TUP - Tupelo MS US',
                  'TUS - Tucson AZ US',
                  'TUU - Tabuk SA',
                  'TVC - Traverse City MI US',
                  'TVF - Thief River Falls MN US',
                  'TVU - Taveuni FJ',
                  'TWB - Toowoomba QL AU',
                  'TWF - Twin Falls ID US',
                  'TWU - Tawau MY',
                  'TXK - Texarkana AR US',
                  'TXL - Berlin-Tegel DE',
                  'TXN - Tunxi CN',
                  'TYN - Taiyuan CN',
                  'TYR - Tyler Pounds TX US',
                  'TYS - Knoxville TN US',
                  'TZN - S Andros BS',
                  'TZX - Trabzon TR',
                  'UAK - Narsarsuaq GL',
                  'UAQ - San Juan SJ AR',
                  'UBJ - Ube JP',
                  'UBP - Ubon Ratchathani TH',
                  'UCT - Ukhta RU',
                  'UFA - Ufa RU',
                  'UIN - Quincy IL US',
                  'UIO - Quito EC',
                  'UIP - Quimper FR',
                  'UIT - Jaluit Is. MH',
                  'UJE - Ujae Is. MH',
                  'UKK - Ust Kamenogorsk KZ',
                  'ULN - Ulaanbaatar MN',
                  'ULP - Quilpie QL AU',
                  'ULY - Ulyanovsk RU',
                  'UMD - Uummannaq GL',
                  'UME - Umea SE',
                  'UNK - Unalakleet AK US',
                  'UPN - Uruapan MX',
                  'URC - Urumqi CN',
                  'URE - Kuressaare EE',
                  'URJ - Uraj RU',
                  'URO - Rouen FR',
                  'URS - Kursk RU',
                  'URT - Surat Thani TH',
                  'URY - Gurayat SA',
                  'USH - Ushuaia TF AR',
                  'USK - Usinsk RU',
                  'USN - Ulsan KR',
                  'UTH - Udon Thani TH',
                  'UTK - Utirik Is. MH',
                  'UTN - Upington ZA',
                  'UTT - Umtata ZA',
                  'UUA - Bugulma RU',
                  'UUD - Ulan-Ude RU',
                  'UUS - Yuzhno RU',
                  'UVF - St Lucia- Hewanorra LC',
                  'VAA - Vaasa FI',
                  'VAI - Vanimo PG',
                  'VAN - Van TR',
                  'VAR - Varna BG',
                  'VAS - Sivas TR',
                  'VAV - Vava\'u Lupepau\'u TO',
                  'VAW - Vardoe NO',
                  'VBS - Verona-Montichiari IT',
                  'VBV - Vanuabalavu FJ',
                  'VBY - Visby SE',
                  'VCE - Venice-Marco Polo IT',
                  'VCT - Victoria TX US',
                  'VDA - Ovda IL',
                  'VDB - Fagernes NO',
                  'VDM - Viedma RN AR',
                  'VDS - Vadso NO',
                  'VDZ - Valdez AK US',
                  'VER - Veracruz MX',
                  'VFA - Victoria Falls ZW',
                  'VGO - Vigo ES',
                  'VHM - Vilhelmina SE',
                  'VIE - Vienna AT',
                  'VIS - Visalia CA US',
                  'VIT - Vitoria. ES',
                  'VIX - Vitoria ES BR',
                  'VKO - Moscow-Vnukovo RU',
                  'VLC - Valencia ES',
                  'VLD - Valdosta GA US',
                  'VLI - Port Vila VU',
                  'VLL - Valladolid ES',
                  'VNO - Vilnius LT',
                  'VOG - Volgograd RU',
                  'VPN - Vopnafjordur IS',
                  'VPS - Ft. Walton Beach FL US',
                  'VQS - Vieques PR',
                  'VRA - Varadero CU',
                  'VRK - Varkaus FI',
                  'VRN - Verona IT',
                  'VSA - Villahermosa MX',
                  'VST - Stockholm-Vasteras SE',
                  'VTE - Vientiane LA',
                  'VUP - Valledupar CO',
                  'VVI - Santa Cruz BO',
                  'VVO - Vladivostok RU',
                  'VXO - Vaxjo SE',
                  'WAE - Wadi Ad Dawasir SA',
                  'WAG - Wanganui NZ',
                  'WAW - Warsaw PL',
                  'WBM - Wapenamanda PG',
                  'WDG - Enid Woodring Mun. OK US',
                  'WDH - Windhoek NA',
                  'WEH - Weihai CN',
                  'WEI - Weipa QL AU',
                  'WGA - Wagga Wagga NS AU',
                  'WGE - Walgett NS AU',
                  'WHK - Whakatane NZ',
                  'WIC - Wick GB',
                  'WIN - Winton QL AU',
                  'WJA - Woja MH',
                  'WJU - WonJu KR',
                  'WKA - Wanaka NZ',
                  'WKJ - Wakkanai JP',
                  'WLG - Wellington NZ',
                  'WNR - Windorah QL AU',
                  'WNZ - Wenzhou CN',
                  'WOL - Wollongong NS AU',
                  'WRE - Whangarei NZ',
                  'WRG - Wrangell SPB AK US',
                  'WRL - Worland WY US',
                  'WRO - Wroclaw PL',
                  'WSZ - Westport NZ',
                  'WTE - Wotje Is. MH',
                  'WTO - Wotho Is. MH',
                  'WUH - Wuhan CN',
                  'WUS - Wuyishan CN',
                  'WVB - Walvis Bay NA',
                  'WWK - Wewak Boram PG',
                  'WXN - Wanxian CN',
                  'WYA - Whyalla SA AU',
                  'WYS - W Yellowstone MT US',
                  'XAP - Chapeco SC BR',
                  'XCH - Christmas Is. CX',
                  'XDB - Lille Rail FR',
                  'XDS - Ottawa Rail ON CA',
                  'XER - Strasbourg Bus FR',
                  'XFN - Xiangfan CN',
                  'XHG - Ottawa Bus ON CA',
                  'XHK - Valence Rail FR',
                  'XIC - Xichang CN',
                  'XIL - Xilinhot CN',
                  'XIY - Xi An CN',
                  'XMN - Xiamen CN',
                  'XNA - Fayetteville AR US',
                  'XNN - Xining CN',
                  'XOP - Poitiers Rail FR',
                  'XPG - Paris-Gare du Nord Rail FR',
                  'XPJ - Montpellier Rail FR',
                  'XQP - Quepos CR',
                  'XRF - Marseille Rail FR',
                  'XRY - Jerez De La Frontera ES',
                  'XSH - Tours Rail FR',
                  'XTG - Thargomindah QL AU',
                  'XYA - Yandina SB',
                  'XYD - Lyon Rail FR',
                  'XZN - Avignon Rail FR',
                  'YAI - Chillan CL',
                  'YAK - Yakutat AK US',
                  'YAM - Sault Ste Marie ON CA',
                  'YAO - Yaounde CM',
                  'YAP - Yap FM',
                  'YBC - Baie Comeau QC CA',
                  'YBG - Bagotville QC CA',
                  'YBL - Campbell River BC CA',
                  'YBP - Yibin CN',
                  'YCD - Nanaimo BC CA',
                  'YCG - Castlegar BC CA',
                  'YCU - Yun Cheng CN',
                  'YDF - Deer Lake NF CA',
                  'YEG - Edmonton AB CA',
                  'YEI - Bursa Yenisehir TR',
                  'YFC - Fredericton NB CA',
                  'YGJ - Yonago JP',
                  'YGK - Kingston ON CA',
                  'YGP - Gaspe QC CA',
                  'YGR - Iles De La Madeleine QC CA',
                  'YHM - Hamilton ON CA',
                  'YHZ - Halifax NS CA',
                  'YKA - Kamloops BC CA',
                  'YKF - Kitchener ON CA',
                  'YKM - Yakima WA US',
                  'YKS - Yakutsk RU',
                  'YLW - Kelowna BC CA',
                  'YMM - Ft. Mcmurray AB CA',
                  'YMT - Chibougamau QC CA',
                  'YNB - Yanbu SA',
                  'YNJ - Yanji CN',
                  'YNT - Yantai CN',
                  'YNY - Yangyang KR',
                  'YOW - Ottawa ON CA',
                  'YPR - Prince Rupert BC CA',
                  'YQB - Quebec QC CA',
                  'YQG - Windsor ON CA',
                  'YQL - Lethbridge AB CA',
                  'YQM - Moncton NB CA',
                  'YQQ - Comox BC CA',
                  'YQR - Regina SK CA',
                  'YQT - Thunder Bay ON CA',
                  'YQU - Grande Prairie AB CA',
                  'YQX - Gander NF CA',
                  'YQY - Sydney NS CA',
                  'YQZ - Quesnel BC CA',
                  'YRJ - Roberval QC CA',
                  'YSB - Sudbury ON CA',
                  'YSJ - St John NB CA',
                  'YTS - Timmins ON CA',
                  'YTZ - Toronto-Island ON CA',
                  'YUL - Montreal-Trudeau QC CA',
                  'YUM - Yuma AZ US',
                  'YUY - Rouyn QC CA',
                  'YVO - Val D\'Or QC CA',
                  'YVR - Vancouver BC CA',
                  'YWG - Winnipeg MB CA',
                  'YWK - Wabush NF CA',
                  'YWL - Williams Lake BC CA',
                  'YXC - Cranbrook BC CA',
                  'YXE - Saskatoon SK CA',
                  'YXH - Medicine Hat AB CA',
                  'YXJ - Ft. St John BC CA',
                  'YXS - Prince George BC CA',
                  'YXT - Terrace BC CA',
                  'YXU - London City ON, CA',
                  'YXX - Abbotsford BC CA',
                  'YXY - Whitehorse YT CA',
                  'YYB - North Bay ON CA',
                  'YYC - Calgary AB CA',
                  'YYD - Smithers BC CA',
                  'YYF - Penticton BC CA',
                  'YYG - Charlottetown PE CA',
                  'YYJ - Victoria BC CA',
                  'YYR - Goose Bay NF CA',
                  'YYT - St John\'s NF CA',
                  'YYY - Mont Joli QC CA',
                  'YYZ - Toronto-Pearson ON CA',
                  'YZP - Sandspit BC CA',
                  'YZR - Sarnia ON CA',
                  'YZV - Sept Iles QC CA',
                  'ZAD - Zadar HR',
                  'ZAG - Zagreb HR',
                  'ZAL - Valdivia CL',
                  'ZAQ - Nuremberg Rail DE',
                  'ZAZ - Zaragoza ES',
                  'ZBF - Bathurst NB CA',
                  'ZBL - Biloela QL AU',
                  'ZCD - Bamberg Off-line Pt DE',
                  'ZCL - Zacatecas MX',
                  'ZCO - Temuco CL',
                  'ZDH - Basel/Mulhouse Rail CH',
                  'ZDJ - Berne Rail CH',
                  'ZDN - Brno Bus CZ',
                  'ZEU - Goettingen Stn DE',
                  'ZFJ - Rennes Rail FR',
                  'ZFQ - Bordeaux Rail FR',
                  'ZFV - Philadelphia Rail PA US',
                  'ZFX - Szczecin Bus PL',
                  'ZID - Aarhus Bus DK',
                  'ZIH - Ixtapa MX',
                  'ZIL - Horsens Bus Svc DK',
                  'ZIM - Odense Bus DK',
                  'ZLN - Le Mans Rail FR',
                  'ZLO - Manzanillo MX',
                  'ZMB - Hamburg Rail DE',
                  'ZMU - Munich HBF Rail DE',
                  'ZNE - Newman WA AU',
                  'ZNZ - Zanzibar TZ',
                  'ZOS - Osorno CL',
                  'ZQN - Queenstown NZ',
                  'ZRH - Zurich CH',
                  'ZSA - San Salvador BS',
                  'ZSE - St Pierre dela Reunion RE',
                  'ZTC - Turin Bus IT',
                  'ZTF - Westchester Rail NY US',
                  'ZTH - Zakinthos Is GR',
                  'ZVE - New Haven Rail CT US',
                  'ZVR - Hanover Rail DE',
                  'ZWI - Wilmington Rail DE US',
                  'ZWS - Stuttgart Rail DE',
                  'ZYL - Sylhet Civil BD',
                  'ZYN - Nimes Rail FR',
                  'ZYR - Brussels Midi Rail BE',
                  'ZYZ - Antwerp Berchem Rail BE',
                  );
  return @airports;
}# _getAirports

1;

=pod

=head1 NAME

Tk::Airports - A widget to select airports

=for category  Tk Widget Classes

=head1 SYNOPSIS

  use Tk;
  use Tk::Airports;
  
  my $mw = MainWindow->new();
  $airport = $mw->Airports(-title => 'AirportsWoldWide');
  my @return_values = $airport->Show();
  # or as one string
  my $return_value = $airport->Show();

=head1 WIDGET-SPECIFIC OPTIONS

=over 4

=item Name:	B<selectMode>

=item Class:	B<SelectMode>

=item Switch:	B<-selectmode>

Specifies one of several styles for manipulating the selection.
The value of the option may be arbitrary, but the default bindings
expect it to be either B<single>, B<multiple> or B<extended>;  
the default value is B<single>.

=item Name:	B<font>

=item Class:	B<Font>

=item Switch:	B<-font>

Specifies the font for the list of Airports. The default font
is "Courier 8"

=item Name:	B<title>

=item Class:	B<Title>

=item Switch:	B<-title>

Specifies the title of the widget.

=item Name:	B<order>

=item Class:	B<Order>

=item Switch:	B<-order>

It is possible to change the order. The list can be ordered by
Airport-Code (B<code>) or by City-Name (B<city>). The default 
value is B<code>.

=item Name:	B<filename>

=item Class:	B<Filename>

=item Switch:	B<-filename>

Specifies a file that contains a user specific set of Airports

=back

=head1 DESCRIPTION

The B<Airports> method creates a new window and shows a list of nearly
all airports. The widget provides several functions:

Search for an airport with the entry at the top of the widget.

The return values are the codes for the airports. In list context a list
with one code per element is returned, in scalar context a string is returned
with "; " as delimiter.


=head1 WIDGET METHODS

The B<Airports> method creates a widget object.
This object supports the B<configure> and B<cget> methods
described in L<Tk::options> which can be used to enquire and
modify the options described above.
The widget also inherits all the methods provided by the generic
L<Tk::Widget|Tk::Widget> class.

=back

=head1 DEFAULT BINDINGS

The following additional behavior is defined by the default bindings:

=over 4

=item [1]

Start the search via E<lt>Return> in the Entry at the top of the
widget.

=item [2]

Return the selected values via E<lt>Return> in the listbox.

=item [3]

Return one selected value via double-clicking the entry in the
listbox.

=back

=head1 BUGS

Please contact me when you have found a bug.

=head1 ToDo

*) translation of cities into national names
*) allow other fonts
*) option for specifying the return values (code,city,all)
*) option for specifying the delimiter

=head1 AUTHOR

Renee Baecker, E<lt>module@renee-baecker.deE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2005 by Renee Baecker

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.6.1 or,
at your option, any later version of Perl 5 you may have available.

=cut
