#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::Yahoo
#     ABSTRACT:  identify Yahoo owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Sun Oct 12 19:32:46 PDT 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::Yahoo;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.054'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known Yahoo IP blocks as of Oct 2014
    $self->ips(qw(
        8.3.34.0/23
        8.8.178.0/24
        27.123.32.0/19
        46.228.32.0/20
        63.250.192.0/19
        64.56.160.0/19
        64.157.4.0/24
        66.94.224.0/19
        66.163.160.0/19
        66.218.64.0/19
        67.28.112.0/22
        67.72.118.0/23
        67.195.0.0/16
        68.180.128.0/17
        69.147.64.0/18
        76.13.0.0/16
        77.238.160.0/19
        87.248.96.0/19
        98.136.0.0/14
        209.191.64.0/18
        216.252.96.0/19
        216.255.224.0/20
        217.12.7.0/24
        217.12.8.0/21
        217.146.176.0/20
        217.163.20.0/23
    ));
    return $self;
}

sub name {
    return 'Yahoo';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::Yahoo - identify Yahoo owned IP addresses

=head1 VERSION

version 0.054

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::Yahoo;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::Yahoo identifies Yahoo host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::Yahoo object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

103.2.12.0/24
106.10.128.0/18
106.10.192.0/19
111.67.224.0/19
114.141.40.0/21
115.178.0.0/23
115.178.2.0/23
115.178.4.0/23
115.178.6.0/23
115.178.8.0/23
116.214.0.0/20
117.104.190.0/24
117.104.191.0/24
118.151.224.0/19
119.160.240.0/20
119.161.0.0/19
121.101.144.0/24
123.0.0.0/24
123.0.1.0/24
124.108.64.0/21
124.108.80.0/22
124.108.86.0/23
124.108.90.0/23
124.108.92.0/22
124.108.96.0/22
124.108.96.0/23
124.108.96.0/24
124.108.98.0/23
180.222.97.0/24
180.222.98.0/24
180.233.112.0/22
180.233.116.0/24
180.233.117.0/24
180.233.118.0/24
180.233.119.0/24
182.22.0.0/17
183.177.64.0/22
183.177.68.0/22
183.177.80.0/23
183.177.84.0/22
183.177.88.0/23
183.177.94.0/23
183.79.0.0/16
183.79.28.0/23
183.79.56.0/23
184.165.0.0/16
188.125.64.0/21
188.125.72.0/21
188.125.80.0/21
188.125.80.0/24
188.125.88.0/22
188.125.92.0/24
188.125.94.0/24
188.125.95.0/24
189.125.135.0/24
193.93.196.0/24
193.93.197.0/24
193.93.198.0/24
194.88.69.0/24
202.160.176.0/20
202.171.234.0/24
202.174.4.0/24
202.4.164.0/24
202.43.192.0/21
202.46.19.0/24
202.86.4.0/22
202.86.6.0/23
203.110.236.0/24
203.110.237.0/24
203.110.238.0/24
203.110.239.0/24
203.14.212.0/24
203.141.32.0/20
203.145.224.0/19
203.188.192.0/21
203.188.200.0/22
203.188.204.0/22
203.188.204.0/23
203.188.206.0/23
203.216.128.0/20
203.216.144.0/20
203.83.216.0/23
203.95.16.0/24
203.99.254.0/24
206.190.32.0/20
206.190.48.0/21
206.190.52.0/22
206.190.56.0/22
206.190.60.0/22
206.3.0.0/19
207.126.224.0/20
208.67.64.0/21
208.67.66.0/23
208.71.40.0/21
209.131.32.0/20
209.131.50.0/23
209.131.52.0/23
209.131.54.0/23
209.131.56.0/24
209.131.57.0/24
209.131.58.0/24
209.131.59.0/24
209.131.60.0/23
209.131.61.0/24
209.131.62.0/24
209.191.64.0/18
209.191.95.0/24
209.191.96.0/24
211.14.12.0/22
211.14.20.0/22
212.82.100.0/22
212.82.102.0/24
212.82.104.0/21
212.82.112.0/20
212.82.118.0/23
212.82.96.0/22
212.82.98.0/23
216.115.103.0/24
216.115.96.0/20
216.145.48.0/20
216.155.192.0/20

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
