package Forms::Sflang_dbc;

use strict;
use warnings;

use Wx::Perl::DbLinker::Wxform;

use Gtk2::Ex::DbLinker::DbcDataManager;
use Data::Dumper;
use Wx_dnav;

use Wx::Event qw[EVT_TEXT EVT_COMBOBOX];
#EVT_LIST_ITEM_SELECTED EVT_COMBOBOX EVT_LISTBOX EVT_CHECKBOX EVT_BUTTON];

use Wx qw[:everything];

sub new {
	 my ( $class, $href ) = @_;

	  my $self = {
   	xrcfolder => $$href{xrcfolder},
	schema => $$href{schema},
	dnav => $$href{dnav},
	panel_to => $$href{panel_to},
	countryid => $$href{countryid},
   };

    $self->{log} = Log::Log4perl->get_logger(__PACKAGE__);
$self->{log}->debug(" new form ");

	my $top_panel = $self->{dnav}->load_panel($self->{panel_to}, 'xrc/nav.xrc', 'm_dnav_panel');

 my $path = $self->{xrcfolder} .  "\\subform.xrc";
  $self->{dnav} = Wx_dnav->new({ismain=>0, frame=> $top_panel}); 


  $self->{dnav}->load_panel("m_panel_for_content", $path,  "m_panel1"); 

 



   #$self->{dnav}->connect_signals($self);


	my $rs = $self->{schema}->resultset('Speak')->search_rs({countryid => $self->{countryid}}, {columns => ['countryid', 'langid', {langid1 => 'langid'}]});
# (Dumper $rs->as_query);
	my $dman = Gtk2::Ex::DbLinker::DbcDataManager->new({
			rs => $rs,
			});
#print "Row_count " .  $dman->row_count;		
#$dman->first;
#$dman->get_field('langid1');

	$self->{sform} = Wx::Perl::DbLinker::Wxform->new({
		data_manager => $dman,
		builder => $self->{dnav},
		datawidgets => [qw(countryid langid langid1)],
		rec_spinner => $self->{dnav}->get_object('RecordSpinner'),
	    	status_label=>  $self->{dnav}->get_object('lbl_RecordStatus'),
		rec_count_label => $self->{dnav}->get_object("lbl_RecordCount"),
		datawidgets_ro => [qw(langid1)],
		datawidgets_changed => {langid1=> sub{ on_langid_changed(@_, $self) } },
			});

	# $self->{dnav}->set_form($self->{sform});


#	 $sf_dnav->connect_signal_for("langid", \&on_langid_changed, $self);
#my $w =  $self->{dnav}->get_object('langid');
#EVT_COMBOBOX($top_panel, $w, sub {print "evt_Combo\n";});
# my $w =  $self->{dnav}->get_object('langid');
# on_langid_changed($w, $self, @_);
#EVT_TEXT($top_panel, $w, sub{ print "evt_text_from_combo\n"; });
#die unless defined $sf_dnav->get_object('langid2');
		my $combodata = Gtk2::Ex::DbLinker::DbcDataManager->new({
				rs => $self->{schema}->resultset('Langue')->search_rs(undef, {order_by => 'langue' }),
				#{columns => ['langue', {langid2 => 'langid'}],
			});
		
		$self->{sform}->add_combo({
			data_manager => $combodata,
		    	id => 'langid',
			builder => $self->{dnav},
			});
		#fields => [qw(langid langue)],


		$self->{langid} = $self->{sform}->get_data_manager->get_field('langid1');
		my $list =  Gtk2::Ex::DbLinker::DbcDataManager->new({
				rs => $self->{schema}->resultset('Speak')->search_rs({langid => $self->{langid}, countryid => {'!=' => $self->{countryid} }}),
			});

		 $combodata = Gtk2::Ex::DbLinker::DbcDataManager->new({
				rs => $self->{schema}->resultset('Country')->search_rs(undef, { order_by => 'country'} ),
			});


		#set up the datasheet
		#$top_panel = $self->{dnav}->load_panel('m_panel_for_grid', 'xrc/nav.xrc', 'm_dnav_panel');
		$top_panel = $self->{dnav}->load_panel('m_panel_for_grid', 'xrc/nav.xrc', 'm_dnav_panel');
		#fieldnames => ["countryid", "country"],
		#  renderer => "combo",	header_markup => "Country", data_manager=> $combodata, fieldnames => ["countryid", "country"],
		my $dsparam = {
			data_manager => $list,
			fields => [
				{name=>"countryid",
					renderer => "combo",	header_markup => "Country", data_manager=> $combodata, fieldnames => ["countryid", "country"],
					},	
				   {name=>"langid", renderer=>"hidden"},
				
		        	],
		
		};

		#my $grid = $self->{dnav}->load_grid({ top_panel=> $top_panel, dest_name=>"m_panel_for_content", datasheet_param =>$dsparam});
		$self->{sf_list} = $self->{dnav}->load_grid({ top_panel=> $top_panel, dest_name=>"m_panel_for_content", datasheet_param =>$dsparam});

		$self->{sf_list}->{dnav} = Wx_dnav->new({ismain=>0, frame => $top_panel});

	        $self->{sf_list}->{dnav}->set_form($self->{sf_list});

		$self->{sf_list}->{dnav}->connect_signal_for("b_add",\&on_add_lst_clicked, $self);

		$self->{sf_list}->update;

		 $self->{sform}->add_childform($self->{sf_list});

		 # on_countryid_changed($self, $self->{sform}->get_widget_value('countryid'));
		 # $sf_dnav->show_all_except([]);
		 

   $self->{dnav}->connect_signal_for("b_add", \&on_badd_clicked, $self );
   $self->{dnav}->connect_signal_for("b_delete", \&on_delete_clicked, $self );
   $self->{dnav}->connect_signal_for("b_apply", \&on_apply_clicked, $self );

		$self->{sform}->update;
		bless $self, $class;

}

sub on_countryid_changed {
	 my ($self,$value) = @_;
	return if ($value == $$self{countryid});
	$self->{log}->debug("sf_langues: countryid_changed $value");
	$self->{countryid}=$value;

	#die($value);
	$self->{sform}->get_data_manager->query( $self->{schema}->resultset('Speak')->search_rs({ countryid => $value},  {columns => ['countryid', 'langid', {langid1 => 'langid'}]}) );
	# Rdb::Speak::Manager->get_speaks(query => [countryid =>{ eq => $value } ]) 
	$self->{sform}->update;
	$value = $self->{sform}->get_widget_value("langid");
	$self->{log}->debug("sf_langues: langid changed $value");
	
	$self->{sf_list}->get_data_manager->query(  $self->{schema}->resultset('Speak')->search_rs({langid => $value, countryid => {'!=' => $self->{countryid}} }) );
	# Rdb::Speak::Manager->get_speaks(query => [ langid => { eq => $value }, countryid => {ne => $self->{countryid}} ] ) 
	$self->{sf_list}->update;
	


}

sub on_langid_changed {
	my ($b, $e, $self) = @_;
	$self->{log}->debug("sf_langues: langid_changed");
	#print Dumper($b);
	my $value = $b->GetLineText(0);
	if ($value) {
		$self->{log}->debug("sf_langues: langid_changed $value");
		$self->{langid} = $value;
		$self->{sf_list}->get_data_manager->query( $self->{schema}->resultset('Speak')->search_rs({langid => $value, countryid => {'!=' => $self->{countryid}} })  );
		# Rdb::Speak::Manager->get_speaks(query => [ langid => { eq => $value }, countryid => {ne => $self->{countryid}} ] ) );
		$self->{sf_list}->update;
	}
}

sub on_delete_clicked {
    my ($b, $self) =@_;
    $self->{sform}->delete;
}

sub on_badd_clicked {
    my ($b, $self) = @_;
    #die Dumper ($self->{countryid});
    $self->{sform}->insert;
    $self->{sform}->set_widget_value("countryid",$self->{countryid});
    
}


sub on_apply_clicked {
    my ($b, $self) = @_;
    $self->{log}->debug("sform_apply country : " . $self->{countryid} . " langue : " . $self->{langid} );
    $self->{sform}->apply;
}



sub on_add_lst_clicked {
	my ($b, $self) = @_;
	# $self->{sform}->get_widget_value("langid");
	#ajoute une ligne vide qu'il faut completer avec le pays
	$self->{sf_list}->insert($self->{sf_list}->colnumber_from_name("langid") =>  $self->{sform}->get_widget_value("langid"));
	

}


1;
