package PDF::Builder::Resource::Font::CoreFont::courierbold;

use strict;
use warnings;

our $VERSION = '3.012'; # VERSION
my $LAST_UPDATE = '2.029'; # manually update whenever code is changed

=head1 NAME

PDF::Builder::Resource::Font::CoreFont::courierbold - font-specific information for bold weight Courier font

=cut

sub data { return {
    'fontname' => 'Courier-Bold',
    'type' => 'Type1',
    'apiname' => 'CoBo',
    'ascender' => '629',
    'capheight' => '562',
    'descender' => '-157',
    'iscore' => '1',
    'isfixedpitch' => '1',
    'italicangle' => '0',
    'missingwidth' => '600',
    'stdhw' => '84',
    'stdvw' => '106',
    'underlineposition' => '-100',
    'underlinethickness' => '50',
    'xheight' => '439',
    'firstchar' => '32',
    'lastchar' => '255',
    'char' => [ # DEF. ENCODING GLYPH TABLE
        '.notdef',                               # C+0x00 # U+0x0000
        '.notdef',                               # C+0x01 # U+0x0000
        '.notdef',                               # C+0x02 # U+0x0000
        '.notdef',                               # C+0x03 # U+0x0000
        '.notdef',                               # C+0x04 # U+0x0000
        '.notdef',                               # C+0x05 # U+0x0000
        '.notdef',                               # C+0x06 # U+0x0000
        '.notdef',                               # C+0x07 # U+0x0000
        '.notdef',                               # C+0x08 # U+0x0000
        '.notdef',                               # C+0x09 # U+0x0000
        '.notdef',                               # C+0x0A # U+0x0000
        '.notdef',                               # C+0x0B # U+0x0000
        '.notdef',                               # C+0x0C # U+0x0000
        '.notdef',                               # C+0x0D # U+0x0000
        '.notdef',                               # C+0x0E # U+0x0000
        '.notdef',                               # C+0x0F # U+0x0000
        '.notdef',                               # C+0x10 # U+0x0000
        '.notdef',                               # C+0x11 # U+0x0000
        '.notdef',                               # C+0x12 # U+0x0000
        '.notdef',                               # C+0x13 # U+0x0000
        '.notdef',                               # C+0x14 # U+0x0000
        '.notdef',                               # C+0x15 # U+0x0000
        '.notdef',                               # C+0x16 # U+0x0000
        '.notdef',                               # C+0x17 # U+0x0000
        '.notdef',                               # C+0x18 # U+0x0000
        '.notdef',                               # C+0x19 # U+0x0000
        '.notdef',                               # C+0x1A # U+0x0000
        '.notdef',                               # C+0x1B # U+0x0000
        '.notdef',                               # C+0x1C # U+0x0000
        '.notdef',                               # C+0x1D # U+0x0000
        '.notdef',                               # C+0x1E # U+0x0000
        '.notdef',                               # C+0x1F # U+0x0000
        'space',                                 # C+0x20 # U+0x0020
        'exclam',                                # C+0x21 # U+0x0021
        'quotedbl',                              # C+0x22 # U+0x0022
        'numbersign',                            # C+0x23 # U+0x0023
        'dollar',                                # C+0x24 # U+0x0024
        'percent',                               # C+0x25 # U+0x0025
        'ampersand',                             # C+0x26 # U+0x0026
        'quotesingle',                           # C+0x27 # U+0x0027
        'parenleft',                             # C+0x28 # U+0x0028
        'parenright',                            # C+0x29 # U+0x0029
        'asterisk',                              # C+0x2A # U+0x002A
        'plus',                                  # C+0x2B # U+0x002B
        'comma',                                 # C+0x2C # U+0x002C
        'hyphen',                                # C+0x2D # U+0x002D
        'period',                                # C+0x2E # U+0x002E
        'slash',                                 # C+0x2F # U+0x002F
        'zero',                                  # C+0x30 # U+0x0030
        'one',                                   # C+0x31 # U+0x0031
        'two',                                   # C+0x32 # U+0x0032
        'three',                                 # C+0x33 # U+0x0033
        'four',                                  # C+0x34 # U+0x0034
        'five',                                  # C+0x35 # U+0x0035
        'six',                                   # C+0x36 # U+0x0036
        'seven',                                 # C+0x37 # U+0x0037
        'eight',                                 # C+0x38 # U+0x0038
        'nine',                                  # C+0x39 # U+0x0039
        'colon',                                 # C+0x3A # U+0x003A
        'semicolon',                             # C+0x3B # U+0x003B
        'less',                                  # C+0x3C # U+0x003C
        'equal',                                 # C+0x3D # U+0x003D
        'greater',                               # C+0x3E # U+0x003E
        'question',                              # C+0x3F # U+0x003F
        'at',                                    # C+0x40 # U+0x0040
        'A',                                     # C+0x41 # U+0x0041
        'B',                                     # C+0x42 # U+0x0042
        'C',                                     # C+0x43 # U+0x0043
        'D',                                     # C+0x44 # U+0x0044
        'E',                                     # C+0x45 # U+0x0045
        'F',                                     # C+0x46 # U+0x0046
        'G',                                     # C+0x47 # U+0x0047
        'H',                                     # C+0x48 # U+0x0048
        'I',                                     # C+0x49 # U+0x0049
        'J',                                     # C+0x4A # U+0x004A
        'K',                                     # C+0x4B # U+0x004B
        'L',                                     # C+0x4C # U+0x004C
        'M',                                     # C+0x4D # U+0x004D
        'N',                                     # C+0x4E # U+0x004E
        'O',                                     # C+0x4F # U+0x004F
        'P',                                     # C+0x50 # U+0x0050
        'Q',                                     # C+0x51 # U+0x0051
        'R',                                     # C+0x52 # U+0x0052
        'S',                                     # C+0x53 # U+0x0053
        'T',                                     # C+0x54 # U+0x0054
        'U',                                     # C+0x55 # U+0x0055
        'V',                                     # C+0x56 # U+0x0056
        'W',                                     # C+0x57 # U+0x0057
        'X',                                     # C+0x58 # U+0x0058
        'Y',                                     # C+0x59 # U+0x0059
        'Z',                                     # C+0x5A # U+0x005A
        'bracketleft',                           # C+0x5B # U+0x005B
        'backslash',                             # C+0x5C # U+0x005C
        'bracketright',                          # C+0x5D # U+0x005D
        'asciicircum',                           # C+0x5E # U+0x005E
        'underscore',                            # C+0x5F # U+0x005F
        'grave',                                 # C+0x60 # U+0x0060
        'a',                                     # C+0x61 # U+0x0061
        'b',                                     # C+0x62 # U+0x0062
        'c',                                     # C+0x63 # U+0x0063
        'd',                                     # C+0x64 # U+0x0064
        'e',                                     # C+0x65 # U+0x0065
        'f',                                     # C+0x66 # U+0x0066
        'g',                                     # C+0x67 # U+0x0067
        'h',                                     # C+0x68 # U+0x0068
        'i',                                     # C+0x69 # U+0x0069
        'j',                                     # C+0x6A # U+0x006A
        'k',                                     # C+0x6B # U+0x006B
        'l',                                     # C+0x6C # U+0x006C
        'm',                                     # C+0x6D # U+0x006D
        'n',                                     # C+0x6E # U+0x006E
        'o',                                     # C+0x6F # U+0x006F
        'p',                                     # C+0x70 # U+0x0070
        'q',                                     # C+0x71 # U+0x0071
        'r',                                     # C+0x72 # U+0x0072
        's',                                     # C+0x73 # U+0x0073
        't',                                     # C+0x74 # U+0x0074
        'u',                                     # C+0x75 # U+0x0075
        'v',                                     # C+0x76 # U+0x0076
        'w',                                     # C+0x77 # U+0x0077
        'x',                                     # C+0x78 # U+0x0078
        'y',                                     # C+0x79 # U+0x0079
        'z',                                     # C+0x7A # U+0x007A
        'braceleft',                             # C+0x7B # U+0x007B
        'bar',                                   # C+0x7C # U+0x007C
        'braceright',                            # C+0x7D # U+0x007D
        'asciitilde',                            # C+0x7E # U+0x007E
        'bullet',                                # C+0x7F # U+0x2022
        'Euro',                                  # C+0x80 # U+0x20AC
        'bullet',                                # C+0x81 # U+0x2022
        'quotesinglbase',                        # C+0x82 # U+0x201A
        'florin',                                # C+0x83 # U+0x0192
        'quotedblbase',                          # C+0x84 # U+0x201E
        'ellipsis',                              # C+0x85 # U+0x2026
        'dagger',                                # C+0x86 # U+0x2020
        'daggerdbl',                             # C+0x87 # U+0x2021
        'circumflex',                            # C+0x88 # U+0x02C6
        'perthousand',                           # C+0x89 # U+0x2030
        'Scaron',                                # C+0x8A # U+0x0160
        'guilsinglleft',                         # C+0x8B # U+0x2039
        'OE',                                    # C+0x8C # U+0x0152
        'bullet',                                # C+0x8D # U+0x2022
        'Zcaron',                                # C+0x8E # U+0x017D
        'bullet',                                # C+0x8F # U+0x2022
        'bullet',                                # C+0x90 # U+0x2022
        'quoteleft',                             # C+0x91 # U+0x2018
        'quoteright',                            # C+0x92 # U+0x2019
        'quotedblleft',                          # C+0x93 # U+0x201C
        'quotedblright',                         # C+0x94 # U+0x201D
        'bullet',                                # C+0x95 # U+0x2022
        'endash',                                # C+0x96 # U+0x2013
        'emdash',                                # C+0x97 # U+0x2014
        'tilde',                                 # C+0x98 # U+0x02DC
        'trademark',                             # C+0x99 # U+0x2122
        'scaron',                                # C+0x9A # U+0x0161
        'guilsinglright',                        # C+0x9B # U+0x203A
        'oe',                                    # C+0x9C # U+0x0153
        'bullet',                                # C+0x9D # U+0x2022
        'zcaron',                                # C+0x9E # U+0x017E
        'Ydieresis',                             # C+0x9F # U+0x0178
        'space',                                 # C+0xA0 # U+0x0020
        'exclamdown',                            # C+0xA1 # U+0x00A1
        'cent',                                  # C+0xA2 # U+0x00A2
        'sterling',                              # C+0xA3 # U+0x00A3
        'currency',                              # C+0xA4 # U+0x00A4
        'yen',                                   # C+0xA5 # U+0x00A5
        'brokenbar',                             # C+0xA6 # U+0x00A6
        'section',                               # C+0xA7 # U+0x00A7
        'dieresis',                              # C+0xA8 # U+0x00A8
        'copyright',                             # C+0xA9 # U+0x00A9
        'ordfeminine',                           # C+0xAA # U+0x00AA
        'guillemotleft',                         # C+0xAB # U+0x00AB
        'logicalnot',                            # C+0xAC # U+0x00AC
        'hyphen',                                # C+0xAD # U+0x002D
        'registered',                            # C+0xAE # U+0x00AE
        'macron',                                # C+0xAF # U+0x00AF
        'degree',                                # C+0xB0 # U+0x00B0
        'plusminus',                             # C+0xB1 # U+0x00B1
        'twosuperior',                           # C+0xB2 # U+0x00B2
        'threesuperior',                         # C+0xB3 # U+0x00B3
        'acute',                                 # C+0xB4 # U+0x00B4
        'mu',                                    # C+0xB5 # U+0x00B5
        'paragraph',                             # C+0xB6 # U+0x00B6
        'periodcentered',                        # C+0xB7 # U+0x00B7
        'cedilla',                               # C+0xB8 # U+0x00B8
        'onesuperior',                           # C+0xB9 # U+0x00B9
        'ordmasculine',                          # C+0xBA # U+0x00BA
        'guillemotright',                        # C+0xBB # U+0x00BB
        'onequarter',                            # C+0xBC # U+0x00BC
        'onehalf',                               # C+0xBD # U+0x00BD
        'threequarters',                         # C+0xBE # U+0x00BE
        'questiondown',                          # C+0xBF # U+0x00BF
        'Agrave',                                # C+0xC0 # U+0x00C0
        'Aacute',                                # C+0xC1 # U+0x00C1
        'Acircumflex',                           # C+0xC2 # U+0x00C2
        'Atilde',                                # C+0xC3 # U+0x00C3
        'Adieresis',                             # C+0xC4 # U+0x00C4
        'Aring',                                 # C+0xC5 # U+0x00C5
        'AE',                                    # C+0xC6 # U+0x00C6
        'Ccedilla',                              # C+0xC7 # U+0x00C7
        'Egrave',                                # C+0xC8 # U+0x00C8
        'Eacute',                                # C+0xC9 # U+0x00C9
        'Ecircumflex',                           # C+0xCA # U+0x00CA
        'Edieresis',                             # C+0xCB # U+0x00CB
        'Igrave',                                # C+0xCC # U+0x00CC
        'Iacute',                                # C+0xCD # U+0x00CD
        'Icircumflex',                           # C+0xCE # U+0x00CE
        'Idieresis',                             # C+0xCF # U+0x00CF
        'Eth',                                   # C+0xD0 # U+0x00D0
        'Ntilde',                                # C+0xD1 # U+0x00D1
        'Ograve',                                # C+0xD2 # U+0x00D2
        'Oacute',                                # C+0xD3 # U+0x00D3
        'Ocircumflex',                           # C+0xD4 # U+0x00D4
        'Otilde',                                # C+0xD5 # U+0x00D5
        'Odieresis',                             # C+0xD6 # U+0x00D6
        'multiply',                              # C+0xD7 # U+0x00D7
        'Oslash',                                # C+0xD8 # U+0x00D8
        'Ugrave',                                # C+0xD9 # U+0x00D9
        'Uacute',                                # C+0xDA # U+0x00DA
        'Ucircumflex',                           # C+0xDB # U+0x00DB
        'Udieresis',                             # C+0xDC # U+0x00DC
        'Yacute',                                # C+0xDD # U+0x00DD
        'Thorn',                                 # C+0xDE # U+0x00DE
        'germandbls',                            # C+0xDF # U+0x00DF
        'agrave',                                # C+0xE0 # U+0x00E0
        'aacute',                                # C+0xE1 # U+0x00E1
        'acircumflex',                           # C+0xE2 # U+0x00E2
        'atilde',                                # C+0xE3 # U+0x00E3
        'adieresis',                             # C+0xE4 # U+0x00E4
        'aring',                                 # C+0xE5 # U+0x00E5
        'ae',                                    # C+0xE6 # U+0x00E6
        'ccedilla',                              # C+0xE7 # U+0x00E7
        'egrave',                                # C+0xE8 # U+0x00E8
        'eacute',                                # C+0xE9 # U+0x00E9
        'ecircumflex',                           # C+0xEA # U+0x00EA
        'edieresis',                             # C+0xEB # U+0x00EB
        'igrave',                                # C+0xEC # U+0x00EC
        'iacute',                                # C+0xED # U+0x00ED
        'icircumflex',                           # C+0xEE # U+0x00EE
        'idieresis',                             # C+0xEF # U+0x00EF
        'eth',                                   # C+0xF0 # U+0x00F0
        'ntilde',                                # C+0xF1 # U+0x00F1
        'ograve',                                # C+0xF2 # U+0x00F2
        'oacute',                                # C+0xF3 # U+0x00F3
        'ocircumflex',                           # C+0xF4 # U+0x00F4
        'otilde',                                # C+0xF5 # U+0x00F5
        'odieresis',                             # C+0xF6 # U+0x00F6
        'divide',                                # C+0xF7 # U+0x00F7
        'oslash',                                # C+0xF8 # U+0x00F8
        'ugrave',                                # C+0xF9 # U+0x00F9
        'uacute',                                # C+0xFA # U+0x00FA
        'ucircumflex',                           # C+0xFB # U+0x00FB
        'udieresis',                             # C+0xFC # U+0x00FC
        'yacute',                                # C+0xFD # U+0x00FD
        'thorn',                                 # C+0xFE # U+0x00FE
        'ydieresis',                             # C+0xFF # U+0x00FF
    ], # DEF. ENCODING GLYPH TABLE
    'fontbbox' => [ -113, -250, 749, 801 ],
    'wx' => { # HORIZ. WIDTH TABLE
        'space' => '600',                        # C+0x20 # U+0x0020
        'exclam' => '600',                       # C+0x21 # U+0x0021
        'quotedbl' => '600',                     # C+0x22 # U+0x0022
        'numbersign' => '600',                   # C+0x23 # U+0x0023
        'dollar' => '600',                       # C+0x24 # U+0x0024
        'percent' => '600',                      # C+0x25 # U+0x0025
        'ampersand' => '600',                    # C+0x26 # U+0x0026
        'quotesingle' => '600',                  # C+0x27 # U+0x0027
        'parenleft' => '600',                    # C+0x28 # U+0x0028
        'parenright' => '600',                   # C+0x29 # U+0x0029
        'asterisk' => '600',                     # C+0x2A # U+0x002A
        'plus' => '600',                         # C+0x2B # U+0x002B
        'comma' => '600',                        # C+0x2C # U+0x002C
        'hyphen' => '600',                       # C+0x2D # U+0x002D
        'period' => '600',                       # C+0x2E # U+0x002E
        'slash' => '600',                        # C+0x2F # U+0x002F
        'zero' => '600',                         # C+0x30 # U+0x0030
        'one' => '600',                          # C+0x31 # U+0x0031
        'two' => '600',                          # C+0x32 # U+0x0032
        'three' => '600',                        # C+0x33 # U+0x0033
        'four' => '600',                         # C+0x34 # U+0x0034
        'five' => '600',                         # C+0x35 # U+0x0035
        'six' => '600',                          # C+0x36 # U+0x0036
        'seven' => '600',                        # C+0x37 # U+0x0037
        'eight' => '600',                        # C+0x38 # U+0x0038
        'nine' => '600',                         # C+0x39 # U+0x0039
        'colon' => '600',                        # C+0x3A # U+0x003A
        'semicolon' => '600',                    # C+0x3B # U+0x003B
        'less' => '600',                         # C+0x3C # U+0x003C
        'equal' => '600',                        # C+0x3D # U+0x003D
        'greater' => '600',                      # C+0x3E # U+0x003E
        'question' => '600',                     # C+0x3F # U+0x003F
        'at' => '600',                           # C+0x40 # U+0x0040
        'A' => '600',                            # C+0x41 # U+0x0041
        'B' => '600',                            # C+0x42 # U+0x0042
        'C' => '600',                            # C+0x43 # U+0x0043
        'D' => '600',                            # C+0x44 # U+0x0044
        'E' => '600',                            # C+0x45 # U+0x0045
        'F' => '600',                            # C+0x46 # U+0x0046
        'G' => '600',                            # C+0x47 # U+0x0047
        'H' => '600',                            # C+0x48 # U+0x0048
        'I' => '600',                            # C+0x49 # U+0x0049
        'J' => '600',                            # C+0x4A # U+0x004A
        'K' => '600',                            # C+0x4B # U+0x004B
        'L' => '600',                            # C+0x4C # U+0x004C
        'M' => '600',                            # C+0x4D # U+0x004D
        'N' => '600',                            # C+0x4E # U+0x004E
        'O' => '600',                            # C+0x4F # U+0x004F
        'P' => '600',                            # C+0x50 # U+0x0050
        'Q' => '600',                            # C+0x51 # U+0x0051
        'R' => '600',                            # C+0x52 # U+0x0052
        'S' => '600',                            # C+0x53 # U+0x0053
        'T' => '600',                            # C+0x54 # U+0x0054
        'U' => '600',                            # C+0x55 # U+0x0055
        'V' => '600',                            # C+0x56 # U+0x0056
        'W' => '600',                            # C+0x57 # U+0x0057
        'X' => '600',                            # C+0x58 # U+0x0058
        'Y' => '600',                            # C+0x59 # U+0x0059
        'Z' => '600',                            # C+0x5A # U+0x005A
        'bracketleft' => '600',                  # C+0x5B # U+0x005B
        'backslash' => '600',                    # C+0x5C # U+0x005C
        'bracketright' => '600',                 # C+0x5D # U+0x005D
        'asciicircum' => '600',                  # C+0x5E # U+0x005E
        'underscore' => '600',                   # C+0x5F # U+0x005F
        'grave' => '600',                        # C+0x60 # U+0x0060
        'a' => '600',                            # C+0x61 # U+0x0061
        'b' => '600',                            # C+0x62 # U+0x0062
        'c' => '600',                            # C+0x63 # U+0x0063
        'd' => '600',                            # C+0x64 # U+0x0064
        'e' => '600',                            # C+0x65 # U+0x0065
        'f' => '600',                            # C+0x66 # U+0x0066
        'g' => '600',                            # C+0x67 # U+0x0067
        'h' => '600',                            # C+0x68 # U+0x0068
        'i' => '600',                            # C+0x69 # U+0x0069
        'j' => '600',                            # C+0x6A # U+0x006A
        'k' => '600',                            # C+0x6B # U+0x006B
        'l' => '600',                            # C+0x6C # U+0x006C
        'm' => '600',                            # C+0x6D # U+0x006D
        'n' => '600',                            # C+0x6E # U+0x006E
        'o' => '600',                            # C+0x6F # U+0x006F
        'p' => '600',                            # C+0x70 # U+0x0070
        'q' => '600',                            # C+0x71 # U+0x0071
        'r' => '600',                            # C+0x72 # U+0x0072
        's' => '600',                            # C+0x73 # U+0x0073
        't' => '600',                            # C+0x74 # U+0x0074
        'u' => '600',                            # C+0x75 # U+0x0075
        'v' => '600',                            # C+0x76 # U+0x0076
        'w' => '600',                            # C+0x77 # U+0x0077
        'x' => '600',                            # C+0x78 # U+0x0078
        'y' => '600',                            # C+0x79 # U+0x0079
        'z' => '600',                            # C+0x7A # U+0x007A
        'braceleft' => '600',                    # C+0x7B # U+0x007B
        'bar' => '600',                          # C+0x7C # U+0x007C
        'braceright' => '600',                   # C+0x7D # U+0x007D
        'asciitilde' => '600',                   # C+0x7E # U+0x007E
        'bullet' => '600',                       # C+0x7F # U+0x2022
        'Euro' => '600',                         # C+0x80 # U+0x20AC
        'quotesinglbase' => '600',               # C+0x82 # U+0x201A
        'florin' => '600',                       # C+0x83 # U+0x0192
        'quotedblbase' => '600',                 # C+0x84 # U+0x201E
        'ellipsis' => '600',                     # C+0x85 # U+0x2026
        'dagger' => '600',                       # C+0x86 # U+0x2020
        'daggerdbl' => '600',                    # C+0x87 # U+0x2021
        'circumflex' => '600',                   # C+0x88 # U+0x02C6
        'perthousand' => '600',                  # C+0x89 # U+0x2030
        'Scaron' => '600',                       # C+0x8A # U+0x0160
        'guilsinglleft' => '600',                # C+0x8B # U+0x2039
        'OE' => '600',                           # C+0x8C # U+0x0152
        'Zcaron' => '600',                       # C+0x8E # U+0x017D
        'quoteleft' => '600',                    # C+0x91 # U+0x2018
        'quoteright' => '600',                   # C+0x92 # U+0x2019
        'quotedblleft' => '600',                 # C+0x93 # U+0x201C
        'quotedblright' => '600',                # C+0x94 # U+0x201D
        'endash' => '600',                       # C+0x96 # U+0x2013
        'emdash' => '600',                       # C+0x97 # U+0x2014
        'tilde' => '600',                        # C+0x98 # U+0x02DC
        'trademark' => '600',                    # C+0x99 # U+0x2122
        'scaron' => '600',                       # C+0x9A # U+0x0161
        'guilsinglright' => '600',               # C+0x9B # U+0x203A
        'oe' => '600',                           # C+0x9C # U+0x0153
        'zcaron' => '600',                       # C+0x9E # U+0x017E
        'Ydieresis' => '600',                    # C+0x9F # U+0x0178
        'exclamdown' => '600',                   # C+0xA1 # U+0x00A1
        'cent' => '600',                         # C+0xA2 # U+0x00A2
        'sterling' => '600',                     # C+0xA3 # U+0x00A3
        'currency' => '600',                     # C+0xA4 # U+0x00A4
        'yen' => '600',                          # C+0xA5 # U+0x00A5
        'brokenbar' => '600',                    # C+0xA6 # U+0x00A6
        'section' => '600',                      # C+0xA7 # U+0x00A7
        'dieresis' => '600',                     # C+0xA8 # U+0x00A8
        'copyright' => '600',                    # C+0xA9 # U+0x00A9
        'ordfeminine' => '600',                  # C+0xAA # U+0x00AA
        'guillemotleft' => '600',                # C+0xAB # U+0x00AB
        'logicalnot' => '600',                   # C+0xAC # U+0x00AC
        'registered' => '600',                   # C+0xAE # U+0x00AE
        'macron' => '600',                       # C+0xAF # U+0x00AF
        'degree' => '600',                       # C+0xB0 # U+0x00B0
        'plusminus' => '600',                    # C+0xB1 # U+0x00B1
        'twosuperior' => '600',                  # C+0xB2 # U+0x00B2
        'threesuperior' => '600',                # C+0xB3 # U+0x00B3
        'acute' => '600',                        # C+0xB4 # U+0x00B4
        'mu' => '600',                           # C+0xB5 # U+0x00B5
        'paragraph' => '600',                    # C+0xB6 # U+0x00B6
        'periodcentered' => '600',               # C+0xB7 # U+0x00B7
        'cedilla' => '600',                      # C+0xB8 # U+0x00B8
        'onesuperior' => '600',                  # C+0xB9 # U+0x00B9
        'ordmasculine' => '600',                 # C+0xBA # U+0x00BA
        'guillemotright' => '600',               # C+0xBB # U+0x00BB
        'onequarter' => '600',                   # C+0xBC # U+0x00BC
        'onehalf' => '600',                      # C+0xBD # U+0x00BD
        'threequarters' => '600',                # C+0xBE # U+0x00BE
        'questiondown' => '600',                 # C+0xBF # U+0x00BF
        'Agrave' => '600',                       # C+0xC0 # U+0x00C0
        'Aacute' => '600',                       # C+0xC1 # U+0x00C1
        'Acircumflex' => '600',                  # C+0xC2 # U+0x00C2
        'Atilde' => '600',                       # C+0xC3 # U+0x00C3
        'Adieresis' => '600',                    # C+0xC4 # U+0x00C4
        'Aring' => '600',                        # C+0xC5 # U+0x00C5
        'AE' => '600',                           # C+0xC6 # U+0x00C6
        'Ccedilla' => '600',                     # C+0xC7 # U+0x00C7
        'Egrave' => '600',                       # C+0xC8 # U+0x00C8
        'Eacute' => '600',                       # C+0xC9 # U+0x00C9
        'Ecircumflex' => '600',                  # C+0xCA # U+0x00CA
        'Edieresis' => '600',                    # C+0xCB # U+0x00CB
        'Igrave' => '600',                       # C+0xCC # U+0x00CC
        'Iacute' => '600',                       # C+0xCD # U+0x00CD
        'Icircumflex' => '600',                  # C+0xCE # U+0x00CE
        'Idieresis' => '600',                    # C+0xCF # U+0x00CF
        'Eth' => '600',                          # C+0xD0 # U+0x00D0
        'Ntilde' => '600',                       # C+0xD1 # U+0x00D1
        'Ograve' => '600',                       # C+0xD2 # U+0x00D2
        'Oacute' => '600',                       # C+0xD3 # U+0x00D3
        'Ocircumflex' => '600',                  # C+0xD4 # U+0x00D4
        'Otilde' => '600',                       # C+0xD5 # U+0x00D5
        'Odieresis' => '600',                    # C+0xD6 # U+0x00D6
        'multiply' => '600',                     # C+0xD7 # U+0x00D7
        'Oslash' => '600',                       # C+0xD8 # U+0x00D8
        'Ugrave' => '600',                       # C+0xD9 # U+0x00D9
        'Uacute' => '600',                       # C+0xDA # U+0x00DA
        'Ucircumflex' => '600',                  # C+0xDB # U+0x00DB
        'Udieresis' => '600',                    # C+0xDC # U+0x00DC
        'Yacute' => '600',                       # C+0xDD # U+0x00DD
        'Thorn' => '600',                        # C+0xDE # U+0x00DE
        'germandbls' => '600',                   # C+0xDF # U+0x00DF
        'agrave' => '600',                       # C+0xE0 # U+0x00E0
        'aacute' => '600',                       # C+0xE1 # U+0x00E1
        'acircumflex' => '600',                  # C+0xE2 # U+0x00E2
        'atilde' => '600',                       # C+0xE3 # U+0x00E3
        'adieresis' => '600',                    # C+0xE4 # U+0x00E4
        'aring' => '600',                        # C+0xE5 # U+0x00E5
        'ae' => '600',                           # C+0xE6 # U+0x00E6
        'ccedilla' => '600',                     # C+0xE7 # U+0x00E7
        'egrave' => '600',                       # C+0xE8 # U+0x00E8
        'eacute' => '600',                       # C+0xE9 # U+0x00E9
        'ecircumflex' => '600',                  # C+0xEA # U+0x00EA
        'edieresis' => '600',                    # C+0xEB # U+0x00EB
        'igrave' => '600',                       # C+0xEC # U+0x00EC
        'iacute' => '600',                       # C+0xED # U+0x00ED
        'icircumflex' => '600',                  # C+0xEE # U+0x00EE
        'idieresis' => '600',                    # C+0xEF # U+0x00EF
        'eth' => '600',                          # C+0xF0 # U+0x00F0
        'ntilde' => '600',                       # C+0xF1 # U+0x00F1
        'ograve' => '600',                       # C+0xF2 # U+0x00F2
        'oacute' => '600',                       # C+0xF3 # U+0x00F3
        'ocircumflex' => '600',                  # C+0xF4 # U+0x00F4
        'otilde' => '600',                       # C+0xF5 # U+0x00F5
        'odieresis' => '600',                    # C+0xF6 # U+0x00F6
        'divide' => '600',                       # C+0xF7 # U+0x00F7
        'oslash' => '600',                       # C+0xF8 # U+0x00F8
        'ugrave' => '600',                       # C+0xF9 # U+0x00F9
        'uacute' => '600',                       # C+0xFA # U+0x00FA
        'ucircumflex' => '600',                  # C+0xFB # U+0x00FB
        'udieresis' => '600',                    # C+0xFC # U+0x00FC
        'yacute' => '600',                       # C+0xFD # U+0x00FD
        'thorn' => '600',                        # C+0xFE # U+0x00FE
        'ydieresis' => '600',                    # C+0xFF # U+0x00FF
        'dotlessi' => '600',                     # U+0x0131
        'Lslash' => '600',                       # U+0x0141
        'lslash' => '600',                       # U+0x0142
        'caron' => '600',                        # U+0x02C7
        'breve' => '600',                        # U+0x02D8
        'dotaccent' => '600',                    # U+0x02D9
        'ring' => '600',                         # U+0x02DA
        'ogonek' => '600',                       # U+0x02DB
        'hungarumlaut' => '600',                 # U+0x02DD
        'fraction' => '600',                     # U+0x2044
        'minus' => '600',                        # U+0x2212
        'fi' => '600',                           # U+0xFB01
        'fl' => '600',                           # U+0xFB02
    }, # HORIZ. WIDTH TABLE
} };

1;
