package Dist::Zilla::Plugin::Bencher::Scenario;

our $DATE = '2015-11-18'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

use Moose;
use namespace::autoclean;

use Bencher;
use Module::Load;

with (
    'Dist::Zilla::Role::FileMunger',
    'Dist::Zilla::Role::FileFinderUser' => {
        default_finders => [':InstallModules'],
    },
);

sub munge_files {
    no strict 'refs';
    my $self = shift;

    local @INC = ("lib", @INC);

    my %seen_mods;
    for my $file (@{ $self->found_files }) {
        next unless $file->name =~ m!\Alib/(Bencher/Scenario/.+)\.pm\z!;
        my $pkg = $1; $pkg =~ s!/!::!g;
        load $pkg;
        my $scenario = Bencher::parse_scenario(scenario=>${"$pkg\::scenario"});
        my @modules = Bencher::_get_participant_modules($scenario);
        for my $mod (@modules) {
            next if $seen_mods{$mod}++;
            $self->log_debug(["Adding prereq to benchmarked module %s", $mod]);
            $self->zilla->register_prereqs(
                {phase=>'runtime', type=>'recommends'}, $mod, 0);
        }
    }
    return;
}

__PACKAGE__->meta->make_immutable;
1;
# ABSTRACT: Do various stuffs for Bencher-Scenario-* distribution

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::Bencher::Scenario - Do various stuffs for Bencher-Scenario-* distribution

=head1 VERSION

This document describes version 0.01 of Dist::Zilla::Plugin::Bencher::Scenario (from Perl distribution Dist-Zilla-Plugin-Bencher-Scenario), released on 2015-11-18.

=head1 SYNOPSIS

In F<dist.ini>:

 [Bencher::Scenario]

=head1 DESCRIPTION

This plugin is meant to be use when building C<Bencher-Scenario-*> distribution
(e.g.: L<Bencher::Scenario::SetOperationModules>,
L<Bencher::Scenario::Serializers>). Currently what it does are the following:

=over

=item * Add the benchmarked modules as RuntimeRecommends prereqs

=back

=for Pod::Coverage .+

=head1 SEE ALSO

L<Bencher>

L<Pod::Weaver::Plugin::Bencher::Scenario>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Dist-Zilla-Plugin-Bencher-Scenario>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Dist-Zilla-Plugin-Bencher-Scenario>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Dist-Zilla-Plugin-Bencher-Scenario>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
